/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.Switch;
import java.util.HashMap;

public class SmFCIPProfileTableModel
extends SmTableModel {
    static final int TCP_MAXBW_COL = 9;
    static final int TCP_MINAVBW_COL = 10;
    static final int TCP_MAXBW2_COL = 11;
    static final int TCP_MINAVBW2_COL = 12;
    static final int TCP_RNDTRIPTIME_COL = 13;
    static final int PMTU_ENABLE_COL = 14;
    static final int PMTU_RESET_COL = 15;
    static final int[] _cfmFcipEntityExtTcpMaxBWOid = MibNode.get("cfmFcipEntityExtTcpMaxBW").getOid();
    static final int[] _cfmFcipEntityExtTcpMinAvailBWOid = MibNode.get("cfmFcipEntityExtTcpMinAvailBW").getOid();
    static final int[] _cfmFcipEntityExt2TcpMaxBWOid = MibNode.get("cfmFcipEntityExt2TcpMaxBW").getOid();
    static final int[] _cfmFcipEntityExt2TcpMinAvailBWOid = MibNode.get("cfmFcipEntityExt2TcpMinAvailBW").getOid();
    static final int[] _cfmFcipEntityExtTcpRndTrpTimeEstOid = MibNode.get("cfmFcipEntityExtTcpRndTrpTimeEst").getOid();

    @Override
    public synchronized Object[] addElement(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        if (this._outScope) {
            return null;
        }
        Object[] row = this.createRow();
        this._responseData.addElement(row);
        row[0] = node;
        if (index != null) {
            row[1] = index;
        }
        Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
        MibNode[] mibNodes = this.getMibNodes(sw);
        String[] mibVars = this.getMibVars(sw);
        boolean isEqualOrAbove625 = sw.isVersionGreaterThanEqual("6.2(5)");
        if (mibNodes != null && mibVars != null) {
            int mibCol = 0;
            for (int vblCol = 0; mibCol < mibVars.length && vblCol < vbl.size(); ++mibCol, ++vblCol) {
                Object value;
                boolean findMibVar = true;
                if (mibVars[mibCol] == null) {
                    findMibVar = false;
                    for (int j = mibCol + 1; j < mibVars.length; ++j) {
                        if (mibVars[j] == null) continue;
                        mibCol = j;
                        findMibVar = true;
                        break;
                    }
                }
                if (!findMibVar) continue;
                row[mibCol + this._offset] = value = this.getCellDisplayString(node, mibNodes[mibCol + this._offset], vbl, vbl.getVb(vblCol), mibVars[mibCol], this._responseData.size() - 1, mibCol + this._offset, index, 0);
                if (isEqualOrAbove625 || mibCol + this._offset != 11 && mibCol + this._offset != 12) continue;
                row[mibCol + this._offset] = row[mibCol + this._offset - 2];
            }
        }
        this.updateGetProgress();
        return row;
    }

    @Override
    protected HashMap buildSendPdus() throws Exception {
        Array cells = this.getChanged();
        if (cells == null) {
            return null;
        }
        HashMap<SnmpPeer, SnmpPDU> pdus = new HashMap<SnmpPeer, SnmpPDU>();
        for (int i = 0; i < cells.size(); ++i) {
            Cell nextCell;
            Cell cell = (Cell)cells.elementAt(i);
            SnmpPeer node = this.getRowPeer(cell._row);
            SnmpPDU pdu = (SnmpPDU)pdus.get(node);
            if (pdu == null) {
                pdu = new SnmpPDU(-93, new VarBindList());
                pdu.setAddress(node.getAddress());
                pdus.put(node, pdu);
            }
            int[] index = this.getIndex(cell._row);
            SnmpOID oid = new SnmpOID(this._mibNodes[cell._col].getOid(), index);
            SnmpVar changedCellVar = this.getChangedCell(cell._row, cell._col);
            Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
            boolean isEqualOrAbove625 = sw.isVersionGreaterThanEqual("6.2(5)");
            if (oid.startsWith(_cfmFcipEntityExt2TcpMaxBWOid)) {
                if (i + 1 < cells.size()) {
                    nextCell = (Cell)cells.elementAt(i + 1);
                    if (nextCell._row == cell._row && SnmpOID.startsWith(this._mibNodes[nextCell._col].getOid(), _cfmFcipEntityExt2TcpMinAvailBWOid)) {
                        ++i;
                    }
                    if (i + 1 < cells.size()) {
                        nextCell = (Cell)cells.elementAt(i + 1);
                        if (nextCell._row == cell._row && SnmpOID.startsWith(this._mibNodes[nextCell._col].getOid(), _cfmFcipEntityExtTcpRndTrpTimeEstOid)) {
                            ++i;
                        }
                    }
                }
                pdu.addVar(new SnmpOID(isEqualOrAbove625 ? _cfmFcipEntityExt2TcpMinAvailBWOid : _cfmFcipEntityExtTcpMinAvailBWOid, index), (SnmpVar)this.getValueAt(cell._row, 12));
                pdu.addVar(new SnmpOID(_cfmFcipEntityExtTcpRndTrpTimeEstOid, index), (SnmpVar)this.getValueAt(cell._row, 13));
                pdu.addVar(isEqualOrAbove625 ? oid : new SnmpOID(_cfmFcipEntityExtTcpMaxBWOid, index), changedCellVar);
                continue;
            }
            if (oid.startsWith(_cfmFcipEntityExt2TcpMinAvailBWOid)) {
                pdu.addVar(new SnmpOID(isEqualOrAbove625 ? _cfmFcipEntityExt2TcpMaxBWOid : _cfmFcipEntityExtTcpMaxBWOid, index), (SnmpVar)this.getValueAt(cell._row, 11));
                if (i + 1 < cells.size()) {
                    nextCell = (Cell)cells.elementAt(i + 1);
                    if (nextCell._row == cell._row && SnmpOID.startsWith(this._mibNodes[nextCell._col].getOid(), _cfmFcipEntityExtTcpRndTrpTimeEstOid)) {
                        ++i;
                    }
                }
                pdu.addVar(new SnmpOID(_cfmFcipEntityExtTcpRndTrpTimeEstOid, index), (SnmpVar)this.getValueAt(cell._row, 13));
                pdu.addVar(isEqualOrAbove625 ? oid : new SnmpOID(_cfmFcipEntityExtTcpMinAvailBWOid, index), changedCellVar);
                continue;
            }
            if (oid.startsWith(_cfmFcipEntityExtTcpRndTrpTimeEstOid)) {
                pdu.addVar(new SnmpOID(isEqualOrAbove625 ? _cfmFcipEntityExt2TcpMaxBWOid : _cfmFcipEntityExtTcpMaxBWOid, index), (SnmpVar)this.getValueAt(cell._row, 11));
                pdu.addVar(new SnmpOID(isEqualOrAbove625 ? _cfmFcipEntityExt2TcpMinAvailBWOid : _cfmFcipEntityExtTcpMinAvailBWOid, index), (SnmpVar)this.getValueAt(cell._row, 12));
                pdu.addVar(oid, changedCellVar);
                continue;
            }
            pdu.addVar(oid, changedCellVar);
        }
        return pdus;
    }

    @Override
    public boolean isCellActive(int row, int col) {
        if (col == 15) {
            Object o = this.getValueAt(row, 14);
            return o != null && (Boolean)o != false;
        }
        return super.isCellActive(row, col);
    }
}

