/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpReportException;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.dialogs.SmMultiIndexedEditTableModel;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.DataView;
import com.cisco.dcbu.sm.client.model.SmFilter;
import java.awt.Component;

public class SmFiconPortFileTableModel
extends SmMultiIndexedEditTableModel {
    static final int PORT_NAME = 2;
    static final int BLOCK = 3;
    static final int PROHIBIT = 4;
    static final int OPEN = 3;
    static final int CLOSE = 4;
    int[] _cficonCfgFileCmdOid = MibNode.get("cficonCfgFileCmd").getOid();
    Array _openFileInvokers = new Array();
    Array _closeFileInvokers = new Array();
    Array _errFileInvokers = new Array();
    int _filesFiledCount;
    SmFilter[] _newInvoker;
    private StringBuffer _errors;

    public SmFiconPortFileTableModel(DataView view) {
        super(view);
    }

    @Override
    public void build(String[] mibVars, String[] prefixes, int offset) {
        super.build(mibVars, prefixes, offset);
        boolean[] isEditable = this.getEditable();
        isEditable[2] = false;
        isEditable[3] = false;
        isEditable[4] = false;
        this.setEditable(isEditable);
    }

    @Override
    public Array getTableVars(SmFilter[] invoker) throws SnmpException {
        int i;
        this._errors = new StringBuffer();
        this._errFileInvokers.clear();
        this.FileCmd(invoker, 3);
        if (this._filesFiledCount != 0) {
            for (i = 0; i < this._errFileInvokers.size(); ++i) {
                this.getSnmpErrorDetail(((SnmpPDU)this._errFileInvokers.elementAt(i)).getPeer(), (SnmpPDU)this._errFileInvokers.elementAt(i));
            }
            Util.errorMessage((Component)BrowserFrame.getInstance(), this._filesFiledCount + " files(es) failed to open: " + this._errors.toString());
        }
        if (this._openFileInvokers != null) {
            this._newInvoker = new SmFilter[this._openFileInvokers.size()];
            for (i = 0; i < this._openFileInvokers.size(); ++i) {
                this._newInvoker[i] = (SmFilter)this._openFileInvokers.elementAt(i);
            }
        } else {
            this._newInvoker = invoker;
        }
        return super.getTableVars(this._newInvoker);
    }

    @Override
    protected boolean isEnd(SnmpPeer peer, int[] req, SnmpVarBind vb, int[] index, int reqId) {
        boolean isEnd = super.isEnd(peer, req, vb, index, reqId);
        if (isEnd && this._openFileInvokers != null) {
            this._newInvoker = new SmFilter[this._openFileInvokers.size()];
            for (int i = 0; i < this._openFileInvokers.size(); ++i) {
                if (!((SmFilter)this._openFileInvokers.elementAt(i)).getSnmpPeer().getAddress().equals(peer.getAddress())) continue;
                try {
                    this.FileCmd(new SmFilter[]{(SmFilter)this._openFileInvokers.elementAt(i)}, 4);
                    continue;
                }
                catch (SnmpException ex) {
                    DefaultLogger._DefLogger.error((Object)("failed to close ficon file " + ex.getMessage()));
                }
            }
        }
        return isEnd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void FileCmd(SmFilter[] invoker, int cmd) throws SnmpException {
        if (invoker == null || invoker.length == 0) {
            return;
        }
        this._state = 5;
        this._timedoutPeers.clear();
        this._firstOid = this._mibNodes[this._offset].getOid();
        this._openFileInvokers.clear();
        this._filesFiledCount = 0;
        this._numOutstanding.set(0);
        Object object = this._numOutstanding.getLock();
        synchronized (object) {
            for (int i = 0; i < invoker.length; ++i) {
                SnmpPeer peer;
                if (invoker[i] == null || !this.isVersionSupported(peer = invoker[i].getSnmpPeer())) continue;
                int[][] indices = this.getTableVarsIndices(invoker[i]);
                for (int j = 0; j < indices.length; ++j) {
                    SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
                    pdu.addVar(new SnmpOID(this._cficonCfgFileCmdOid, indices[j]), new SnmpInt(cmd));
                    this._state = 5;
                    peer.send(pdu, this);
                    this._numOutstanding.increment();
                    this._openFileInvokers.addElement(invoker[i]);
                }
            }
        }
        if (this._numOutstanding.get() > 0) {
            this.wait(this._numOutstanding);
        }
    }

    @Override
    public boolean checkSnmpCallbackErr(SnmpPeer node, SnmpPDU pdu, boolean timedOut) {
        VarBindList vbl = pdu.getVariables();
        if (SnmpOID.startsWith(vbl.get(0).getOid().getValue(), this._cficonCfgFileCmdOid) && pdu.getError() != 0) {
            for (int i = 0; i < this._openFileInvokers.size(); ++i) {
                int[][] openOid;
                int[] errorOid = pdu.getVariables().get(0).getOid().getValue();
                if (!SnmpOID.startsWith(errorOid, (openOid = ((SmFilter)this._openFileInvokers.elementAt(i)).getIndices())[i], this._cficonCfgFileCmdOid.length)) continue;
                this._openFileInvokers.removeElementAt(i);
            }
            ++this._filesFiledCount;
            this._errFileInvokers.addElement(pdu);
        }
        return super.checkSnmpCallbackErr(node, pdu, timedOut);
    }

    private void getSnmpErrorDetail(SnmpPeer peer, SnmpPDU pdu) {
        String strErr = SnmpReportException.getError(pdu);
        String strErrorDetail = peer.getSnmpErrorDetail(strErr, pdu);
        String err = peer + ": " + strErrorDetail;
        this._errors.append(err + "\n");
    }
}

