/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.KTable;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.SmCommandDispatcher;
import com.cisco.dcbu.sm.client.gui.SmGenericTab;
import com.cisco.dcbu.sm.client.gui.intface.InterfaceIslTab;
import com.cisco.dcbu.sm.client.gui.tools.HealthAnalysis;
import com.cisco.dcbu.sm.client.map.actions.SelectionAction;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.SmFilter;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.common.dto.QueueGetResponseObject;
import com.cisco.dcbu.sm.common.dto.QueueResponseObject;
import com.cisco.dcbu.sm.common.dto.SmHealthAnalysisDetail;
import com.cisco.dcbu.sm.common.event.PtoPEventFactory;
import com.cisco.dcbu.sm.common.event.PtoPEventHandler;
import com.cisco.dcbu.sm.common.event.QueueListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.InetAddress;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SmHealthAnalysisTableModel
extends SnmpTableModel
implements ListSelectionListener,
QueueListener {
    HealthAnalysis _healthDlg;
    Array _peersAlive;
    SnmpKTable _table;
    JLabel _status;
    JScrollPane _sp;
    JButton _startButton;
    public static String SHA_VSAN_SUSPENDED = "VSAN Suspended";
    PtoPEventHandler _ptopHandler = null;
    long _requestId = -1L;
    JDialog _parent;
    boolean _chkIfLink;
    boolean _chkTrunkVsanMatchIsolation;
    protected Array _responseData;

    public SmHealthAnalysisTableModel(JDialog parent) {
        this._parent = parent;
        this._responseData = new Array();
        this.setData(this._responseData);
    }

    @Override
    public void onMessage(Object msg) {
        try {
            QueueResponseObject response;
            System.out.println("SwitchHealthAnalysis Queue Listener::  -====== onMessage, recv obj=" + msg);
            if (msg instanceof QueueResponseObject && (response = (QueueResponseObject)msg).getRequestId() == this._requestId) {
                switch (response.getResultValue()) {
                    case 4: {
                        StringBuilder errmsg = new StringBuilder("Unable to run Switch Health Analysis, \nrecieved an error: ");
                        errmsg.append(Util.getErrorMessage(response.getException()));
                        this.setStatus("Error");
                        this._startButton.setText("Start");
                        JOptionPane.showMessageDialog(this._parent, errmsg, "Error running Switch Health Analysis", 0);
                        break;
                    }
                    case 2: {
                        StringBuilder errmsg = new StringBuilder("Unable to run Switch Health Analysis, \nrecieved an error: ");
                        errmsg.append(response.getStatusStr());
                        this.setStatus("Error");
                        this._startButton.setText("Start");
                        JOptionPane.showMessageDialog(this._parent, errmsg, "Error running Switch Health Analysis", 0);
                        break;
                    }
                    case 1: {
                        this.setStatus(response.getStatusStr());
                        this.updateTableInfo();
                        this._startButton.setText("Start");
                        break;
                    }
                    case 3: {
                        if (response instanceof QueueGetResponseObject) {
                            Object[] rowArray = ((QueueGetResponseObject)response).getData();
                            InetAddress addr = ((SmHealthAnalysisDetail)rowArray[2])._addr;
                            SnmpPeer clientPeer = SnmpPeer.findPeer(addr);
                            rowArray[0] = clientPeer;
                            this._responseData.addElement(rowArray);
                        } else {
                            this.setStatus(response.getStatusStr());
                        }
                        this.updateTableInfo();
                        break;
                    }
                    default: {
                        StringBuilder errmsg = new StringBuilder("Recieved unknown response from running Switch Health Analysis.");
                        this.setStatus("Error");
                        this._startButton.setText("Start");
                        JOptionPane.showMessageDialog(this._parent, errmsg, "Error running Switch Health Analysis", 0);
                    }
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void cleanup() {
        if (this._ptopHandler != null) {
            this._ptopHandler.stop();
            this._ptopHandler = null;
        }
    }

    public void setInfo4Model(HealthAnalysis healthDlg, SnmpKTable table, JLabel status, JScrollPane sp, JButton startButton) {
        this._healthDlg = healthDlg;
        this._table = table;
        this._status = status;
        this._sp = sp;
        this._startButton = startButton;
        this._table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                Object[] row;
                Object detail;
                int sel;
                if (event.getSource() instanceof KTable && event.getClickCount() > 1 && (sel = SmHealthAnalysisTableModel.this._table.getSelectedRow()) != -1 && (detail = (row = (Object[])SmHealthAnalysisTableModel.this._responseData.elementAt(sel))[2]) instanceof SmHealthAnalysisDetail) {
                    SmHealthAnalysisTableModel.this.showDetails(row[1].toString(), (SmHealthAnalysisDetail)detail, (SnmpPeer)row[0]);
                }
            }
        });
        this._table.getSelectionModel().addListSelectionListener(this);
    }

    public void setContinueFlag(boolean goOn) {
        if (!goOn) {
            try {
                ClientController.getInstance().assertAnalysis().stopAsychAnalysis(this._requestId);
                this._startButton.setText("Start");
            }
            catch (Exception ex) {
                DefaultLogger._DefLogger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public void start() {
        this._requestId = -1L;
        this._responseData.clear();
        this.updateTableInfo();
        Fabric fab = ClientController.getInstance().getFabric();
        if (fab == null) {
            fab = ClientController.getInstance().getFirstFabric();
        }
        try {
            PtoPEventFactory factory = PtoPEventFactory.getInstance();
            if (this._ptopHandler == null) {
                this._ptopHandler = factory.getPtoPHandler("jms/queue/SwitchHealthAnalysis", this);
            }
            this._requestId = ClientController.getInstance().assertAnalysis().runHeathAnalysisAsynchronously(fab.getFabricBase().getPK(), this._chkIfLink, this._chkTrunkVsanMatchIsolation, this._ptopHandler.getCommunicationObject());
        }
        catch (Exception ex) {
            DefaultLogger._DefLogger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    void setStatus(String status) {
        this._status.setText(status);
    }

    public void clearTable() {
        this._responseData.clear();
        this.updateTableInfo();
    }

    public void update() {
        this.updateTableInfo();
        if (this._peersAlive.size() == 0) {
            // empty if block
        }
    }

    public void updateTableInfo() {
        this._table.setAutoResizeMode(0);
        this._sp.setPreferredSize(this._table.calcPreferredSize());
        this._table.getTableHeader().resizeAndRepaint();
        this.fireTableDataChanged();
    }

    public void details(SnmpKTable table) {
        Object[] row;
        Object detail;
        int sel = table.getSelectedRow();
        if (sel != -1 && (detail = (row = (Object[])this._responseData.elementAt(sel))[2]) instanceof SmHealthAnalysisDetail) {
            this.showDetails(row[1].toString(), (SmHealthAnalysisDetail)detail, (SnmpPeer)row[0]);
        }
    }

    public void showDetails(String title, SmHealthAnalysisDetail detail, SnmpPeer peer) {
        SmFilter[] elements = new SmFilter[]{new SmFilter(peer, detail._indices)};
        if (detail._cmdName == null) {
            return;
        }
        if (detail._cmdName.startsWith("Interface")) {
            if (detail._cmdName.equals("InterfaceISL")) {
                new InterfaceIslTab().refresh(BrowserFrame.getDataView(), title, null, elements, "ifsgeneral", null);
            } else if (detail._cmdName.equals("InterfacePC")) {
                new InterfaceIslTab().refresh(BrowserFrame.getDataView(), title, null, elements, "ifsgeneral", null, 1);
            } else if (detail._cmdName.equals("InterfaceISLTrunkStatus")) {
                new InterfaceIslTab().refresh(BrowserFrame.getDataView(), title, null, elements, "ifstrunkStatus", null);
            } else if (detail._cmdName.equals("InterfacePCTrunkStatus")) {
                new InterfaceIslTab().refresh(BrowserFrame.getDataView(), title, null, elements, "ifstrunkStatus", null, 1);
            } else if (detail._cmdName.equals("InterfaceISLDmIf")) {
                new InterfaceIslTab().refresh(BrowserFrame.getDataView(), title, null, elements, "ifsdmIf", null);
            } else if (detail._cmdName.equals("InterfaceFcsp")) {
                new InterfaceIslTab().refresh(BrowserFrame.getDataView(), title, null, elements, "ifsfcsp", null);
            }
        } else if (detail._subCmdName != null && detail._subCmdName.contains("CFS")) {
            SmGenericTab tabbedPanel;
            SmCommandDispatcher.invoke(detail._cmdName, BrowserFrame.getDataView(), elements, title, null, detail._userData);
            if (!detail._cmdName.equals("callHomeTab") && (tabbedPanel = BrowserFrame.getDataView().getTabPanel()) != null && detail._subCmdName != null) {
                tabbedPanel.setStartTab(detail._subCmdName);
            }
        } else {
            SmCommandDispatcher.invoke(detail._cmdName, BrowserFrame.getDataView(), elements, title, detail._subCmdName, detail._userData);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        boolean selected;
        boolean bl = selected = this.getRowCount() > 0 && this._table.getSelectedRowCount() > 0;
        if (selected && !e.getValueIsAdjusting()) {
            Object[] row;
            Object detail;
            this.mapSelectDevice(this._table);
            int sel = this._table.getSelectedRow();
            boolean showDetailBtn = false;
            if (sel != -1 && (detail = (row = (Object[])this._responseData.elementAt(sel))[2]) instanceof SmHealthAnalysisDetail) {
                showDetailBtn = ((SmHealthAnalysisDetail)detail)._cmdName != null;
            }
            this._healthDlg.enableButton(1, showDetailBtn);
        }
    }

    public void setChkIfLink(boolean chk) {
        this._chkIfLink = chk;
    }

    public void setChkTrunkVsanMatchIsolation(boolean chk) {
        this._chkTrunkVsanMatchIsolation = chk;
    }

    public void mapSelectDevice(SnmpKTable table) {
        int[] sels = table.getSelectedRows();
        Array data = this.getData();
        ArrayList<Object> devList = new ArrayList<Object>();
        for (int i = 0; i < sels.length; ++i) {
            int row = sels[i];
            Object[] rowData = (Object[])data.elementAt(row);
            Object target = rowData[0];
            if (target == null) continue;
            if (target instanceof SnmpPeer) {
                Switch sw = ClientController.findFabricSwitchByIpAddress(((SnmpPeer)target).getAddress());
                if (sw == null) continue;
                devList.add(sw);
                continue;
            }
            devList.add(target);
        }
        SelectionAction.getInstance().setObjects(devList, null);
        SelectionAction.getInstance().execute();
    }
}

