/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.InsertDialog;
import com.cisco.dcbu.sm.client.gui.InsertForm;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.Switch;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.JTextField;

public class SmInsertAAAServerGrp
extends InsertForm {
    static final int INDEX = 0;
    static final int NAME = 1;
    static final int PROTO = 2;
    static final int LIST = 3;
    static final int DEAD_TIME = 4;
    static final int MAP_NAME = 5;
    static final int SSL_MODE = 6;
    static final int BIND_FIRST = 7;
    static final int AUTH_MECH = 8;
    static final int COMP_PASS = 9;
    static final int DN_BIND = 10;
    static final int SERV_BIND = 11;
    int protocolIndex = this.getVarIndex("cAAASvrGrpProtocol");

    public SmInsertAAAServerGrp(SnmpPeer[] peers, InsertDialog parent, SmTableModel table) {
        super(peers, parent, table);
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        String strGrps;
        if (index == 3 && ((strGrps = ((JTextField)this._values[index]).getText()) == null || strGrps.length() == 0)) {
            throw new Exception("List cannot be empty!");
        }
        return super.getComponentValue(index);
    }

    @Override
    protected String getFormLabel(String mibVar, int index) {
        if (mibVar.equals("cAAAServerList")) {
            return "ServerIdList";
        }
        return super.getFormLabel(mibVar, index);
    }

    @Override
    protected void build() throws Exception {
        super.build();
        RadioButtonPanel protocolPanel = (RadioButtonPanel)this._values[this.protocolIndex];
        for (int i = 0; i < protocolPanel.getComponentCount(); ++i) {
            protocolPanel.getButton(i).addActionListener(this);
            protocolPanel.getButton(i).setActionCommand("Proto");
        }
        this.setProtocolDefaultValue(2);
    }

    @Override
    protected SnmpPDU getInsertPDU(SnmpPeer peer, VarBindList vbl) throws Exception {
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        boolean isVersion30Below = sw.isVersionLessThan("3.0(0)");
        VarBindList newVbl = new VarBindList();
        newVbl.copy(vbl, 0, vbl.size());
        if (isVersion30Below) {
            newVbl.remove(newVbl.size() - 1);
        }
        return new SnmpPDU(-93, newVbl);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Proto")) {
            char cmd = ((AbstractButton)e.getSource()).getText().charAt(0);
            if (cmd == 't') {
                this.setProtocolDefaultValue(1);
            } else if (cmd == 'r') {
                this.setProtocolDefaultValue(2);
            } else {
                this.setProtocolDefaultValue(3);
            }
        } else {
            super.actionPerformed(e);
        }
    }

    void setProtocolDefaultValue(int serverType) {
        boolean isLdap = false;
        if (serverType == 3) {
            isLdap = true;
        }
        for (int i = 5; i <= 11; ++i) {
            if (this._labels[i] != null) {
                this._labels[i].setVisible(isLdap);
            }
            this._values[i].setEnabled(isLdap);
            this._values[i].setVisible(isLdap);
        }
        InsertDialog dlg = BrowserFrame.getDataView().getInsertDlg();
        if (dlg != null) {
            dlg.pack();
        }
    }
}

