/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.GroupButtonPanel;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.dialogs.SmProfileUtil;
import com.cisco.dcbu.sm.client.gui.InsertDialog;
import com.cisco.dcbu.sm.client.gui.InsertForm;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.Switch;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JToggleButton;

public class SmInsertCallHomeEmail
extends InsertForm
implements ItemListener {
    static final String[] _Profiles = new String[]{"xml", "full_txt", "short_txt"};
    private static int INDEX = 1;
    private static int DESTINATION_TYPE = 2;
    private static int DESTINATION_EMAIL = 3;
    private static int DEST_HTTP_URL = 4;

    public SmInsertCallHomeEmail(SnmpPeer[] peers, InsertDialog parent, SmTableModel table) {
        super(peers, parent, table);
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 0) {
            LinkedHashSet<String> commonProfiles = new LinkedHashSet<String>();
            List prof = SmProfileUtil.getInstance().getPeerProfiles(this._peers[0]);
            if (prof != null) {
                commonProfiles = new LinkedHashSet(prof);
            }
            for (int i = 1; i < this._peers.length; ++i) {
                List profiles = SmProfileUtil.getInstance().getPeerProfiles(this._peers[i]);
                commonProfiles.retainAll(profiles);
            }
            commonProfiles.addAll(Arrays.asList(_Profiles));
            JComboBox<String> cmbx = new JComboBox<String>(commonProfiles.toArray(new String[0]));
            cmbx.setEditable(true);
            return cmbx;
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == 0) {
            return new SnmpString(((JComboBox)this.getComponentAt(0)).getSelectedItem().toString());
        }
        return super.getComponentValue(index);
    }

    @Override
    protected SnmpPDU getInsertPDU(SnmpPeer peer, VarBindList vbl) throws Exception {
        Switch sw;
        boolean isAbove4dot2;
        SnmpVar[] values = this.getInsertValue();
        if (((SnmpInt)values[2]).getValue() == 2) {
            StringBuffer upSupportedSws = new StringBuffer();
            for (int i = 0; i < this._peers.length; ++i) {
                Switch sw2;
                boolean isAbove4dot22;
                if (!this.isPeerSelected(this._peers[i]) || (isAbove4dot22 = (sw2 = ClientController.findFabricSwitchByIpAddress(this._peers[i].getAddress())).isVersionGreaterThanEqual("4.2(0)"))) continue;
                upSupportedSws.append(sw2.getName() + ", ");
            }
            if (upSupportedSws.length() > 0) {
                throw new Exception("The following switche(s) do not support destination type http:\n" + upSupportedSws.substring(0, upSupportedSws.length() - 2));
            }
        }
        if (!(isAbove4dot2 = (sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress())).isVersionGreaterThanEqual("4.2(0)"))) {
            VarBindList peerVbl = new VarBindList();
            peerVbl.copy(vbl, 0, vbl.size());
            peerVbl.remove(1);
            SnmpPDU pdu = super.getInsertPDU(peer, peerVbl);
            return pdu;
        }
        return super.getInsertPDU(peer, vbl);
    }

    @Override
    protected int setInsertRow(VarBindList vbl) throws Exception {
        int pduSent = 0;
        for (int i = 0; i < this._selPeerList.length; ++i) {
            SnmpPDU pdu = this.getInsertPDU((SnmpPeer)this._selPeerList[i], vbl);
            if (pdu == null) continue;
            ++this._pending;
            ++pduSent;
            ((SnmpPeer)this._selPeerList[i]).send(pdu, this);
        }
        return pduSent;
    }

    @Override
    protected void build() throws Exception {
        super.build();
        this._labels[INDEX].setText("ID:");
        GroupButtonPanel type = (GroupButtonPanel)this._values[DESTINATION_TYPE];
        for (int i = 0; i < type.getComponentCount(); ++i) {
            if (!type.getButton(i).getText().startsWith("email")) continue;
            type.setSelected(i);
        }
        boolean isEmail = type.getSelectedValue().equals("email");
        this._values[DEST_HTTP_URL].setEnabled(!isEmail);
        this._values[DESTINATION_EMAIL].setEnabled(isEmail);
        this._labels[DEST_HTTP_URL].setEnabled(!isEmail);
        this._labels[DESTINATION_EMAIL].setEnabled(isEmail);
        type.addChangeListener(this);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        boolean isEmail = ((JToggleButton)e.getSource()).getText().equals("email");
        this._values[DEST_HTTP_URL].setEnabled(!isEmail);
        this._values[DESTINATION_EMAIL].setEnabled(isEmail);
        this._labels[DEST_HTTP_URL].setEnabled(!isEmail);
        this._labels[DESTINATION_EMAIL].setEnabled(isEmail);
    }
}

