/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.InsertDialog;
import com.cisco.dcbu.sm.client.gui.InsertForm;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.Switch;
import java.awt.event.ActionEvent;

public class SmInsertCallhomeDestProfile
extends InsertForm {
    private static int TRANSPORT_METHOD = 5;

    public SmInsertCallhomeDestProfile(SnmpPeer[] peers, InsertDialog parent, SmTableModel table) {
        super(peers, parent, table, false);
        this.setSwVersionSupportedGreaterThanEqual("1.3(0)");
    }

    @Override
    protected int[] getInsertIndex(SnmpVar[] values) throws Exception {
        int[] index = super.getInsertIndex(values);
        int[] newIndex = new int[index.length + 1];
        System.arraycopy(index, 0, newIndex, 1, index.length);
        newIndex[0] = index.length;
        return newIndex;
    }

    @Override
    protected void build() throws Exception {
        super.build();
        this._labels[TRANSPORT_METHOD].setText("TransportMethod:");
        this._choice.setActionCommand("L");
        this._choice.addActionListener(this);
        this.updateInputFields();
    }

    void updateInputFields() {
        SnmpPeer peer = (SnmpPeer)this._choice.getSelectedItem();
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        boolean isAbove4dot2 = sw.isVersionGreaterThanEqual("4.2(0)");
        this.setComponentVisibleAt(TRANSPORT_METHOD, isAbove4dot2);
        this.setEnabled(TRANSPORT_METHOD, isAbove4dot2);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        switch (cmd.charAt(0)) {
            case 'L': {
                this.updateInputFields();
                return;
            }
        }
        super.actionPerformed(e);
    }
}

