/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.StringUtil;
import com.cisco.dcbu.portland.lib.util.CommonRoleExtUtil;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.dialogs.SmInsertCommonRole;
import com.cisco.dcbu.sm.client.gui.InsertDialog;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.Switch;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class SmInsertCommonRoleExt
extends SmInsertCommonRole
implements ItemListener {
    protected static final int VLAN_SCOPE_TEXT = 6;
    protected static final int VLAN_ENABLE = 7;
    protected static final int VLAN_SCOPE = 8;
    protected static final int[] ccreRowStatus = MibNode.get("ccreRoleRowStatus").getOid();
    protected static final int[] ccreRoleDesc = MibNode.get("ccreRoleDescription").getOid();
    protected static final int[] ccreRoleResourceAccess = MibNode.get("ccreRoleResourceAccess").getOid();

    public SmInsertCommonRoleExt(SnmpPeer[] peers, InsertDialog parent, SmTableModel table) {
        super(peers, parent, table);
    }

    @Override
    protected void build() throws Exception {
        super.build();
        this._labels[8].setEnabled(false);
        this._values[8].setEnabled(false);
        this.setComponentVisibleAt(6, false);
        this.setComponentVisibleAt(7, false);
        this.setComponentVisibleAt(8, false);
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        switch (index) {
            case 2: {
                return new JCheckBox("Has Config, Exec and Show Permission (MDS only) ", true);
            }
            case 7: {
                JCheckBox comp = (JCheckBox)super.buildComponent(mibVar, mibNode, index);
                comp.addItemListener(this);
                return comp;
            }
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        switch (index) {
            case 2: {
                this._bRuleRW = ((JCheckBox)this._values[index]).isSelected();
                return null;
            }
            case 4: {
                return new SnmpInt(((JCheckBox)this._values[index]).isSelected() ? 2 : 1);
            }
            case 7: 
            case 8: {
                return null;
            }
        }
        return super.getComponentValue(index);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        boolean isSelected;
        boolean bl = isSelected = e.getStateChange() == 1;
        if (e.getSource() == this._values[7]) {
            this.setEnabled(8, isSelected);
        } else {
            super.itemStateChanged(e);
        }
    }

    @Override
    protected SnmpPDU getInsertPDU(SnmpPeer peer, VarBindList vbl) throws Exception {
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        if (sw.isN5K()) {
            return this.getInsertPDUForN5K(peer);
        }
        return super.getInsertPDU(peer, vbl);
    }

    private SnmpPDU getInsertPDUForN5K(SnmpPeer peer) throws Exception {
        SnmpVar[] values = this.getInsertValue();
        int[] insertIndex = this.getInsertIndex(values);
        this.insertRoleAndScopes(peer, insertIndex);
        this._firstOid = ccreRoleDesc;
        VarBindList vbl = new VarBindList();
        SnmpPDU pdu = new SnmpPDU(-93, vbl);
        vbl.add(new SnmpVarBind(new SnmpOID(ccreRoleDesc, insertIndex), new SnmpString(this.getComponentText(1))));
        return pdu;
    }

    protected void insertRoleAndScopes(SnmpPeer peer, int[] index) throws Exception {
        VarBindList vbl = new VarBindList();
        vbl.add(new SnmpVarBind(new SnmpOID(ccreRowStatus, index), new SnmpInt(this._table.getInsertValue())));
        vbl.add(new SnmpVarBind(new SnmpOID(ccreRoleResourceAccess, index), this.getUpdatedPolicyString()));
        SnmpPDU pdu = new SnmpPDU(-93, vbl);
        peer.set(pdu);
        pdu = new SnmpPDU(-93, new VarBindList());
        this.addScopes(pdu, index);
        peer.set(pdu);
    }

    private SnmpString getUpdatedPolicyString() {
        byte[] b = new byte[1];
        if (!((JCheckBox)this._values[4]).isSelected()) {
            SnmpString.setBitBase0(b, 0);
        }
        if (!((JCheckBox)this._values[7]).isSelected()) {
            SnmpString.setBitBase0(b, 1);
        }
        SnmpString.setBitBase0(b, 2);
        return new SnmpString(b);
    }

    private void addScopes(SnmpPDU pdu, int[] index) throws Exception {
        int[] lRoleNameIndex = index;
        int[] lScopes = new int[]{5, 8};
        int lCount = 1;
        for (int lScope : lScopes) {
            String str;
            if (!this._values[lScope].isEnabled() || (str = ((JTextField)this._values[lScope]).getText()) == null || str.length() == 0) continue;
            int[] lValues = this.getScopesToBeInserted(str, lScope);
            int rest = this.getRestrictionToBeInserted(lScope);
            if (lValues == null) continue;
            for (int value : lValues) {
                SnmpOID insertIndex = new SnmpOID(lRoleNameIndex, lCount);
                CommonRoleExtUtil.getInstance().createNewScope(pdu, insertIndex.getValue(), new SnmpInt(rest), new SnmpInt(value));
                ++lCount;
            }
        }
    }

    private int[] getScopesToBeInserted(Object o, int col) throws Exception {
        int[] lScopeValues = null;
        if (col == 5 || col == 8) {
            Array ids = StringUtil.tokenize(o.toString(), ",", "-", 10, true, 1, 4096, true);
            lScopeValues = new int[ids.size()];
            for (int i = 0; i < ids.size(); ++i) {
                lScopeValues[i] = (Integer)ids.elementAt(i);
            }
        }
        return lScopeValues;
    }

    private int getRestrictionToBeInserted(int col) {
        switch (col) {
            case 5: {
                return 1;
            }
            case 8: {
                return 2;
            }
        }
        throw new IllegalArgumentException("Scope Restriction not defined for col :" + col);
    }
}

