/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.mds.PortInterfaceUtil;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpGauge;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.InsertDialog;
import com.cisco.dcbu.sm.client.gui.InsertForm;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.Switch;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class SmInsertFCIPTunnels
extends InsertForm
implements ItemListener {
    static final int IP_COMP = 11;
    static final int WRITE_ACC = 12;
    static final int TAPE_ACC = 13;
    static final int TAPE_MAX_OS = 14;
    static final int FICON_VSAN_LIST = 15;
    static final int ENABLE_XRC_EMULATOR = 16;
    int _idIndex = this.getVarIndex("cfmFcipLinkIndex");
    static final int[] _cfmFcipLinkExtFiconTAVsanL2kOid = MibNode.get("cfmFcipLinkExtFiconTAVsanL2k").getOid();

    public SmInsertFCIPTunnels(SnmpPeer[] peers, InsertDialog parent, SmTableModel table) {
        super(peers, parent, table, false);
    }

    @Override
    public void build() throws Exception {
        super.build();
        this._choice.setActionCommand("L");
        this._choice.addActionListener(this);
        this.updateInputFields();
        this._values[14].setEnabled(false);
        this._labels[14].setEnabled(false);
        ((JCheckBox)this._values[13]).addItemListener(this);
    }

    @Override
    protected int[] getInsertIndex(SnmpVar[] values) throws Exception {
        int[] index = super.getInsertIndex(values);
        index[1] = index[1] - 1;
        return index;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        boolean isSelected = e.getStateChange() == 1;
        JComponent comp = (JComponent)e.getSource();
        if (comp == this._values[13]) {
            this._values[14].setEnabled(isSelected);
            this._labels[14].setEnabled(isSelected);
            if (isSelected) {
                ((FieldPanel)this._values[14]).setText("0");
            }
        }
    }

    @Override
    protected void insertAction() throws Exception {
        super.insertAction();
        int curIndex = Integer.parseInt(this.getComponentText(this._idIndex));
        this.updateFields(curIndex);
    }

    protected void updateFields(int curIndex) {
        int nextIndex = curIndex + 1;
        this.setComponentText(this._idIndex, Integer.toString(nextIndex));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        switch (cmd.charAt(0)) {
            case 'L': {
                this.updateInputFields();
                return;
            }
        }
        super.actionPerformed(e);
    }

    void updateInputFields() {
        SnmpPeer peer = (SnmpPeer)this._choice.getSelectedItem();
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        boolean isSupported = sw.isVersionGreaterThanEqual("1.3(0)");
        this.setEnabled(11, isSupported);
        this.setEnabled(12, isSupported);
        isSupported = sw.isVersionGreaterThanEqual("2.0(0)");
        if (!isSupported) {
            this.setEnabled(13, isSupported);
            this.setEnabled(14, isSupported);
        }
        isSupported = sw.isVersionGreaterThanEqual("3.0(0)");
        this.setEnabled(15, isSupported);
        isSupported = sw.isVersionGreaterThanEqual("4.2(0)");
        this.setEnabled(16, isSupported);
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 14) {
            return new FieldPanel(10, mibNode.getLo(), mibNode.getHi(), (String)SnmpTableModel._Units.get(mibVar), true, "(0=Auto)");
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        int n;
        if (index == 14 && (n = FieldPanel.getNumber(((FieldPanel)this._values[index]).getField().getText())) == 0) {
            return new SnmpGauge(0L);
        }
        return super.getComponentValue(index);
    }

    @Override
    protected JLabel createFormLabel(String mibVar, int index) {
        if (index == 15) {
            return new JLabel("FICON TA VSAN List:", 4);
        }
        return super.createFormLabel(mibVar, index);
    }

    @Override
    protected SnmpPDU getInsertPDU(SnmpPeer peer, VarBindList vbl) throws Exception {
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        boolean isVersion30Above = sw.isVersionGreaterThanEqual("3.0(0)");
        if (isVersion30Above) {
            for (int i = vbl.size() - 1; i >= 0; --i) {
                SnmpOID oidObj = vbl.get(i).getOid();
                if (!oidObj.startsWith(_cfmFcipLinkExtFiconTAVsanL2kOid)) continue;
                SnmpVar var = vbl.get(i).getVar();
                int[] oid = oidObj.getValue();
                int indexLen = oid.length - _cfmFcipLinkExtFiconTAVsanL2kOid.length;
                int[] index = new int[indexLen];
                System.arraycopy(oid, _cfmFcipLinkExtFiconTAVsanL2kOid.length, index, 0, indexLen);
                PortInterfaceUtil.getInstance(11).addVsan4k2Pdu(vbl, oidObj, var, index);
                break;
            }
        }
        return super.getInsertPDU(peer, vbl);
    }
}

