/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.ui.CheckBoxPanel;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.sm.client.gui.InsertDialog;
import com.cisco.dcbu.sm.client.gui.InsertForm;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;

public class SmInsertIpsecXFormSet
extends InsertForm {
    static final int NAME = 0;
    static final int PROTO = 1;
    static final int ENCRYPT = 2;
    static final int AUTH = 3;
    static final int MODE = 4;
    static final int ESP_ENCRYP = 0;
    static final int ESP_AUTH = 1;
    static final int SNM_ESP_ENCRP_VAL = 2;
    static final int SNM_ESP_ENCRP_AUTH_VAL = 12;
    static final int AUTH_NONE = 0;
    static final int ENCRYP_AES_128 = 2;
    static final int ENCRYP_AESCTR_128 = 4;
    static final int ENCRYP_AESCTR_256 = 5;

    public SmInsertIpsecXFormSet(SnmpPeer[] peers, InsertDialog parent, SmTableModel table) {
        super(peers, parent, table);
    }

    @Override
    protected void build() throws Exception {
        super.build();
        CheckBoxPanel protoPanel = (CheckBoxPanel)this._values[1];
        for (int i = 0; i < protoPanel.getComponentCount(); ++i) {
            if (i == 0) {
                ((JCheckBox)protoPanel.getButton(i)).setSelected(true);
                ((JCheckBox)protoPanel.getButton(i)).setEnabled(false);
            }
            protoPanel.getButton(i).addActionListener(this);
            protoPanel.getButton(i).setActionCommand("protocol");
        }
        RadioButtonPanel ecrypPanel = (RadioButtonPanel)this._values[2];
        ((JRadioButton)ecrypPanel.getButton(4)).setEnabled(false);
        ((JRadioButton)ecrypPanel.getButton(5)).setEnabled(false);
        RadioButtonPanel authPanel = (RadioButtonPanel)this._values[3];
        authPanel.setEnabled(false);
        authPanel.getButton(0).setVisible(false);
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 1) {
            return new CheckBoxPanel(new String[]{"ESP-Encryption", "ESP-Auth"}, 2);
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == 1) {
            CheckBoxPanel protoPanel = (CheckBoxPanel)this._values[index];
            if (((JCheckBox)protoPanel.getButton(1)).isSelected()) {
                return new SnmpInt(12);
            }
            return new SnmpInt(2);
        }
        return super.getComponentValue(index);
    }

    @Override
    protected int[] getInsertIndex(SnmpVar[] values) throws Exception {
        int[] index = super.getInsertIndex(values);
        int[] newIndex = new int[index.length + 1];
        System.arraycopy(index, 0, newIndex, 1, index.length);
        newIndex[0] = index.length;
        return newIndex;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("protocol")) {
            JCheckBox protoBtn = (JCheckBox)e.getSource();
            String cmd = protoBtn.getText();
            RadioButtonPanel authPanel = (RadioButtonPanel)this._values[3];
            if (cmd.equals("ESP-Auth")) {
                boolean isEspAuth = protoBtn.isSelected();
                authPanel.setEnabled(isEspAuth);
                RadioButtonPanel ecrypPanel = (RadioButtonPanel)this._values[2];
                ((JRadioButton)ecrypPanel.getButton(4)).setEnabled(isEspAuth);
                ((JRadioButton)ecrypPanel.getButton(5)).setEnabled(isEspAuth);
                int encrypSel = ecrypPanel.getSelected();
                if (!(isEspAuth || encrypSel != 4 && encrypSel != 5)) {
                    ecrypPanel.setSelected(2);
                }
            }
        } else {
            super.actionPerformed(e);
        }
    }
}

