/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.GroupButtonPanel;
import com.cisco.dcbu.lib.ui.MenuButton;
import com.cisco.dcbu.lib.ui.table.IvrDomainFcidCellEditor;
import com.cisco.dcbu.sm.client.dialogs.SmInsertIvrDomain;
import com.cisco.dcbu.sm.client.gui.InsertDialog;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class SmInsertIvrFcid
extends SmInsertIvrDomain {
    private static final int DEVICE_TYPE = 3;
    private static final int FCID = 5;

    public SmInsertIvrFcid(SnmpPeer[] peers, InsertDialog parent, SmTableModel table) {
        super(peers, parent, table);
    }

    @Override
    protected void build() throws Exception {
        super.build();
        this.setGroupButtonPanel((GroupButtonPanel)this._values[3], this._mibNodes[3].getEnums(), new SnmpInt(1));
        this.setComponentVisibleAt(3, false);
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 5 && this.getValidPeers().length == 1) {
            FieldPanel f = new FieldPanel(25, (JComponent)new domainIdMenuButton(null, this.getValidPeers()[0]));
            return f;
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    @Override
    protected boolean isAddStringLength(MibNode mibNode) {
        return mibNode.getType() == 4;
    }

    class domainIdMenuButton
    extends MenuButton {
        SnmpPeer _peer;
        int _currentAfid;
        int _currentVsan;

        public domainIdMenuButton(JMenu menu, SnmpPeer peer) {
            super(menu);
            this._peer = peer;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int currentAfid = -1;
            int currentVsan = -1;
            String text = ((FieldPanel)SmInsertIvrFcid.this._values[1]).getText();
            if (!text.equals("")) {
                currentAfid = Integer.parseInt(text);
                if (this._currentAfid != currentAfid) {
                    this._menu = null;
                }
                this._currentAfid = currentAfid;
            }
            if (!(text = ((FieldPanel)SmInsertIvrFcid.this._values[2]).getText()).equals("")) {
                currentVsan = Integer.parseInt(text);
                if (this._currentVsan != currentVsan) {
                    this._menu = null;
                }
                this._currentVsan = currentVsan;
            }
            if (this._currentAfid == -1 || this._currentVsan == -1) {
                this.setEnabled(false);
                return;
            }
            this._menu = new JMenu();
            Object[] names = IvrDomainFcidCellEditor.getDomainList(this._peer, this._currentAfid, this._currentVsan);
            if (names != null && names.length != 0) {
                this.buildMenu(names);
            }
            if (e.getSource() instanceof JMenuItem && this.getParent() instanceof FieldPanel) {
                String domainIdHex = Integer.toHexString(Integer.parseInt(((JMenuItem)e.getSource()).getText()));
                String fcid = ((FieldPanel)this.getParent()).getText();
                StringBuffer sb = new StringBuffer("0x");
                sb.append(domainIdHex);
                if (fcid.startsWith("0x") && fcid.length() == 8) {
                    sb.append(fcid.substring(4, fcid.length()));
                } else {
                    sb.append("0000");
                }
                ((FieldPanel)this.getParent()).setText(sb.toString());
            } else {
                super.actionPerformed(e);
            }
        }
    }
}

