/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.SnmpFcAddressId;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.PortEditorFilter;
import com.cisco.dcbu.lib.mds.PortSetEditor;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.KTextField;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.HashedArrayList;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.dialogs.IslData;
import com.cisco.dcbu.sm.client.dialogs.SmPreferredPathTableModel;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.InsertDialog;
import com.cisco.dcbu.sm.client.gui.InsertForm;
import com.cisco.dcbu.sm.client.gui.SmPortSetFieldPanel;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SmInsertPreferredPath
extends InsertForm
implements ItemListener,
ListSelectionListener {
    static final int COL_VSAN_ID = 0;
    static final int COL_INTERFACE = 1;
    static final int COL_DEST_DOMAIN = 2;
    static final int COL_DEST_MASK = 3;
    static final int COL_HOLDER_ISLS = 5;
    static final int COL_PRI_ISL = 7;
    static final int COL_SEC_ISL = 9;
    static final String CMD_ADD_PRIPATH = "Add Primary";
    static final String CMD_ADD_SECPATH = "Add Secondary";
    static final String FILTER_DIRECT = "direct";
    static final String FILTER_ANY = "any";
    static final int ISL_FILTER_DIRECT = 0;
    static final int ISL_FILTER_ANY = 1;
    private SnmpPeer _srcPeer;
    private DomainData _selDomain;
    private JLabel _ifLabel;
    private JLabel _destDomainLabel;
    private JLabel _vsanLabel;
    private JLabel _destMaskLabel;
    private JLabel _holderIslLabel;
    private JLabel _priIslLabel;
    private JLabel _secIslLabel;
    private JButton[] _cmdBtns;
    private SmPortSetFieldPanel _portChooserPanel;
    private RadioButtonPanel _filterBtnPanel;
    private JList _domainList;
    private JList _islList;
    private JTextField _domainField;
    private JTextField _priIsl;
    private JTextField _secIsl;
    private int _vsanId;
    private Vsan _vsan;
    private int _portMemIndex;
    private int[] _portMemIfIndices;

    public SmInsertPreferredPath(SnmpPeer[] peers, InsertDialog parent, SmTableModel table) {
        super(peers, parent, table, false);
        this._vsanId = ((SmPreferredPathTableModel)this._table).getVsanId();
        this._vsan = (Vsan)ClientController.getInstance().getSelectedDomain();
    }

    @Override
    protected void build() throws Exception {
        super.build();
        this._choice.setActionCommand("L");
        this._choice.addActionListener(this);
        this._srcPeer = (SnmpPeer)this._choice.getSelectedItem();
        this._labels[0].setVisible(false);
        this._values[0].setVisible(false);
        this._labels[3].setVisible(false);
        this._values[3].setVisible(false);
        this._priIsl = (JTextField)this._values[7];
        this._secIsl = (JTextField)this._values[9];
        this._portChooserPanel.setNode((SnmpPeer)this._choice.getSelectedItem());
    }

    @Override
    protected JLabel createFormLabel(String mibVar, int index) {
        switch (index) {
            case 1: {
                this._ifLabel = new JLabel("Interface:", 4);
                return this._ifLabel;
            }
            case 2: {
                this._destDomainLabel = new JLabel("<html><div align=right>Available<br>Destination<br>Domain:<br>[ip, switch wwn, domain]</html>", 4);
                return this._destDomainLabel;
            }
            case 0: {
                this._vsanLabel = new JLabel("VSAN:", 4);
                return this._vsanLabel;
            }
            case 3: {
                this._destMaskLabel = new JLabel("Mask:", 4);
                return this._destMaskLabel;
            }
            case 5: {
                this._holderIslLabel = new JLabel("<html><div align=right>Available<br>ISLs:</html>", 4);
                return this._holderIslLabel;
            }
            case 7: {
                this._priIslLabel = new JLabel("Interface:", 4);
                return this._priIslLabel;
            }
            case 9: {
                this._secIslLabel = new JLabel("Interface:", 4);
                return this._secIslLabel;
            }
        }
        return super.createFormLabel(mibVar, index);
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 1) {
            short ss = SmPortSetFieldPanel.SHOW_ISL_PC_BMP;
            ss = (short)(ss | SmPortSetFieldPanel.SHOW_F_PC_BMP);
            PortEditorFilter psFilter = new PortEditorFilter(new int[]{1});
            this._portChooserPanel = new SmPortSetFieldPanel(false, 20, psFilter, ss);
            return this._portChooserPanel;
        }
        if (index == 2) {
            JPanel panel = new JPanel(new BorderLayout(1, 2));
            this._domainList = new JList();
            this._domainList.addListSelectionListener(this);
            this._domainList.setSelectionMode(1);
            JScrollPane sp = new JScrollPane(this._domainList);
            sp.setPreferredSize(new Dimension(300, 100));
            panel.add("Center", sp);
            this._domainField = new KTextField();
            panel.add("South", this._domainField);
            this.updateDomainList(this._peers[0]);
            return panel;
        }
        if (index == 5) {
            JPanel panel = new JPanel(new BorderLayout(1, 2));
            Object[] btnNames = new String[]{FILTER_DIRECT, FILTER_ANY};
            this._filterBtnPanel = new RadioButtonPanel(btnNames, 3, this);
            panel.add("North", this._filterBtnPanel);
            this._islList = new JList();
            this._islList.setSelectionMode(1);
            JScrollPane sp = new JScrollPane(this._islList);
            sp.setPreferredSize(new Dimension(300, 100));
            panel.add("Center", sp);
            String[] bLabels = new String[]{CMD_ADD_PRIPATH, CMD_ADD_SECPATH};
            this._cmdBtns = DialogUtil.buildButtons(bLabels, (ActionListener)this);
            JPanel btnPanel2 = new JPanel(new BorderLayout());
            if (this._cmdBtns != null) {
                JPanel buttonPanel = new JPanel(new FlowLayout(2, 6, 3));
                for (int i = 0; i < this._cmdBtns.length; ++i) {
                    buttonPanel.add(this._cmdBtns[i]);
                }
                btnPanel2.add("Center", buttonPanel);
            }
            panel.add("South", btnPanel2);
            return panel;
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        String cmd = ((JToggleButton)e.getSource()).getText();
        if (cmd.equals(FILTER_DIRECT) || cmd.equals(FILTER_ANY)) {
            this.updateIslList();
            return;
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if ((JList)e.getSource() == this._domainList) {
            this._selDomain = (DomainData)this._domainList.getSelectedValue();
            if (this._selDomain != null) {
                this._domainField.setText(this._selDomain.getDomainIdString());
                this.clearIsls();
            }
            this.updateIslList();
        }
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == 1) {
            return new SnmpInt(this._portMemIndex);
        }
        if (index == 2) {
            int domId = SmInsertPreferredPath.convertDomainIdToInteger(this._domainField.getText());
            if (domId < 0) {
                throw new Exception("Domain Id: invalid entry");
            }
            String domIdStr = "0x" + Integer.toHexString(domId) + "0000";
            return new SnmpFcAddressId(domIdStr);
        }
        if (index == 0) {
            return new SnmpInt(this._vsanId);
        }
        if (index == 3) {
            String domMask = "0xFF0000";
            return new SnmpFcAddressId(domMask);
        }
        if (index == 7) {
            if (this._priIsl.getText().trim().length() <= 0) {
                return null;
            }
            return super.getComponentValue(index);
        }
        if (index == 9) {
            if (this._secIsl.getText().trim().length() <= 0) {
                return null;
            }
            return super.getComponentValue(index);
        }
        return super.getComponentValue(index);
    }

    @Override
    protected void insertAction() throws Exception {
        if (!this.validateInput()) {
            return;
        }
        for (int i = 0; i < this._portMemIfIndices.length; ++i) {
            this._parent.setCursor(Cursor.getPredefinedCursor(3));
            this._portMemIndex = this._portMemIfIndices[i];
            this.insert();
            this._parent.setCursor(Cursor.getDefaultCursor());
            this.updateTableDisplay();
        }
        if (this._insertErrMsg.size() == 0) {
            this.setStatus("Success.");
        } else {
            this.showInsertError();
        }
    }

    protected boolean validateInput() throws Exception {
        boolean status = false;
        String port = ((FieldPanel)this._values[1]).getText();
        if (port == null || port.trim().length() <= 0) {
            Util.errorMessage((Component)this._parent, "Please select source interface(s).");
            return status;
        }
        String priIsl = ((JTextField)this._values[7]).getText();
        if (priIsl == null || priIsl.trim().length() <= 0) {
            Util.errorMessage((Component)this._parent, "Please specify a primary ISL.");
            return status;
        }
        String secIsl = ((JTextField)this._values[9]).getText();
        if (secIsl != null && secIsl.equals(priIsl) && JOptionPane.showOptionDialog(this._parent, "Primary ISL Interface and Secondary ISL Interface are the same.\nDo you want to continue?", this._parent.getTitle(), 0, 2, null, new String[]{"Yes", "No"}, "No") == 1) {
            return status;
        }
        this._portMemIfIndices = SnmpIntList.parse(port, this.getSelectedIfIndexIf());
        Switch srcSw = ClientController.findFabricSwitchByIpAddress(this._srcPeer.getAddress());
        HashedArrayList<EndPort> upPorts = new HashedArrayList<EndPort>();
        HashedArrayList<EndPort> srcPorts = new HashedArrayList<EndPort>();
        srcSw.getEndPorts(srcPorts);
        for (EndPort thisPort : srcPorts) {
            int thisIndex = thisPort.getIfIndex();
            for (int j = 0; j < this._portMemIfIndices.length; ++j) {
                if (thisIndex != this._portMemIfIndices[j] || !thisPort.getStatus().equalsIgnoreCase("ok")) continue;
                ((ArrayList)upPorts).add(thisPort);
            }
        }
        if (upPorts.size() > 0 && JOptionPane.showOptionDialog(this._parent, "Some port is up. Setting/Changing Preferred Path may affect I/O.\nDo you want to continue?", this._parent.getTitle(), 0, 2, null, new String[]{"Yes", "No"}, "No") == 1) {
            return status;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        switch (cmd.charAt(0)) {
            case 'L': {
                this._srcPeer = (SnmpPeer)this._choice.getSelectedItem();
                this.updateDomainList(this._srcPeer);
                return;
            }
        }
        if (cmd.equals(CMD_ADD_PRIPATH)) {
            IslData islData = (IslData)this._islList.getSelectedValue();
            if (islData == null) {
                Util.errorMessage((Component)this._parent, "Please select an ISL.");
                return;
            }
            String ifName = islData.getSrcIfName();
            this._priIsl.setText(ifName);
            return;
        }
        if (cmd.equals(CMD_ADD_SECPATH)) {
            IslData islData = (IslData)this._islList.getSelectedValue();
            if (islData == null) {
                Util.errorMessage((Component)this._parent, "Please select an ISL.");
                return;
            }
            String ifName = islData.getSrcIfName();
            this._secIsl.setText(ifName);
            return;
        }
        if (cmd.equals(FILTER_DIRECT) || cmd.equals(FILTER_ANY)) {
            this.updateIslList();
            return;
        }
        super.actionPerformed(e);
    }

    @Override
    public void dispose() {
        PortSetEditor.getInstance(BrowserFrame.getInstance()).hideDlg();
    }

    void updateDomainList(SnmpPeer peer) {
        Switch selSw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        String selIpAddr = selSw.getIpAddress();
        Switch[] switches = this._vsan.getSwitches();
        ArrayList<DomainData> domArray = new ArrayList<DomainData>();
        for (Switch sw : switches) {
            String ipAddr = sw.getIpAddress();
            if (ipAddr != null && selIpAddr.equals(ipAddr)) continue;
            DomainData data = new DomainData(sw, this._vsanId);
            domArray.add(data);
        }
        this._domainList.setListData(domArray.toArray());
        this._domainField.setText("");
        this.clearIsls();
        if (this._portChooserPanel != null) {
            this._portChooserPanel.setText("");
        }
    }

    protected void clearIsls() {
        if (this._islList != null) {
            this._islList.setListData(new Object[0]);
        }
        if (this._priIsl != null) {
            this._priIsl.setText("");
        }
        if (this._secIsl != null) {
            this._secIsl.setText("");
        }
    }

    public void updateIslList() {
        if (this._selDomain == null) {
            return;
        }
        this.clearIsls();
        Switch srcSw = ClientController.findFabricSwitchByIpAddress(this._srcPeer.getAddress());
        Switch dstSw = this._selDomain.getSwitch();
        boolean directConn = this._filterBtnPanel.getSelected() == 0;
        ArrayList<IslData> islList = new ArrayList<IslData>();
        ((SmPreferredPathTableModel)this._table).getIslList(srcSw, dstSw, this._vsan, directConn, islList);
        this._islList.setListData(islList.toArray());
    }

    public static int convertDomainIdToInteger(String idStr) throws NumberFormatException {
        if (idStr == null || idStr.trim().length() == 0) {
            throw new NumberFormatException("Input string is null or empty.");
        }
        if (idStr.indexOf(40) >= 0) {
            int value = Integer.parseInt(idStr.substring(idStr.indexOf(40) + 1, idStr.indexOf(41)));
            return value;
        }
        if (idStr.toLowerCase().startsWith("0x")) {
            int value = Integer.parseInt(idStr.substring(2), 16);
            return value;
        }
        return Integer.parseInt(idStr);
    }

    protected void insert_test() throws Exception {
        this.insertInit();
        this._insertValues = this.getInsertValue();
        int[] index = this.getInsertIndex(this._insertValues);
        VarBindList vbl = this.buildInsertVarbind(index, this._insertValues);
        this.insertRow(vbl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callback_test(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        SnmpPeer node = SnmpPeer.findPeer(pdu.getAddress());
        ++this._successfulSets;
        this.processInsertCfs();
        SnmpPeer[] vb = pdu.getVariables().getVb(0);
        int[] oid = vb.getOid().getValue();
        if (oid.length >= this._firstOid.length) {
            int[] index = new int[oid.length - this._firstOid.length];
            System.arraycopy(oid, this._firstOid.length, index, 0, oid.length - this._firstOid.length);
            if (this._insertRowCallback != null) {
                SnmpPDU qPdu = this._table.buildGetPdu(node, this.getTableIndex(index));
                ++this._pending;
                try {
                    node.send(qPdu, this._insertRowCallback);
                }
                catch (SnmpException ex) {
                    // empty catch block
                }
            }
        }
        --this._pending;
        if (this._pending <= 0) {
            try {
                vb = this._peers;
                synchronized (this._peers) {
                    this._peers.notifyAll();
                    // ** MonitorExit[vb] (shouldn't be in output)
                }
            }
            catch (IllegalMonitorStateException ex) {
                DefaultLogger._DefLogger.error((Object)ex);
            }
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertRowCallback_test(SnmpPDU pdu, boolean timedOut) {
        SnmpPeer node = SnmpPeer.findPeer(pdu.getAddress());
        SnmpPeer[] vb = pdu.getVariables().getVb(0);
        int[] oid = vb.getOid().getValue();
        int[] firstOid = this.getTableFirstOid();
        SnmpOID index = new SnmpOID(oid, firstOid.length, oid.length - firstOid.length);
        SmTableModel curActiveTableModel = BrowserFrame.getDataView()._tableModel;
        boolean bAddRow2Table = true;
        if (bAddRow2Table) {
            this._table.addElement(pdu.getVariables(), node, index);
            if (!this._peer2InsertRowIndex.containsKey(node)) {
                int rowIndex = this._table.getData().size() - 1;
                this._peer2InsertRowIndex.put(node, new Integer(rowIndex));
            }
        }
        --this._pending;
        if (this._pending <= 0) {
            try {
                vb = this._peers;
                synchronized (this._peers) {
                    this._peers.notifyAll();
                    // ** MonitorExit[vb] (shouldn't be in output)
                }
            }
            catch (IllegalMonitorStateException ex) {
                DefaultLogger._DefLogger.error((Object)ex);
            }
        }
        {
            return;
        }
    }

    class DomainData {
        Switch _swData;
        int _vsanId;

        public DomainData(Switch sw, int vsanId) {
            this._swData = sw;
            this._vsanId = vsanId;
        }

        public Switch getSwitch() {
            return this._swData;
        }

        public String getIpAddress() {
            return this._swData.getIpAddress();
        }

        public int getDomainId() {
            return this._swData.getDomainId(this._vsanId);
        }

        public String getDomainIdString() {
            return "0x" + Integer.toHexString(this._swData.getDomainId(this._vsanId)) + '(' + this._swData.getDomainId(this._vsanId) + ')';
        }

        public String toString() {
            String wwnStr;
            StringBuffer domBuf = new StringBuffer();
            if (this.getIpAddress() != null) {
                domBuf.append(this.getIpAddress());
            }
            if ((wwnStr = this._swData.getWwn().toString()) != null) {
                domBuf.append(',').append(wwnStr);
            }
            domBuf.append(",0x" + Integer.toHexString(this._swData.getDomainId(this._vsanId)) + '(' + this._swData.getDomainId(this._vsanId) + ')');
            return domBuf.toString();
        }
    }
}

