/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.ui.KTextField;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.sm.client.gui.InsertDialog;
import com.cisco.dcbu.sm.client.gui.InsertForm;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class SmInsertQosPolicy2Class
extends InsertForm {
    static final int POLICYMAP_ID = 0;
    static final int ID = 1;
    static final int CLASSMAP_ID = 2;
    static final int DSCP = 3;
    static final int[] _cdsmFCMultiFieldClfrStatusOid = MibNode.get("cdsmFCMultiFieldClfrStatus").getOid();
    static final int[] _diffServActionStatusOid = MibNode.get("diffServActionStatus").getOid();

    public SmInsertQosPolicy2Class(SnmpPeer[] peers, InsertDialog parent, SmTableModel table) {
        super(peers, parent, table);
    }

    @Override
    protected JLabel createFormLabel(String mibVar, int index) {
        switch (index) {
            case 0: {
                return new JLabel("Policy Map Id:", 4);
            }
            case 2: {
                return new JLabel("Class Map Id:", 4);
            }
            case 3: {
                return new JLabel("Priority:", 4);
            }
        }
        return super.createFormLabel(mibVar, index);
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 3) {
            Object[] priority = new String[]{"high", "medium", "low"};
            RadioButtonPanel priPanel = new RadioButtonPanel(priority, 3);
            priPanel.setSelected(0);
            return priPanel;
        }
        if (index == 0 || index == 2) {
            return new KTextField(10);
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == 2) {
            int classMapId = Integer.parseInt(this.getComponentText(index));
            int[] rowPtr = new int[_cdsmFCMultiFieldClfrStatusOid.length + 1];
            System.arraycopy(_cdsmFCMultiFieldClfrStatusOid, 0, rowPtr, 0, _cdsmFCMultiFieldClfrStatusOid.length);
            rowPtr[rowPtr.length - 1] = classMapId;
            return new SnmpOID(rowPtr);
        }
        if (index == 3) {
            int selected = ((RadioButtonPanel)this._values[index]).getSelected();
            int actionTableIndex = selected == 0 ? 13 : (selected == 1 ? 19 : 1);
            int[] rowPtr = new int[_diffServActionStatusOid.length + 1];
            System.arraycopy(_diffServActionStatusOid, 0, rowPtr, 0, _diffServActionStatusOid.length);
            rowPtr[rowPtr.length - 1] = actionTableIndex;
            return new SnmpOID(rowPtr);
        }
        return super.getComponentValue(index);
    }

    @Override
    protected String getErrMsgFieldName(String mibVar, int index) {
        if (index == 0) {
            return "Policy Map Id";
        }
        if (index == 2) {
            return "Class Map Id";
        }
        if (index == 3) {
            return "Priority";
        }
        return super.getErrMsgFieldName(mibVar, index);
    }
}

