/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.SnmpBitmap;
import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpAggregrate;
import com.cisco.dcbu.lib.snmp.SnmpAggregrateIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogSeparator;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.GroupButtonPanel;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.HeaderListener;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.InsertDialog;
import com.cisco.dcbu.sm.client.gui.InsertForm;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.common.dto.VsanDomain;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;

public class SmInsertVsan
extends InsertForm
implements ItemListener,
SnmpAggregrateIf {
    int _indexIndex = this.getVarIndex("vsanIndex");
    int _nameIndex = this.getVarIndex("vsanName");
    boolean _bSendVsanName;
    JCheckBox _ficonCB;
    JCheckBox _fabricBindingCB;
    JCheckBox _allPortProhibitCB;
    JCheckBox _useStaticDmId;
    private FieldPanel _uniqueDmList = null;
    private JButton _applyDmIdBtn = null;
    static final String[] DMIDTableLabels = new String[]{"Switch", "DomainId"};
    VsanCreateDmIdTableModel _dmIdmodel;
    SnmpKTable _dmIdtable;
    JPanel _pDmIdPanel;
    private static final int SNMP_TRUE = 1;
    private static final int SNMP_FALSE = 2;
    private static final int ID = 0;
    private static final int NAME = 1;
    private static final int LOAD_BALANCING = 2;
    private static final int INTEROPERTYPE = 3;
    private static final int ADMIN = 4;
    private static final int FICON = 5;
    private static final int INORDER_DELIVERY = 6;
    private static final int TIMER_RATOV = 7;
    private static final int TIMER_DSTOV = 8;
    private static final int TIMER_EDTOV = 9;
    private static final int DROP_LATENCY = 10;
    private static final int INTEROPERMODE = 11;
    static final int[] _dmDomainIdOid = MibNode.get("dmDomainId").getOid();

    public SmInsertVsan(SnmpPeer[] peers, InsertDialog parent, SmTableModel table) {
        super(peers, parent, table);
    }

    @Override
    protected void build() throws Exception {
        int newVsanId;
        super.build();
        this._values[5].setVisible(false);
        this._values[5].setEnabled(false);
        this._values[6].setVisible(false);
        this._values[6].setEnabled(false);
        this._values[7].setVisible(false);
        this._values[7].setEnabled(false);
        this._labels[7].setVisible(false);
        this._values[8].setVisible(false);
        this._values[8].setEnabled(false);
        this._labels[8].setVisible(false);
        this._values[9].setVisible(false);
        this._values[9].setEnabled(false);
        this._labels[9].setVisible(false);
        this._values[10].setVisible(false);
        this._values[10].setEnabled(false);
        this._labels[10].setVisible(false);
        this._values[11].setVisible(false);
        Vsan[] vsans = ClientController.getInstance().getFabric().getVsans();
        byte[] vsanIds = new byte[512];
        for (int i = 0; i < vsans.length; ++i) {
            int vsanId = vsans[i].getVsanId();
            SnmpString.setBit(vsanIds, vsanId);
        }
        for (newVsanId = 1; SnmpString.getBit(vsanIds, newVsanId) && newVsanId < 4094; ++newVsanId) {
        }
        if (newVsanId < 4094) {
            this.setComponentText(this._indexIndex, Integer.toString(newVsanId));
        }
        this._list.addChangeListener(this);
        ((GroupButtonPanel)this._values[3]).addChangeListener(new InteropItemListener());
    }

    @Override
    protected void layoutForm() {
        JComponent[] labels = new JComponent[this._labels.length + 6];
        System.arraycopy(this._labels, 0, labels, 0, this._labels.length);
        JComponent[] values = new JComponent[this._values.length + 6];
        System.arraycopy(this._values, 0, values, 0, this._values.length);
        values[values.length - 6] = new DialogSeparator();
        values[values.length - 5] = new JPanel(new FlowLayout(0, 2, 0));
        this._useStaticDmId = new JCheckBox("Static Domain Ids:", false);
        values[values.length - 5].add(this._useStaticDmId);
        this._useStaticDmId.setToolTipText("<html>Find unused Domain Ids in Fabric: " + ClientController.getInstance().getFabric() + ".<br>(The Logical Domains VSAN tree should be up to date)");
        this._applyDmIdBtn = new JButton("Apply");
        this._uniqueDmList = new FieldPanel(20, (JComponent)this._applyDmIdBtn);
        values[values.length - 5].add(this._uniqueDmList);
        this._uniqueDmList.setEnabled(false);
        this._useStaticDmId.addItemListener(this);
        this._applyDmIdBtn.addActionListener(this);
        this._pDmIdPanel = new JPanel(new BorderLayout());
        this._dmIdmodel = new VsanCreateDmIdTableModel();
        this._dmIdmodel.setHeaders(DMIDTableLabels);
        this._dmIdmodel.setEditable(new boolean[]{false, true});
        this._dmIdmodel._mibNodes = new MibNode[DMIDTableLabels.length];
        this._dmIdmodel._mibNodes[1] = MibNode.get("dmConfigDomainId");
        this._dmIdtable = new SnmpKTable(this._dmIdmodel);
        this._dmIdtable.setSelectionMode(0);
        this._dmIdtable.setAutoResizeMode(3);
        this._dmIdtable.getTableHeader().addMouseListener(new HeaderListener());
        this._dmIdtable.setSortable(true);
        this._dmIdtable.addPopupMenu();
        ((JLabel)((Object)this._dmIdtable.getTableHeader().getDefaultRenderer())).setHorizontalAlignment(2);
        JScrollPane sp = new JScrollPane(this._dmIdtable);
        sp.setPreferredSize(new Dimension(100, 100));
        this._pDmIdPanel.add("Center", sp);
        values[values.length - 4] = this._pDmIdPanel;
        Array<Object[]> data = new Array<Object[]>();
        this._dmIdmodel.setData(data);
        SnmpPeer[] dmIdPeers = this.getInsertPeerList();
        for (int i = 0; i < dmIdPeers.length; ++i) {
            Switch sw = ClientController.findFabricSwitchByIpAddress(dmIdPeers[i].getAddress());
            Object[] row = new Object[DMIDTableLabels.length + 1];
            row[0] = dmIdPeers[i];
            row[1] = "";
            data.addElement(row);
        }
        this._ficonCB = new JCheckBox("FICON");
        values[values.length - 3] = this._ficonCB;
        this._ficonCB.addItemListener(this);
        this._fabricBindingCB = new JCheckBox("Enable Fabric Binding for Selected Switches");
        values[values.length - 2] = this._fabricBindingCB;
        this._fabricBindingCB.setEnabled(false);
        this._allPortProhibitCB = new JCheckBox("All Port Prohibited");
        values[values.length - 1] = this._allPortProhibitCB;
        this._allPortProhibitCB.setEnabled(false);
        DialogUtil.buildPanel(this._container, labels, values);
        this._pDmIdPanel.setVisible(false);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this._ficonCB) {
            boolean isSelected = e.getStateChange() == 1;
            this._fabricBindingCB.setEnabled(isSelected);
            this._allPortProhibitCB.setEnabled(isSelected);
            RadioButtonPanel lb = (RadioButtonPanel)this._values[2];
            lb.getButton(1).setEnabled(!isSelected);
            lb.setSelected(isSelected ? 0 : 1);
            lb = (RadioButtonPanel)this._values[3];
            lb.getButton(1).setEnabled(!isSelected);
            lb.getButton(2).setEnabled(!isSelected);
            lb.getButton(3).setEnabled(!isSelected);
            lb.getButton(4).setEnabled(!isSelected);
            if (isSelected) {
                lb.setSelected(0);
            }
            if (isSelected) {
                this._useStaticDmId.setSelected(isSelected);
                this.showDmIdSelection(isSelected);
                this.showDmTable(isSelected);
            }
            return;
        }
        if (e.getSource() == this._useStaticDmId) {
            boolean isStatic = this._useStaticDmId.isSelected();
            if (!isStatic && this._ficonCB.isSelected()) {
                Util.errorMessage((Component)BrowserFrame.getInstance(), "Static DomainIds is required for FICON");
                this._useStaticDmId.setSelected(true);
                isStatic = true;
            }
            this.showDmIdSelection(isStatic);
            this.showDmTable(isStatic);
        } else {
            int i;
            String swName = ((JToggleButton)e.getSource()).getText();
            Array dmIdData = this._dmIdmodel.getData();
            boolean findPeer = false;
            for (i = dmIdData.size() - 1; i >= 0; --i) {
                SnmpPeer peer = (SnmpPeer)((Object[])dmIdData.elementAt(i))[0];
                if (!peer.toString().equals(swName)) continue;
                findPeer = true;
                if (e.getStateChange() != 2) continue;
                dmIdData.removeElementAt(i);
                break;
            }
            if (!findPeer && e.getStateChange() == 1) {
                for (i = 0; i < this._peers.length; ++i) {
                    if (!this._peers[i].toString().equals(swName)) continue;
                    Object[] row = new Object[DMIDTableLabels.length + 1];
                    row[0] = this._peers[i];
                    row[1] = "";
                    dmIdData.addElement(row);
                }
            }
            this._dmIdmodel.fireTableDataChanged();
        }
    }

    void showDmTable(boolean show) {
        this._pDmIdPanel.setVisible(show);
        this._parent.validate();
        this._parent.invalidate();
        this._parent.pack();
    }

    void showDmIdSelection(boolean show) {
        if (show && this._uniqueDmList.getText().equals("")) {
            this.getUniqueDmIdList();
        }
        this._uniqueDmList.setEnabled(show);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        switch (cmd.charAt(0)) {
            case 'A': {
                try {
                    this.fillTableDmId();
                    return;
                }
                catch (Exception ex) {
                    this._parent.setCursor(Cursor.getDefaultCursor());
                    Util.errorMessage((Component)this._parent, ex);
                    if (!SnmpSession.isTrace()) break;
                    DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
        super.actionPerformed(e);
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == this._nameIndex) {
            String units = (String)SnmpTableModel._Units.get(mibVar);
            return new FieldPanel(20, (JComponent)new JLabel(" " + units));
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    @Override
    protected void insert() throws Exception {
        SnmpPDU pdu;
        HashMap<Object, SnmpPDU> vblByPeer;
        this.validDmId();
        super.insert();
        int curIndex = Integer.parseInt(this.getComponentText(this._indexIndex));
        boolean isFiconSelected = this._ficonCB != null && this._ficonCB.isSelected();
        boolean isDmIdStatic = this._useStaticDmId != null && this._useStaticDmId.isSelected();
        RadioButtonPanel interop = (RadioButtonPanel)this._values[3];
        boolean isInterop4 = interop.getButton(4).isSelected();
        if (isDmIdStatic) {
            vblByPeer = new HashMap<Object, SnmpPDU>();
            for (int i = 0; i < this._selPeerList.length; ++i) {
                SnmpPeer peer = (SnmpPeer)this._selPeerList[i];
                Switch sw = ClientController.findFabricSwitchByIpAddress(((SnmpPeer)this._selPeerList[i]).getAddress());
                if (isFiconSelected && sw.isVersionGreaterThan("1.3(3.0)") || sw.isNpvEnabled()) continue;
                pdu = new SnmpPDU(-93, new VarBindList());
                vblByPeer.put(this._selPeerList[i], pdu);
                pdu.addVar(new SnmpOID(MibNode.get("dmConfigDomainIdType").getOid(), curIndex), new SnmpInt(1));
                SnmpInt dmId = this.getDmId((SnmpPeer)this._selPeerList[i]);
                pdu.addVar(new SnmpOID(MibNode.get("dmConfigDomainId").getOid(), curIndex), dmId);
                pdu.addVar(new SnmpOID(MibNode.get("dmRestart").getOid(), curIndex), new SnmpInt(1));
            }
            SnmpAggregrate agg = new SnmpAggregrate();
            int numSuccesses = agg.set(vblByPeer.keySet().iterator(), vblByPeer.values().iterator());
            if (numSuccesses < vblByPeer.size()) {
                this.showInsertError();
                throw new SnmpException(agg.getErrors());
            }
        }
        if (isFiconSelected) {
            int numSelected = this._selPeerList.length;
            for (int i = 0; i < this._selPeerList.length; ++i) {
                Switch sw = ClientController.findFabricSwitchByIpAddress(((SnmpPeer)this._selPeerList[i]).getAddress());
                if (!sw.isVersionLessThanEqual("1.3(3.0)") && !sw.isNpvEnabled()) continue;
                this._selPeerList[i] = null;
                --numSelected;
            }
            SnmpPeer[] selectedPeers = new SnmpPeer[numSelected];
            int j = 0;
            for (int i = 0; i < this._selPeerList.length; ++i) {
                if (this._selPeerList[i] == null) continue;
                selectedPeers[j++] = (SnmpPeer)this._selPeerList[i];
            }
            this.addFiconVsan(selectedPeers, curIndex, this._fabricBindingCB.isSelected(), this._allPortProhibitCB.isSelected());
        }
        if (isInterop4) {
            vblByPeer = new HashMap();
            for (int i = 0; i < this._selPeerList.length; ++i) {
                SnmpPeer peer = (SnmpPeer)this._selPeerList[i];
                Switch sw = ClientController.findFabricSwitchByIpAddress(((SnmpPeer)this._selPeerList[i]).getAddress());
                if (sw.isNpvEnabled()) continue;
                pdu = new SnmpPDU(-93, new VarBindList());
                vblByPeer.put(this._selPeerList[i], pdu);
                pdu.addVar(new SnmpOID(MibNode.get("wwnmVsanWwnRowStatus").getOid(), curIndex), new SnmpInt(4));
                pdu.addVar(new SnmpOID(MibNode.get("wwnmVsanWwn").getOid(), curIndex), this.generateInterop4Wwn(sw, curIndex));
            }
            SnmpAggregrate agg = new SnmpAggregrate();
            int numSuccesses = agg.set(vblByPeer.keySet().iterator(), vblByPeer.values().iterator());
            if (numSuccesses < vblByPeer.size()) {
                this.showInsertError();
                throw new SnmpException(agg.getErrors());
            }
        }
        try {
            ClientController.getInstance().getFabric().rediscover();
        }
        catch (Exception ex) {
            Util.errorMessage((Component)BrowserFrame.getInstance(), ex);
        }
        this._parent.dispose();
    }

    private SnmpString generateInterop4Wwn(Switch sw, int vsanId) {
        byte[] swWwn = sw.getWwn().getValue();
        return new SnmpString(WwnDictionary.generateInterop4Wwn(swWwn, vsanId));
    }

    void validDmId() throws Exception {
        if (this._useStaticDmId == null || !this._useStaticDmId.isSelected()) {
            return;
        }
        if (this._dmIdtable.isEditing()) {
            this._dmIdtable.editingStopped(null);
        }
        this.getSelectedPeers();
        Array dmIdData = this._dmIdmodel.getData();
        byte[] dmIdAvList = this.getDmIdAvList();
        for (int i = 0; i < dmIdData.size(); ++i) {
            Object[] row = (Object[])dmIdData.elementAt(i);
            SnmpPeer dmIdPeer = (SnmpPeer)row[0];
            if (!this.isPeerSelected(dmIdPeer)) continue;
            boolean bErr = false;
            Object dmIdObj = row[1];
            if (dmIdObj instanceof String) {
                String dmIdStr = (String)dmIdObj;
                if (dmIdStr.equals("")) {
                    bErr = true;
                } else {
                    row[1] = dmIdObj = new SnmpInt(dmIdStr);
                    int dmId = ((SnmpInt)dmIdObj).getValue();
                }
            }
            if (dmIdObj instanceof SnmpInt) {
                int value = ((SnmpInt)dmIdObj).getValue();
                if (!SnmpString.getBit(dmIdAvList, value)) {
                    bErr = true;
                } else {
                    SnmpString.clearBit(dmIdAvList, value);
                }
                if (value < this._dmIdmodel._mibNodes[1].getLo() + 1 || value > this._dmIdmodel._mibNodes[1].getHi() || value == 8) {
                    bErr = true;
                }
            }
            if (!bErr) continue;
            throw new Exception(dmIdPeer + ": DomainId" + " should be in range " + (this._dmIdmodel._mibNodes[1].getLo() + 1) + ".." + this._dmIdmodel._mibNodes[1].getHi() + ", excluding 8. It also has to be unique across selected switches.");
        }
    }

    void getUniqueDmIdList() {
        byte[] dmIdAvList = this.getDmIdAvList();
        SnmpPeer[] dmIdPeers = this.getUsedDmIdPeerList();
        for (int i = 0; i < dmIdPeers.length; ++i) {
            VsanDomain[] vsanDomainIds;
            Switch sw = ClientController.findFabricSwitchByIpAddress(dmIdPeers[i].getAddress());
            if (sw == null || sw.isNpvEnabled() || (vsanDomainIds = sw.getVsanDomainIds()) == null) continue;
            for (int j = 0; j < vsanDomainIds.length; ++j) {
                SnmpString.clearBit(dmIdAvList, vsanDomainIds[j]._domainId);
            }
        }
        this._uniqueDmList.setText(SnmpBitmap.toString(dmIdAvList, true));
    }

    byte[] getDmIdAvList() {
        int i;
        byte[] dmIdAvList = new byte[32];
        for (i = 0; i < 32; ++i) {
            dmIdAvList[i] = -1;
        }
        SnmpString.clearBit(dmIdAvList, 8);
        for (i = 240; i <= 256; ++i) {
            SnmpString.clearBit(dmIdAvList, i);
        }
        return dmIdAvList;
    }

    void fillTableDmId() throws Exception {
        Array data = this._dmIdmodel.getData();
        byte[] unsedDmdIdList = SnmpBitmap.parse(this._uniqueDmList.getText(), true, null, false, 239);
        int rowId = 0;
        int dmId = 1;
        while (rowId < data.size()) {
            Object[] row = (Object[])data.elementAt(rowId);
            while (!SnmpString.getBit(unsedDmdIdList, dmId)) {
                ++dmId;
            }
            row[1] = new SnmpInt(dmId);
            ++rowId;
            ++dmId;
        }
        if (rowId < data.size()) {
            for (int emptemptyDmIdRow = rowId; emptemptyDmIdRow < data.size(); ++emptemptyDmIdRow) {
                Object[] row = (Object[])data.elementAt(emptemptyDmIdRow);
                row[1] = "";
            }
        }
        this._dmIdmodel.fireTableDataChanged();
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == this._nameIndex) {
            String vsanName = ((FieldPanel)this._values[index]).getText();
            if (vsanName.equals("")) {
                this._bSendVsanName = false;
                return null;
            }
            this._bSendVsanName = true;
            if (vsanName.indexOf(32) != -1) {
                return new SnmpString(vsanName.replace(' ', '_'));
            }
        }
        return super.getComponentValue(index);
    }

    @Override
    protected SnmpPDU getInsertPDU(SnmpPeer peer, VarBindList vbl) throws Exception {
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        boolean isVer12Above = sw.isVersionGreaterThanEqual("1.2(0)");
        boolean isVersion20Above = sw.isVersionGreaterThanEqual("2.0(0)");
        boolean isVersion52Above = sw.isVersionGreaterThanEqual("5.2(0)");
        VarBindList newVbl = new VarBindList();
        newVbl.copy(vbl, 0, vbl.size());
        if (isVer12Above) {
            newVbl.remove(newVbl.size() - 1);
        } else {
            int type = newVbl.intValue(this._bSendVsanName ? 3 : 2);
            newVbl.remove(this._bSendVsanName ? 3 : 2);
            SnmpVarBind vbMode = newVbl.getVb(newVbl.size() - 1);
            vbMode.setVar(type == 1 ? new SnmpInt(1) : new SnmpInt(2));
        }
        return new SnmpPDU(-93, newVbl);
    }

    public void addFiconVsan(SnmpPeer[] selectedPeers, int vsanId, boolean needFabricBinding, boolean isAllPortProhibit) throws SnmpException {
        SnmpAggregrate agg = new SnmpAggregrate();
        MibEnum[] features = MibNode.get("cfcFeatureCtrlIndex").getEnums();
        int ficonFeatureIndex = MibEnum.getValue(features, "ficon");
        int fbFeatureIndex = MibEnum.getValue(features, "fabricBinding");
        VarBindList vbl = new VarBindList();
        vbl.add(MibNode.get("cfcFeatureCtrlOpStatus").getOid(), ficonFeatureIndex);
        vbl.add(MibNode.get("cfcFeatureCtrlOpStatus").getOid(), fbFeatureIndex);
        SnmpPDU[] resp = agg.get(selectedPeers, vbl, false);
        ArrayList<SnmpPeer> disabledPeers = new ArrayList<SnmpPeer>();
        for (int i = 0; i < resp.length; ++i) {
            SnmpPeer peer = SnmpPeer.findPeer(resp[i].getAddress());
            if (peer == null) {
                DefaultLogger._DefLogger.error((Object)("Unknown :" + resp[i].getAddress()));
                continue;
            }
            if (resp[i].getVariables().intValue(0) == 2 && resp[i].getVariables().intValue(1) == 2) continue;
            disabledPeers.add(peer);
        }
        if (disabledPeers.size() > 0) {
            SnmpPeer[] peers = disabledPeers.toArray(new SnmpPeer[disabledPeers.size()]);
            vbl.clear();
            vbl.add(MibNode.get("cfcFeatureCtrlAction").getOid(), fbFeatureIndex, (SnmpVar)new SnmpInt(2));
            int numSuccesses = agg.set(peers, vbl);
            if (numSuccesses < peers.length) {
                throw new SnmpException(agg.getErrors());
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            vbl.clear();
            vbl.add(MibNode.get("cfcFeatureCtrlAction").getOid(), ficonFeatureIndex, (SnmpVar)new SnmpInt(2));
            numSuccesses = agg.set(peers, vbl);
            if (numSuccesses < peers.length) {
                throw new SnmpException(agg.getErrors());
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        HashMap<SnmpPeer, SnmpPDU> vblByPeer = new HashMap<SnmpPeer, SnmpPDU>();
        for (int i = 0; i < selectedPeers.length; ++i) {
            SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
            vblByPeer.put(selectedPeers[i], pdu);
            pdu.addVar(new SnmpOID(MibNode.get("zoneDefaultZoneBehaviour").getOid(), vsanId), new SnmpInt(1));
            pdu.addVar(new SnmpOID(MibNode.get("vsanInorderDelivery").getOid(), vsanId), new SnmpInt(1));
            pdu.addVar(new SnmpOID(MibNode.get("dmConfigDomainIdType").getOid(), vsanId), new SnmpInt(1));
            SnmpInt dmId = this.getDmId(selectedPeers[i]);
            pdu.addVar(new SnmpOID(MibNode.get("dmConfigDomainId").getOid(), vsanId), dmId);
            pdu.addVar(new SnmpOID(MibNode.get("dmRestart").getOid(), vsanId), new SnmpInt(1));
        }
        int numSuccesses = agg.set(vblByPeer.keySet().iterator(), vblByPeer.values().iterator());
        if (numSuccesses < vblByPeer.size()) {
            throw new SnmpException(agg.getErrors());
        }
        vblByPeer.clear();
        int[] fbIndex = new int[]{1, vsanId, 0};
        int[] fbActivateIndex = new int[]{1, vsanId};
        for (int i = 0; i < selectedPeers.length; ++i) {
            SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
            vblByPeer.put(selectedPeers[i], pdu);
            Switch sw0 = ClientController.findFabricSwitchByIpAddress(selectedPeers[i].getAddress());
            if (needFabricBinding) {
                for (int j = 0; j < selectedPeers.length; ++j) {
                    if (selectedPeers[i] == selectedPeers[j]) continue;
                    fbIndex[2] = j + 2;
                    Switch sw1 = ClientController.findFabricSwitchByIpAddress(selectedPeers[j].getAddress());
                    pdu.addVar(new SnmpOID(MibNode.get("cpsmFabricBindRowStatus").getOid(), fbIndex), new SnmpInt(4));
                    pdu.addVar(new SnmpOID(MibNode.get("cpsmFabricBindSwitchWwn").getOid(), fbIndex), new SnmpString(sw1.getWwn().getValue()));
                    boolean isSw0Ver30Above = sw0.isVersionGreaterThanEqual("3.0(0)");
                    SnmpInt dmId = this.getDmId(selectedPeers[j]);
                    if (isSw0Ver30Above) {
                        pdu.addVar(new SnmpOID(MibNode.get("cpsmFabricBindDomIdRev1").getOid(), fbIndex), dmId);
                        continue;
                    }
                    pdu.addVar(new SnmpOID(MibNode.get("cpsmFabricBindDomId").getOid(), fbIndex), dmId);
                }
            }
            pdu.addVar(new SnmpOID(MibNode.get("cpsmFabricBindActivate").getOid(), fbActivateIndex), new SnmpInt(3));
            if (sw0.isVersionGreaterThanEqual("3.0(2)")) {
                pdu.addVar(new SnmpOID(MibNode.get("cficonDefaultPortBlock").getOid(), 0), new SnmpInt(isAllPortProhibit ? 1 : 2));
            }
            pdu.addVar(new SnmpOID(MibNode.get("cficonVsanEntryStatus").getOid(), vsanId), new SnmpInt(4));
        }
        numSuccesses = agg.set(vblByPeer.keySet().iterator(), vblByPeer.values().iterator(), this);
    }

    SnmpInt getDmId(SnmpPeer peer) throws SnmpException {
        Array dmIdData = this._dmIdmodel.getData();
        InetAddress peerAdr = peer.getAddress();
        for (int i = 0; i < dmIdData.size(); ++i) {
            Object[] row = (Object[])dmIdData.elementAt(i);
            SnmpPeer rowPeer = (SnmpPeer)row[0];
            if (!rowPeer.getAddress().equals(peerAdr)) continue;
            return (SnmpInt)row[1];
        }
        Switch sw = ClientController.findFabricSwitchByIpAddress(peerAdr);
        if (sw != null) {
            return new SnmpInt(sw.getVsanDomainId(1));
        }
        throw new SnmpException(peer + ":" + "unable to assign valid DomainId");
    }

    @Override
    public void snmpAggregrate(SnmpPDU pdu, String err) {
        SnmpPeer peer = SnmpPeer.findPeer(pdu.getAddress());
        if (err.length() != 0) {
            this._insertErrMsg.addElement(err);
        } else {
            int rowIndex = (Integer)this._peer2InsertRowIndex.get(peer);
            Object[] row = (Object[])this._table.getData().elementAt(rowIndex);
            row[8] = Boolean.TRUE;
        }
    }

    protected SnmpPeer[] getInsertPeerList() {
        return this._peers;
    }

    protected SnmpPeer[] getUsedDmIdPeerList() {
        return this._peers;
    }

    class InteropItemListener
    implements ItemListener {
        InteropItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object source = e.getSource();
            if (source instanceof JToggleButton && e.getStateChange() == 1) {
                String label = ((JToggleButton)source).getText();
                GroupButtonPanel bp = (GroupButtonPanel)SmInsertVsan.this._values[4];
                if (label.endsWith("4")) {
                    bp.getButton(1).setSelected(true);
                } else {
                    bp.getButton(0).setSelected(true);
                }
            }
        }
    }

    class VsanCreateDmIdTableModel
    extends SnmpTableModel {
        VsanCreateDmIdTableModel() {
        }

        @Override
        protected void assignCellValue(Object aValue, int row, int col, Object[] values) throws Exception {
            try {
                super.assignCellValue(aValue, row, col, values);
            }
            catch (InvocationTargetException ex) {
                values[col] = aValue;
            }
        }
    }
}

