/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.JnmMibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.sm.client.gui.SmTableModel;

public class SmIpAddressInTableModel
extends SmTableModel {
    public static final int ADR_TYPE_UNKNOWN = 0;
    public static final int ADR_TYPE_DNS = 16;
    public static final int ADR_TYPE_IPV4 = 1;
    public static final int ADR_TYPE_IPV6 = 2;
    protected String _addrVar;
    protected String _addrTypeVar;
    protected int _supportedAddrType;
    int _addrTypePos;
    public static final int ADDR_TYPE_BOTH = 0;
    public static final int ADDR_TYPE_IP = 1;
    public static final int ADDR_TYPE_DNS = 2;

    public SmIpAddressInTableModel() {
    }

    public SmIpAddressInTableModel(String addrVar, String addrTypeVar) {
        this(addrVar, addrTypeVar, 0);
    }

    public SmIpAddressInTableModel(String addrVar, String addrTypeVar, int supportedAddrType) {
        this._addrVar = addrVar;
        this._addrTypeVar = addrTypeVar;
        this._supportedAddrType = supportedAddrType;
    }

    @Override
    public synchronized Object[] addElement(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        int addrType = -1;
        this._addrTypePos = -1;
        for (int i = 0; i < vbl.size() - 1; ++i) {
            if (!this._vars[i].startsWith(this._addrTypeVar)) continue;
            addrType = vbl.intValue(i);
            this._addrTypePos = i;
            if (this._isScalar) break;
            ++this._addrTypePos;
            break;
        }
        Object[] row = new Object[vbl.size() + this._offset + 1];
        this._responseData.addElement(row);
        row[0] = node;
        if (index != null) {
            row[1] = index;
        }
        for (int i = 0; i < vbl.size(); ++i) {
            if (this._vars[i].equals(this._addrVar) && addrType != -1) {
                SnmpVar v = vbl.getVb(i).getVar();
                row[i + this._offset] = this.getAddrValue(addrType, v, vbl, node, index);
                continue;
            }
            row[i + this._offset] = super.toCell(this._mibNodes[i + this._offset], vbl.getVb(i).getVar(), this._vars[i], this._responseData.size() - 1);
        }
        this.updateGetProgress();
        return row;
    }

    String getAddrValue(int addrType, SnmpVar addrVar, VarBindList vbl, SnmpPeer node, SnmpOID index) {
        if (addrType == 0) {
            return "";
        }
        if (addrType == 1 || addrType == 2) {
            return SnmpIpAddress.toString(((SnmpString)addrVar).getValue());
        }
        return ((SnmpString)addrVar).toString();
    }

    @Override
    protected SnmpVar getChangedCellVar(int row, int col, SnmpOID changedCellOid, int[] index) throws Exception {
        if (changedCellOid.startsWith(MibNode.get(this._addrVar).getOid())) {
            SnmpString changedCellVar;
            String cellVal = (String)this.getValueAt(row, col);
            Object type = this.getValueAt(row, this._addrTypePos + 1);
            int addrType = ((JnmMibEnum)type).getValue();
            if (addrType == 1 || addrType == 2) {
                byte[] ipaddress = SnmpIpAddress.parse(cellVal);
                changedCellVar = new SnmpString(ipaddress);
            } else {
                if (this._supportedAddrType == 1) {
                    throw new Exception("Unsupport IpAddress Type");
                }
                changedCellVar = new SnmpString(cellVal);
            }
            return changedCellVar;
        }
        return super.getChangedCellVar(row, col, changedCellOid, index);
    }
}

