/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.Switch;

public class SmIpInterfaceTableModel
extends SmTableModel {
    protected int _ifType;
    protected boolean _getIPS;
    public static final int ALL_IF = 0;
    public static final int PHYSICAL_IF = 1;
    public static final int LOGICAL_IF = 2;
    public static final int ETH_VSIF_IF = 3;
    public static final int MGMT_IPFC_IF = 4;
    static final int[] _ipAddressOid = MibNode.get("ciiIPIfAddressPrefixLength").getOid();
    static final int[] _rowStatusLogical = MibNode.get("virtualNwIfRowStatus").getOid();

    public SmIpInterfaceTableModel(int ifType, boolean getIPS) {
        this._ifType = ifType;
        this._getIPS = getIPS;
    }

    @Override
    protected boolean isModelTypeSupported(SnmpPeer peer) {
        boolean supported = super.isModelTypeSupported(peer);
        if (supported) {
            if (this._ifType == 3) {
                Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
                supported = sw.isN5K();
            } else if (this._ifType == 1) {
                Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
                supported = sw.isN5K() ? !this._getIPS && sw.isVersionGreaterThanEqual("4.0(1a)") : this._getIPS || sw.isFcoeEnabled();
            }
        }
        return supported;
    }

    @Override
    public Array getTableVars(SnmpPeer[] nodes) throws SnmpException {
        switch (this._ifType) {
            case 1: {
                return this.getPhysicalTableVars(nodes);
            }
            case 2: {
                return this.getLogicalTableVars(nodes);
            }
            case 4: {
                return this.getMgmtTableVars(nodes);
            }
            case 3: {
                this._index = 0x1BFFFFFF;
                this._stopIndex = IfIndexUtil.getLastValidIfIndexFor(28) + 1;
            }
        }
        return super.getTableVars(nodes);
    }

    public Array getMgmtTableVars(SnmpPeer[] nodes) throws SnmpException {
        Array returnData = new Array();
        this._index = 0x4FFFFFF;
        this._stopIndex = 0x6000000;
        Array getData = super.getTableVars(nodes);
        returnData.append(getData);
        this._index = 0x8000000;
        this._stopIndex = IfIndexUtil.getLastValidIfIndexFor(8) + 1;
        getData = super.getTableVars(nodes);
        returnData.append(getData);
        this._responseData = returnData;
        return this._responseData;
    }

    public Array getPhysicalTableVars(SnmpPeer[] nodes) throws SnmpException {
        Array returnData = new Array();
        if (this._getIPS) {
            this._index = 0x1FFFFFF;
            this._stopIndex = 0x4000000;
            Array getData = super.getTableVars(nodes);
            returnData.append(getData);
        } else {
            this._index = 0x19FFFFFF;
            this._stopIndex = 0x1C000000;
            Array ethData = super.getTableVars(nodes);
            this._index = 0x1EFFFFFF;
            this._stopIndex = 0x25000000;
            Array fexData = super.getTableVars(nodes);
            returnData.append(ethData);
            returnData.append(fexData);
        }
        this._responseData = returnData;
        return this._responseData;
    }

    public Array getLogicalTableVars(SnmpPeer[] nodes) throws SnmpException {
        Array returnData = new Array();
        if (this._getIPS) {
            this._index = 0x3FFFFFF;
            this._stopIndex = 0x5000000;
            Array getData = super.getTableVars(nodes);
            returnData.append(getData);
            this._responseData = returnData;
            return this._responseData;
        }
        this._index = 0x15FFFFFF;
        this._stopIndex = 0x1A000000;
        Array getData = super.getTableVars(nodes);
        returnData.append(getData);
        this._responseData = returnData;
        return this._responseData;
    }

    @Override
    public Object getCellDisplayString(SnmpPeer node, MibNode mibNode, VarBindList vbl, SnmpVarBind vb, String var, int row, int col, SnmpOID index, int indexOfVbl) {
        if (var.equals("ciiIPIfAddressPrefixLength")) {
            SnmpVar v = vb.getVar();
            int[] oid = vb.getOid().getValue();
            Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
            StringBuffer sb = new StringBuffer(sw.ifIndexToName(oid[_ipAddressOid.length]) + ", ");
            if (oid[_ipAddressOid.length + 1] == 1) {
                sb.append(SnmpOID.toString(oid, _ipAddressOid.length + 3, oid.length));
                sb.append('/');
                sb.append(vb.getVar().toString());
                return sb.toString();
            }
            if (oid[_ipAddressOid.length + 1] == 2) {
                int[] addr = new int[16];
                System.arraycopy(oid, _ipAddressOid.length + 3, addr, 0, addr.length);
                sb.append(SnmpIpAddress.toHexString(oid, _ipAddressOid.length + 3, oid.length));
                sb.append('/');
                sb.append(vb.getVar().toString());
                return sb.toString();
            }
            sb.append("(unknown type)");
            return sb.toString();
        }
        return super.getCellDisplayString(node, mibNode, vbl, vb, var, row, col, index, indexOfVbl);
    }

    @Override
    protected SnmpPDU processDeleteRow(SnmpPeer node, SnmpPDU pdu, int rowN) {
        if (this._getIPS && this._ifType == 2) {
            int ifIndex = this.getIndex(rowN)[0];
            int[] index = new int[3];
            if (IfIndexUtil.getType(ifIndex) == 5) {
                return super.processDeleteRow(node, pdu, rowN);
            }
            if (IfIndexUtil.getType(ifIndex) == 8 && (ifIndex >> 19 & 0x1F) + 1 == 32) {
                Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
                int module = sw.getActiveSupSlot();
                int vsanId = ifIndex - 0x8F80000;
                int processorId = sw.getModuleProcessorId(module - 1);
                index = new int[]{processorId, 1, vsanId};
            } else {
                int module = (ifIndex >> 19 & 0x1F) + 1;
                int vsanId = ifIndex & 0xFFF;
                Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
                int processorId = sw.getModuleProcessorId(module - 1);
                index = new int[]{processorId, 1, vsanId};
            }
            pdu.addVar(new SnmpOID(_rowStatusLogical, index), new SnmpInt(this._deleteValue));
            return pdu;
        }
        return super.processDeleteRow(node, pdu, rowN);
    }
}

