/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpUnsignedInt;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;

public class SmIpsecCryptoMapTableModel
extends SmTableModel {
    private static final int AUTO_PEER_COL = 4;
    private static final int PEERADDR_LIST_COL = 5;
    private static final int CURPEER_COL = 6;
    private static final int LIFETIME_VALUE_COL = 8;
    private static final int LIFESIZE_VALUE_COL = 9;
    private static final int LIFESIZE_UNIT_COL = 10;
    private final int[] _cipsCryMapPeerOrderOid = MibNode.get("cipsCryMapPeerOrder").getOid();
    private final int[] _cipsCryMapPeerStatusOid = MibNode.get("cipsCryMapPeerStatus").getOid();
    private final int[] _cipsCryMapPeerAddrTypeOid = MibNode.get("cipsCryMapPeerAddrType").getOid();
    private final int[] _cipsCryMapPeerAddrOid = MibNode.get("cipsCryMapPeerAddr").getOid();
    HashMap _peer2RowIndices = new HashMap();
    HashMap _peer2PeerListVbl = new HashMap();
    public static final long LIFESIZE_KB_LOW = 2560L;
    public static final long LIFESIZE_KB_HIGH = 0xFFF00000L;
    public static final long LIFESIZE_MB_LOW = 3L;
    public static final long LIFESIZE_MB_HIGH = 4193280L;
    public static final long LIFESIZE_GB_LOW = 1L;
    public static final long LIFESIZE_GB_HIGH = 4095L;

    @Override
    public Array getTableVars(SnmpPeer[] nodes) throws SnmpException {
        this._peer2RowIndices.clear();
        super.getTableVars(nodes);
        this.getPeerAddress(nodes);
        return this._responseData;
    }

    @Override
    public synchronized Object[] addElement(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        Object[] row = super.addElement(vbl, node, index);
        if (row != null) {
            row[5] = "";
            HashMap<SnmpOID, Integer> info2Row = (HashMap<SnmpOID, Integer>)this._peer2RowIndices.get(node);
            if (info2Row == null) {
                info2Row = new HashMap<SnmpOID, Integer>();
                this._peer2RowIndices.put(node, info2Row);
            }
            info2Row.put(index, new Integer(this._responseData.size() - 1));
        }
        return row;
    }

    @Override
    protected void updateRow(Object[] row, SnmpPeer node, VarBindList vbl, int indexOfVbl, int mibLen, int rowIndex, SnmpOID index) {
        String curPeerList = (String)row[5];
        super.updateRow(row, node, vbl, indexOfVbl, mibLen, rowIndex, index);
        row[5] = (Boolean)row[4] == true ? "" : curPeerList;
    }

    @Override
    public Object getCellDisplayString(SnmpPeer node, MibNode mibNode, VarBindList vbl, SnmpVarBind vb, String var, int row, int col, SnmpOID index, int indexOfVbl) {
        if (col == 10) {
            return "KB";
        }
        return super.toCell(mibNode, vb.getVar(), var, row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getPeerAddress(SnmpPeer[] nodes) throws SnmpException {
        if (nodes == null) {
            return;
        }
        this._peer2PeerListVbl.clear();
        this._numOutstanding.set(0);
        Object object = this._numOutstanding.getLock();
        synchronized (object) {
            for (int i = 0; i < nodes.length; ++i) {
                SnmpPeer peer = nodes[i];
                if (this.isPeerTimedOut(peer)) continue;
                SnmpFetch f = new SnmpFetch();
                f.getBulk(peer, new String[]{"cipsCryMapPeerOrder", "cipsCryMapPeerAddrType", "cipsCryMapPeerAddr"}, (SnmpCallbackIf)this);
                this._numOutstanding.increment();
            }
        }
        if (this._numOutstanding.get() > 0) {
            this.wait(this._numOutstanding);
            this.processPeerList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        Object firstOid;
        SnmpPeer node = SnmpPeer.findPeer(pdu.getAddress());
        if (!this.checkSnmpCallbackErr(node, pdu, timedOut) && pdu.getVariables().size() > 0) {
            firstOid = pdu.getVariables().getVb(0).getOid();
            VarBindList vbl = pdu.getVariables();
            if (((SnmpOID)firstOid).startsWith(this._cipsCryMapPeerOrderOid)) {
                this._peer2PeerListVbl.put(node, vbl);
            } else {
                super.callback(session, reqid, pdu, timedOut);
                return;
            }
        }
        this._numOutstanding.decrement();
        if (this._numOutstanding.get() <= 0) {
            try {
                firstOid = this._numOutstanding;
                synchronized (firstOid) {
                    this._numOutstanding.notifyAll();
                }
            }
            catch (IllegalMonitorStateException ex) {
                // empty catch block
            }
        }
        this.updateTableDisplay();
    }

    void processPeerList() {
        VarBindList vbl = null;
        for (SnmpPeer node : this._peer2PeerListVbl.keySet()) {
            vbl = (VarBindList)this._peer2PeerListVbl.get(node);
            this.updatePeerList(node, vbl);
        }
    }

    public void updatePeerList(SnmpPeer node, VarBindList vbl) {
        HashMap info2Row = (HashMap)this._peer2RowIndices.get(node);
        if (info2Row != null) {
            SnmpOID firstOid = vbl.getVb(0).getOid();
            ArrayList<peerTableEntry> entriesList = new ArrayList<peerTableEntry>();
            int[] oid = firstOid.getValue();
            int[] mapLookupIndex = new int[2 + oid[this._cipsCryMapPeerOrderOid.length]];
            System.arraycopy(oid, this._cipsCryMapPeerOrderOid.length, mapLookupIndex, 0, mapLookupIndex.length);
            for (int i = 0; i < vbl.size(); i += 3) {
                int[] newoid = vbl.getVb(i).getOid().getValue();
                int[] newmapLookupIndex = new int[2 + newoid[this._cipsCryMapPeerOrderOid.length]];
                System.arraycopy(newoid, this._cipsCryMapPeerOrderOid.length, newmapLookupIndex, 0, newmapLookupIndex.length);
                if (!SnmpOID.equals(newmapLookupIndex, mapLookupIndex)) {
                    this.updatePeerListRow(info2Row, entriesList, mapLookupIndex);
                    entriesList.clear();
                    mapLookupIndex = newmapLookupIndex;
                }
                peerTableEntry entry = new peerTableEntry();
                entriesList.add(entry);
                entry._order = (int)((SnmpUnsignedInt)vbl.getVb(i).getVar()).getValue();
                int addrType = ((SnmpInt)vbl.getVb(i + 1).getVar()).getValue();
                if (addrType == 1) {
                    byte[] b = ((SnmpString)vbl.getVb(i + 2).getVar()).getValue();
                    entry._addr = new SnmpIpAddress(b).toString();
                    continue;
                }
                if (addrType != 16) continue;
                entry._addr = ((SnmpString)vbl.getVb(i + 2).getVar()).toString();
            }
            if (entriesList.size() != 0) {
                this.updatePeerListRow(info2Row, entriesList, mapLookupIndex);
            }
        }
    }

    void updatePeerListRow(HashMap info2Row, ArrayList entriesList, int[] mapLookupIndex) {
        boolean b = info2Row.containsKey(new SnmpOID(mapLookupIndex));
        Integer rowObj = (Integer)info2Row.get(new SnmpOID(mapLookupIndex));
        if (rowObj != null) {
            int rowN = rowObj;
            Object[] row = (Object[])this._responseData.elementAt(rowN);
            Object[] entries = entriesList.toArray(new peerTableEntry[entriesList.size()]);
            Arrays.sort(entries);
            StringBuffer buf = new StringBuffer();
            for (int j = 0; j < entries.length; ++j) {
                if (buf.length() != 0) {
                    buf.append(",");
                }
                buf.append(((peerTableEntry)entries[j])._addr);
            }
            row[5] = buf.toString();
        }
    }

    @Override
    protected SnmpVar processChangedCell(Cell cell, SnmpPDU pdu, SnmpOID changedCellOid, int[] index) throws Exception {
        if (cell._col == 5) {
            SnmpString adr;
            int addrType;
            Object[] values = (Object[])this.getData().elementAt(cell._row);
            Object[] oldVals = (Object[])values[this.getHeaders().length];
            String oldPeerAddr = (String)oldVals[5];
            String curPeerAddr = (String)values[5];
            int[] rowIndex = ((SnmpOID)values[1]).getValue();
            int[] peerTableIndex = new int[rowIndex.length + 1];
            System.arraycopy(rowIndex, 0, peerTableIndex, 0, rowIndex.length);
            peerTableIndex[peerTableIndex.length - 1] = 1;
            if (oldPeerAddr.length() != 0) {
                pdu.addVar(new SnmpOID(this._cipsCryMapPeerStatusOid, peerTableIndex), new SnmpInt(6));
            }
            try {
                byte[] ipaddress = SnmpIpAddress.parse(curPeerAddr);
                addrType = 1;
                adr = new SnmpString(ipaddress);
            }
            catch (SnmpException ex) {
                if (curPeerAddr.length() != 0) {
                    throw new Exception("Invalid IP Address");
                }
                return null;
            }
            pdu.addVar(new SnmpOID(this._cipsCryMapPeerStatusOid, peerTableIndex), new SnmpInt(4));
            pdu.addVar(new SnmpOID(this._cipsCryMapPeerAddrTypeOid, peerTableIndex), new SnmpInt(addrType));
            pdu.addVar(new SnmpOID(this._cipsCryMapPeerAddrOid, peerTableIndex), adr);
            return null;
        }
        if (cell._col == 8) {
            Object[] values = (Object[])this.getData().elementAt(cell._row);
            long lifeTime = ((SnmpUnsignedInt)values[8]).getValue();
            if (lifeTime != 0L) {
                return super.processChangedCell(cell, pdu, changedCellOid, index);
            }
            pdu.addVar(changedCellOid, new SnmpUnsignedInt(0L));
            return null;
        }
        if (cell._col == 10) {
            long oldLifeSize;
            Object[] values = (Object[])this.getData().elementAt(cell._row);
            Object[] oldVals = (Object[])values[this.getHeaders().length];
            long lifeSize = ((SnmpUnsignedInt)values[9]).getValue();
            SnmpUnsignedInt oldLifeSizeVar = (SnmpUnsignedInt)oldVals[9];
            if (oldLifeSizeVar != null && lifeSize != (oldLifeSize = oldLifeSizeVar.getValue())) {
                return null;
            }
            return this.getLifeSize(cell, pdu, changedCellOid, index);
        }
        if (cell._col == 9) {
            return this.getLifeSize(cell, pdu, changedCellOid, index);
        }
        return super.processChangedCell(cell, pdu, changedCellOid, index);
    }

    SnmpVar getLifeSize(Cell cell, SnmpPDU pdu, SnmpOID changedCellOid, int[] index) throws Exception {
        Object[] values = (Object[])this.getData().elementAt(cell._row);
        long lifeSize = ((SnmpUnsignedInt)values[9]).getValue();
        String unit = (String)this.getValueAt(cell._row, 10);
        SnmpUnsignedInt lifeSizeSvar = new SnmpUnsignedInt(0L);
        if (lifeSize != 0L) {
            if (unit.startsWith("K")) {
                if (lifeSize < 2560L || lifeSize > 0xFFF00000L) {
                    throw new Exception("LifeSize Value should be in range 2560KB..4293918720KB");
                }
                lifeSizeSvar = (SnmpUnsignedInt)this.getChangedCellVar(cell._row, 9, changedCellOid, index);
            } else if (unit.startsWith("M")) {
                if (lifeSize < 3L || lifeSize > 4193280L) {
                    throw new Exception("LifeSize Value should be in range 3MB..4193280MB");
                }
                lifeSizeSvar = new SnmpUnsignedInt(lifeSize *= 1024L);
            } else if (unit.startsWith("G")) {
                if (lifeSize < 1L || lifeSize > 4095L) {
                    throw new Exception("LifeSize Value should be in range 1GB..4095GB");
                }
                lifeSize = lifeSize * 1024L * 1024L;
                lifeSizeSvar = new SnmpUnsignedInt(lifeSize);
            }
        }
        pdu.addVar(changedCellOid, lifeSizeSvar);
        return lifeSizeSvar;
    }

    @Override
    protected SnmpOID getCellOid(Cell cell, int[] index, SnmpPeer node) {
        if (cell._col == 10) {
            return new SnmpOID(this._mibNodes[9].getOid(), index);
        }
        return super.getCellOid(cell, index, node);
    }

    private int[] getPeerBindingIndex(Object[] row, String peerAddr) {
        int addrType;
        byte[] adrBytes = null;
        try {
            addrType = 1;
            adrBytes = SnmpIpAddress.parse(peerAddr);
        }
        catch (Exception ex) {
            adrBytes = new SnmpString(peerAddr).getValue();
            addrType = peerAddr.equals("") ? 0 : 16;
        }
        int[] rowIndex = ((SnmpOID)row[1]).getValue();
        int[] index = new int[rowIndex.length + 1 + adrBytes.length];
        System.arraycopy(rowIndex, 0, index, 0, rowIndex.length);
        index[rowIndex.length] = addrType;
        for (int i = 0; i < adrBytes.length; ++i) {
            index[rowIndex.length + 1 + i] = adrBytes[i] & 0xFF;
        }
        return index;
    }

    @Override
    public boolean isCellActive(int row, int col) {
        if (col == 5) {
            Object o = this.getValueAt(row, 4);
            return o != null && (Boolean)o == false;
        }
        return super.isCellActive(row, col);
    }

    class peerTableEntry
    implements Comparator {
        int _order;
        String _addr;

        peerTableEntry() {
        }

        public int compare(Object o1, Object o2) {
            peerTableEntry entry1 = (peerTableEntry)o1;
            peerTableEntry entry2 = (peerTableEntry)o2;
            return entry1._order - entry2._order;
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }
    }
}

