/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.mds.PortInterfaceUtil;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.dialogs.SmIscsiTableModel;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.DataView;
import com.cisco.dcbu.sm.client.gui.UIControls;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;

public class SmIscsiInitiatorTableModel
extends SmIscsiTableModel
implements ActionListener {
    static final int[] _fcAddressOid = MibNode.get("fcAddress").getOid();
    final String[] _fcAddress = new String[]{"fcAddress"};
    static final int VSAN2K_MIB = 1;
    static final int DYNAMIC_MIB = 2;
    static final int NODE_PERSISTENT_MIB = 3;
    static final int NODE_SYSTEMASSIGNED_FCADR_MIB = 4;
    static final int NODE_FC_ADDR_MIB = 5;
    static final int ADDRLISTINDEX_MIB = 7;
    HashMap _peer2FCAddrListIndex = new HashMap();
    private static final String[] Wizard_BUTTON = new String[]{"icons/iSCSI_Toolbar.gif", "Wizard...", "iscsiwizard"};
    static final int[] _iscsi2FcNodeVsanList2kOid = MibNode.get("iscsi2FcNodeVsanList2k").getOid();

    public SmIscsiInitiatorTableModel() {
        DataView dataView = BrowserFrame.getDataView();
        dataView.insertButton(3, new String[][]{Wizard_BUTTON}, new ActionListener[]{this});
    }

    @Override
    public void build(String[] mibVars, String[] prefixes, int offset) {
        super.build(mibVars, prefixes, offset);
        boolean[] isEditable = this.getEditable();
        isEditable[4 + this._offset] = false;
        isEditable[5 + this._offset] = false;
        this.setEditable(isEditable);
    }

    @Override
    public Array getTableVars(SnmpPeer[] nodes) throws SnmpException {
        this._peer2FCAddrListIndex.clear();
        super.getTableVars(nodes);
        if (this._peer2FCAddrListIndex.size() != 0) {
            this.getExtraTableData(this._peer2FCAddrListIndex, this._fcAddress);
        }
        return this._responseData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        Object firstOid;
        SnmpPeer node = SnmpPeer.findPeer(pdu.getAddress());
        if (!this.checkSnmpCallbackErr(node, pdu, timedOut) && pdu.getVariables().size() > 0) {
            firstOid = pdu.getVariables().getVb(0).getOid();
            if (!((SnmpOID)firstOid).startsWith(_fcAddressOid)) {
                super.callback(session, reqid, pdu, timedOut);
                return;
            }
            int[] mibColIndices = new int[]{7};
            this.processExtraTableData(node, pdu.getVariables(), _fcAddressOid, this._peer2FCAddrListIndex, mibColIndices);
        }
        this._numOutstanding.decrement();
        if (this._numOutstanding.get() <= 0) {
            try {
                firstOid = this._numOutstanding;
                synchronized (firstOid) {
                    this._numOutstanding.notifyAll();
                }
            }
            catch (IllegalMonitorStateException ex) {
                // empty catch block
            }
        }
        this.updateTableDisplay();
    }

    @Override
    public synchronized Object[] addElement(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        SnmpString vsan2k = (SnmpString)vbl.getVb(1).getVar();
        SnmpString vsan4k = (SnmpString)vbl.getVb(vbl.size() - 1).getVar();
        PortInterfaceUtil.getInstance(2).getVsan(vsan2k, vsan4k, true);
        Object[] row = super.addElement(vbl, node, index);
        if (row == null) {
            return row;
        }
        row[7 + this._offset] = new StringBuffer();
        int fcAddrListIndex = vbl.intValue(7);
        if (fcAddrListIndex != 0) {
            HashMap<Integer, Object[]> addrIndex2RowData = (HashMap<Integer, Object[]>)this._peer2FCAddrListIndex.get(node);
            if (addrIndex2RowData == null) {
                addrIndex2RowData = new HashMap<Integer, Object[]>();
                this._peer2FCAddrListIndex.put(node, addrIndex2RowData);
            }
            addrIndex2RowData.put(new Integer(fcAddrListIndex), row);
        } else {
            row[7 + this._offset] = "autoAllocated";
        }
        return row;
    }

    @Override
    protected SnmpVar processChangedCell(Cell cell, SnmpPDU pdu, SnmpOID changedCellOid, int[] index) throws Exception {
        SnmpVar changedCellVar = super.processChangedCell(cell, pdu, changedCellOid, index);
        if (changedCellOid.startsWith(_iscsi2FcNodeVsanList2kOid)) {
            PortInterfaceUtil.getInstance(2).addVsan4k2Pdu(pdu, changedCellOid, changedCellVar, index);
            this._fragPduOnByte = true;
        }
        return changedCellVar;
    }

    protected String getVarString(int mibColIndex, SnmpVar v) {
        return SnmpString.toHexString(((SnmpString)v).getValue());
    }

    @Override
    public boolean isCellActive(int row, int col) {
        if (col == 4 + this._offset) {
            return false;
        }
        return super.isCellActive(row, col);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        UIControls.getInstance().actionPerformed(e);
    }
}

