/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpNull;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import java.util.HashMap;
import java.util.Set;

public class SmIscsiSessionTableModel
extends SmTableModel {
    static final int[] _cIscsiNodeNameOid = MibNode.get("cIscsiNodeName").getOid();
    final String[] _cIscsiNodeName = new String[]{"cIscsiNodeName"};
    static final int NODENAME_COL = 2;
    HashMap _peer2RowNData = new HashMap();

    @Override
    public Array getTableVars(SnmpPeer[] nodes) throws SnmpException {
        this._peer2RowNData.clear();
        super.getTableVars(nodes);
        if (this._peer2RowNData.size() != 0) {
            this.getIscsiNodeName();
        }
        return this._responseData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        Object firstOid;
        SnmpPeer node = SnmpPeer.findPeer(pdu.getAddress());
        if (!this.checkSnmpCallbackErr(node, pdu, timedOut) && pdu.getVariables().size() > 0) {
            firstOid = pdu.getVariables().getVb(0).getOid();
            if (!((SnmpOID)firstOid).startsWith(_cIscsiNodeNameOid)) {
                super.callback(session, reqid, pdu, timedOut);
                return;
            }
            this.processIscsiNodeNameData(node, pdu.getVariables());
        }
        this._numOutstanding.decrement();
        if (this._numOutstanding.get() <= 0) {
            try {
                firstOid = this._numOutstanding;
                synchronized (firstOid) {
                    this._numOutstanding.notifyAll();
                }
            }
            catch (IllegalMonitorStateException ex) {
                // empty catch block
            }
        }
        this.updateTableDisplay();
    }

    @Override
    public synchronized Object[] addElement(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        Object[] row = super.addElement(vbl, node, index);
        if (row == null) {
            return null;
        }
        row[2] = "";
        int rowN = this._responseData.size() - 1;
        HashMap<Integer, Object[]> rowN2Data = (HashMap<Integer, Object[]>)this._peer2RowNData.get(node);
        if (rowN2Data == null) {
            rowN2Data = new HashMap<Integer, Object[]>();
            this._peer2RowNData.put(node, rowN2Data);
        }
        rowN2Data.put(new Integer(rowN), row);
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getIscsiNodeName() throws SnmpException {
        this._numOutstanding.set(0);
        Object object = this._numOutstanding.getLock();
        synchronized (object) {
            for (SnmpPeer peer : this._peer2RowNData.keySet()) {
                if (this._timedoutPeers.find(peer) != -1) continue;
                HashMap rowN2Data = (HashMap)this._peer2RowNData.get(peer);
                VarBindList vbl = new VarBindList();
                for (Integer rowNObj : rowN2Data.keySet()) {
                    Object[] row = (Object[])rowN2Data.get(rowNObj);
                    if (row == null) continue;
                    int rowN = rowNObj;
                    int[] index = this.getIndex(rowN);
                    int[] nodeIndex = new int[]{index[0], index[1]};
                    vbl.add(new SnmpVarBind(new SnmpOID(_cIscsiNodeNameOid, nodeIndex)));
                }
                if (vbl.size() == 0) continue;
                SnmpFetch f = new SnmpFetch();
                f.get(peer, vbl, this);
                this._numOutstanding.increment();
            }
        }
        if (this._numOutstanding.get() > 0) {
            this.wait(this._numOutstanding);
        }
    }

    void processIscsiNodeNameData(SnmpPeer node, VarBindList vbl) {
        HashMap rowN2Data = (HashMap)this._peer2RowNData.get(node);
        if (rowN2Data == null) {
            return;
        }
        Set rowNs = rowN2Data.keySet();
        Object[] rowNObjs = rowNs.toArray();
        for (int i = 0; i < vbl.size(); ++i) {
            Object[] row = (Object[])rowN2Data.get(rowNObjs[i]);
            if (row == null || vbl.getVb(i).getVar() instanceof SnmpNull) continue;
            row[2] = vbl.stringValue(i);
        }
    }
}

