/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.MibVariableFormat;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.dialogs.IslSortByVsan;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.map.ISLMapLink;
import com.cisco.dcbu.sm.client.map.PCMapLink;
import com.cisco.dcbu.sm.client.model.AbstractLink;
import com.cisco.dcbu.sm.client.model.AbstractSwitch;
import com.cisco.dcbu.sm.client.model.EnforcedZone;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.San;
import com.cisco.dcbu.sm.client.model.SmFilter;
import com.cisco.dcbu.sm.client.model.Vsan;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.JMenuItem;

public class SmIslTableModel
extends SmTableModel {
    protected int _vsanId = 0;
    AbstractSwitch _sw1 = null;
    AbstractSwitch _sw2 = null;
    String[] _labels = new String[]{"VSANs", "<html>From<br>Switch", "<html>From<br>Interface", "<html>To<br>Switch", "<html>To<br>Interface", "Speed", "Status", "Port Channel Members", "Additional Info"};
    static final int WSAN = 0;
    public static final int STATUS_COL = 6;
    public static final int PORTMEMBER_COL = 7;
    public static final int ADDITIONAL_INFO_COL = 8;

    public SmIslTableModel() {
    }

    public SmIslTableModel(int vsanId) {
        this._vsanId = vsanId;
    }

    public SmIslTableModel(AbstractSwitch sw1, AbstractSwitch sw2) {
        this._sw1 = sw1;
        this._sw2 = sw2;
    }

    @Override
    public JMenuItem[] getMapMenuItems() {
        if (this.isChannel(this._leadIndex)) {
            return PCMapLink.getMenuItems(null);
        }
        return ISLMapLink.getMenuItems(null);
    }

    @Override
    public void setAttr(String[] vars, String[] prefixes, int index, boolean isScalar) {
        this._isScalar = isScalar;
        this.build(vars, prefixes, 4);
        this._index = index;
        this._vars = vars;
    }

    @Override
    protected void setSpecialAttr() {
        SnmpKTable table = BrowserFrame.getTable();
        table.setFixedWidth(7, 450);
    }

    @Override
    public void build(String[] mibVars, String[] prefixes, int offset) {
        this.adjustHeader();
        this._offset = offset;
        String[] headers = new String[this._labels.length];
        this._prefixes = prefixes;
        for (int i = 0; i < headers.length; ++i) {
            headers[i] = this._labels[i];
        }
        this.setHeaders(headers);
        this.setData(new Array());
        this._isEditable = false;
    }

    private void adjustHeader() {
        MgmtDomainIf mgmtDomain = ClientController.getInstance().getSelectedDomain();
        this._labels[0] = mgmtDomain.isDataCenter() ? "VSANs/VLANs" : (mgmtDomain.isLAN() || mgmtDomain.isVlan() ? "VLANs" : "VSANs");
    }

    @Override
    public Array getTableVars(SnmpPeer[] nodes) throws SnmpException {
        return this.getTableVars();
    }

    @Override
    public Array getTableVars(SmFilter[] invoker) throws SnmpException {
        return this.getTableVars();
    }

    Array getTableVars() throws SnmpException {
        if (this._vsanId == -1) {
            return null;
        }
        this._responseData = new Array();
        MgmtDomainIf mgmtDomain = ClientController.getInstance().getSelectedDomain();
        AbstractLink[] isls = SmIslTableModel.getMgmtDomainIsls();
        if (isls != null) {
            this.adIslTableVars(mgmtDomain, isls, this._responseData);
        }
        return this._responseData;
    }

    public static AbstractLink[] getMgmtDomainIsls() {
        MgmtDomainIf mgmtDomain = ClientController.getInstance().getSelectedDomain();
        MgmtDomainIf[] fas = null;
        Vsan vsan = null;
        if (mgmtDomain == null) {
            fas = San.getInstance().getFabrics();
        } else if (mgmtDomain.isSan()) {
            fas = ((San)mgmtDomain).getFabrics();
        } else if (mgmtDomain.isFabric()) {
            fas = new Fabric[]{(Fabric)mgmtDomain};
        } else {
            if (mgmtDomain.isLAN() || mgmtDomain.isVlan()) {
                return mgmtDomain.getEthIsls();
            }
            if (mgmtDomain.isDataCenter()) {
                return mgmtDomain.getAbstractLinks();
            }
            if (mgmtDomain.isVsan()) {
                vsan = (Vsan)mgmtDomain;
            } else if (mgmtDomain.isZone()) {
                vsan = ((EnforcedZone)mgmtDomain).getVsan();
            }
            fas = new MgmtDomainIf[]{mgmtDomain};
        }
        if (fas == null) {
            fas = San.getInstance().getFabrics();
        }
        ArrayList<AbstractLink> islList = new ArrayList<AbstractLink>();
        if (fas != null && fas.length > 0) {
            for (int i = 0; i < fas.length; ++i) {
                islList = fas[i].getAbstractLinks(islList);
            }
        }
        if (vsan == null) {
            return islList.toArray(new Isl[islList.size()]);
        }
        if (islList.size() > 0) {
            ArrayList<Isl> list = new ArrayList<Isl>(islList.size());
            for (int i = 0; i < islList.size(); ++i) {
                Isl isl = (Isl)islList.get(i);
                if (!isl.isMemberOfVsan(vsan) || list.contains(isl)) continue;
                list.add(isl);
            }
            return list.toArray(new Isl[list.size()]);
        }
        return null;
    }

    public static SmFilter[] getMgmtDomainIslFilters() {
        AbstractLink[] isls = SmIslTableModel.getMgmtDomainIsls();
        if (isls == null) {
            return null;
        }
        HashMap peers2IfIndices = new HashMap();
        for (int i = 0; i < isls.length; ++i) {
            AbstractLink thisIsl = isls[i];
            SnmpPeer p1 = thisIsl.getAbstractSwitch1().getPeer();
            SnmpPeer p2 = thisIsl.getAbstractSwitch2().getPeer();
            int ifIndex1 = thisIsl.getIfIndex1();
            int ifIndex2 = thisIsl.getIfIndex2();
            if (p1 != null && (thisIsl.getAbstractSwitch1().isMDS() || thisIsl.getAbstractSwitch1().isQuail())) {
                ArrayList<int[]> indexList1 = (ArrayList<int[]>)peers2IfIndices.get(p1);
                if (indexList1 == null) {
                    indexList1 = new ArrayList<int[]>();
                    peers2IfIndices.put(p1, indexList1);
                }
                if (IfIndexUtil.isFmIfIndex(ifIndex1)) {
                    DefaultLogger._DefLogger.debug((Object)("SmIslTableModel: skip " + ifIndex1));
                } else {
                    indexList1.add(new int[]{ifIndex1});
                }
            }
            if (p2 == null || !thisIsl.getAbstractSwitch2().isMDS() && !thisIsl.getAbstractSwitch2().isQuail()) continue;
            ArrayList<int[]> indexList2 = (ArrayList<int[]>)peers2IfIndices.get(p2);
            if (indexList2 == null) {
                indexList2 = new ArrayList<int[]>();
                peers2IfIndices.put(p2, indexList2);
            }
            if (IfIndexUtil.isFmIfIndex(ifIndex2)) {
                DefaultLogger._DefLogger.debug((Object)("SmIslTableModel: skip " + ifIndex2));
                continue;
            }
            indexList2.add(new int[]{ifIndex2});
        }
        SmFilter[] invoker = new SmFilter[peers2IfIndices.size()];
        SnmpPeer[] peers = peers2IfIndices.keySet().toArray(new SnmpPeer[peers2IfIndices.size()]);
        for (int i = 0; i < invoker.length; ++i) {
            ArrayList indexList = (ArrayList)peers2IfIndices.get(peers[i]);
            invoker[i] = new SmFilter(peers[i], (int[][])indexList.toArray((T[])new int[indexList.size()][]));
        }
        return invoker;
    }

    protected void adIslTableVars(MgmtDomainIf md, AbstractLink[] isls, Array responseData) {
        AbstractSwitch[] sws = md == null ? null : md.getAbstractSwitches();
        Arrays.sort(isls, new IslSortByVsan());
        for (int i = 0; i < isls.length; ++i) {
            AbstractLink thisIsl = isls[i];
            if (this._sw1 != null && (thisIsl.getAbstractSwitch1() != this._sw1 || thisIsl.getAbstractSwitch2() != this._sw2) || this._vsanId != 0 && !thisIsl.isFcObject() && !this.isVsanEntry(thisIsl) || sws != null && !this.isMember(sws, isls[i])) continue;
            Object[] row = new Object[this._labels.length + 2];
            row[0] = thisIsl.getVsansAsString();
            row[1] = thisIsl.getAbstractSwitch1().getName();
            row[2] = thisIsl.getIfIndex1Name();
            row[3] = thisIsl.getAbstractSwitch2().getName();
            row[4] = thisIsl.getIfIndex2Name();
            row[5] = MibVariableFormat.highSpeed(thisIsl.getSpeed() / 1000000L);
            row[6] = thisIsl.getStatus();
            row[7] = thisIsl.getPCMemberLinksAsString();
            row[8] = thisIsl.getAdditionalDetailsForDisplay();
            row[row.length - 1] = thisIsl;
            responseData.addElement(row);
        }
    }

    boolean isChannel(int index) {
        if (index < 0) {
            return false;
        }
        Object[] row = (Object[])this._responseData.elementAt(index);
        if (row == null) {
            return false;
        }
        String ifIndexName = (String)row[2];
        if (ifIndexName != null && ifIndexName.contains("channel")) {
            return true;
        }
        ifIndexName = (String)row[4];
        return ifIndexName != null && ifIndexName.contains("channel");
    }

    boolean isMember(AbstractSwitch[] sws, AbstractLink isl) {
        if (sws == null || sws.length == 0) {
            return false;
        }
        for (int i = 0; i < sws.length; ++i) {
            if (!isl.getAbstractSwitch1().equals(sws[i]) && !isl.getAbstractSwitch2().equals(sws[i])) continue;
            return true;
        }
        return false;
    }

    boolean isVsanEntry(AbstractLink isl) {
        String vsanList = isl.getVsansAsString();
        if (vsanList != null) {
            StringTokenizer st = new StringTokenizer(vsanList, ",");
            while (st.hasMoreTokens()) {
                String t = st.nextToken();
                if (t.equals("none")) continue;
                int low = 0;
                int high = 0;
                if (t.indexOf("-") == -1) {
                    low = Integer.parseInt(t);
                } else {
                    try {
                        StringTokenizer subst = new StringTokenizer(t, "-");
                        String lowStr = subst.nextToken();
                        String highStr = subst.nextToken();
                        low = Integer.parseInt(lowStr);
                        high = Integer.parseInt(highStr);
                    }
                    catch (Exception ex) {
                        DefaultLogger._DefLogger.error((Object)ex);
                        continue;
                    }
                }
                if (this._vsanId != low && (this._vsanId < low || this._vsanId > high)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void selectionAction(SnmpKTable table) {
        this.mapSelectLink(table);
    }
}

