/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.Switch;
import java.util.ArrayList;

public class SmIvrPolicyTableModel
extends SmTableModel {
    @Override
    public boolean isCellActive(int row, int col) {
        SnmpPeer peer;
        Switch sw;
        if (!(col != 1 || (sw = ClientController.findFabricSwitchByIpAddress((peer = this.getRowPeer(row)).getAddress())).isManageable() && sw.isVersionGreaterThanEqual("1.3(0)"))) {
            return false;
        }
        return super.isCellActive(row, col);
    }

    @Override
    public boolean applyChanges() throws Exception {
        boolean bChangesApplied = super.applyChanges();
        try {
            ClientController.getInstance().getFabric().rediscover();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bChangesApplied;
    }

    @Override
    protected SnmpPeer[] getWrkingPeers() {
        Switch[] sw = ClientController.getInstance().getFabric().getSwitches();
        ArrayList<SnmpPeer> peers = new ArrayList<SnmpPeer>();
        if (sw != null) {
            for (int i = 0; i < sw.length; ++i) {
                if (!sw[i].isManageable() || !sw[i].isIvrCapable()) continue;
                peers.add(sw[i].getPeer());
            }
        }
        this._wrkingPeers = peers.toArray(new SnmpPeer[peers.size()]);
        return this._wrkingPeers;
    }
}

