/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.AbstractModelObject;
import com.cisco.dcbu.sm.client.model.AbstractSwitch;
import com.cisco.dcbu.sm.client.model.DataCenter;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.SmFilter;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.common.model.Card;
import com.cisco.dcbu.sm.common.model.HwInventoryComponent;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.WwnKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class SmPhysicalSummaryCachedTableModel
extends SmTableModel {
    static final String na = "n/a";
    public static final int SWITCH_COL = 0;
    public static final int NAME_COL = 1;
    public static final int MODEL_NAME_COL = 2;
    public static final int SERIAL_NO_COL = 3;
    public static final int SERIAL_NO_2_COL = 4;
    public static final int TYPE = 5;
    public static final int HW_REV_COL = 6;
    public static final int SW_REV_COL = 7;
    public static final int ASSET_ID_COL = 8;
    public static final int OPERSTATUS_COL = 9;
    static final int SW_INFO = 11;
    static final int HW_COMP = 12;
    final String[] _headers = new String[]{"Switch", "Name", "ModelName", "<html>Serial No<br>Primary", "<html>Serial No<br>Secondary", "Type", "H/W Rev", "S/W Rev", "AssetID", "OperStatus"};
    static final boolean[] _colEditable = new boolean[]{false, false, false, false, false, false, false, false, true, false};
    MgmtDomainIf _mgmtDomain = null;
    protected Logger _logger = LogManager.getLogger(this.getClass());

    @Override
    public Array getTableVars(SmFilter[] invoker) throws SnmpException {
        ArrayList<SnmpPeer> peers = new ArrayList<SnmpPeer>();
        for (int i = 0; i < invoker.length; ++i) {
            SnmpPeer nextPeer = invoker[i].getSnmpPeer();
            if (nextPeer == null) continue;
            peers.add(nextPeer);
        }
        if (peers.size() > 0) {
            this.getSwitchData(peers.toArray(new SnmpPeer[peers.size()]));
        }
        return this._responseData;
    }

    public SmPhysicalSummaryCachedTableModel() {
        this.init();
    }

    public SmPhysicalSummaryCachedTableModel(MgmtDomainIf mgmtDomain) {
        this._mgmtDomain = mgmtDomain;
        this.init();
    }

    private void init() {
    }

    @Override
    public void setAttr(String[] vars, String[] prefixes, int index, boolean isScalar) {
        this._isScalar = isScalar;
        this.build(vars, prefixes, 0);
        this._index = index;
        this._vars = vars;
    }

    @Override
    public void build(String[] mibVars, String[] prefixes, int offset) {
        this._offset = offset;
        this._mibVars = mibVars;
        this._prefixes = prefixes;
        this.setHeaders(this._headers);
        this.setEditable(_colEditable);
        this._isEditable = true;
        this.setData(new Array());
    }

    @Override
    public Array getTableVars(SnmpPeer[] nodes) throws SnmpException {
        MgmtDomainIf mgmtDomain;
        this._responseData = new Array();
        MgmtDomainIf mgmtDomainIf = mgmtDomain = this._mgmtDomain != null ? this._mgmtDomain : ClientController.getInstance().getSelectedDomain();
        if (mgmtDomain != null) {
            this.getSwitchData(mgmtDomain);
        }
        return this._responseData;
    }

    protected Array getSwitchData(SnmpPeer[] peers) {
        ArrayList<Switch> switches = new ArrayList<Switch>();
        for (SnmpPeer nextPeer : peers) {
            ClientController.getInstance();
            Switch nextSw = ClientController.findFabricSwitchByIpAddress(nextPeer.getAddress());
            if (nextSw == null) continue;
            switches.add(nextSw);
        }
        if (switches.size() == 0) {
            return this._responseData;
        }
        Object[] sw = switches.toArray(new AbstractSwitch[switches.size()]);
        Arrays.sort(sw);
        for (int j = 0; j < sw.length; ++j) {
            Object s = sw[j];
            HwInventoryComponent[] comps = ((AbstractSwitch)s).getHwInventoryComponents();
            if (comps == null) continue;
            for (HwInventoryComponent nextComp : comps) {
                Object[] row = new Object[this._headers.length + 3];
                this.processRowData(row, (AbstractSwitch)s, nextComp);
                this._responseData.addElement(row);
            }
        }
        return this._responseData;
    }

    protected Array getSwitchData(MgmtDomainIf mgmtDomain) {
        Object[] sw = null;
        if (mgmtDomain != null) {
            sw = mgmtDomain instanceof DataCenter ? this.getDataCenterSwitchesWithoutEthFCDups(mgmtDomain) : mgmtDomain.getAbstractSwitches();
        } else {
            return this._responseData;
        }
        if (sw == null) {
            return this._responseData;
        }
        Arrays.sort(sw);
        for (int j = 0; j < sw.length; ++j) {
            Object s = sw[j];
            HwInventoryComponent[] comps = ((AbstractSwitch)s).getHwInventoryComponents();
            if (comps == null) continue;
            for (HwInventoryComponent nextComp : comps) {
                Object[] row = new Object[this._headers.length + 3];
                this.processRowData(row, (AbstractSwitch)s, nextComp);
                this._responseData.addElement(row);
            }
        }
        return this._responseData;
    }

    protected AbstractSwitch[] getDataCenterSwitchesWithoutEthFCDups(MgmtDomainIf mgmtDomain) {
        Map<PKIf, PKIf> allCoexistSwPKs = null;
        Object[] sw = mgmtDomain.getAbstractSwitches();
        if (sw == null) {
            return new AbstractSwitch[0];
        }
        try {
            allCoexistSwPKs = ClientController.getInstance().getAllCoexistSwPKs();
        }
        catch (Exception e1) {
            this._logger.error((Object)e1);
        }
        if (allCoexistSwPKs == null || allCoexistSwPKs.isEmpty()) {
            return sw;
        }
        Arrays.sort(sw);
        ArrayList<Object> noDupSw = new ArrayList<Object>();
        for (int j = 0; j < sw.length; ++j) {
            Object s = sw[j];
            if (((AbstractModelObject)s).isEthObject()) {
                PKIf ethSwitchPK = ((AbstractModelObject)s).getPK();
                if (ethSwitchPK == null) continue;
                PKIf fcSwitchPK = allCoexistSwPKs.get(ethSwitchPK);
                if (fcSwitchPK != null) {
                    Switch fcSwitch = DataCenter.getInstance().findSwitchByPK((WwnKey)fcSwitchPK);
                    if (fcSwitch != null) continue;
                    noDupSw.add(s);
                    continue;
                }
                noDupSw.add(s);
                continue;
            }
            noDupSw.add(s);
        }
        return noDupSw.size() == 0 ? new AbstractSwitch[]{} : noDupSw.toArray(new AbstractSwitch[noDupSw.size()]);
    }

    protected void processRowData(Object[] row, AbstractSwitch sw, HwInventoryComponent hwComp) {
        boolean active;
        boolean isIpAdrOrNameEmpty = false;
        String name = sw.getSysName();
        row[0] = new SnmpString(name == null ? "" : name);
        row[1] = hwComp.getName();
        row[2] = hwComp.getModelName();
        row[3] = hwComp.getSerialNumber();
        String secSerialNo = hwComp.getSecSerialNumber();
        row[4] = na.equals(secSerialNo) ? "" : secSerialNo;
        row[5] = hwComp.getHardwareType().toString();
        row[6] = hwComp.getHardwareRevision();
        row[7] = hwComp.getSoftwareRevision();
        row[8] = hwComp.getAssetId();
        String operStatus = hwComp.getStatusDescr();
        if (hwComp instanceof Card && (active = ((Card)hwComp).isActive())) {
            operStatus = operStatus + " (active)";
        }
        row[9] = operStatus;
        row[11] = sw;
        row[12] = hwComp;
    }

    @Override
    public boolean applyChanges() throws Exception {
        Array cells = this.getChanged();
        if (cells == null) {
            return false;
        }
        return super.applyChanges();
    }

    @Override
    protected HashMap buildSendPdus() throws Exception {
        Array cells = this.getChanged();
        if (cells == null) {
            return null;
        }
        HashMap<SnmpPeer, SnmpPDU> pdus = new HashMap<SnmpPeer, SnmpPDU>();
        for (int i = 0; i < cells.size(); ++i) {
            int[] oid;
            Cell cell = (Cell)cells.elementAt(i);
            Switch sw = (Switch)this.getValueAt(cell._row, 11);
            HwInventoryComponent hw = (HwInventoryComponent)this.getValueAt(cell._row, 12);
            SnmpPeer node = sw.getPeer();
            SnmpPDU pdu = (SnmpPDU)pdus.get(node);
            if (pdu == null) {
                pdu = new SnmpPDU(-93, new VarBindList());
                pdu.setAddress(node.getAddress());
                pdus.put(node, pdu);
            }
            if ((oid = this.getMibOid(cell._col)) == null) continue;
            pdu.addVar(new SnmpOID(oid, hw.getPhysicalIndex()), new SnmpString(this.getValueAt(cell._row, cell._col).toString()));
        }
        return pdus;
    }

    private int[] getMibOid(int col) {
        switch (col) {
            case 8: {
                return MibNode.get("entPhysicalAssetID").getOid();
            }
        }
        return null;
    }

    @Override
    public void selectionAction(SnmpKTable table) {
        this.mapSelectDevice(table);
    }

    @Override
    protected Object getDevicebject(Object[] rowData) {
        return rowData[11];
    }

    @Override
    public boolean isCellActive(int row, int col) {
        AbstractSwitch sw = (AbstractSwitch)this.getValueAt(row, 11);
        if (col == 8) {
            return sw.getPeer() != null;
        }
        return super.isCellActive(row, col);
    }
}

