/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.dialogs.SmFcInterfaceTableModel;
import com.cisco.dcbu.sm.client.model.Switch;

public class SmPhysicalTableModel
extends SmFcInterfaceTableModel {
    static final int CONNECTPRESENT = 1;
    private static final int BEACON_COL = 2;
    private static final int CONNECTORPRESENT_COL = 3;
    private static final int MODULETYPE_COL = 4;
    private static final int TRANS_COL = 5;
    private static final int SERIAL_COL = 6;
    private static final int REV_COL = 7;
    private static final int VENDOR_COL = 8;
    private static final int PARTNO_COL = 9;
    private static final int DATE_COL = 10;

    public SmPhysicalTableModel(int ifType) {
        super(ifType);
    }

    @Override
    public synchronized Object[] addElement(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        Object[] row = super.addElement(vbl, node, index);
        if (row == null) {
            return row;
        }
        ClientController.getInstance();
        Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
        if (!sw.isMDS()) {
            row[2] = Boolean.FALSE;
            return row;
        }
        if (vbl.intValue(1) != 1) {
            this._responseData.removeElementAt(this._responseData.size() - 1);
        }
        return row;
    }

    @Override
    public boolean isCellActive(int row, int col) {
        SnmpPeer peer = (SnmpPeer)this.getValueAt(row, 0);
        ClientController.getInstance();
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        switch (col) {
            case 2: {
                return sw.isMDS() && !sw.isN5K();
            }
        }
        return super.isCellActive(row, col);
    }
}

