/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.JnmMibEnum;
import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.mds.MibVariableFormat;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpAggregrate;
import com.cisco.dcbu.lib.snmp.SnmpAggregrateIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.PerspectiveIf;
import com.cisco.dcbu.lib.ui.PerspectiveManager;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.KTable;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.dialogs.SmFcInterfaceTableModel;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.DataView;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.gui.UIActions;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.SmFilter;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.common.model.Card;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class SmPortGeneralTableModel
extends SmFcInterfaceTableModel
implements MouseListener,
ActionListener {
    static final int FC_ADMIN_MIB = 0;
    static final int FC_OPER_MIB = 1;
    static final int VSANIF_MIB = 2;
    static final int IF_DPVM_VSAN = 3;
    static final int IF_ALIAS_MIB = 4;
    static final int DEV_ALIAS_MIB = 5;
    static final int SPEEDGROUP_MIB = 6;
    static final int ADMINSPEED_MIB = 7;
    static final int IF_SPEED_MIB = 8;
    static final int SPEED_MODE_MIB = 9;
    static final int SERVICE_MIB = 10;
    static final int IF_ADMINSTATUS_MIB = 11;
    static final int IF_OPERSTATUS_MIB = 12;
    static final int IF_FAILURECAUSE_MIB = 13;
    static final int IF_INITSTATUS_MIB = 14;
    static final int IF_LASTCHANGE_MIB = 15;
    static final int IF_OWNER_MIB = 16;
    static final int SPEED_AUTOMAX2G = 5;
    static final int SPEED_8G = 6;
    static final int SPEED_AUTOMAX4G = 7;
    static final int[] _ifDpvmVsan = MibNode.get("cdpvmDynPortVsan").getOid();
    static final int[] _ifAliasOid = MibNode.get("ifAlias").getOid();
    static final int[] _ifHighSpeedOid = MibNode.get("ifHighSpeed").getOid();
    static final int[] _ifAdminStatusOid = MibNode.get("ifAdminStatus").getOid();
    static final int[] _ifOperStatusOid = MibNode.get("ifOperStatus").getOid();
    static final int[] _ifLastChangeOid = MibNode.get("ifLastChange").getOid();
    static final int[] _fcIfAdminModeOid = MibNode.get("fcIfAdminMode").getOid();
    static final int[] _fcIfAdminSpeedOid = MibNode.get("fcIfAdminSpeed").getOid();
    static final int[] _fcIfPortRateModeOid = MibNode.get("fcIfPortRateMode").getOid();
    static final int[] cefcModuleLocalSwitchingModeOid = MibNode.get("cefcModuleLocalSwitchingMode").getOid();
    public static final int LOCAL_SW_ENABLED = 1;
    HashMap _peers2Row2Data;
    final int[] _fcIfPortInitStatusOid = MibNode.get("fcIfPortInitStatus").getOid();
    static final int FC_IFSERVICE_OUT_OF_SERVICE = 2;
    static final int DEDICATED = 1;
    JButton _alias2DescBtn;
    static final String ALIAS_2_DESC_BTN_TEXT = "Alias->Description";
    private static final String[][] NEW_BUTTON = new String[][]{{null, "Alias->Description", "T"}};
    private static final String ALISDESC_BTN_TOOLTIP = "<html><p>Populate Alias of selected rows to the corresponding Description field.</p></html>";
    private HashMap<Wwn, Fabric> _fabricBySwPK = new HashMap();

    public SmPortGeneralTableModel(int ifType) {
        this(ifType, true);
    }

    public SmPortGeneralTableModel(int ifType, boolean showAlias) {
        super(ifType);
        this._peers2Row2Data = new HashMap();
        BrowserFrame.getTable().addMouseListener(this);
        if (showAlias) {
            DataView dataView = BrowserFrame.getDataView();
            this._alias2DescBtn = dataView.insertButton(0, NEW_BUTTON, new ActionListener[]{this});
            this._alias2DescBtn.setToolTipText(ALISDESC_BTN_TOOLTIP);
        }
    }

    @Override
    protected void setSpecialAttr() {
        SmTableModel.SmTableModelCellChecker[] checkers = new SmTableModel.SmTableModelCellChecker[2];
        String mibNameVsanId = "vsanIfVsan";
        String warningMsgVsanId = "Changing the Port VSAN may affect I/O. Continue?";
        checkers[0] = new SmTableModel.SmTableModelCellChecker((SmTableModel)this, mibNameVsanId, null, warningMsgVsanId, true);
        String mibNamefcIfServiceState = "fcIfServiceState";
        String warningMsgfcIfServiceState = "Putting an interface out-of-service will cause its shared resource configuration to revert to default.\nContinue?";
        int[] fcIfServiceStateValue = new int[]{2};
        checkers[1] = new SmTableModel.SmTableModelCellChecker(this, mibNamefcIfServiceState, fcIfServiceStateValue, warningMsgfcIfServiceState);
        this.setCellChecker(checkers);
    }

    @Override
    public void build(String[] mibVars, String[] prefixes, int offset) {
        super.build(mibVars, prefixes, offset);
        boolean[] isEditable = this.getEditable();
        isEditable[5 + this._offset] = false;
        this.setEditable(isEditable);
    }

    @Override
    public Array getTableVars(SnmpPeer[] nodes) throws SnmpException {
        this._peers2Row2Data.clear();
        Array data = super.getTableVars(nodes);
        if (this._peers2Row2Data.size() != 0) {
            this.getIfTable();
        }
        return data;
    }

    @Override
    public Array getTableVars(SmFilter[] invoker) throws SnmpException {
        this._peers2Row2Data.clear();
        Array data = super.getTableVars(invoker);
        if (this._peers2Row2Data.size() != 0) {
            this.getIfTable();
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getIfTable() throws SnmpException {
        VarBindList vbl;
        HashMap<SnmpPeer, VarBindList> peer2Vbl = new HashMap<SnmpPeer, VarBindList>();
        for (SnmpPeer peer : this._peers2Row2Data.keySet()) {
            HashMap row2Data = (HashMap)this._peers2Row2Data.get(peer);
            vbl = new VarBindList();
            Iterator itData = row2Data.keySet().iterator();
            while (itData.hasNext()) {
                int ifIndex = (Integer)itData.next();
                vbl.add(new SnmpVarBind(new SnmpOID(_ifDpvmVsan, ifIndex)));
                vbl.add(new SnmpVarBind(new SnmpOID(_ifAliasOid, ifIndex)));
                vbl.add(new SnmpVarBind(new SnmpOID(_ifHighSpeedOid, ifIndex)));
                vbl.add(new SnmpVarBind(new SnmpOID(_ifAdminStatusOid, ifIndex)));
                vbl.add(new SnmpVarBind(new SnmpOID(_ifOperStatusOid, ifIndex)));
                vbl.add(new SnmpVarBind(new SnmpOID(_ifLastChangeOid, ifIndex)));
            }
            peer2Vbl.put(peer, vbl);
        }
        this._numOutstanding.set(0);
        Object object = this._numOutstanding.getLock();
        synchronized (object) {
            for (SnmpPeer peer : peer2Vbl.keySet()) {
                vbl = (VarBindList)peer2Vbl.get(peer);
                SnmpFetch f = new SnmpFetch();
                f.getWithFixedRoundTripDelay(peer, vbl, this, 10);
                this._numOutstanding.increment();
            }
        }
        if (this._numOutstanding.get() > 0) {
            this.wait(this._numOutstanding);
        }
    }

    @Override
    public synchronized Object[] addElement(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        Object[] row = super.addElement(vbl, node, index);
        if (row == null) {
            return row;
        }
        ClientController.getInstance();
        Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
        if (sw.isMDS()) {
            ArrayList<EndPort> endPorts;
            Fabric fb;
            int[] Oid;
            int ifIndex = index.getValue()[0];
            if (ifIndex != (Oid = vbl.getVb(4).getOid().getValue())[Oid.length - 1]) {
                Object[] newRow = new Object[row.length + 1];
                System.arraycopy(row, 0, newRow, 0, row.length);
                this._responseData.removeElement(row);
                this._responseData.addElement(newRow);
                newRow[newRow.length - 1] = new Integer(this._responseData.size() - 1);
                row = newRow;
                Oid[Oid.length - 1] = ifIndex;
                Oid = vbl.getVb(8).getOid().getValue();
                Oid[Oid.length - 1] = ifIndex;
                Oid = vbl.getVb(11).getOid().getValue();
                Oid[Oid.length - 1] = ifIndex;
                Oid = vbl.getVb(12).getOid().getValue();
                Oid[Oid.length - 1] = ifIndex;
                Oid = vbl.getVb(15).getOid().getValue();
                Oid[Oid.length - 1] = ifIndex;
                Oid = vbl.getVb(3).getOid().getValue();
                Oid[Oid.length - 1] = ifIndex;
                HashMap<Integer, Object[]> row2Data = (HashMap<Integer, Object[]>)this._peers2Row2Data.get(node);
                if (row2Data == null) {
                    row2Data = new HashMap<Integer, Object[]>();
                    this._peers2Row2Data.put(node, row2Data);
                }
                row2Data.put(new Integer(ifIndex), newRow);
            }
            if ((fb = this._fabricBySwPK.get(sw.getWwn())) == null) {
                fb = ClientController.getInstance().findFabricBySwitchWwn(sw.getWwn());
                this._fabricBySwPK.put(sw.getWwn(), fb);
            }
            row[5 + this._offset] = (endPorts = fb.findEndPortsBySwitchIfIndex(sw, ifIndex)) != null ? (endPorts.size() == 1 ? endPorts.get(0).getAlias() : "<multiple>") : "";
        } else if (sw.isQuail()) {
            row[2 + this._offset] = sw.getVsansAsString();
        }
        return row;
    }

    @Override
    public boolean isCellActive(int row, int col) {
        SnmpOID indexOid = (SnmpOID)this.getValueAt(row, 1);
        SnmpPeer peer = (SnmpPeer)this.getValueAt(row, 0);
        ClientController.getInstance();
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        if (sw == null) {
            return false;
        }
        int index = indexOid.getValue()[0];
        int ifType = IfIndexUtil.getType(index);
        int mibCol = col - this._offset;
        switch (mibCol) {
            case 7: {
                if (sw.isQuail()) {
                    return false;
                }
                return ifType != 10 && ifType != 11 && ifType != 14 && ifType != 18;
            }
            case 0: {
                return ifType != 11 && ifType != 14 && ifType != 18;
            }
            case 2: {
                if (!sw.isMDS()) {
                    return false;
                }
                Object ifOperMode = this.getValueAt(row, 1 + this._offset);
                return ifOperMode != null && !ifOperMode.toString().equals("TF") && !ifOperMode.toString().equals("TNP");
            }
            case 10: {
                if (sw.isQuail()) {
                    return false;
                }
                Object ifadminStatus = this.getValueAt(row, 11 + this._offset);
                return ifadminStatus != null && ((JnmMibEnum)ifadminStatus).getLabel().startsWith("down");
            }
            case 9: {
                if (sw.isQuail()) {
                    return false;
                }
                return ifType == 1;
            }
            case 16: {
                if (!sw.isN5K()) break;
                return false;
            }
            case 6: {
                if (ifType != 1) {
                    return false;
                }
                Card card = sw.getCard(IfIndexUtil.getIfIndexCard(index));
                if (card == null) {
                    return false;
                }
                return FRUConstants.isSupportSpeedGroup(card.getType());
            }
        }
        return super.isCellActive(row, col);
    }

    @Override
    public Object getCellDisplayString(SnmpPeer node, MibNode mibNode, VarBindList vbl, SnmpVarBind vb, String var, int row, int col, SnmpOID index, int indexOfVbl) {
        if (var.startsWith("fcIfPortInitStatus")) {
            int ifIndex = index.getValue()[0];
            int ifType = IfIndexUtil.getType(ifIndex);
            if (ifType == 18) {
                return "n/a";
            }
        } else if (col == 5 + this._offset) {
            ClientController.getInstance();
            Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
            int ifIndex = index.getValue()[0];
            Fabric fb = ClientController.getInstance().getFirstFabric();
            ArrayList<EndPort> endPorts = fb.findEndPortsBySwitchIfIndex(sw, ifIndex);
            if (endPorts != null) {
                if (endPorts.size() == 1) {
                    return endPorts.get(0).getAlias();
                }
                return "<multiple>";
            }
            return "";
        }
        return super.getCellDisplayString(node, mibNode, vbl, vb, var, row, col, index, indexOfVbl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        Object firstOid;
        SnmpPeer node = SnmpPeer.findPeer(pdu.getAddress());
        if (!this.checkSnmpCallbackErr(node, pdu, timedOut) && pdu.getVariables().size() > 0) {
            firstOid = pdu.getVariables().getVb(0).getOid();
            if (((SnmpOID)firstOid).startsWith(_ifDpvmVsan)) {
                this.fillIfData(node, pdu.getVariables());
            } else {
                ClientController.getInstance();
                Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
                int[] firstOid2Chk = null;
                if (sw.isMDS()) {
                    firstOid2Chk = this._firstOid;
                } else {
                    MibNode[] mibNode = (MibNode[])this._switch2MibNodes.get(sw.getModelType());
                    if (mibNode != null) {
                        int index;
                        for (index = this._offset; mibNode[index] == null && index < mibNode.length; ++index) {
                        }
                        if (mibNode[index] != null) {
                            firstOid2Chk = mibNode[index].getOid();
                        }
                    }
                }
                if (firstOid2Chk != null && ((SnmpOID)firstOid).startsWith(firstOid2Chk)) {
                    super.callback(session, reqid, pdu, timedOut);
                    return;
                }
            }
        }
        this._numOutstanding.decrement();
        if (this._numOutstanding.get() <= 0) {
            try {
                firstOid = this._numOutstanding;
                synchronized (firstOid) {
                    this._numOutstanding.notifyAll();
                }
            }
            catch (IllegalMonitorStateException ex) {
                // empty catch block
            }
        }
        this.updateTableDisplay();
    }

    void fillIfData(SnmpPeer node, VarBindList vbl) {
        HashMap row2Data = (HashMap)this._peers2Row2Data.get(node);
        if (row2Data == null) {
            return;
        }
        for (int i = 0; i < vbl.size(); i += 5) {
            SnmpVarBind vb = vbl.getVb(i);
            int[] oid = vb.getOid().getValue();
            int index = oid[oid.length - 1];
            Object[] row = (Object[])row2Data.get(new Integer(index));
            if (row == null) continue;
            int rowIndex = (Integer)row[row.length - 1];
            row[3 + this._offset] = this.getCellDisplayString(node, this._mibNodes[3 + this._offset], vbl, vb, this._vars[3], rowIndex, 3 + this._offset, new SnmpOID(new int[]{index}), 0);
            vb = vbl.getVb(i + 1);
            row[4 + this._offset] = this.getCellDisplayString(node, this._mibNodes[4 + this._offset], vbl, vb, this._vars[4], rowIndex, 4 + this._offset, new SnmpOID(new int[]{index}), 0);
            vb = vbl.getVb(i + 2);
            row[8 + this._offset] = this.getCellDisplayString(node, this._mibNodes[8 + this._offset], vbl, vb, this._vars[8], rowIndex, 8 + this._offset, new SnmpOID(new int[]{index}), 0);
            vb = vbl.getVb(i + 3);
            row[11 + this._offset] = this.getCellDisplayString(node, this._mibNodes[11 + this._offset], vbl, vb, this._vars[11], rowIndex, 11 + this._offset, new SnmpOID(new int[]{index}), 0);
            vb = vbl.getVb(i + 4);
            row[12 + this._offset] = this.getCellDisplayString(node, this._mibNodes[12 + this._offset], vbl, vb, this._vars[12], rowIndex, 12 + this._offset, new SnmpOID(new int[]{index}), 0);
            vb = vbl.getVb(i + 5);
            row[15 + this._offset] = this.getCellDisplayString(node, this._mibNodes[15 + this._offset], vbl, vb, this._vars[15], rowIndex, 15 + this._offset, new SnmpOID(new int[]{index}), 0);
        }
    }

    @Override
    public void cleanup() {
        super.cleanup();
        BrowserFrame.getTable().removeMouseListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof AbstractButton && e.getActionCommand().equals(NEW_BUTTON[0][1])) {
            this.applyChangesToSelectedRows();
        }
    }

    protected void applyChangesToSelectedRows() {
        try {
            DataView dataView = BrowserFrame.getDataView();
            if (dataView._tableModel instanceof SmPortGeneralTableModel) {
                int[] sels = dataView._table.getSelectedRows();
                Array data = this.getData();
                for (int i = 0; i < sels.length; ++i) {
                    int row = sels[i];
                    Object[] rowData = (Object[])data.elementAt(row);
                    String alias = (String)rowData[5 + this._offset];
                    if (alias == null || alias.equals("")) continue;
                    this.setValueAt(alias, row, 4 + this._offset);
                }
            }
        }
        catch (Exception ex) {
            Util.errorMessage((Component)BrowserFrame.getDataView(), ex);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() instanceof KTable && e.getClickCount() > 1) {
            Array data;
            Object[] row;
            String failureReason;
            Point p = e.getPoint();
            KTable t = (KTable)e.getSource();
            int r = t.rowAtPoint(p);
            int c = t.columnAtPoint(p);
            int modelcol = BrowserFrame.getDataView()._table.convertColumnIndexToModel(c);
            if (modelcol == 13 + this._offset && (failureReason = (String)(row = (Object[])(data = this.getData()).elementAt(r))[modelcol]) != null && MibVariableFormat._FcIfOperStatusReason[23].getLabel().equals(failureReason)) {
                SnmpPeer peer = (SnmpPeer)row[0];
                Switch sw = ClientController.getInstance().getFabric().findSwitchByIpAddress(peer.getAddress());
                if (!sw.isMDS()) {
                    return;
                }
                int ifIndex = ((SnmpOID)row[1]).getValue()[0];
                short vsanId = (short)((SnmpInt)row[2 + this._offset]).getValue();
                Vsan vsan = sw.getVsan(vsanId);
                try {
                    PerspectiveIf view = PerspectiveManager.getInstance().getView();
                    if (view != null && view.isVisible("menu", "Zone Merge")) {
                        UIActions.getInstance().invokeZoneMerge(sw.ifIndexToName(ifIndex), vsan, peer);
                    }
                }
                catch (SnmpException ex) {
                    Util.errorMessage((Component)BrowserFrame.getInstance(), ex.getMessage());
                }
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public int applyChangesSet(HashMap pdus, SnmpAggregrateIf applyChangesCallback) throws Exception {
        Iterator peersIt = pdus.keySet().iterator();
        Iterator pdusIt = pdus.values().iterator();
        ArrayList<SnmpPeer> peerList = new ArrayList<SnmpPeer>();
        ArrayList<SnmpPDU> pduList = new ArrayList<SnmpPDU>();
        while (pdusIt.hasNext()) {
            SnmpPDU pdu = (SnmpPDU)pdusIt.next();
            int pduSize = pdu.getVariables().size();
            if (pduSize == 0) continue;
            SnmpPeer node = (SnmpPeer)peersIt.next();
            VarBindList vbl = pdu.getVariables();
            if (pduSize > SnmpFetch._Max) {
                int vblCount = 0;
                VarBindList vblNew = new VarBindList();
                pdu = new SnmpPDU(-93, vblNew);
                pdu.setAddress(node.getAddress());
                int i = 0;
                while (i < vbl.size()) {
                    SnmpVarBind vb = vbl.getVb(i);
                    SnmpOID oid = vb.getOid();
                    if (oid.startsWith(_fcIfAdminModeOid) && vblCount > SnmpFetch._Max - 3 || oid.startsWith(_fcIfAdminSpeedOid) && vblCount > SnmpFetch._Max - 2 || vblCount == SnmpFetch._Max) {
                        peerList.add(node);
                        pduList.add(pdu);
                        vblCount = 0;
                        vblNew = new VarBindList();
                        pdu = new SnmpPDU(-93, vblNew);
                        pdu.setAddress(node.getAddress());
                    }
                    vblNew.add(vb);
                    ++i;
                    ++vblCount;
                }
            }
            peerList.add(node);
            pduList.add(pdu);
        }
        SnmpAggregrate aggregrate = new SnmpAggregrate();
        int successfulSets = aggregrate.set(peerList.toArray(new SnmpPeer[peerList.size()]), pduList.toArray(new SnmpPDU[pduList.size()]), pduList, applyChangesCallback, this._fragPduOnByte);
        return successfulSets;
    }

    @Override
    public void setCellEditor(SnmpKTable table) {
        super.setCellEditor(table);
        if (this._mibNodes != null) {
            for (int i = 0; i < this._mibNodes.length; ++i) {
                TableColumn col;
                TableCellEditor cellEditor;
                if (this._mibNodes[i] == null || !Arrays.equals(this._mibNodes[i].getOid(), _fcIfAdminModeOid) && !Arrays.equals(this._mibNodes[i].getOid(), _fcIfAdminSpeedOid) || !((cellEditor = (col = table.getColumnModel().getColumn(i)).getCellEditor()) instanceof SnmpKTable.BoldEditor)) continue;
                ((SnmpKTable.BoldEditor)cellEditor).putClientProperty(SnmpKTable.REFRESH, new AdminComboRefresher(this._mibNodes[i].getOid()));
            }
        }
    }

    class AdminComboRefresher
    implements SnmpKTable.Refresher {
        private DefaultComboBoxModel defaultModel;
        private DefaultComboBoxModel N5KModel;
        private DefaultComboBoxModel N5KNPVModel;
        private DefaultComboBoxModel N5K8GSpeedModel;
        private DefaultComboBoxModel N5KNon8GSpeedModel;
        private int[] oid;

        public AdminComboRefresher(int[] oid) {
            this.oid = oid;
        }

        @Override
        public void refresh(Object o, JTable table, int row, int column) {
            if (o instanceof JComboBox) {
                JComboBox adminModeCombo = (JComboBox)o;
                if (this.defaultModel == null) {
                    this.populateComboBoxModels(adminModeCombo);
                }
                DefaultComboBoxModel model = this.getComboBoxModel(table, row, column);
                adminModeCombo.setModel(model);
            }
        }

        private void populateComboBoxModels(JComboBox comboBox) {
            if (Arrays.equals(this.oid, _fcIfAdminModeOid)) {
                this.populateModeModel(comboBox);
            } else if (Arrays.equals(this.oid, _fcIfAdminSpeedOid)) {
                this.populateSpeedModel(comboBox);
            }
        }

        private void populateSpeedModel(JComboBox comboBox) {
            this.defaultModel = (DefaultComboBoxModel)comboBox.getModel();
            int count = this.defaultModel.getSize();
            ArrayList<MibEnum> speedEnumsForN5KNon8GModule = new ArrayList<MibEnum>();
            ArrayList<MibEnum> speedEnumsForN5K8GModule = new ArrayList<MibEnum>();
            for (int i = 0; i < count; ++i) {
                MibEnum mibEnum = (MibEnum)this.defaultModel.getElementAt(i);
                int speed = mibEnum.getValue();
                if (speed == 7 || speed == 5) continue;
                if (speed != 6) {
                    speedEnumsForN5KNon8GModule.add(mibEnum);
                }
                speedEnumsForN5K8GModule.add(mibEnum);
            }
            this.N5KNon8GSpeedModel = new DefaultComboBoxModel<MibEnum>(speedEnumsForN5KNon8GModule.toArray(new MibEnum[0]));
            this.N5K8GSpeedModel = new DefaultComboBoxModel<MibEnum>(speedEnumsForN5K8GModule.toArray(new MibEnum[0]));
        }

        private void populateModeModel(JComboBox comboBox) {
            this.defaultModel = (DefaultComboBoxModel)comboBox.getModel();
            int count = this.defaultModel.getSize();
            ArrayList<MibEnum> adminModeEnumsForN5K = new ArrayList<MibEnum>();
            ArrayList<MibEnum> adminModeEnumsForN5KNPV = new ArrayList<MibEnum>();
            for (int i = 0; i < count; ++i) {
                MibEnum mibEnum = (MibEnum)this.defaultModel.getElementAt(i);
                String label = mibEnum.getLabel();
                if (label.equals("NP") || label.equals("F") || label.equals("SD")) {
                    adminModeEnumsForN5KNPV.add(mibEnum);
                }
                if (label.equals("FX") || label.equals("FV") || label.equals("ST") || label.equals("FL") || label.equals("TL") || label.equals("NP")) continue;
                adminModeEnumsForN5K.add(mibEnum);
            }
            this.N5KModel = new DefaultComboBoxModel<MibEnum>(adminModeEnumsForN5K.toArray(new MibEnum[0]));
            this.N5KNPVModel = new DefaultComboBoxModel<MibEnum>(adminModeEnumsForN5KNPV.toArray(new MibEnum[0]));
        }

        private DefaultComboBoxModel getComboBoxModel(JTable table, int row, int col) {
            Object o = table.getModel().getValueAt(row, 0);
            if (o instanceof SnmpPeer) {
                SnmpPeer peer = (SnmpPeer)o;
                Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
                if (sw == null) {
                    return this.defaultModel;
                }
                if (sw.isN5K()) {
                    if (Arrays.equals(this.oid, _fcIfAdminModeOid)) {
                        if (sw.isNpvEnabled()) {
                            return this.N5KNPVModel;
                        }
                        return this.N5KModel;
                    }
                    if (Arrays.equals(this.oid, _fcIfAdminSpeedOid)) {
                        int ifIndex = ((SnmpOID)table.getModel().getValueAt(row, 1)).getValue()[0];
                        if (sw.getCard(IfIndexUtil.getIfIndexCard(ifIndex)).getType() == 0x989689 || sw.getCard(IfIndexUtil.getIfIndexCard(ifIndex)).getType() == 10000013 || sw.getCard(IfIndexUtil.getIfIndexCard(ifIndex)).getType() == 10000018 || sw.getCard(IfIndexUtil.getIfIndexCard(ifIndex)).getType() == 10000017 || sw.getCard(IfIndexUtil.getIfIndexCard(ifIndex)).getType() == 10000019 || sw.getCard(IfIndexUtil.getIfIndexCard(ifIndex)).getType() == 30000006) {
                            return this.N5K8GSpeedModel;
                        }
                        return this.N5KNon8GSpeedModel;
                    }
                }
            }
            return this.defaultModel;
        }
    }
}

