/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.mds.SharedUtil;
import com.cisco.dcbu.lib.mds.renderers.SensorValueRenderer;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.IntArray;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.dialogs.SmMultiIndexedTableModel;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.SmFilter;
import com.cisco.dcbu.sm.client.model.Switch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class SmPortSfpDiagTableModel
extends SmMultiIndexedTableModel {
    static final int SENSOR_VAL_MIB = 0;
    static final int SENSOR_TYPE_MIB = 1;
    static final int SNSOR_SCALE_MIB = 2;
    public static final int LOW_ALARM_COL = 3;
    public static final int LOW_WARNING_COL = 4;
    public static final int SENSOR_VAL_COL = 2;
    public static final int HIGH_WARNING_COL = 5;
    public static final int HIGH_ALARM_COL = 6;
    static final int SENSOR_TYPE_COL = 7;
    static final int SENSOR_SCALE_COL = 8;
    static final int THRESHOLD_TYPE_HIGH_ALARM = 1;
    static final int THRESHOLD_TYPE_HIGH_WARNING = 2;
    static final int THRESHOLD_TYPE_LOW_ALARM = 3;
    static final int THRESHOLD_TYPE_LOW_WARNING = 4;
    static final int MAJOR = 1;
    static final int MINOR = 2;
    static final int NUM_OF_SENSOR_THRESHHOLD_MIBS = 4;
    int[] _thresholdValueOid = MibNode.get("entSensorThresholdValue").getOid();
    int[] _entSensorThresholdRelationOid = MibNode.get("entSensorThresholdRelation").getOid();
    HashMap _peer2RowIndices;
    SmFilter[] _originalFilter;
    SensorValueRenderer _sensorValueRenderer;
    private int _type = 0;
    HashMap<SnmpPeer, LinkedList<Integer>> peer2ethernetCards = new HashMap();
    public static List<Integer> ethernetCardTypes = new ArrayList<Integer>();

    public SmPortSfpDiagTableModel() {
    }

    public SmPortSfpDiagTableModel(int type) {
        this._type = type;
    }

    @Override
    public void setAttr(String[] vars, String[] prefixes, int index, boolean isScalar) {
        super.setAttr(vars, prefixes, index, isScalar);
        String[] headers = new String[]{"Switch", "Interface, Sensor", "Value/Unit", "Low Alarm", "Low Warning", "High Warning", "High Alarm", "Type", "Scale"};
        boolean[] editable = new boolean[headers.length];
        this.setHeaders(headers);
        this.setEditable(editable);
        this._peer2RowIndices = new HashMap();
    }

    @Override
    protected void setSpecialAttr() {
        SnmpKTable table = BrowserFrame.getTable();
        if (this._sensorValueRenderer == null) {
            this._sensorValueRenderer = new SensorValueRenderer(4, 5, 2);
            this._sensorValueRenderer.setHorizontalAlignment(4);
        }
        table.getColumnModel().getColumn(2).setCellRenderer(this._sensorValueRenderer);
        ChangedCellRenderer rightRenderer = new ChangedCellRenderer();
        rightRenderer.setHorizontalAlignment(4);
        table.getColumnModel().getColumn(3).setCellRenderer(rightRenderer);
        table.getColumnModel().getColumn(4).setCellRenderer(rightRenderer);
        table.getColumnModel().getColumn(5).setCellRenderer(rightRenderer);
        table.getColumnModel().getColumn(6).setCellRenderer(rightRenderer);
    }

    @Override
    public synchronized Object[] addElement(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        int[] curIdx = index.getValue();
        ClientController.getInstance();
        Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
        boolean is6_1_0_above = sw.getVersion().compareTo("6.1(0)") >= 0;
        int slot = SharedUtil.getSensorSlot(is6_1_0_above, curIdx[0]);
        int port = SharedUtil.getSensorPort(is6_1_0_above, curIdx[0], slot);
        int cardType = sw.getCard(slot + 1).getType();
        int ifType = FRUConstants.getPortIfType(cardType, port + 1);
        if (this._type != 0 && ifType != this._type) {
            return null;
        }
        Object[] row = super.addElement(vbl, node, index);
        row[8] = row[2 + this._offset];
        row[7] = row[1 + this._offset];
        row[2] = row[0 + this._offset];
        row[3] = "";
        row[4] = "";
        row[5] = "";
        row[6] = "";
        int[] currentRowIndex = ((SnmpOID)row[1]).getValue();
        String type = (String)row[7];
        int scaleindex = MibEnum.getValue(SharedUtil._EntSensorScaleEnums, (String)row[8]);
        if (scaleindex == -1) {
            DefaultLogger._DefLogger.debug((Object)(node + "sensor scale value is " + (String)row[8] + " sensorIndex is " + currentRowIndex[0]));
            return row;
        }
        int scale = SharedUtil.Scale[scaleindex];
        int currentValue = ((SnmpInt)row[2]).getValue();
        int slotNum = SharedUtil.getSensorSlot(is6_1_0_above, currentRowIndex[0]);
        int lane = SharedUtil.getSensorLane(is6_1_0_above, currentRowIndex[0], slotNum, port);
        int sens_type = SharedUtil.getSensorType(is6_1_0_above, currentRowIndex[0], slotNum, port, lane);
        String sens_string = MibEnum.getLabel(SharedUtil.SensorType, sens_type);
        row[2] = currentValue == 0 && (sens_string.startsWith("Rx") || sens_string.startsWith("Tx")) ? "n/a" : SharedUtil.getSensorString(scale, currentValue, type);
        return row;
    }

    @Override
    public Array getTableVars(MgmtDomainIf mgmtDomain, boolean isScalar) throws SnmpException {
        if (mgmtDomain.isSan() || mgmtDomain.isFabric() || mgmtDomain.isVsan()) {
            return super.getTableVars(mgmtDomain);
        }
        SmFilter[] filters = mgmtDomain.getFilters((short)4352);
        ArrayList<SnmpPeer> peers = new ArrayList<SnmpPeer>();
        if (filters.length != 0) {
            for (SmFilter f : filters) {
                if (f.getSnmpPeer() == null || f.getIndicesCount() != 0) continue;
                peers.add(f.getSnmpPeer());
            }
            if (peers.size() > 0) {
                return this.getTableVars(peers.toArray(new SnmpPeer[0]));
            }
            BrowserFrame.getDataView().setValidateVbl(true);
            return this.getTableVars(filters);
        }
        return null;
    }

    @Override
    protected int[] getIndex(SnmpPeer node) {
        ClientController.getInstance();
        Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
        boolean is6_1_0_above = sw.getVersion().compareTo("6.1(0)") >= 0;
        this._index = SharedUtil.getSensorStartingIndex(is6_1_0_above);
        if (this._type == 26 && sw.isMDS()) {
            int slot;
            int[] cardTypes = sw.getCardTypeInSlots();
            LinkedList<Integer> ethernetCards = new LinkedList<Integer>();
            for (slot = 0; slot < cardTypes.length; ++slot) {
                if (!ethernetCardTypes.contains(cardTypes[slot])) continue;
                ethernetCards.add(slot);
            }
            if (ethernetCards.size() > 0) {
                this.peer2ethernetCards.put(node, ethernetCards);
                slot = (Integer)ethernetCards.remove(0);
                this._index = SharedUtil.getSensorIndex4Slot(is6_1_0_above, slot, cardTypes[slot], this._type);
            }
        }
        return this.getIndex();
    }

    @Override
    public Array getTableVars(SnmpPeer[] nodes) throws SnmpException {
        this._peer2RowIndices.clear();
        super.getTableVars(nodes);
        this.getSensorThresholdDetailTable();
        return this._responseData;
    }

    @Override
    public Array getTableVars(SmFilter[] invoker) throws SnmpException {
        if (this._originalFilter == null) {
            this._originalFilter = new SmFilter[invoker.length];
            ArrayList<SmFilter> validFilters = new ArrayList<SmFilter>();
            for (int i = 0; i < invoker.length; ++i) {
                SmFilter filter = invoker[i];
                SnmpPeer node = filter.getSnmpPeer();
                int[][] origIndex = new int[filter.getIndices().length][1];
                IntArray validIndexList = new IntArray();
                for (int j = 0; j < filter.getIndices().length; ++j) {
                    System.arraycopy(filter.getIndices()[j], 0, origIndex[j], 0, filter.getIndicesCount(j));
                    int ifIndex = filter.getIndex(j, 0);
                    if (IfIndexUtil.getType(ifIndex) != 1) continue;
                    int sensorIndex = this.getSensorIndex(node, ifIndex);
                    filter.setIndex(j, 0, sensorIndex);
                    validIndexList.add(sensorIndex);
                }
                this._originalFilter[i] = new SmFilter(node, origIndex);
                if (validIndexList.size() == 0) continue;
                if (validIndexList.size() != filter.getIndices().length) {
                    int[][] updateIndex = new int[validIndexList.size()][1];
                    for (int k = 0; k < validIndexList.size(); ++k) {
                        updateIndex[k][0] = validIndexList.get(k);
                    }
                    filter.setIndices(updateIndex);
                }
                validFilters.add(filter);
            }
            if (validFilters.size() != invoker.length) {
                invoker = validFilters.toArray(new SmFilter[validFilters.size()]);
            }
        }
        if (invoker.length > 0) {
            super.getTableVars(invoker);
            this.getSensorThresholdDetailTable();
        }
        return this._responseData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getSensorThresholdDetailTable() throws SnmpException {
        VarBindList sfpDiagGetVbl;
        HashMap<SnmpPeer, VarBindList> peer2SfpDiagGetVbl = new HashMap<SnmpPeer, VarBindList>();
        for (int i = 0; i < this._responseData.size(); ++i) {
            IntArray rowIndices;
            Object[] row = (Object[])this._responseData.elementAt(i);
            SnmpPeer node = (SnmpPeer)row[0];
            sfpDiagGetVbl = (VarBindList)peer2SfpDiagGetVbl.get(node);
            if (sfpDiagGetVbl == null) {
                sfpDiagGetVbl = new VarBindList();
                peer2SfpDiagGetVbl.put(node, sfpDiagGetVbl);
            }
            if ((rowIndices = (IntArray)this._peer2RowIndices.get(node)) == null) {
                rowIndices = new IntArray();
                this._peer2RowIndices.put(node, rowIndices);
            }
            rowIndices.add(i);
            int[] thresholdIndexOrder = new int[]{3, 4, 2, 1};
            int[] currentRowIndex = ((SnmpOID)row[1]).getValue();
            for (int k = 0; k < thresholdIndexOrder.length; ++k) {
                int[] getIndex = new int[]{currentRowIndex[0], thresholdIndexOrder[k]};
                sfpDiagGetVbl.add(new SnmpVarBind(new SnmpOID(this._thresholdValueOid, getIndex)));
                sfpDiagGetVbl.add(new SnmpVarBind(new SnmpOID(this._entSensorThresholdRelationOid, getIndex)));
            }
        }
        this._numOutstanding.set(0);
        Object object = this._numOutstanding.getLock();
        synchronized (object) {
            for (SnmpPeer peer : peer2SfpDiagGetVbl.keySet()) {
                sfpDiagGetVbl = (VarBindList)peer2SfpDiagGetVbl.get(peer);
                SnmpFetch f = new SnmpFetch();
                f.get(peer, sfpDiagGetVbl, this);
                this._numOutstanding.increment();
            }
        }
        if (this._numOutstanding.get() > 0) {
            this.wait(this._numOutstanding);
        }
    }

    void processSensorThresholdDetail(SnmpPeer node, VarBindList vbl) {
        IntArray rowIndices = (IntArray)this._peer2RowIndices.get(node);
        if (rowIndices != null) {
            int vblIndex = 0;
            for (int rowIndex = 0; vblIndex < vbl.size() && rowIndex < rowIndices.size(); vblIndex += 8, ++rowIndex) {
                SnmpOID oid = vbl.get(vblIndex).getOid();
                Object[] row = (Object[])this._responseData.elementAt(rowIndices.get(rowIndex));
                int id = ((SnmpOID)row[1]).getValue()[0];
                if (oid.getValue()[oid.getValue().length - 2] != id) continue;
                int scaleindex = MibEnum.getValue(SharedUtil._EntSensorScaleEnums, (String)row[8]);
                if (scaleindex == -1) {
                    DefaultLogger._DefLogger.debug((Object)(node + "sensor scale value is " + (String)row[8] + " sensorIndex is " + id));
                    continue;
                }
                int scale = SharedUtil.Scale[scaleindex];
                for (int col = 3; col <= 6; ++col) {
                    int[] index = vbl.get(vblIndex).getOid().getValue();
                    int thresholdType = index[index.length - 1] == 1 || index[index.length - 1] == 2 ? 1 : 2;
                    int subIndex = 2 * (col - 3);
                    int thresholdValue = vbl.intValue(vblIndex + subIndex);
                    int relation = vbl.intValue(vblIndex + subIndex + 1);
                    row[col] = SharedUtil.getSensorString(scale, thresholdValue, null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        Object firstOid;
        SnmpPeer node = SnmpPeer.findPeer(pdu.getAddress());
        if (!this.checkSnmpCallbackErr(node, pdu, timedOut) && pdu.getVariables().size() > 0) {
            firstOid = pdu.getVariables().getVb(0).getOid();
            VarBindList vbl = pdu.getVariables();
            if (((SnmpOID)firstOid).startsWith(this._thresholdValueOid)) {
                this.processSensorThresholdDetail(node, vbl);
            } else {
                super.callback(session, reqid, pdu, timedOut);
                return;
            }
        }
        this._numOutstanding.decrement();
        if (this._numOutstanding.get() <= 0) {
            try {
                firstOid = this._numOutstanding;
                synchronized (firstOid) {
                    this._numOutstanding.notifyAll();
                }
            }
            catch (IllegalMonitorStateException ex) {
                // empty catch block
            }
        }
        this.updateTableDisplay();
    }

    @Override
    protected boolean prepareGetNextPdu(SnmpPeer peer, VarBindList vbl) {
        SnmpVarBind vb;
        for (int i = 0; i < vbl.size(); ++i) {
            vb = vbl.getVb(i);
            vb.setVar(null);
        }
        if (this._type == 26 && this.peer2ethernetCards.containsKey(peer)) {
            int[] oid = vbl.getVb(0).getOid().getValue();
            Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
            boolean is6_1_0_above = sw.getVersion().compareTo("6.1(0)") >= 0;
            int[] firstOid = this.getFirstOid(sw);
            if (firstOid != null && oid.length >= firstOid.length) {
                LinkedList<Integer> cardList;
                SnmpOID index = new SnmpOID(oid, firstOid.length, oid.length - firstOid.length);
                int slot = SharedUtil.getSensorSlot(is6_1_0_above, index.getValue()[0]);
                int[] cardTypes = sw.getCardTypeInSlots();
                int numEthPorts = FRUConstants.getNumEthPorts(cardTypes[slot]);
                int end = SharedUtil.getSensorStopOffset4Slot(is6_1_0_above, slot, numEthPorts, cardTypes[slot], this._type);
                if (index.getValue()[0] >= end && (cardList = this.peer2ethernetCards.get(peer)).size() > 0) {
                    int nextSlot = cardList.remove(0);
                    int nextNumEthPorts = FRUConstants.getNumEthPorts(cardTypes[slot]);
                    int newIndex = SharedUtil.getSensorStopOffset4Slot(is6_1_0_above, nextSlot, nextNumEthPorts, cardTypes[slot], this._type);
                    for (int i = 0; i < vbl.size(); ++i) {
                        vb = vbl.getVb(i);
                        vb.setIndex(newIndex);
                    }
                }
            }
        }
        return true;
    }

    @Override
    protected boolean isSubIndexInRange(SnmpPeer node, int currentTableIndex, int originalStartIndex) {
        ClientController.getInstance();
        Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
        boolean is6_1_0_above = sw.getVersion().compareTo("6.1(0)") >= 0;
        return currentTableIndex <= SharedUtil.getSensorStopOffset(is6_1_0_above, originalStartIndex);
    }

    int getSensorIndex(SnmpPeer node, int ifIndex) {
        ClientController.getInstance();
        Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
        int slot = IfIndexUtil.ifIndex2Card(ifIndex);
        int cardType = sw.getCard(slot + 1).getType();
        boolean is6_1_0_above = sw.getVersion().compareTo("6.1(0)") >= 0;
        return SharedUtil.getSensorIndex(is6_1_0_above, ifIndex, cardType);
    }

    int getIfIndexFromSensorIndex(SnmpPeer node, int sensorIndex) {
        ClientController.getInstance();
        Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
        boolean is6_1_0_above = sw.getVersion().compareTo("6.1(0)") >= 0;
        int slotNum = SharedUtil.getSensorSlot(is6_1_0_above, sensorIndex);
        int port = SharedUtil.getSensorPort(is6_1_0_above, sensorIndex, slotNum);
        int cardType = sw.getCard(slotNum + 1).getType();
        int ifPort = IfIndexUtil.getPortEntity2If(port, cardType);
        int ifType = port != ifPort ? 2 : 1;
        int ifIndex = IfIndexUtil.nameToIfIndex(slotNum + 1, ifPort + 1, ifType);
        return ifIndex;
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.setViewFilter(this._originalFilter);
    }

    @Override
    protected int getWaitTime() {
        return super.getWaitTime() + this._queriedPeers.size() * 1000;
    }

    static {
        ethernetCardTypes.add(57);
        ethernetCardTypes.add(58);
        ethernetCardTypes.add(68);
        ethernetCardTypes.add(60000004);
    }
}

