/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpGauge;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.table.BorderCellRenderer;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.SyncedInt;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.dialogs.SmPhysicalSummaryTableModel;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.SmFilter;
import com.cisco.dcbu.sm.client.model.Switch;
import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JTable;

public class SmPowerSupplyTableModel
extends SmTableModel {
    static final int REDUNDANCY_COL = 5;
    static final int CAPACITY_COL = 6;
    static final int DRAWN_COL = 7;
    static final int AVAILABLE_COL = 8;
    static final int UNITS_COL = 9;
    static final int REDUNDANT_OPER = 10;
    static final int WARN_ON_LOW_POWER_COL = 12;
    static final int last_row = 12;
    static final int VAL_REDUNDANCY_COMBINED = 3;
    protected final SyncedInt _requests = new SyncedInt(0);
    HashMap _maxByPeer;
    static final double AVAILABLE_POWER_WARNING_LEVEL = 400.0;

    @Override
    public Array getTableVars(SnmpPeer[] nodes) throws SnmpException {
        this.getTotalPower(nodes);
        SmFilter[] filters = new SmFilter[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            Switch sw = ClientController.findFabricSwitchByIpAddress(nodes[i].getAddress());
            int[] modelindices = sw.getPSPhysicalIndices();
            if (modelindices != null) {
                int[][] indices = SmPhysicalSummaryTableModel.getIndices2Array(modelindices);
                filters[i] = new SmFilter(nodes[i], indices);
                continue;
            }
            filters[i] = null;
        }
        return super.getTableVars(filters, false);
    }

    @Override
    public Array getTableVars(SmFilter[] mapInvoker) throws SnmpException {
        this.getTotalPower(this.getWrkingPeers());
        return super.getTableVars(mapInvoker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getTotalPower(SnmpPeer[] nodes) throws SnmpException {
        if (nodes == null || nodes.length == 0) {
            return;
        }
        SnmpKTable table = BrowserFrame.getTable();
        table.getColumnModel().getColumn(7).setCellRenderer(new AvailablePowerSupplyRenderer());
        VarBindList vblOld = new VarBindList();
        vblOld.add(new SnmpVarBind(new SnmpOID(MibNode.get("cefcMaxDefaultInLinePower").getOid(), 0)));
        VarBindList vblNew = new VarBindList();
        vblNew.add(new SnmpVarBind(new SnmpOID(MibNode.get("cefcMaxDefaultHighInLinePower").getOid(), 0)));
        this._maxByPeer = new HashMap();
        this._requests.set(0);
        Object object = this._requests.getLock();
        synchronized (object) {
            for (int i = 0; i < nodes.length; ++i) {
                SnmpPeer peer;
                Switch sw = ClientController.findFabricSwitchByIpAddress((peer = nodes[i]).getAddress());
                peer.send(new SnmpPDU(-96, sw.isVersionGreaterThanEqual("6.2(7)") ? vblNew : vblOld), this);
                this._requests.increment();
            }
        }
        if (this._requests.get() > 0) {
            this.wait(this._requests);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        if (this._requests.get() == 0) {
            super.callback(session, reqid, pdu, timedOut);
            return;
        }
        SnmpPeer peer = SnmpPeer.findPeer(pdu.getAddress());
        if (peer != null) {
            this._maxByPeer.put(peer, pdu.getVariables().getVb(0).getVar());
        }
        this._requests.decrement();
        if (this._requests.get() <= 0) {
            try {
                SyncedInt syncedInt = this._requests;
                synchronized (syncedInt) {
                    this._requests.notifyAll();
                }
            }
            catch (IllegalMonitorStateException ex) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized Object[] addElement(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        Object[] row = new Object[13];
        this._responseData.addElement(row);
        this.updateRow(row, node, vbl, 0, this._mibNodes.length - this._offset, this._responseData.size() - 1, index);
        this.updateGetProgress();
        return row;
    }

    @Override
    protected void updateRow(Object[] row, SnmpPeer node, VarBindList vbl, int indexOfVbl, int mibLen, int rowIndex, SnmpOID index) {
        row[0] = node;
        row[1] = index;
        for (int i = 2; i < 6; ++i) {
            row[i] = this.getCellDisplayString(node, this._mibNodes[i], vbl, vbl.getVb(indexOfVbl + (i - this._offset)), this._vars[i - this._offset], rowIndex, i, index, 0);
        }
        int units = 4200;
        String unit = vbl.stringValue(indexOfVbl + 7);
        row[9] = unit;
        int pos = unit.indexOf(64);
        if (pos != -1) {
            try {
                units = Integer.parseInt(unit.substring(pos + 2, unit.indexOf(86))) * 100;
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        row[12] = new Boolean(false);
        row[6] = this.getCurrent(vbl.intValue(indexOfVbl + 4), units, row, false);
        row[7] = this.getCurrent(vbl.intValue(indexOfVbl + 5), units, row, false);
        row[8] = "";
        SnmpVar maxVar = (SnmpVar)this._maxByPeer.get(node);
        if (maxVar != null) {
            if (maxVar.getType() == 2) {
                row[8] = this.getCurrent(((SnmpInt)maxVar).getValue(), units, row, true);
            } else if (maxVar.getType() == 66) {
                row[8] = this.getCurrentNew(((SnmpGauge)maxVar).getValue(), units, row, true);
            }
        }
        row[10] = this.getCellDisplayString(node, this._mibNodes[10], vbl, vbl.getVb(indexOfVbl + (10 - this._offset)), this._vars[10 - this._offset], rowIndex, 10, index, 0);
    }

    @Override
    protected void setSpecialAttr() {
        SmTableModel.SmTableModelCellChecker[] checkers = new SmTableModel.SmTableModelCellChecker[]{new SmTableModel.SmTableModelCellChecker(this, "cefcPowerRedundancyMode", new int[]{3}, "You've changed RedundancyMode to 'combined' for some of the power supplies.\nAre you sure you want to set them?")};
        this.setCellChecker(checkers);
    }

    private String getCurrentNew(long current, int units, Object[] row, boolean warnLowPower) {
        int nSlots;
        SnmpPeer peer;
        Switch sw;
        if (current == 0L) {
            return "n/a";
        }
        double wattsV = (double)current / 1000.0;
        double unitsV = (double)units / 100.0;
        if (wattsV == 0.0) {
            return "n/a";
        }
        double ampsV = wattsV / unitsV;
        if (warnLowPower && (sw = ClientController.findFabricSwitchByIpAddress((peer = (SnmpPeer)row[0]).getAddress())) != null && (nSlots = sw.getNumSlots()) != 2 && wattsV < 400.0) {
            row[12] = new Boolean(true);
        }
        return wattsV + "W / " + ampsV + 'A';
    }

    private String getCurrent(int current, int units, Object[] row, boolean warnLowPower) {
        int nSlots;
        SnmpPeer peer;
        Switch sw;
        if (current == 0) {
            return "n/a";
        }
        double amp = (double)current / 100.0;
        double watts = amp * (double)units / 100.0;
        if (warnLowPower && (sw = ClientController.findFabricSwitchByIpAddress((peer = (SnmpPeer)row[0]).getAddress())) != null && (nSlots = sw.getNumSlots()) != 2 && watts < 400.0) {
            row[12] = new Boolean(true);
        }
        return watts + "W / " + amp + 'A';
    }

    @Override
    public boolean isCellActive(int row, int col) {
        SnmpPeer peer;
        Switch sw;
        if (col == 5 && (sw = ClientController.findFabricSwitchByIpAddress((peer = (SnmpPeer)this.getValueAt(row, 0)).getAddress())).isN5K()) {
            return false;
        }
        return super.isCellActive(row, col);
    }

    class AvailablePowerSupplyRenderer
    extends BorderCellRenderer {
        AvailablePowerSupplyRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value != null) {
                Object[] rowData = (Object[])SmPowerSupplyTableModel.this._responseData.elementAt(row);
                boolean warnOnLowAvailablePower = (Boolean)rowData[12];
                if (warnOnLowAvailablePower) {
                    this.setBackground(Color.yellow);
                } else {
                    this.setBackground(table.getBackground());
                }
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

