/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.common.model.Card;
import java.util.ArrayList;
import java.util.Collections;

public class SmVirtualInitTableModel
extends SmTableModel {
    static final String[] LABELS = new String[]{"VSAN Id", "Port WWN", "Interface", "Processor Id", "Control"};
    public static final int VSANID = 0;
    public static final int PORTWWN = 1;
    public static final int ATTATCH = 2;
    public static final int PID = 3;
    public static final int CONTROL = 4;

    @Override
    public void setAttr(String[] vars, String[] prefixes, int index, boolean isScalar) {
        this._isScalar = isScalar;
        this.build(vars, prefixes, this._isScalar ? 1 : 2);
        this._index = index;
        this._vars = vars;
    }

    @Override
    public void build(String[] mibVars, String[] prefixes, int offset) {
        this._offset = offset;
        this._prefixes = prefixes;
        this.setHeaders(LABELS);
        this.setEditable(new boolean[]{false, false, false, false, false});
        this.setData(new Array());
    }

    @Override
    public Array getTableVars(SnmpPeer[] nodes) throws SnmpException {
        this._responseData = new Array();
        ArrayList<EndPort> endPorts = ClientController.getInstance().getSelectedDomain().getEndPorts(null, false);
        Collections.sort(endPorts);
        for (int i = 0; i < endPorts.size(); ++i) {
            int attatchedCard;
            Card card;
            EndPort ep = endPorts.get(i);
            boolean isCiscoMDS = WwnDictionary.isMDSWwn(ep.getPortWwn().getValue());
            Switch attatchedSw = ep.getSwitch();
            if (!isCiscoMDS || attatchedSw == null || ep.isFicon() || !ep.isPresent() || ((card = attatchedSw.getCard((attatchedCard = attatchedSw.ifIndex2Card(ep.getIfIndex())) + 1)) == null || card.getType() != 5 && card.getType() != 20) && card.getType() != 39 && card.getType() != 41 && card.getType() != 68) continue;
            Object[] row = new Object[LABELS.length + 1 + 1];
            row[0] = ep.getVsansAsString();
            row[1] = ep.getPortWwn();
            row[2] = ep.getSwitch().getName() + " " + ep.getIfIndexName();
            row[3] = new Integer(attatchedSw.ifIndex2Port(ep.getIfIndex()) / 4 + 1);
            row[4] = ep.isVirtualized() && ep.isVICPP() ? "true" : "false";
            row[SmVirtualInitTableModel.LABELS.length + 1] = ep;
            this._responseData.addElement(row);
        }
        return this._responseData;
    }

    @Override
    protected Object getDevicebject(Object[] rowData) {
        return rowData[LABELS.length + 1];
    }
}

