/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.mds.PortSet;
import com.cisco.dcbu.lib.mds.VsanUtil;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.model.Switch;

class VsanMember {
    Array _port = new Array();
    PortSet _portList = new PortSet(new byte[128]);
    Array _portChannel = new Array();
    SnmpString _portChannelList = new SnmpString(new byte[176]);
    Array _fcIp = new Array();
    SnmpString _fcIpList = new SnmpString(new byte[242]);
    Array _iScsi = new Array();
    SnmpString _iScsiList = new SnmpString(new byte[274]);
    Array _ficon = new Array();
    SnmpString _ficonList = new SnmpString(new byte[274]);
    Array _fcVSif = new Array();
    SnmpString _fcVSifList = new SnmpString(new byte[VsanUtil.MAX_ARRAYSIZE_VFC_EXPLICIT_END]);
    Array _vfcSlotPort = new Array();
    SnmpString _vfcSlotPortList = new SnmpString(new byte[VsanUtil.MAX_ARRAYSIZE_VFC_SLOTPORT_END]);
    Array _vfcFexSlotPort = new Array();
    SnmpString _vfcFexSlotPortList = new SnmpString(new byte[VsanUtil.MAX_ARRAYSIZE_VFC_FEX_IMPLICIT_END]);
    Array _vfcpo = new Array();
    SnmpString _vfcpoList = new SnmpString(new byte[VsanUtil.MAX_ARRAYSIZE_VFC_PORTCHANNEL_END]);

    void addMember(int ifIndex, Switch sw, boolean isFICON) {
        switch (sw.getType(ifIndex)) {
            case 1: {
                this._port.addElement(new Integer(ifIndex));
                int card = sw.ifIndex2Card(ifIndex);
                int port = sw.ifIndex2Port(ifIndex);
                PortSet.setBit(this._portList.getValue(), card, port);
                if (!isFICON) break;
                PortSet.setBit(this._ficonList.getValue(), card, port);
                break;
            }
            case 4: {
                this._portChannel.addElement(new Integer(ifIndex));
                int portChannel = IfIndexUtil.ifIndex2PortChannel(ifIndex);
                VsanUtil.setBit(this._portChannelList.getValue(), portChannel + 1152);
                if (!isFICON) break;
                PortSet.setBit(this._ficonList.getValue(), portChannel + 1152);
                break;
            }
            case 10: {
                this._fcIp.addElement(new Integer(ifIndex));
                int fcIP = IfIndexUtil.ifIndex2Fcip(ifIndex);
                VsanUtil.setBit(this._fcIpList.getValue(), fcIP + 1408);
                if (!isFICON) break;
                VsanUtil.setBit(this._ficonList.getValue(), fcIP + 1408);
                break;
            }
            case 11: {
                this._iScsi.addElement(new Integer(ifIndex));
                int gigECard = sw.ifIndex2Card(ifIndex);
                int gigEPort = sw.ifIndex2Port(ifIndex);
                VsanUtil.setBit(1936, this._iScsiList.getValue(), gigECard, gigEPort);
                if (!isFICON) break;
                VsanUtil.setBit(1936, this._ficonList.getValue(), gigECard, gigEPort);
                break;
            }
            case 30: {
                int subType = IfIndexUtil.getSubType(ifIndex);
                if (subType == 0) {
                    this._fcVSif.addElement(new Integer(ifIndex));
                    int vsifId = IfIndexUtil.getVfcId(ifIndex);
                    VsanUtil.setBit(this._fcVSifList.getValue(), vsifId + 2192);
                    break;
                }
                if (subType == 2) {
                    this._vfcSlotPort.addElement(new Integer(ifIndex));
                    int c = sw.ifIndex2Card(ifIndex);
                    int p = sw.ifIndex2Port(ifIndex);
                    VsanUtil.setBit(VsanUtil.MAX_VFC_SLOTPORT_STARTPOS, this._vfcSlotPortList.getValue(), c, p);
                    break;
                }
                if (subType == 4) {
                    this._vfcFexSlotPort.addElement(new Integer(ifIndex));
                    int fexChassis = sw.ifIndex2Card(ifIndex);
                    int p = sw.ifIndex2Port(ifIndex);
                    VsanUtil.setBit(VsanUtil.MAX_VFC_FEX_IMPLICIT_STARTPOS, this._vfcFexSlotPortList.getValue(), fexChassis - 100, p);
                    break;
                }
                if (subType != 1) break;
                this._vfcpo.addElement(new Integer(ifIndex));
                int vfcpoId = IfIndexUtil.getVfcId(ifIndex) - 1;
                VsanUtil.setBit(this._vfcpoList.getValue(), vfcpoId + VsanUtil.MAX_VFC_PO_STARTPOS);
                break;
            }
        }
    }
}

