/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.Switch;

public class ZoneActStatusTableModel
extends SmTableModel {
    static final int CAUSE_COL = 4;
    static final int DOM_COL = 5;

    @Override
    public synchronized Object[] addElement(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        int domainId;
        Object[] row = super.addElement(vbl, node, index);
        if (row == null) {
            return row;
        }
        if (vbl.intValue(2) == 0) {
            row[4] = "n/a";
        }
        if ((domainId = vbl.intValue(3)) == 0) {
            row[5] = "none";
        } else {
            int vsanId = index.getValue()[0];
            Switch sw = ClientController.findFabricSwitchByVsanDomainId(vsanId, domainId);
            if (sw != null) {
                row[5] = sw;
            }
        }
        return row;
    }

    @Override
    protected boolean validateVbl(SnmpPeer peer, VarBindList vbl, int state) {
        return true;
    }
}

