/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dmmsewizard;

import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.dmmsewizard.DmmSeWizardBase;
import com.cisco.dcbu.sm.client.dmmsewizard.SwitchCardContainer;
import com.cisco.dcbu.sm.common.model.Card;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DmmSeEnableStep
extends WizardPanel {
    public static final String TABLE_PANEL = new String("Table Panel");
    public static final String TEXT_PANEL = new String("Text Panel");
    public static final String DMM_StepTitle = ": Enable DMM Feature";
    public static final String SE_StepTitle = ": Enable Secure Erase Feature";
    public static final String StepDesc = "On this step the feature will be enabled for all the ports\\node(s) on the modules you have selected.";
    public static final String DefaultSkipText = "Detected that all modules have the feature enabled.\nUpon clicking next will check and create the necessary routes.";
    private DmmSeWizardBase.WizardType _type;
    private int _instanceID;
    private List<SwitchCardContainer> _selectedSwitchCards = new ArrayList<SwitchCardContainer>();
    JList _displayList;

    public DmmSeEnableStep(DmmSeWizardBase wizard, int stepNumber, DmmSeWizardBase.WizardType type, int instanceID) {
        super(type == DmmSeWizardBase.WizardType.DMM_WIZARD ? "Step " + stepNumber + DMM_StepTitle : "Step " + stepNumber + SE_StepTitle, "On this step the feature will be enabled for all the ports\\node(s) on the modules you have selected.  Upon clicking finish, the " + type.getName() + " for all " + (type == DmmSeWizardBase.WizardType.DMM_WIZARD ? "ports" : "node(s)") + " on the listed modules will be enabled.", wizard, wizard.getIcon());
        this._instanceID = instanceID;
        this._type = type;
        this._selectedSwitchCards.clear();
        this._selectedSwitchCards.addAll(wizard.getSelectedSwitchModules());
        this.initialize();
    }

    @Override
    public boolean refresh() {
        this._selectedSwitchCards.clear();
        this._selectedSwitchCards.addAll(((DmmSeWizardBase)this.getWizard()).getSelectedSwitchModules());
        this._displayList.setListData(this._selectedSwitchCards.toArray(new SwitchCardContainer[this._selectedSwitchCards.size()]));
        return super.refresh();
    }

    @Override
    public void doFinish() {
        SetThread setTh = new SetThread();
        setTh.start();
    }

    public void doFinishNoChecking() {
        this.getWizard().getNavigator().getCancel().setText("Close");
        this.setDataValid(false);
        super.doFinish();
    }

    private void initialize() {
        String portNodeText = this._type == DmmSeWizardBase.WizardType.DMM_WIZARD ? "ports" : "node(s)";
        JLabel ListText = new JLabel("Switch, Module", 2);
        this._displayList = new JList<SwitchCardContainer>(this._selectedSwitchCards.toArray(new SwitchCardContainer[this._selectedSwitchCards.size()]));
        JScrollPane scrPan = new JScrollPane(this._displayList);
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setVgap(5);
        JPanel mainListPanel = new JPanel(borderLayout);
        mainListPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        mainListPanel.add((Component)ListText, "North");
        mainListPanel.add((Component)scrPan, "Center");
        this.add(mainListPanel);
    }

    class SetThread
    extends Thread {
        SetThread() {
        }

        @Override
        public void run() {
            ArrayList<Card> cards = new ArrayList<Card>();
            HashMap<Card, SwitchCardContainer> swCardMap = new HashMap<Card, SwitchCardContainer>();
            for (SwitchCardContainer nextSwCard : DmmSeEnableStep.this._selectedSwitchCards) {
                cards.add(nextSwCard.getCard());
                swCardMap.put(nextSwCard.getCard(), nextSwCard);
            }
            String featureName = DmmSeEnableStep.this._type == DmmSeWizardBase.WizardType.DMM_WIZARD ? "dmm" : "se";
            try {
                DmmSeEnableStep.this.getWizard().getNavigator().getBackBtn().setEnabled(false);
                DmmSeEnableStep.this.getWizard().getNavigator().getNextBtn().setEnabled(false);
                Map<Card, Exception> failures = ClientController.getInstance().getDDMServerRif().setFeatureEnabledDmmSe(cards, featureName);
                if (failures.size() == 0) {
                    Util.infoMessage(DmmSeEnableStep.this.getWizard(), "Feature enabling successful.", false);
                    DmmSeEnableStep.this.doFinishNoChecking();
                } else {
                    Object[] msgAndList = new Object[2];
                    msgAndList[0] = new String("Unable to enable the feature for all cards.\nUnable to continue at this time.\nError(s) received:");
                    String[] strErrors = new String[failures.size()];
                    int index = 0;
                    for (Card card : failures.keySet()) {
                        Exception err = failures.get(card);
                        SwitchCardContainer swCard = (SwitchCardContainer)swCardMap.get(card);
                        StringBuilder errMs = new StringBuilder(swCard + ":");
                        errMs.append(Util.getErrorMessage(err));
                        strErrors[index] = errMs.toString();
                    }
                    JList<String> displayList = new JList<String>(strErrors);
                    JScrollPane scrPan = new JScrollPane(displayList);
                    scrPan.setPreferredSize(new Dimension(650, 100));
                    msgAndList[1] = scrPan;
                    JOptionPane.showMessageDialog(DmmSeEnableStep.this.getWizard(), msgAndList, "Error :" + ((DmmSeWizardBase)DmmSeEnableStep.this.getWizard()).getTitle(), 0);
                    DmmSeEnableStep.this.getWizard().getNavigator().getNextBtn().setEnabled(true);
                }
            }
            catch (Exception e) {
                Util.errorMessage((Component)DmmSeEnableStep.this.getWizard(), "Unable to enable the feature for all cards.\nUnable to continue at this time.\nError received: " + e.getMessage());
                DmmSeEnableStep.this.getWizard().getNavigator().getNextBtn().setEnabled(true);
            }
        }
    }
}

