/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dmmsewizard;

import com.cisco.dcbu.lib.ui.table.KTable;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.dmmsewizard.SwitchCardContainer;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.common.dto.SSHConfigInfo;
import com.cisco.dcbu.sm.common.model.Card;
import com.cisco.dcbu.sm.common.model.LicenseInfo;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.rif.ModelFacadeRif;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.UIManager;

public abstract class DmmSeWizardBase
extends JWizard {
    private static final Font TableFont = (Font)UIManager.getDefaults().get("Table.font");
    public static final Dimension Default_Wizard_Size = new Dimension(750, 600);
    public static final String SE_FEATURE_NAME = "se";
    public static final String DMM_MIN_VERSION = "4.2(0)";
    public static final String SE_MIN_VERSION = "5.0(0)";
    public static final int[] DMM_SUPPORTED_CARDS = new int[]{5, 20, 39, 41, 68};
    public static final int[] SE_SUPPORTED_CARDS = new int[]{39, 41};
    public static final String[] DMM_LICENSE = new String[]{"DMM_FOR_SSM_PKG", "DMM_184_PKG", "DMM_9222i_PKG", "DMM_9250"};
    public static final String[] SE_LICENSE = new String[]{"STORAGE_SERVICES_ENABLER_PKG", "STORAGE_SERVICES_184", "STORAGE_SERVICES_9222i"};
    private static Map<String, List<Integer>> dmmMapLicenseToCardType = new HashMap<String, List<Integer>>();
    private static Map<String, List<Integer>> seMapLicenseToCardType = new HashMap<String, List<Integer>>();
    private List<Integer> _supportedCards = new ArrayList<Integer>();
    private WizardType _wizardType = null;
    private JFrame _parent;
    private List<SwitchCardContainer> _selectedSwitchModules = new ArrayList<SwitchCardContainer>();
    private Map<SwitchBase, SSHConfigInfo> _discoveredSSHInfo = new HashMap<SwitchBase, SSHConfigInfo>();
    private Map<SwitchBase, List<String>> _discoveredVsanIpInfo = new HashMap<SwitchBase, List<String>>();
    private Map<Card, List<String>> _discoveredCppIpInfo = new HashMap<Card, List<String>>();
    private ImageIcon _wizardIcon;

    protected DmmSeWizardBase(JFrame parent, WizardType wizardType, ImageIcon icon) {
        super(parent);
        this._parent = parent;
        this._wizardIcon = icon;
        this._wizardType = wizardType;
        if (wizardType == WizardType.DMM_WIZARD) {
            this.populateSupportedCards(DMM_SUPPORTED_CARDS);
        } else {
            this.populateSupportedCards(SE_SUPPORTED_CARDS);
        }
        this.initialize();
        this.addWizardSteps();
    }

    @Override
    public void dispose() {
        super.dispose();
        this._supportedCards.clear();
        this._wizardType = null;
        this._parent = null;
        this._selectedSwitchModules.clear();
        this._discoveredSSHInfo.clear();
        this._discoveredVsanIpInfo.clear();
        this._discoveredCppIpInfo.clear();
        this._wizardIcon = null;
    }

    private void populateSupportedCards(int[] cards) {
        this._supportedCards.clear();
        for (int nextCard : cards) {
            this._supportedCards.add(nextCard);
        }
    }

    public ImageIcon getIcon() {
        return this._wizardIcon;
    }

    public JFrame getFrame() {
        return this._parent;
    }

    public WizardType getWizardType() {
        return this._wizardType;
    }

    public void setSelectedSwitchModules(List<SwitchCardContainer> swModules) {
        this._selectedSwitchModules.clear();
        this._selectedSwitchModules.addAll(swModules);
    }

    public List<SwitchCardContainer> getSelectedSwitchModules() {
        ArrayList<SwitchCardContainer> swModules = new ArrayList<SwitchCardContainer>();
        swModules.addAll(this._selectedSwitchModules);
        return swModules;
    }

    public List<SwitchCardContainer> getNonSUPSelectedSwitchModules() {
        ArrayList<SwitchCardContainer> swModules = new ArrayList<SwitchCardContainer>();
        for (SwitchCardContainer next : this._selectedSwitchModules) {
            if (next.getCard().getType() == 41 || next.getCard().getType() == 68) continue;
            swModules.add(next);
        }
        return swModules;
    }

    public List<Switch> getSelectedSwitches() {
        ArrayList<Switch> sws = new ArrayList<Switch>();
        for (SwitchCardContainer nextSwitchCon : this._selectedSwitchModules) {
            Switch nextSw = nextSwitchCon.getSwitch();
            if (sws.contains(nextSw)) continue;
            sws.add(nextSw);
        }
        return sws;
    }

    public void setSSHConfigInfo(Map<SwitchBase, SSHConfigInfo> sshInfo) {
        this._discoveredSSHInfo.clear();
        this._discoveredSSHInfo.putAll(sshInfo);
    }

    public Map<SwitchBase, SSHConfigInfo> getSSHConfigInfo() {
        HashMap<SwitchBase, SSHConfigInfo> sshInfo = new HashMap<SwitchBase, SSHConfigInfo>();
        sshInfo.putAll(this._discoveredSSHInfo);
        return sshInfo;
    }

    public void setCppIpAddressInfo(Map<Card, List<String>> vsanIpInfo) {
        this._discoveredCppIpInfo.clear();
        this._discoveredCppIpInfo.putAll(vsanIpInfo);
    }

    public Map<Card, List<String>> getCppIpAddressInfo() {
        HashMap<Card, List<String>> ipInfo = new HashMap<Card, List<String>>();
        ipInfo.putAll(this._discoveredCppIpInfo);
        return ipInfo;
    }

    public void setVSANIpAddressInfo(Map<SwitchBase, List<String>> vsanIpInfo) {
        this._discoveredVsanIpInfo.clear();
        this._discoveredVsanIpInfo.putAll(vsanIpInfo);
    }

    public Map<SwitchBase, List<String>> getVSANIpAddressInfo() {
        HashMap<SwitchBase, List<String>> ipInfo = new HashMap<SwitchBase, List<String>>();
        ipInfo.putAll(this._discoveredVsanIpInfo);
        return ipInfo;
    }

    public List<SwitchCardContainer> getCapableSwitchesForUserSelection() throws Exception {
        MgmtDomainIf selDomain = ClientController.getInstance().getSelectedDomain();
        Switch[] switches = selDomain.getSwitches();
        return this.filterNonValidSwitches(switches);
    }

    public List<SwitchCardContainer> getValidPeers() {
        MgmtDomainIf selDomain = ClientController.getInstance().getSelectedDomain();
        Switch[] switches = selDomain.getSwitches();
        return this.filterNonValidPeers(switches);
    }

    public String cardToString(Card card) {
        return new StringBuffer("Module ").append(card.getSlotId()).append(" (").append(card.getModelName()).append(") ").append(card.getName()).toString();
    }

    public static String getWrapErrorMessage(String msg, int charWidth) {
        int lastPos = msg.indexOf(32);
        int posLastReturn = 0;
        if (msg.length() > charWidth && lastPos != -1) {
            while (msg.length() - posLastReturn > charWidth) {
                int nextPos = msg.indexOf(32, lastPos + 1);
                if (nextPos < charWidth) {
                    lastPos = nextPos;
                    continue;
                }
                posLastReturn = lastPos;
                msg = msg.substring(0, lastPos) + "\n" + msg.substring(lastPos + 1);
            }
        }
        return msg;
    }

    private List<SwitchCardContainer> filterNonValidSwitches(Switch[] switches) throws Exception {
        ArrayList<SwitchCardContainer> resultSwitches = new ArrayList<SwitchCardContainer>();
        for (Switch nextSwitch : switches) {
            if (!nextSwitch.isPresent() || !this.checkMinVersion(nextSwitch) || !this.checkIsLicensed(nextSwitch)) continue;
            List<Integer> supportedCardsForSwitchLicense = this.getSupportedCardsBasedOnLicense(nextSwitch);
            this.findCardBySwitch(nextSwitch, resultSwitches, supportedCardsForSwitchLicense);
        }
        return resultSwitches;
    }

    private List<Integer> getSupportedCardsBasedOnLicense(Switch sw) {
        ArrayList<Integer> cardslicensedOnSwitch = new ArrayList<Integer>();
        if (this._wizardType == WizardType.DMM_WIZARD) {
            for (String nextLicName : DMM_LICENSE) {
                LicenseInfo info = sw.getLicense(nextLicName);
                if (info == null || !info.canCheckout()) continue;
                List<Integer> cardTypesForLicense = dmmMapLicenseToCardType.get(nextLicName);
                for (Integer nextType : cardTypesForLicense) {
                    if (cardslicensedOnSwitch.contains(nextType)) continue;
                    cardslicensedOnSwitch.add(nextType);
                }
            }
            return cardslicensedOnSwitch;
        }
        for (String nextLicName : SE_LICENSE) {
            LicenseInfo info = sw.getLicense(nextLicName);
            if (info == null || !info.canCheckout()) continue;
            List<Integer> cardTypesForLicense = seMapLicenseToCardType.get(nextLicName);
            for (Integer nextType : cardTypesForLicense) {
                if (cardslicensedOnSwitch.contains(nextType)) continue;
                cardslicensedOnSwitch.add(nextType);
            }
        }
        return cardslicensedOnSwitch;
    }

    private boolean checkMinVersion(Switch sw) {
        if (this._wizardType == WizardType.DMM_WIZARD) {
            return sw.isVersionGreaterThanEqual(DMM_MIN_VERSION);
        }
        return sw.isVersionGreaterThanEqual(SE_MIN_VERSION);
    }

    private void findCardBySwitch(Switch sw, List<SwitchCardContainer> list, List<Integer> supportedCardsLicensedOnSwitch) throws Exception {
        Card[] cards = sw.getCards();
        if (this._wizardType == WizardType.DMM_WIZARD) {
            for (Card card : cards) {
                SwitchCardContainer switchCard;
                int dmmState;
                if (!supportedCardsLicensedOnSwitch.contains(card.getType()) || card.getPowerOperStatus() != 2 || (dmmState = card.getDmmState()) == 1 || list.contains(switchCard = new SwitchCardContainer(sw, card))) continue;
                list.add(switchCard);
            }
        } else {
            ModelFacadeRif modelF = ClientController.getInstance().assertModelFacade();
            ArrayList<SwitchBase> swList = new ArrayList<SwitchBase>();
            swList.add(sw.getSwitchBase());
            List<Card> cardsFeatureEnabled = modelF.getCardsWithFeatureEnabled(swList, SE_FEATURE_NAME);
            for (Card card : cards) {
                if (!supportedCardsLicensedOnSwitch.contains(card.getType()) || card.getPowerOperStatus() != 2 || cardsFeatureEnabled.contains(card)) continue;
                SwitchCardContainer switchCard = new SwitchCardContainer(sw, card);
                list.add(switchCard);
            }
        }
    }

    private List<SwitchCardContainer> filterNonValidPeers(Switch[] switches) {
        ArrayList<SwitchCardContainer> resultSwitches = new ArrayList<SwitchCardContainer>();
        for (Switch nextSwitch : switches) {
            if (!nextSwitch.isPresent() || !nextSwitch.isVersionGreaterThanEqual(DMM_MIN_VERSION) || !this.checkIsLicensed(nextSwitch)) continue;
            this.findDmmEnabledCardBySwitch(nextSwitch, resultSwitches);
        }
        return resultSwitches;
    }

    private void findDmmEnabledCardBySwitch(Switch sw, List<SwitchCardContainer> list) {
        Card[] cards;
        for (Card card : cards = sw.getCards()) {
            int dmmState;
            if (!this._supportedCards.contains(card.getType()) || card.getPowerOperStatus() != 2 || (dmmState = card.getDmmState()) != 1) continue;
            SwitchCardContainer ddmSwitch = new SwitchCardContainer(sw, card);
            list.add(ddmSwitch);
        }
    }

    private boolean checkIsLicensed(Switch sw) {
        if (this._wizardType == WizardType.DMM_WIZARD) {
            for (String nextLicName : DMM_LICENSE) {
                LicenseInfo info = sw.getLicense(nextLicName);
                if (info == null || !info.canCheckout()) continue;
                return true;
            }
            return false;
        }
        for (String nextLicName : SE_LICENSE) {
            LicenseInfo info = sw.getLicense(nextLicName);
            if (info == null || !info.canCheckout()) continue;
            return true;
        }
        return false;
    }

    protected abstract void initialize();

    protected abstract void addWizardSteps();

    public static void setColumnWidth(KTable table, int[] columnNumChars) {
        int cols = table.getColumnCount();
        if (cols > columnNumChars.length) {
            throw new IllegalArgumentException("");
        }
        for (int i = 0; i < cols; ++i) {
            int width = DmmSeWizardBase.calcColumnWidth(table, i, TableFont, columnNumChars[i]);
            DmmSeWizardBase.setColumnWidth(table, i, width);
        }
    }

    private static int calcColumnWidth(KTable table, int col, Font font, int charLen) {
        FontMetrics fm = table.getFontMetrics(font);
        int widest = table.getHeaderColumnWidth(fm, col);
        char[] chars = new char[charLen];
        for (int i = 0; i < charLen; ++i) {
            chars[i] = 77;
        }
        int cwidth = fm.charsWidth(chars, 0, charLen - 1);
        if (widest < cwidth) {
            widest = cwidth;
        }
        return widest + 4;
    }

    private static void setColumnWidth(KTable table, int col, int width) {
        table.getColumnModel().getColumn(col).setPreferredWidth(width);
    }

    static {
        ArrayList<Integer> cardTypes = new ArrayList<Integer>();
        cardTypes.add(5);
        cardTypes.add(20);
        dmmMapLicenseToCardType.put("DMM_FOR_SSM_PKG", cardTypes);
        cardTypes = new ArrayList();
        cardTypes.add(39);
        dmmMapLicenseToCardType.put("DMM_184_PKG", cardTypes);
        cardTypes = new ArrayList();
        cardTypes.add(41);
        dmmMapLicenseToCardType.put("DMM_9222i_PKG", cardTypes);
        cardTypes = new ArrayList();
        cardTypes.add(68);
        dmmMapLicenseToCardType.put("DMM_9250", cardTypes);
        cardTypes = new ArrayList();
        cardTypes.add(39);
        cardTypes.add(41);
        seMapLicenseToCardType.put("STORAGE_SERVICES_ENABLER_PKG", cardTypes);
        cardTypes = new ArrayList();
        cardTypes.add(39);
        seMapLicenseToCardType.put("STORAGE_SERVICES_184", cardTypes);
        cardTypes = new ArrayList();
        cardTypes.add(41);
        seMapLicenseToCardType.put("STORAGE_SERVICES_9222i", cardTypes);
    }

    public static enum WizardType {
        DMM_WIZARD("DMM"),
        SE_WIZARD("Secure Erase");

        private String name;

        private WizardType(String typeName) {
            this.name = typeName;
        }

        public String getName() {
            return this.name;
        }
    }
}

