/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dmmsewizard;

import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.dmmsewizard.SwitchCardContainer;
import java.util.ArrayList;
import java.util.Arrays;

public class SwitchCardIPMaskTableModel
extends KTableModel {
    public final int ColumnSize = Column.values().length;

    public SwitchCardIPMaskTableModel(String[] headers) {
        this.setHeaders(headers);
        Array data = new Array();
        this.setData(data);
    }

    public int getSwitchModuleIndex(SwitchCardContainer swCard) {
        Array data = this.getData();
        Integer index = -1;
        for (int i = 0; i < data.size(); ++i) {
            Object[] row = (Object[])data.elementAt(i);
            if (!swCard.equals(row[Column.SWITCH_MODULE.ordinal()])) continue;
            index = i;
            break;
        }
        return index;
    }

    public synchronized void addEntry(SwitchCardContainer swCard, SnmpIpAddress ip, int prefix) throws Exception {
        if (this.getSwitchModuleIndex(swCard) != -1) {
            throw new Exception("Entry already exists");
        }
        Object[] row = new Object[this.ColumnSize];
        row[Column.SWITCH_MODULE.ordinal()] = swCard;
        row[Column.IPADDR.ordinal()] = ip;
        row[Column.MASK.ordinal()] = prefix;
        this.getData().addElement(row);
        this.fireTableDataChanged();
    }

    public synchronized void deleteEntriesFor(SwitchCardContainer swCard) {
        Array data = this.getData();
        Integer index = this.getSwitchModuleIndex(swCard);
        if (index != -1) {
            data.removeElementAt(index);
            this.fireTableDataChanged();
        }
    }

    public synchronized void clearAll() {
        this.getData().clear();
        this.fireTableDataChanged();
    }

    public synchronized SwitchCardContainer[] deleteRows(int[] rowIndexes) {
        if (rowIndexes == null) {
            return new SwitchCardContainer[0];
        }
        ArrayList<SwitchCardContainer> deletedSwitchRows = new ArrayList<SwitchCardContainer>();
        Arrays.sort(rowIndexes);
        for (int i = rowIndexes.length - 1; i >= 0; --i) {
            SwitchCardContainer result = this.deleteRow(rowIndexes[i], false);
            if (result == null) continue;
            deletedSwitchRows.add(result);
        }
        this.fireTableDataChanged();
        return deletedSwitchRows.toArray(new SwitchCardContainer[deletedSwitchRows.size()]);
    }

    private synchronized SwitchCardContainer deleteRow(int rowIndex, boolean fireDataChanged) {
        Array data = this.getData();
        Object[] row = (Object[])data.elementAt(rowIndex);
        SwitchCardContainer swCard = (SwitchCardContainer)row[Column.SWITCH_MODULE.ordinal()];
        this.getData().removeElementAt(rowIndex);
        if (fireDataChanged) {
            this.fireTableDataChanged();
        }
        return swCard;
    }

    public static enum Column {
        SWITCH_MODULE,
        IPADDR,
        MASK;

    }
}

