/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dmmsewizard;

import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.dmmsewizard.SwitchCardContainer;
import java.util.ArrayList;
import java.util.Arrays;

public class SwitchCardPeerTableModel
extends KTableModel {
    public final int ColumnSize = Column.values().length;

    public SwitchCardPeerTableModel(String[] headers) {
        this.setHeaders(headers);
        Array data = new Array();
        this.setData(data);
    }

    public int getSwitchModuleIndex(SwitchCardContainer swCard, SwitchCardContainer swCardPeer) {
        Array data = this.getData();
        Integer index = -1;
        for (int i = 0; i < data.size(); ++i) {
            Object[] row = (Object[])data.elementAt(i);
            if (!swCard.equals(row[Column.SWITCH_MODULE.ordinal()]) || !swCardPeer.equals(row[Column.PEER.ordinal()])) continue;
            index = i;
            break;
        }
        return index;
    }

    public int[] getSwitchModuleIndexes(SwitchCardContainer swCard) {
        Array data = this.getData();
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (int i = 0; i < data.size(); ++i) {
            Object[] row = (Object[])data.elementAt(i);
            if (!swCard.equals(row[Column.SWITCH_MODULE.ordinal()])) continue;
            indexes.add(i);
            break;
        }
        int[] results = indexes.isEmpty() ? new int[]{} : new int[indexes.size()];
        for (int i = 0; i < indexes.size(); ++i) {
            results[i] = (Integer)indexes.get(i);
        }
        return results;
    }

    public synchronized void addEntry(SwitchCardContainer swCard, SwitchCardContainer swCardPeer) throws Exception {
        if (this.getSwitchModuleIndex(swCard, swCardPeer) != -1 || this.getSwitchModuleIndex(swCardPeer, swCard) != -1) {
            throw new Exception("Entry already exists");
        }
        Object[] row = new Object[this.ColumnSize];
        row[Column.SWITCH_MODULE.ordinal()] = swCard;
        row[Column.PEER.ordinal()] = swCardPeer;
        this.getData().addElement(row);
        this.fireTableDataChanged();
    }

    public synchronized void deleteEntriesFor(SwitchCardContainer swCard) {
        Array data = this.getData();
        int[] indexes = this.getSwitchModuleIndexes(swCard);
        if (indexes.length > 0) {
            this.deleteRows(indexes);
            this.fireTableDataChanged();
        }
    }

    public synchronized void clearAll() {
        this.getData().clear();
        this.fireTableDataChanged();
    }

    public synchronized SwitchCardContainer[] deleteRows(int[] rowIndexes) {
        if (rowIndexes == null) {
            return new SwitchCardContainer[0];
        }
        ArrayList<SwitchCardContainer> deletedSwitchRows = new ArrayList<SwitchCardContainer>();
        Arrays.sort(rowIndexes);
        for (int i = rowIndexes.length - 1; i >= 0; --i) {
            SwitchCardContainer result = this.deleteRow(rowIndexes[i], false);
            if (result == null) continue;
            deletedSwitchRows.add(result);
        }
        this.fireTableDataChanged();
        return deletedSwitchRows.toArray(new SwitchCardContainer[deletedSwitchRows.size()]);
    }

    private synchronized SwitchCardContainer deleteRow(int rowIndex, boolean fireDataChanged) {
        Array data = this.getData();
        Object[] row = (Object[])data.elementAt(rowIndex);
        SwitchCardContainer swCard = (SwitchCardContainer)row[Column.SWITCH_MODULE.ordinal()];
        this.getData().removeElementAt(rowIndex);
        if (fireDataChanged) {
            this.fireTableDataChanged();
        }
        return swCard;
    }

    public static enum Column {
        SWITCH_MODULE,
        PEER;

    }
}

