/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.event;

import com.cisco.dcbu.sm.client.event.EventDispatcher;
import com.cisco.dcbu.sm.common.event.AbstractEventHandler;
import com.cisco.dcbu.sm.common.event.MessageSelector;
import java.io.Serializable;
import java.rmi.RemoteException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;

public class LanEventHandler
extends AbstractEventHandler {
    private static LanEventHandler _eventHandler = null;
    private static final String TOPIC_FM = "jms/topic/fmsTopic";

    public LanEventHandler(String host, int port) throws RemoteException {
        super(host, port);
    }

    public static LanEventHandler getInstance(String host, int port) throws RemoteException {
        if (_eventHandler == null) {
            _eventHandler = new LanEventHandler(host, port);
        }
        return _eventHandler;
    }

    @Override
    protected void setMessageSelector() throws JMSException {
        this.setMessageSelector(MessageSelector.LAN_MSG_SELECTOR);
    }

    @Override
    public void onMessage(Message msg) {
        ObjectMessage om = (ObjectMessage)msg;
        Serializable event = null;
        try {
            event = om.getObject();
        }
        catch (Exception ex) {
            this._logger.error((Object)("error process event:" + om.toString()));
            return;
        }
        EventDispatcher.getInstance().enqueue(event);
    }

    @Override
    public void remove() {
        _eventHandler = null;
    }

    @Override
    protected String getTopic() {
        return TOPIC_FM;
    }
}

