/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.fa.wizard;

import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.script.AbstractWorker;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.fa.FACfgComparator;
import com.cisco.dcbu.sm.client.fa.FAClientHelper;
import com.cisco.dcbu.sm.client.fa.MoveTask;
import com.cisco.dcbu.sm.client.fa.wizard.FAPreConfigFinishPanel;
import com.cisco.dcbu.sm.client.fa.wizard.FAWizard;
import com.cisco.dcbu.sm.client.fa.wizard.MoveAskPWWNStep;
import com.cisco.dcbu.sm.client.fa.wizard.MoveDestStep;
import com.cisco.dcbu.sm.client.fa.wizard.MoveMenuStep;
import com.cisco.dcbu.sm.client.fa.wizard.MoveSourceStep;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.npv.util.NpvClientHelper;
import com.cisco.dcbu.sm.client.npv.view.ProgressWindow;
import com.cisco.dcbu.sm.common.dto.FlexAtahCfg;
import com.cisco.dcbu.sm.common.dto.FlexAtahSwBaseCfg;
import com.cisco.dcbu.sm.common.model.FcPortBase;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class FAMoveWizard
extends FAWizard {
    public static final String NAME = "Flex Attach:  Move Server";
    public static final ImageIcon ICON = Util.loadIcon("icons/FA.gif");
    private Fabric fabric;
    protected Map<SwitchBase, List<FlexAtahCfg>> faCfgMap = new HashMap<SwitchBase, List<FlexAtahCfg>>();
    protected Map<SwitchBase, List<FcPortBase>> portMap = new HashMap<SwitchBase, List<FcPortBase>>();
    private boolean isCanceled = false;
    protected ProgressWindow progressWindow;
    private MoveMenuStep menuStep;
    private MoveSourceStep sourceStep;
    private MoveDestStep destStep;
    private MoveAskPWWNStep wwnStep;
    private boolean isApplying = false;

    public static FAWizard getInstance(JFrame frame) throws Exception {
        return FAMoveWizard.createMoveWizard(frame);
    }

    public static FAMoveWizard getInstance() {
        return (FAMoveWizard)instance;
    }

    protected FAMoveWizard(JFrame p) {
        super(p);
    }

    @Override
    public String getWizardName() {
        return NAME;
    }

    @Override
    public void addSteps() {
        this.menuStep = new MoveMenuStep();
        this.addPanel("Step1", this.menuStep);
        this.sourceStep = new MoveSourceStep();
        this.addPanel("Step2", this.sourceStep);
        this.destStep = new MoveDestStep();
        this.addPanel("Step3", this.destStep);
        this.wwnStep = new MoveAskPWWNStep();
        this.addPanel("Step4", this.wwnStep);
        this.first();
        this.setVisible(true);
    }

    @Override
    protected void init() {
        if (this.progressWindow == null) {
            this.progressWindow = new ProgressWindow((JFrame)this.getParent(), NAME, "Preloading data...please wait.");
        }
        AbstractWorker worker = new AbstractWorker(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object construct() {
                HashMap<SwitchBase, Exception> swExceptions = new HashMap<SwitchBase, Exception>();
                try {
                    FAMoveWizard.this.progressWindow.setMaximum(3);
                    if (FAWizard.logger.isTraceEnabled()) {
                        FAWizard.logger.trace((Object)"Starting progress window");
                    }
                    FAMoveWizard.this.progressWindow.start();
                    FAMoveWizard.this.fabric = ClientController.getInstance().getFabric();
                    if (FAMoveWizard.this.fabric == null) {
                        RuntimeException runtimeException = new RuntimeException("Fabric is null, unable to initialize Flex Attach:  Move Server");
                        return runtimeException;
                    }
                    FAMoveWizard.this.progressWindow.setProgress(1);
                    Switch[] sws = FAMoveWizard.this.fabric.getSwitches();
                    ArrayList<SwitchBase> baseList = new ArrayList<SwitchBase>();
                    ArrayList<SnmpUserOpt> optList = new ArrayList<SnmpUserOpt>();
                    if (sws != null) {
                        for (Switch sw : sws) {
                            if (!sw.isNpvEnabled() || !FAMoveWizard.this.isAllow(sw)) continue;
                            baseList.add(sw.getSwitchBase());
                            optList.add(sw.getFabric().getSnmpUserOpt());
                        }
                    }
                    Collections.sort(baseList, new Comparator<SwitchBase>(){

                        @Override
                        public int compare(SwitchBase obj1, SwitchBase obj2) {
                            return obj1.toString().compareTo(obj2.toString());
                        }
                    });
                    FAMoveWizard.this.portMap = NpvClientHelper.getInstance().getNPVRif().findFcPortBase(baseList);
                    FAMoveWizard.this.progressWindow.setProgress(2);
                    Map<SwitchBase, FlexAtahSwBaseCfg> swCfgs = FAClientHelper.getRemote().getFlexAtahCfg(baseList, optList);
                    for (SwitchBase sw : swCfgs.keySet()) {
                        FlexAtahSwBaseCfg cfg = swCfgs.get(sw);
                        if (cfg.getException() == null) {
                            FAMoveWizard.this.faCfgMap.put(sw, cfg.getPortList());
                            continue;
                        }
                        swExceptions.put(sw, cfg.getException());
                    }
                    Set<SwitchBase> keys = FAMoveWizard.this.faCfgMap.keySet();
                    for (SwitchBase key : keys) {
                        List<FlexAtahCfg> cfgs = FAMoveWizard.this.faCfgMap.get(key);
                        FAClientHelper.removeNpPort(cfgs);
                        Collections.sort(cfgs, new FACfgComparator());
                    }
                    FAMoveWizard.this.progressWindow.setProgress(3);
                    for (SwitchBase key : swExceptions.keySet()) {
                        FAMoveWizard.this.faCfgMap.remove(key);
                        FAMoveWizard.this.portMap.remove(key);
                    }
                }
                catch (Exception ex) {
                    FAWizard.logger.error((Object)ex.getMessage());
                    Exception exception = ex;
                    return exception;
                }
                finally {
                    if (FAMoveWizard.this.progressWindow != null) {
                        if (FAWizard.logger.isTraceEnabled()) {
                            FAWizard.logger.trace((Object)"Stopping progress window");
                        }
                        FAMoveWizard.this.progressWindow.stop();
                        FAMoveWizard.this.progressWindow.dispose();
                    }
                    if (FAMoveWizard.this.faCfgMap.size() != FAMoveWizard.this.portMap.size() || FAMoveWizard.this.faCfgMap.size() <= 0 || FAMoveWizard.this.faCfgMap.size() <= 0) {
                        String msg = FAWizard.NUM_SWITCH_MISMATCH_ERR;
                        if (swExceptions.size() > 0) {
                            msg = msg + "\n\n" + FAClientHelper.buildExceptionMessage(swExceptions);
                        }
                        return new Exception(msg);
                    }
                    if (swExceptions.size() > 0) {
                        String msg = FAClientHelper.buildExceptionMessage(swExceptions);
                        if (!this.isInterrupted()) {
                            JOptionPane.showMessageDialog(FAMoveWizard.getInstance(), msg, FAMoveWizard.NAME, 2);
                        }
                    }
                }
                return true;
            }

            @Override
            public void finished() {
                Object retObj = this.getValue();
                if (retObj instanceof Exception) {
                    Exception ex = (Exception)retObj;
                    FAWizard.logger.error((Object)ex.getStackTrace());
                    FAWizard.logger.warn((Object)"Unable to load Flex Attach data: ", (Throwable)ex);
                    if (!this.isInterrupted()) {
                        FAMoveWizard.this.showError(ex, FAMoveWizard.NAME);
                        FAMoveWizard.this.dispose();
                    }
                } else if (!this.isInterrupted()) {
                    FAMoveWizard.this.addSteps();
                }
                if (FAMoveWizard.this.progressWindow != null) {
                    FAMoveWizard.this.progressWindow.stop();
                    FAMoveWizard.this.progressWindow.dispose();
                }
            }
        };
        this.addWorker(worker);
        worker.start();
    }

    public boolean isSameSwitch() {
        return this.menuStep.isSameSwitch();
    }

    public void applyMove(final FAPreConfigFinishPanel progressPanel) throws Exception {
        final SwitchBase fromSw = this.sourceStep.getSwitch();
        final SwitchBase toSw = this.destStep.getSwitch();
        final FlexAtahCfg sCfg = this.sourceStep.getSource();
        final FlexAtahCfg toCfg = this.destStep.getDest();
        if (toCfg == null || sCfg == null) {
            throw new Exception("Unable to get new configuration.");
        }
        ClientController.getInstance();
        final SnmpUserOpt userOptFrom = ClientController.findFabricSwitchByWwn(fromSw.getWwn()).getFabric().getSnmpUserOpt();
        ClientController.getInstance();
        final SnmpUserOpt userOptTo = ClientController.findFabricSwitchByWwn(toSw.getWwn()).getFabric().getSnmpUserOpt();
        AbstractWorker worker = new AbstractWorker(){

            @Override
            public Object construct() {
                try {
                    FAMoveWizard.this.isApplying = true;
                    progressPanel.setTotalProgressNum(1);
                    MoveTask task = new MoveTask(fromSw, sCfg, toSw, toCfg, FAMoveWizard.this.wwnStep.getVPWWN(), userOptFrom, userOptTo, progressPanel);
                    task.run();
                    while (!task.isEnded()) {
                        try {
                            Thread.sleep(300L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    progressPanel.updateProgress(1);
                }
                catch (Exception ex) {
                    if (FAMoveWizard.this.isCanceled) {
                        return true;
                    }
                    FAWizard.logger.warn((Object)"Got exception from applying settings.", (Throwable)ex);
                    return ex;
                }
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finished() {
                try {
                    FAMoveWizard.this.isApplying = false;
                    Object ret = this.getValue();
                    if (ret instanceof Exception) {
                        Util.errorMessage((Component)progressPanel.getParent(), (Exception)ret);
                        progressPanel.postError("\n\nAn error has occurred: " + ((Exception)ret).getMessage());
                    }
                }
                finally {
                    progressPanel.complete();
                    FAMoveWizard.this.sourceStep.actionFinished(true);
                }
            }
        };
        worker.start();
    }

    @Override
    public void setCancel(boolean b) {
        this.isCanceled = b;
    }

    @Override
    public boolean isRunningApply() {
        return this.isApplying;
    }

    @Override
    public void dispose() {
        if (this.progressWindow != null) {
            this.progressWindow.dispose();
        }
        super.dispose();
    }

    public SwitchBase getSourceSw() {
        return this.sourceStep.getSwitch();
    }

    public int getSourceIf() {
        FlexAtahCfg cfg = this.sourceStep.getSource();
        if (cfg == null) {
            return -1;
        }
        return this.sourceStep.getSource().getIfIndex();
    }

    public FlexAtahCfg getSource() {
        return this.sourceStep.getSource();
    }

    public void updateAskPanel() {
        this.wwnStep.updatePanel(this.sourceStep.getGlobalVPWWNList(), this.sourceStep.getInterfaceVPWWN());
    }
}

