/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.fa.wizard;

import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.sm.client.fa.FAClientHelper;
import com.cisco.dcbu.sm.client.fa.FAReplaceController;
import com.cisco.dcbu.sm.client.fa.wizard.FAMoveWizard;
import com.cisco.dcbu.sm.client.fa.wizard.ReplaceDestStep;
import com.cisco.dcbu.sm.common.dto.FlexAtahCfg;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import javax.swing.JOptionPane;

public class MoveDestStep
extends ReplaceDestStep {
    protected static final String BRIEF = "Please select a new port the server is moved to.  Please ensure that this port is not being used and in down oper mode.  To select a port, click on its corresponding row.";

    public MoveDestStep() {
        super(TITLE, BRIEF, FAMoveWizard.ICON);
    }

    @Override
    public boolean refresh() {
        SwitchBase selectedSw;
        this.setTitle("Step 3 of 4:  " + TITLE);
        if (this.controller == null) {
            this.controller = new FAReplaceController(this.swSelectCard, this.swSelectPanel, FAMoveWizard.getInstance().faCfgMap, 2);
            this.npvCombo.addItemListener(this.controller);
        }
        SwitchBase item = FAMoveWizard.getInstance().getSourceSw();
        boolean sameSw = FAMoveWizard.getInstance().isSameSwitch();
        this.npvCombo.removeAllItems();
        for (SwitchBase sw : FAMoveWizard.getInstance().faCfgMap.keySet()) {
            if (sameSw) {
                if (!sw.equals(item)) continue;
                this.npvCombo.addItem(sw);
                break;
            }
            if (sw.equals(item)) continue;
            this.npvCombo.addItem(sw);
        }
        if ((selectedSw = (SwitchBase)this.npvCombo.getSelectedItem()) != null && selectedSw.equals(FAMoveWizard.getInstance().getSourceSw())) {
            this.npvCombo.setSelectedItem(FAMoveWizard.getInstance().getSourceSw());
        }
        this.controller.removeFromTable(FAMoveWizard.getInstance().getSourceSw(), FAMoveWizard.getInstance().getSourceIf());
        if (FAMoveWizard.getInstance().isSameSwitch()) {
            this.npvCombo.setVisible(false);
            this.label.setVisible(false);
            this.label.setText("Selected switch: ");
        } else {
            this.npvCombo.setVisible(true);
            this.label.setVisible(true);
            this.label.setText("Select a switch: ");
        }
        return true;
    }

    @Override
    public void doNext() {
        if (!this.controller.stopCellEditing()) {
            return;
        }
        if (this.controller.hasSelection()) {
            int rc;
            FlexAtahCfg cfg = this.controller.getSelection();
            if (cfg == null) {
                throw new RuntimeException("Selection is null");
            }
            String admin = MibEnum.getLabel(FAClientHelper.adminStatEnums, cfg.getOperStatus());
            if ("up".equalsIgnoreCase(admin) && (rc = JOptionPane.showConfirmDialog(this.getParent(), "This port is being used.  Are you sure you want to move server to this port?", "Flex Attach:  Move Server - " + TITLE, 0, 2)) == 1) {
                return;
            }
        }
        super.doNext();
    }
}

