/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.fc;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.renderers.AAASvrIndexRenderer;
import com.cisco.dcbu.lib.mds.renderers.CallHomeEmailIndexRenderer;
import com.cisco.dcbu.lib.mds.renderers.DomainIfIndexRenderer;
import com.cisco.dcbu.lib.mds.renderers.IpFilterIfIndexRenderer;
import com.cisco.dcbu.lib.mds.renderers.PortIndexRenderer;
import com.cisco.dcbu.lib.mds.renderers.UserNameIndexRenderer;
import com.cisco.dcbu.lib.mds.renderers.VrrpIfIpIndexRenderer;
import com.cisco.dcbu.lib.mds.renderers.VsanIndexRenderer;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.fc.AbstractFabricCheck;
import com.cisco.dcbu.sm.client.fc.CheckData;
import com.cisco.dcbu.sm.client.fc.FabricCheckAAATable;
import com.cisco.dcbu.sm.client.fc.FabricCheckCallHome;
import com.cisco.dcbu.sm.client.fc.FabricCheckCallHomeDestTable;
import com.cisco.dcbu.sm.client.fc.FabricCheckDMTable;
import com.cisco.dcbu.sm.client.fc.FabricCheckEventTargets;
import com.cisco.dcbu.sm.client.fc.FabricCheckFcipIsl;
import com.cisco.dcbu.sm.client.fc.FabricCheckFeature;
import com.cisco.dcbu.sm.client.fc.FabricCheckFspfIfTable;
import com.cisco.dcbu.sm.client.fc.FabricCheckIPFCTable;
import com.cisco.dcbu.sm.client.fc.FabricCheckIslTable;
import com.cisco.dcbu.sm.client.fc.FabricCheckNonResolvableTable;
import com.cisco.dcbu.sm.client.fc.FabricCheckNtp;
import com.cisco.dcbu.sm.client.fc.FabricCheckPChannel;
import com.cisco.dcbu.sm.client.fc.FabricCheckScalarEvents;
import com.cisco.dcbu.sm.client.fc.FabricCheckScalars;
import com.cisco.dcbu.sm.client.fc.FabricCheckSysLog;
import com.cisco.dcbu.sm.client.fc.FabricCheckSysLogServerTable;
import com.cisco.dcbu.sm.client.fc.FabricCheckTable;
import com.cisco.dcbu.sm.client.fc.FabricCheckUsersTable;
import com.cisco.dcbu.sm.client.fc.FabricCheckVersion;
import com.cisco.dcbu.sm.client.fc.FabricCheckVsanTable;
import com.cisco.dcbu.sm.client.fc.FabricCheckZonePolicyTable;
import com.cisco.dcbu.sm.client.model.Switch;
import org.w3c.dom.Node;

class CheckMethods {
    CheckMethods() {
    }

    static void VSAN(SnmpPeer peer, boolean[] checks, Array peers, Array data, Node pout, String category) throws SnmpException {
        String[] _VsanAttrs = new String[]{"vsanLoadBalancingType", "vsanName", "vsanAdminState", "vsanInterOperValue", "vsanInterOperMode"};
        CheckData _VsanChkAttrs = new CheckData(_VsanAttrs, null);
        FabricCheckVsanTable ct = new FabricCheckVsanTable();
        ct._checkMismatch = checks[0];
        ct._checkMissing = checks[1];
        ct._checkExtra = checks[2];
        CheckMethods.takeAction(peer, peers, data, pout, category, _VsanChkAttrs, ct, "vsanRowStatus");
    }

    static void FSPF(SnmpPeer peer, boolean[] checks, Array peers, Array data, Node pout, String category) throws SnmpException {
        String[] _FspfAttrs = new String[]{"fspfAdminStatus", "fspfRegionId", "fspfSpfHoldTime"};
        CheckData _FspfChkAttrs = new CheckData(_FspfAttrs, null);
        FabricCheckTable ct = new FabricCheckTable();
        ct._checkMismatch = checks[0];
        ct._checkMissing = checks[1];
        ct._checkExtra = checks[2];
        CheckMethods.takeAction(peer, peers, data, pout, category, _FspfChkAttrs, ct, "fspfRowStatus");
        String[] _FspfIfAttrs = new String[]{"fspfIfDeadInterval", "fspfIfHelloInterval", "fspfIfRetransmitInterval"};
        CheckData _FspfIfChkAttrs = new CheckData(_FspfIfAttrs, new DomainIfIndexRenderer());
        FabricCheckFspfIfTable cft = new FabricCheckFspfIfTable();
        cft._checkMismatch = checks[0];
        cft._checkExtra = false;
        cft._checkMissing = false;
        if (null != data && cft._checkMismatch) {
            CheckMethods.takeAction(peer, peers, data, pout, category + "Interface", _FspfIfChkAttrs, cft, null);
        }
    }

    static void ISL(SnmpPeer peer, boolean[] checks, Array peers, Array data, Node pout, String category) throws SnmpException {
        String[] _IslAttrs = new String[]{"fcIfAllowedVsanList2k", "fcIfAllowedVsanList4k"};
        CheckData _IslChkAttrs = new CheckData(_IslAttrs, null);
        FabricCheckIslTable ct = new FabricCheckIslTable();
        ct._checkMismatch = checks[0];
        ct._checkExtra = false;
        ct._checkMissing = false;
        if (null != data && ct._checkMismatch) {
            ct.doIt(peer, peers, category, _IslChkAttrs, data, null, pout);
        }
    }

    static void IPFC(SnmpPeer peer, boolean[] checks, Array peers, Array data, Node pout, String category) throws SnmpException {
        String[] _ipfcAttrs = new String[]{"ciiIPIfAddressPrefixLength"};
        CheckData _ipfcChkAttrs = new CheckData(_ipfcAttrs, null);
        FabricCheckIPFCTable ct = new FabricCheckIPFCTable();
        ct._checkMismatch = checks[0];
        ct._checkMissing = checks[1];
        ct._checkExtra = checks[2];
        if (null != data && ct._checkMismatch) {
            CheckMethods.takeAction(peer, peers, data, pout, category, _ipfcChkAttrs, ct, "ciiIPIfAddressStatus");
        }
    }

    static void Domain_Manager(SnmpPeer peer, boolean[] checks, Array peers, Array data, Node pout, String category) throws SnmpException {
        String[] _dmAttrs = new String[]{"dmConfigDomainId", "dmConfigDomainIdType", "dmEnable", "dmContiguousAllocation", "dmFcIdPersistency", "dmDomainId"};
        CheckData _dmChkAttrs = new CheckData(_dmAttrs, null);
        FabricCheckDMTable ct = new FabricCheckDMTable();
        ct._checkMismatch = checks[0];
        ct._checkMissing = checks[1];
        ct._checkExtra = checks[2];
        CheckMethods.takeAction(peer, peers, data, pout, category, _dmChkAttrs, ct, null);
    }

    static void NameServer_Proxy(SnmpPeer peer, boolean[] checks, Array peers, Array data, Node pout, String category) throws SnmpException {
        String[] _nsAttrs = new String[]{"fcNameServerProxyPortName"};
        CheckData _nsChkAttrs = new CheckData(_nsAttrs, null);
        FabricCheckTable ct = new FabricCheckTable();
        ct._checkMismatch = checks[0];
        ct._checkMissing = checks[1];
        ct._checkExtra = checks[2];
        CheckMethods.takeAction(peer, peers, data, pout, category, _nsChkAttrs, ct, null);
    }

    static void Zone_Policies(SnmpPeer peer, boolean[] checks, Array peers, Array data, Node pout, String category) throws SnmpException {
        String[] _zoneAttrs = new String[]{"zoneDefaultZoneBehaviour", "zoneSetPropagationMode", "zoneDefaultZoneReadOnly"};
        CheckData _zoneChkAttrs = new CheckData(_zoneAttrs, null);
        FabricCheckZonePolicyTable ct = new FabricCheckZonePolicyTable();
        ct._checkMismatch = checks[0];
        ct._checkMissing = checks[1];
        ct._checkExtra = checks[2];
        CheckMethods.takeAction(peer, peers, data, pout, category, _zoneChkAttrs, ct, null);
    }

    static void CallHome(SnmpPeer peer, boolean[] checks, Array peers, Array data, Node pout, String category) throws SnmpException {
        String[] _chDestProfileAttrs = new String[]{"callHomeDestProfileMaxMsgSize"};
        CallHomeEmailIndexRenderer renderer = new CallHomeEmailIndexRenderer();
        CheckData _chChkDestProfileAttrs = new CheckData(_chDestProfileAttrs, renderer);
        FabricCheckTable ct = new FabricCheckTable();
        ct._checkMismatch = checks[0];
        ct._checkMissing = checks[1];
        ct._checkExtra = checks[2];
        CheckMethods.takeAction(peer, peers, data, pout, category + "Profile", _chChkDestProfileAttrs, ct, null);
        String[] _chEmailAttrs = new String[]{"callHomeDestEmailAddress"};
        CheckData _chChkEmailAttrs = new CheckData(_chEmailAttrs, renderer);
        FabricCheckCallHomeDestTable ct2 = new FabricCheckCallHomeDestTable();
        ct2._checkMismatch = checks[0];
        ct2._checkMissing = checks[1];
        ct2._checkExtra = checks[2];
        CheckMethods.takeAction(peer, peers, data, pout, category + "DestEmail", _chChkEmailAttrs, ct2, "callHomeDestEmailAddressStatus");
        String[] _chSysAttrs = new String[]{"sysContact", "sysContactEmailAddress", "sysContactPhoneNumber", "sysStreetAddress", "callHomeContractId", "callHomeCustomerId", "callHomeDeviceServicePriority", "callHomeEmailFrom", "callHomeEmailReplyTo", "callHomeEnable", "callHomeSiteId", "callHomeSmtpServerAddr", "callHomeSmtpServerAddrType", "callHomeSmtpServerPort"};
        CheckData _chSysChkAttrs = new CheckData(_chSysAttrs, null);
        FabricCheckCallHome cs = new FabricCheckCallHome();
        CheckMethods.takeAction(peer, peers, data, pout, category + "Other", _chSysChkAttrs, cs, null);
    }

    static void Syslog(SnmpPeer peer, boolean[] checks, Array peers, Array data, Node pout, String category) throws SnmpException {
        String[] _SyslogAttrs = new String[]{"cseSyslogConsoleEnable", "cseSyslogConsoleMsgSeverity", "cseSyslogTerminalEnable", "cseSyslogTerminalMsgSeverity", "cseSyslogLinecardEnable", "cseSyslogLinecardMsgSeverity"};
        CheckData _SyslogChkAttrs = new CheckData(_SyslogAttrs, null);
        FabricCheckSysLog cs = new FabricCheckSysLog();
        cs._checkMismatch = checks[0];
        CheckMethods.takeAction(peer, peers, data, pout, category, _SyslogChkAttrs, cs, null);
        String[] _syslogServers = new String[]{"cseSyslogServerAddressType", "cseSyslogServerAddress", "cseSyslogServerMsgSeverity", "cseSyslogServerFacility"};
        CheckData _syslogChkServers = new CheckData(_syslogServers, null);
        FabricCheckSysLogServerTable ct = new FabricCheckSysLogServerTable();
        ct._checkMismatch = checks[0];
        CheckMethods.takeAction(peer, peers, data, pout, category + "Servers", _syslogChkServers, ct, "cseSyslogServerStatus");
        String[] _syslogSeverity = new String[]{"cseSyslogMessageSeverity"};
        CheckData _syslogChkSeverity = new CheckData(_syslogSeverity, null);
        FabricCheckTable ct2 = new FabricCheckTable();
        ct2._checkMismatch = checks[0];
        ct._checkExtra = false;
        ct2._checkMissing = false;
        CheckMethods.takeAction(peer, peers, data, pout, category + "Severity", _syslogChkSeverity, ct2, null);
    }

    static void Radius(SnmpPeer peer, boolean[] checks, Array peers, Array data, Node pout, String category) throws SnmpException {
        String[] _radiusAttrs = new String[]{"crRadiusRetransmits", "crRadiusTimeout"};
        CheckData _radiusChkAttrs = new CheckData(_radiusAttrs, null);
        FabricCheckScalars cs = new FabricCheckScalars();
        cs._checkMismatch = checks[0];
        CheckMethods.takeAction(peer, peers, data, pout, category, _radiusChkAttrs, cs, null);
        String[] _radiusServers = new String[]{"crRadiusServerAddr", "crRadiusServerAuthPort", "crRadiusServerAcctPort", "crRadiusServerKey", "crRadiusServerType", "crRadiusServerMode"};
        CheckData _radiusChkServers = new CheckData(_radiusServers, null);
        FabricCheckNonResolvableTable ct = new FabricCheckNonResolvableTable();
        ct._checkMismatch = checks[0];
        ct._checkMissing = checks[1];
        ct._checkExtra = checks[2];
        CheckMethods.takeAction(peer, peers, data, pout, category + "Servers", _radiusChkServers, ct, "crRadiusServerRowStatus");
    }

    static void AAA(SnmpPeer peer, boolean[] checks, Array peers, Array data, Node pout, String category) throws SnmpException {
        String[] _aaaServers = new String[]{"cAAAServerAddr", "casAuthenPort", "casAcctPort", "cAAAServerKeyEncrType", "cAAAServerDeadTime", "cAAAServerTimeOut", "cAAAServerRetransmits"};
        CheckData _aaaChkServers = new CheckData(_aaaServers, new AAASvrIndexRenderer());
        if (!FabricCheckAAATable.isAAASupported(peer)) {
            return;
        }
        FabricCheckAAATable ct = new FabricCheckAAATable();
        Array peers13 = ct.getAAASupportingPeers(peers);
        if (peers13.size() == 0) {
            return;
        }
        ct._checkMismatch = checks[0];
        ct._checkMissing = checks[1];
        ct._checkExtra = checks[2];
        CheckMethods.takeAction(peer, peers13, data, pout, category + "Servers", _aaaChkServers, ct, "casConfigRowStatus");
    }

    static void Snmp_User(SnmpPeer peer, boolean[] checks, Array peers, Array data, Node pout, String category) throws SnmpException {
        String[] _userAttrs = new String[]{"ccmCommonUserSNMPAuthProtocol"};
        CheckData _userChkAttrs = new CheckData(_userAttrs, new UserNameIndexRenderer());
        FabricCheckUsersTable cut = new FabricCheckUsersTable();
        cut._checkMismatch = checks[0];
        cut._checkMissing = checks[1];
        cut._checkExtra = checks[2];
        CheckMethods.takeAction(peer, peers, data, pout, category, _userChkAttrs, cut, null);
    }

    static void VRRP(SnmpPeer peer, boolean[] checks, Array peers, Array data, Node pout, String category) throws SnmpException {
        String[] _vrrpAttr = new String[]{"vrrpOperAdminState", "vrrpOperAuthType", "vrrpOperPriority", "vrrpOperAdvertisementInterval", "vrrpOperPreemptMode"};
        CheckData _vrrpChkAttr = new CheckData(_vrrpAttr, new PortIndexRenderer());
        FabricCheckNonResolvableTable ct = new FabricCheckNonResolvableTable();
        ct._checkMismatch = checks[0];
        ct._checkMissing = checks[1];
        ct._checkExtra = checks[2];
        CheckMethods.takeAction(peer, peers, data, pout, category, _vrrpChkAttr, ct, null);
        String[] _vrrpAddttr1 = new String[]{"vrrpAssoIpAddrRowStatus"};
        CheckData _vrrpChkAddttr1 = new CheckData(_vrrpAddttr1, new VrrpIfIpIndexRenderer());
        ct = new FabricCheckNonResolvableTable();
        ct._checkMismatch = checks[0];
        ct._checkMissing = checks[1];
        ct._checkExtra = checks[2];
        CheckMethods.takeAction(peer, peers, data, pout, category + "Address", _vrrpChkAddttr1, ct, null);
    }

    static void Snmp_Events(SnmpPeer peer, boolean[] checks, Array peers, Array data, Node pout, String category) throws SnmpException {
        String[] _snmpAttrs = new String[]{"nlmConfigGlobalEntryLimit", "nlmConfigGlobalAgeOut", "rmonAlarmEnable", "rmonMaxAlarms", "zoneDefZoneBehvrChngNotifyEnable", "zoneMergeFailureNotifyEnable", "zoneMergeSuccessNotifyEnable", "zoneServiceReqRejNotifyEnable", "zoneDefZoneBehvrChngNotifyEnable", "fspfNbrStateChangeNotifyEnable", "dmReConfFabricChangeNotifyEnable", "fcsReqRejNotifyEnable", "rscnIlsRejectReqNotifyEnable", "rscnElsRejectReqNotifyEnable", "cefcMIBEnableStatusNotification", "snmpEnableAuthenTraps", "vrrpNotificationCntl"};
        CheckData _snmpChkAttrs = new CheckData(_snmpAttrs, null);
        FabricCheckScalarEvents cs = new FabricCheckScalarEvents();
        cs._checkMismatch = checks[0];
        Array nonNpvPeers = CheckMethods.getNonNPVPeers(peers);
        if (nonNpvPeers.size() > 0 && !CheckMethods.isNPVPeer(peer)) {
            CheckMethods.takeAction(peer, nonNpvPeers, data, pout, category, _snmpChkAttrs, cs, null);
        }
        String[] _targetAdd = new String[]{"snmpTargetAddrTAddress"};
        CheckData _targetChkAdd = new CheckData(_targetAdd, new VrrpIfIpIndexRenderer());
        FabricCheckEventTargets ct = new FabricCheckEventTargets();
        ct._checkMismatch = checks[0];
        if (ct._checkMismatch) {
            CheckMethods.takeAction(peer, peers, data, pout, "SNMP_Targets", _targetChkAdd, ct, null);
        }
    }

    static void Timers_Policies(SnmpPeer peer, boolean[] checks, Array peers, Array data, Node pout, String category) throws SnmpException {
        String[] _timerAttrs = new String[]{"fcTimerEdtov", "fcTimerRatov", "fcTimerDstov", "fcNetworkDropLatency", "fcInorderDelivery", "adminTrunkProtocol"};
        CheckData _timerChkAttrs = new CheckData(_timerAttrs, null);
        FabricCheckScalars cs = new FabricCheckScalars();
        cs._checkMismatch = checks[0];
        Array nonNpvPeers = CheckMethods.getNonNPVPeers(peers);
        if (nonNpvPeers.size() > 0 && !CheckMethods.isNPVPeer(peer)) {
            CheckMethods.takeAction(peer, nonNpvPeers, data, pout, category, _timerChkAttrs, cs, null);
        }
    }

    static void Port_Channels(SnmpPeer peer, boolean[] checks, Array peers, Array data, Node pout, String category) throws SnmpException {
        String[] _timerAttrs = new String[]{"portChannelMemberList"};
        CheckData _timerChkAttrs = new CheckData(_timerAttrs, null);
        FabricCheckPChannel cs = new FabricCheckPChannel();
        cs._checkMismatch = checks[0];
        CheckMethods.takeAction(peer, peers, data, pout, category, _timerChkAttrs, cs, null);
    }

    static void FCIP(SnmpPeer peer, boolean[] checks, Array peers, Array data, Node pout, String category) throws SnmpException {
        String[] _attrs = new String[]{"cfmFcipLinkExtPassiveMode"};
        CheckData _chkAttrs = new CheckData(_attrs, null);
        FabricCheckFcipIsl cs = new FabricCheckFcipIsl();
        cs._checkMismatch = checks[0];
        if (null != data && cs._checkMismatch) {
            CheckMethods.takeAction(peer, peers, data, pout, category, _chkAttrs, cs, null);
        }
    }

    static void Version(SnmpPeer peer, boolean[] checks, Array peers, Array data, Node pout, String category) throws SnmpException {
        FabricCheckVersion cs = new FabricCheckVersion();
        cs._checkMismatch = checks[0];
        if (null != data && cs._checkMismatch) {
            CheckMethods.takeAction(peer, peers, data, pout, category, null, cs, null);
        }
    }

    static void Port_Security(SnmpPeer peer, boolean[] checks, Array peers, Array data, Node pout, String category) throws SnmpException {
        String[] _psAttrs = new String[]{"cpsmPortBindAutoLearnEnable"};
        CheckData _psmChkAttrs = new CheckData(_psAttrs, new VsanIndexRenderer());
        FabricCheckTable cs = new FabricCheckTable();
        cs._checkMismatch = checks[0];
        cs._checkExtra = false;
        cs._checkMissing = false;
        if (null != data && cs._checkMismatch) {
            CheckMethods.takeAction(peer, peers, data, pout, category, _psmChkAttrs, cs, null);
        }
    }

    static void NTP_Server(SnmpPeer peer, boolean[] checks, Array peers, Array data, Node pout, String category) throws SnmpException {
        String[] _ntpAttrs = new String[]{"cntpPeersPeerAddress", "cntpPeersMode", "cntpPeersPrefPeer"};
        CheckData _ntpChkAttrs = new CheckData(_ntpAttrs, null);
        FabricCheckNtp cs = new FabricCheckNtp();
        cs._checkMismatch = checks[0];
        cs._checkMissing = checks[1];
        cs._checkExtra = checks[2];
        CheckMethods.takeAction(peer, peers, data, pout, category, _ntpChkAttrs, cs, null);
    }

    static void IP_Filter(SnmpPeer peer, boolean[] checks, Array peers, Array data, Node pout, String category) throws SnmpException {
        String[] _ipAclAttrs = new String[]{"cippfIfIpProfileName"};
        ClientController.getInstance();
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        if (sw == null || sw.isN7K()) {
            DefaultLogger._DumpLogger.info((Object)("Skipping N7K for IP_FILTER test " + sw));
            return;
        }
        Array peersNonN7K = CheckMethods.getNonN7KPeers(peers);
        if (peersNonN7K.size() == 0) {
            return;
        }
        CheckData _ipAclChkAttrs = new CheckData(_ipAclAttrs, new IpFilterIfIndexRenderer());
        FabricCheckNonResolvableTable cs = new FabricCheckNonResolvableTable();
        cs._checkMismatch = checks[0];
        cs._checkMissing = checks[1];
        cs._checkExtra = checks[2];
        CheckMethods.takeAction(peer, peersNonN7K, data, pout, category, _ipAclChkAttrs, cs, null);
    }

    static void Feature(SnmpPeer peer, boolean[] checks, Array peers, Array data, Node pout, String category) throws SnmpException {
        String[] _featureAtt = new String[]{"cfcFeatureCtrlOpStatus"};
        ClientController.getInstance();
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        if (sw == null || !sw.isVersionGreaterThanEqual("1.3(0)")) {
            return;
        }
        Array peers13 = CheckMethods.getRel13Peers(peers);
        if (peers13.size() == 0) {
            return;
        }
        CheckData _featureChkAttrs = new CheckData(_featureAtt, null);
        FabricCheckFeature cs = new FabricCheckFeature();
        cs._checkMismatch = checks[0];
        cs._checkExtra = checks[2];
        cs._checkMissing = checks[1];
        CheckMethods.takeAction(peer, peers13, data, pout, category, _featureChkAttrs, cs, null);
    }

    static Array getRel13Peers(Array peers) {
        Array<SnmpPeer> peers13 = new Array<SnmpPeer>();
        for (int i = 0; i < peers.size(); ++i) {
            SnmpPeer peer = (SnmpPeer)peers.elementAt(i);
            ClientController.getInstance();
            Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
            if (sw != null && sw.isVersionGreaterThanEqual("1.3(0)")) {
                peers13.addElement(peer);
                continue;
            }
            if (sw == null) continue;
            DefaultLogger._DumpLogger.info((Object)("Skipping switches with version lower than 1.3 " + sw));
        }
        return peers13;
    }

    static Array getNonN7KPeers(Array peers) {
        Array<SnmpPeer> peers13 = new Array<SnmpPeer>();
        for (int i = 0; i < peers.size(); ++i) {
            SnmpPeer peer = (SnmpPeer)peers.elementAt(i);
            ClientController.getInstance();
            Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
            if (sw != null && !sw.isN7K()) {
                peers13.addElement(peer);
                continue;
            }
            if (sw == null) continue;
            DefaultLogger._DumpLogger.info((Object)("Skipping N7K switch " + sw));
        }
        return peers13;
    }

    static Array getNonNPVPeers(Array peers) {
        Array<SnmpPeer> peers13 = new Array<SnmpPeer>();
        for (int i = 0; i < peers.size(); ++i) {
            SnmpPeer peer = (SnmpPeer)peers.elementAt(i);
            ClientController.getInstance();
            Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
            if (sw != null && !sw.isNpvEnabled()) {
                peers13.addElement(peer);
                continue;
            }
            if (sw == null) continue;
            DefaultLogger._DumpLogger.info((Object)("Skipping NPV Switch " + sw));
        }
        return peers13;
    }

    static boolean isNPVPeer(SnmpPeer peer) {
        if (peer != null) {
            ClientController.getInstance();
            Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
            return sw != null && sw.isNpvEnabled();
        }
        return false;
    }

    static void takeAction(SnmpPeer peer, Array peers, Array data, Node pout, String category, CheckData attr, AbstractFabricCheck tbl, String rowAddRm) throws SnmpException {
        if (null != pout && null == data) {
            tbl.addToFile(peer, category, attr, pout);
        }
        if (null != data) {
            tbl.doIt(peer, peers, category, attr, data, rowAddRm, pout);
        }
    }
}

