/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.fc;

import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.fc.FabricCheckScalars;
import com.cisco.dcbu.sm.client.fc.ResolveData;

class FabricCheckCallHome
extends FabricCheckScalars {
    FabricCheckCallHome() {
    }

    @Override
    protected void compare(SnmpPeer peer, String name, Array source, Array target) {
        if (source == null || target == null) {
            return;
        }
        for (int i = 0; i < source.size(); ++i) {
            SnmpVarBind svb = (SnmpVarBind)source.elementAt(i);
            SnmpVarBind tvb = (SnmpVarBind)target.elementAt(i);
            if (svb == null || tvb == null || this.equals(svb.getVar(), tvb.getVar())) continue;
            Array<SnmpVarBind> varbinds = new Array<SnmpVarBind>();
            varbinds.addElement(svb);
            boolean resolvable = true;
            String varNm = this.getVarName(tvb, this._enums[i]);
            if (svb.getVar().getType() == 5) {
                resolvable = false;
            } else if (svb.getVar().getType() == 4) {
                SnmpString sval = (SnmpString)svb.getVar();
                if (sval.getValue() == null || sval.getValue().length == 0) {
                    resolvable = false;
                }
                if (varNm.startsWith("callHomeSmtpServerAddr")) {
                    varbinds.insertElementAt((SnmpVarBind)source.elementAt(++i), 0);
                    SnmpVarBind vbndType = (SnmpVarBind)target.elementAt(i);
                    int addType = ((SnmpInt)vbndType.getVar()).getValue();
                    SnmpVarBind srcVbndType = (SnmpVarBind)source.elementAt(i);
                    int srcAddType = ((SnmpInt)srcVbndType.getVar()).getValue();
                    boolean bl = resolvable = (srcAddType == 1 || srcAddType == 2 || srcAddType == 16) && resolvable;
                    if (addType == 16) {
                        StringBuffer buf = new StringBuffer("Mismatch callHomeSmtpServerAddr.0=");
                        buf.append(tvb.getVar());
                        this.addData(peer, resolvable, name, buf.toString(), new ResolveData(varbinds, this._rndr));
                        continue;
                    }
                }
            }
            this.addData(peer, resolvable, name, "Mismatch " + varNm, new ResolveData(varbinds, this._rndr));
        }
    }
}

