/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.fc;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.fc.CheckData;
import com.cisco.dcbu.sm.client.fc.FabricCheckIslBase;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.model.San;
import com.cisco.dcbu.sm.client.model.Switch;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Node;

class FabricCheckFcipIsl
extends FabricCheckIslBase {
    int _numProfileReqs = 0;
    HashMap _peerToProfileInfo = new HashMap();
    HashMap _peerToTnlList = new HashMap();
    Array _peerArr = new Array();
    String[] _attrs;
    final String[] _attrsProfile = new String[]{"cfmFcipEntitySACKOption", "cfmFcipEntityExtTcpKeepAliveTO", "cfmFcipEntityExtTcpMinRTO", "cfmFcipEntityExtTcpMaxReTx", "cfmFcipEntityExtPMTUEnable", "cfmFcipEntityExtPMTUResetTO"};

    public FabricCheckFcipIsl() {
        this._ignoreIsls = true;
    }

    @Override
    protected void doIt(SnmpPeer peer, Array peers, String category, CheckData chkAttrs, Array data, String rowAddRm, Node rtNd) throws SnmpException {
        this._attrs = chkAttrs._attrs;
        super.doIt(peer, peers, category, chkAttrs, data, rowAddRm, rtNd);
    }

    @Override
    protected void filterSelIsllist() throws SnmpException {
        Array<Isl> filteredIsl = new Array<Isl>();
        int maxi = this._islLnks.size();
        for (int i = 0; i < maxi; ++i) {
            Isl isl = (Isl)this._islLnks.elementAt(i);
            if (!isl.isFCIP() && !isl.isFcipPortChannel()) continue;
            filteredIsl.addElement(isl);
        }
        this._islLnks = filteredIsl;
    }

    @Override
    protected boolean waitAllowed() {
        return false;
    }

    @Override
    protected void populateDiscrepancyTable(Array islLnks) {
        if (this._peerArr.size() > 0) {
            this.buildTunnelList();
            this.findUnusedProfiles();
            this.testIsls();
        }
    }

    @Override
    protected void checkDiscrepancy(Array toData, int toIndex, Array fromData, int fromIndex, SnmpPeer toPeer, SnmpPeer fromPeer) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void getData(String[] attrs) throws SnmpException {
        block14: {
            block13: {
                int i;
                VarBindList requestProf = this.buildRequest(this._attrsProfile);
                this._peerToProfileInfo.clear();
                SnmpPeer[] peers = San.getInstance().getSnmpPeers();
                this._peerArr.clear();
                for (i = 0; i < peers.length; ++i) {
                    Switch sw = ClientController.findFabricSwitchByIpAddress(peers[i].getAddress());
                    if (null == sw || !sw.hasIPSCard()) continue;
                    this._peerArr.addElement(peers[i]);
                }
                this._numProfileReqs = this._peerArr.size();
                this._numReqs = 0;
                int maxi = this._peerArr.size();
                for (i = 0; i < maxi; ++i) {
                    new SnmpFetch().getBulk((SnmpPeer)this._peerArr.elementAt(i), requestProf, (SnmpCallbackIf)this);
                }
                try {
                    if (this._peerArr.size() <= 0) break block13;
                    Array i2 = this._data;
                    synchronized (i2) {
                        this._data.wait(24000L);
                    }
                }
                catch (Exception ex) {
                    DefaultLogger._DefLogger.error((Object)"Wait broken");
                }
            }
            this._numProfileReqs = 0;
            this._numReqs = this._peerArr.size();
            VarBindList request = this.buildRequest(this._attrs);
            int maxi = this._peerArr.size();
            for (int i = 0; i < maxi; ++i) {
                new SnmpFetch().getBulk((SnmpPeer)this._peerArr.elementAt(i), request, (SnmpCallbackIf)this);
            }
            try {
                if (this._peerArr.size() <= 0) break block14;
                Array i = this._data;
                synchronized (i) {
                    this._data.wait(24000L);
                }
            }
            catch (Exception ex) {
                DefaultLogger._DefLogger.error((Object)"Wait broken");
            }
        }
    }

    @Override
    public int getModIndex(int index) {
        return index & 0xFFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        if (this._numReqs > 0) {
            super.callback(session, reqid, pdu, timedOut);
        } else {
            Object vbLst;
            --this._numProfileReqs;
            SnmpPeer peer = ClientController.findFabricSwitchByIpAddress(pdu.getAddress()).getPeer();
            if (this.handleErrorCallBack(peer, pdu, timedOut) && ((VarBindList)(vbLst = pdu.getVariables())).size() > 0) {
                this._peerToProfileInfo.put(peer, vbLst);
            }
            if (this._numProfileReqs <= 0) {
                try {
                    vbLst = this._data;
                    synchronized (vbLst) {
                        this._data.notify();
                    }
                }
                catch (Exception ex) {
                    DefaultLogger._DefLogger.error((Object)("callback notify failed: " + ex));
                }
            }
        }
    }

    void buildTunnelList() {
        this._peerToTnlList.clear();
        for (Map.Entry obEntry : this._peerToSnmpInfo.entrySet()) {
            SnmpPeer obHmKey = (SnmpPeer)obEntry.getKey();
            Array tnlVbndArr = (Array)obEntry.getValue();
            Array<Tunnel> tnlList = new Array<Tunnel>(tnlVbndArr.size());
            int maxi = tnlVbndArr.size();
            for (int i = 0; i < maxi; i += this._enums.length) {
                Tunnel tnl = new Tunnel();
                SnmpVarBind vbnd = (SnmpVarBind)tnlVbndArr.elementAt(i);
                int[] oid = vbnd.getOid().getValue();
                tnl._index = oid[oid.length - 1];
                vbnd = (SnmpVarBind)tnlVbndArr.elementAt(i);
                tnl._passiveMode = ((SnmpInt)vbnd.getVar()).getValue();
                tnl._localProfile = this.getProfile(oid[oid.length - 2], obHmKey);
                tnlList.addElement(tnl);
            }
            this._peerToTnlList.put(obHmKey, tnlList);
        }
    }

    Profile getProfile(int prfId, SnmpPeer peer) {
        for (Map.Entry obEntry : this._peerToProfileInfo.entrySet()) {
            SnmpPeer obHmKey = (SnmpPeer)obEntry.getKey();
            if (!peer.getAddress().equals(obHmKey.getAddress())) continue;
            VarBindList prfVbndArr = (VarBindList)obEntry.getValue();
            int maxi = prfVbndArr.size();
            for (int i = 0; i < maxi; i += this._attrsProfile.length) {
                Profile prf = new Profile();
                SnmpVarBind vbnd = prfVbndArr.get(i);
                int[] oid = vbnd.getOid().getValue();
                int prfIndex = oid[oid.length - 1];
                if (prfIndex != prfId) continue;
                prf._index = prfIndex;
                prf._sackOption = prfVbndArr.intValue(i);
                prf._tcpKeepAliveTo = prfVbndArr.intValue(i + 1);
                prf._tcpMinRTO = prfVbndArr.intValue(i + 2);
                prf._tcpMaxReTx = prfVbndArr.intValue(i + 3);
                prf._pMTUEnable = prfVbndArr.intValue(i + 4);
                prf._pMTUResetTO = prfVbndArr.intValue(i + 5);
                return prf;
            }
        }
        return null;
    }

    void findUnusedProfiles() {
        for (Map.Entry obEntry : this._peerToProfileInfo.entrySet()) {
            SnmpPeer obHmKey = (SnmpPeer)obEntry.getKey();
            VarBindList prfVbndArr = (VarBindList)obEntry.getValue();
            Object obTnlList = this._peerToTnlList.get(obHmKey);
            if (null == obTnlList) continue;
            Array<Integer> unusedProfile = new Array<Integer>();
            Array tnlList = (Array)obTnlList;
            int maxi = prfVbndArr.size();
            for (int i = 0; i < maxi; i += this._attrsProfile.length) {
                SnmpVarBind vbnd = prfVbndArr.get(i);
                int[] oid = vbnd.getOid().getValue();
                int prfIndex = oid[oid.length - 1];
                boolean emptyPrf = true;
                int maxj = tnlList.size();
                for (int j = 0; j < maxj; ++j) {
                    Tunnel tnl = (Tunnel)tnlList.elementAt(j);
                    if (null == tnl._localProfile || null == tnl._localProfile || tnl._localProfile._index != prfIndex) continue;
                    emptyPrf = false;
                    break;
                }
                if (!emptyPrf) continue;
                unusedProfile.addElement(new Integer(prfIndex));
            }
            if (unusedProfile.size() <= 0) continue;
            StringBuffer buf = new StringBuffer("No tunnels for profiles: ");
            int maxk = unusedProfile.size();
            for (int k = 0; k < maxk; ++k) {
                if (k > 0) {
                    buf.append(", ");
                }
                buf.append(unusedProfile.elementAt(k));
            }
            this.addData(obHmKey, false, this._attrName, buf.toString(), null);
        }
    }

    void testIsls() {
        int MAXL = this._islLnks.size();
        for (int il = 0; il < MAXL; ++il) {
            Tunnel tnl;
            int j;
            int maxj;
            Isl lk = (Isl)this._islLnks.elementAt(il);
            Switch swA = lk.getSwitch1();
            Switch swB = lk.getSwitch2();
            int toTnlIndex = this.getModIndex(lk.getIfIndex1());
            int fromTnlIndex = this.getModIndex(lk.getIfIndex2());
            Tunnel toTnl = null;
            Tunnel fromTnl = null;
            Array tnlList = (Array)this._peerToTnlList.get(swA.getPeer());
            if (tnlList != null) {
                maxj = tnlList.size();
                for (j = 0; j < maxj; ++j) {
                    tnl = (Tunnel)tnlList.elementAt(j);
                    if (toTnlIndex != tnl._index) continue;
                    toTnl = tnl;
                    break;
                }
            }
            if ((tnlList = (Array)this._peerToTnlList.get(swB.getPeer())) != null) {
                maxj = tnlList.size();
                for (j = 0; j < maxj; ++j) {
                    tnl = (Tunnel)tnlList.elementAt(j);
                    if (fromTnlIndex != tnl._index) continue;
                    fromTnl = tnl;
                    break;
                }
            }
            if (null == toTnl || null == fromTnl) continue;
            StringBuffer buf = new StringBuffer("Mismatch:");
            buf.append(swA.ifIndexToName(lk.getIfIndex1()));
            buf.append("<->");
            buf.append(swB);
            buf.append(" ");
            buf.append(swB.ifIndexToName(lk.getIfIndex2()));
            buf.append(" ");
            StringBuffer buff = new StringBuffer();
            this.addTestData(buff, new Long(toTnl._checkTimestamp), new Long(fromTnl._checkTimestamp), "timeStamp");
            this.addTestData(buff, new Long(toTnl._numTcpConn), new Long(fromTnl._numTcpConn), "TCP connections");
            this.addTestData(buff, toTnl._passiveMode == 1, fromTnl._passiveMode == 1, "passive mode");
            this.addTestData(buff, new Long(toTnl._timestampTolerance), new Long(fromTnl._timestampTolerance), "timeStamp tolerance");
            if (buff.length() > 0) {
                buf.append(buff.toString());
                this.addData(swA.getPeer(), false, this._attrName, buf.toString(), null);
            }
            buf = new StringBuffer("Mismatch Profile: ");
            buf.append(swA.ifIndexToName(lk.getIfIndex1()));
            buf.append("<->");
            buf.append(swB);
            buf.append(swB.ifIndexToName(lk.getIfIndex2()));
            buf.append(" ");
            buff = new StringBuffer();
            if (null == toTnl._localProfile || null == fromTnl._localProfile) continue;
            this.addTestData(buff, toTnl._localProfile._pMTUEnable == 1, fromTnl._localProfile._pMTUEnable == 1, "mtu enabled");
            this.addTestData(buff, new Long(toTnl._localProfile._pMTUResetTO), new Long(fromTnl._localProfile._pMTUResetTO), "mtu reset");
            this.addTestData(buff, toTnl._localProfile._sackOption == 1, fromTnl._localProfile._sackOption == 1, "sack option");
            this.addTestData(buff, new Long(toTnl._localProfile._tcpKeepAliveTo), new Long(fromTnl._localProfile._tcpKeepAliveTo), "keep alive");
            this.addTestData(buff, new Long(toTnl._localProfile._tcpMinRTO), new Long(fromTnl._localProfile._tcpMinRTO), "min rto");
            this.addTestData(buff, new Long(toTnl._localProfile._tcpMaxReTx), new Long(fromTnl._localProfile._tcpMaxReTx), "max re tx");
            if (buff.length() <= 0) continue;
            buf.append(buff.toString());
            this.addData(swA.getPeer(), false, this._attrName, buf.toString(), null);
        }
    }

    void addTestData(StringBuffer buf, Object toVal, Object fromVal, String prop) {
        if (!toVal.toString().equals(fromVal.toString())) {
            buf.append(prop);
            buf.append(":(");
            buf.append(toVal);
            buf.append(", ");
            buf.append(fromVal);
            buf.append(") ");
        }
    }

    class Profile {
        int _index;
        int _sackOption;
        int _tcpKeepAliveTo;
        int _tcpMinRTO;
        int _tcpMaxReTx;
        int _pMTUEnable;
        int _pMTUResetTO;

        Profile() {
        }
    }

    class Tunnel {
        Profile _localProfile;
        int _index;
        int _checkTimestamp;
        long _timestampTolerance;
        int _passiveMode;
        long _numTcpConn;

        Tunnel() {
        }
    }
}

