/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.fc;

import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.BorderCellRenderer;
import com.cisco.dcbu.lib.ui.table.KTable;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.fc.OptionsRenderer;
import com.cisco.dcbu.sm.client.fc.OptionsTableModel;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;

class OptionDialog
extends JDialog
implements ActionListener {
    static final String[] _ColLabels = new String[]{"Feature", "Mismatched Values", "Missing Entries", "Extra Entries"};
    static final boolean[] _Editable = new boolean[]{false, true, true, true};

    public OptionDialog(JDialog parent, Array data) {
        super((Dialog)parent, true);
        this.setTitle("Fabric Rules" + ClientController.getInstance().getDialogFabricTitlePostfix());
        OptionsTableModel model = new OptionsTableModel();
        model.setData(data);
        model.setHeaders(_ColLabels);
        model.setEditable(_Editable);
        OptionsTable table = new OptionsTable(model);
        JScrollPane sp = new JScrollPane(table);
        sp.setPreferredSize(table.calcPreferredSize());
        String[] bLabels = new String[]{"OK"};
        AbstractButton[] buttons = DialogUtil.buildButtons(bLabels, (ActionListener)this);
        DialogUtil.buildDialog((JDialog)this, (Container)parent, (Container)sp, buttons);
        this.setDefaultCloseOperation(2);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.dispose();
    }

    class OptionsTable
    extends KTable {
        public OptionsTable(KTableModel model) {
            super(model);
            this.setDefaultRenderer(Object.class, new BorderCellRenderer());
            this.setDefaultRenderer(Boolean.class, new OptionsRenderer());
            this.setCellSelectionEnabled(true);
            this.addPopupMenu();
        }

        @Override
        protected void buildPopupMenu() {
            super.buildPopupMenu();
            this._popup.addSeparator();
            String[] menu = new String[]{"Undo Changes", "All", "None"};
            for (int i = 0; i < menu.length; ++i) {
                this._popup.add(Util.createMenuItem(menu[i], menu[i], this));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KTableModel model = (KTableModel)this.getModel();
            switch (((AbstractButton)e.getSource()).getText().charAt(0)) {
                case 'U': {
                    model.undo();
                    break;
                }
                case 'A': {
                    this.setOptions(model.getData(), true);
                    break;
                }
                case 'N': {
                    this.setOptions(model.getData(), false);
                    break;
                }
                default: {
                    super.actionPerformed(e);
                    return;
                }
            }
            model.fireTableDataChanged();
        }

        void setOptions(Array data, boolean on) {
            Boolean b = on ? Boolean.TRUE : Boolean.FALSE;
            for (int i = 0; i < data.size(); ++i) {
                Object[] row = (Object[])data.elementAt(i);
                row[1] = b;
                if (row[2] != null) {
                    row[2] = b;
                }
                if (row[3] == null) continue;
                row[3] = b;
            }
        }
    }
}

