/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.fcip;

import com.cisco.dcbu.lib.mds.zm.AbstractMdsAction;
import com.cisco.dcbu.lib.mds.zm.PollerCallbackIf;
import com.cisco.dcbu.lib.mds.zm.PollerManager;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import java.util.ArrayList;

class FeatureAction
extends AbstractMdsAction {
    static final int[] FEATURE_ACTION = MibNode.get("cfcFeatureCtrlAction").getOid();
    static final MibEnum[] FEATURE_ENUM = MibNode.get("cfcFeatureCtrlIndex").getEnums();
    static final int[] FEATURE_RESULT = MibNode.get("cfcFeatureCtrlLastActionResult").getOid();
    static final int[] FEATURE_FAIL_REASON = MibNode.get("cfcFeatureCtrlLastFailureReason").getOid();
    static final int[] FEATURE_OP_STATUSON = MibNode.get("cfcFeatureCtrlOpStatus").getOid();
    static final int ENABLED = 2;
    static final int DISABLED = 3;
    static final int SUCCESS = 2;
    static final int FAILED = 3;
    static final int IN_PROGRESS = 4;
    private SnmpPeer _peer;
    private int[] _featureIds;
    private boolean _enableFeature;
    private ArrayList _failedFeatures = new ArrayList();
    private ArrayList _successFeatures = new ArrayList();
    private StringBuffer _failedReason = new StringBuffer();

    private FeatureAction(SnmpPeer peer, int[] featureIds, PollerCallbackIf pollerCallBack, boolean enableFeature) {
        super(pollerCallBack);
        this._peer = peer;
        this._featureIds = featureIds;
        this._enableFeature = enableFeature;
    }

    @Override
    public VarBindList getPollVarBind() {
        VarBindList vb = new VarBindList();
        for (int i = 0; i < this._featureIds.length; ++i) {
            vb.add(FEATURE_RESULT, this._featureIds[i]);
            vb.add(FEATURE_FAIL_REASON, this._featureIds[i]);
            vb.add(FEATURE_OP_STATUSON, this._featureIds[i]);
        }
        return vb;
    }

    @Override
    public VarBindList getActionVarBind() throws SnmpException {
        this._failedFeatures.clear();
        this._successFeatures.clear();
        this._failedReason.setLength(0);
        VarBindList vb = new VarBindList();
        for (int i = 0; i < this._featureIds.length; ++i) {
            vb.add(FEATURE_ACTION, this._featureIds[i], (SnmpVar)new SnmpInt(this._enableFeature ? 2 : 3));
        }
        return vb;
    }

    @Override
    public String toString() {
        return (this._enableFeature ? "Enable Features" : "Disable Features") + " on " + this._peer + ".";
    }

    @Override
    public VarBindList getCleanUpVarBind() {
        return null;
    }

    @Override
    public int pollStatus(PollerManager manager, VarBindList response, StringBuffer status) {
        this._pollerCallBack.pollStatus(manager, response, status);
        block4: for (int i = 0; i < this._featureIds.length; ++i) {
            Integer featureInt = new Integer(this._featureIds[i]);
            int result = response.intValue(i * 3);
            switch (result) {
                case 4: {
                    continue block4;
                }
                case 2: {
                    if (response.intValue(i * 3 + 2) != (this._enableFeature ? 2 : 3) || this._successFeatures.contains(featureInt)) continue block4;
                    this._successFeatures.add(featureInt);
                    continue block4;
                }
                default: {
                    if (!this._failedFeatures.contains(featureInt)) {
                        this._failedFeatures.add(featureInt);
                    }
                    this._failedReason.append(MibEnum.getLabel(FEATURE_ENUM, featureInt) + ":" + response.stringValue(i * 1) + "\n");
                }
            }
        }
        if (this._failedFeatures.size() + this._successFeatures.size() < this._featureIds.length) {
            return 0;
        }
        if (this._failedFeatures.size() > 0) {
            return 2;
        }
        return 1;
    }

    public static FeatureAction createAction(SnmpPeer peer, boolean enableFeature, int[] featureIds, PollerManager manager, PollerCallbackIf callback) throws SnmpException {
        FeatureAction act = new FeatureAction(peer, featureIds, callback, enableFeature);
        manager.addTask(act);
        return act;
    }

    @Override
    public void failed(PollerManager manager, SnmpException ex) {
        super.failed(manager, new SnmpException(this.getFailedReason()));
    }

    boolean isFailed() {
        return this._failedFeatures.size() > 0;
    }

    String getFailedReason() {
        return this._failedReason.toString();
    }
}

