/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.fcoe.wizard;

import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.sm.client.fcoe.wizard.ConfigureEthernetInterfacesPanel;
import com.cisco.dcbu.sm.client.fcoe.wizard.FCoEConfigurationWizard;
import com.cisco.dcbu.sm.client.fcoe.wizard.VEFCoEConfigurationPanel;
import com.cisco.dcbu.sm.client.model.AbstractSwitch;
import com.cisco.dcbu.sm.common.type.PKIf;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.TreeMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.TableModelEvent;

public class VEConfigureEthernetInterfacesPanel
extends ConfigureEthernetInterfacesPanel {
    private static final long serialVersionUID = 1L;
    protected static String _panelName = new String("Step 4 of 4: Configure Ethernet Interfaces");
    protected static String _panelDesc = new String("Create and bind virtual FC interfaces to the ethernet interfaces/channels. Configure the appropriate virtual FC interfaces and ethernet interfaces/channels. Apply FCoE changes to the switches.");
    private JLabel _selSwitch1Lbl;
    private JLabel _selSwitch2Lbl;
    protected VEFCoEConfigurationPanel tablePanel;

    public VEConfigureEthernetInterfacesPanel(JWizard wizard) {
        super(wizard, _panelName, _panelDesc);
    }

    public JPanel createVEFCoEConfigurationPanel(TreeMap<Integer, Integer> activeVlanVsans, TreeMap<Integer, Integer> selectedVlanVsan, LinkedHashMap<AbstractSwitch, ArrayList<String>> interfacesList, HashMap<PKIf, Integer> switchVFCAdminMode) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.createSummaryPanel(), "North");
        this.tablePanel = new VEFCoEConfigurationPanel(activeVlanVsans, selectedVlanVsan, interfacesList, switchVFCAdminMode);
        panel.add((Component)this.tablePanel, "Center");
        this.tablePanel.getTableModel().addTableModelListener(this);
        return panel;
    }

    protected JPanel createSummaryPanel() {
        JPanel sumaryPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridy = 0;
        gbc.gridx = 0;
        JLabel lbl = new JLabel("Selected Switch 1: ");
        lbl.setHorizontalAlignment(4);
        sumaryPanel.add((Component)lbl, gbc);
        this._selSwitch1Lbl = new JLabel();
        this._selSwitch1Lbl.setHorizontalAlignment(2);
        Font lblFont = this._selSwitch1Lbl.getFont().deriveFont(1);
        this._selSwitch1Lbl.setFont(lblFont);
        ++gbc.gridx;
        gbc.anchor = 21;
        sumaryPanel.add((Component)this._selSwitch1Lbl, gbc);
        lbl = new JLabel("Selected Switch 2: ");
        lbl.setHorizontalAlignment(4);
        ++gbc.gridx;
        gbc.anchor = 13;
        sumaryPanel.add((Component)lbl, gbc);
        this._selSwitch2Lbl = new JLabel();
        this._selSwitch2Lbl.setHorizontalAlignment(2);
        lblFont = this._selSwitch1Lbl.getFont().deriveFont(1);
        this._selSwitch2Lbl.setFont(lblFont);
        ++gbc.gridx;
        gbc.anchor = 17;
        sumaryPanel.add((Component)this._selSwitch2Lbl, gbc);
        return sumaryPanel;
    }

    @Override
    public boolean refresh() {
        this.updateStep();
        AbstractSwitch[] selectedSwitches = (AbstractSwitch[])this.getModelValue("SELECTED_VE_FCOE_SWITCHES");
        LinkedHashMap interfacesList = (LinkedHashMap)this.getModelValue("SELECTED_INTERFACES");
        HashMap switchVFCAdminMode = (HashMap)this.getModelValue("SWITCH_VFC_ADMIN_MODE");
        TreeMap activeVlanVsans = (TreeMap)this.getModelValue("Active VLAN VSAN Mappings");
        TreeMap selectedVlanVsans = (TreeMap)this.getModelValue("Selected VLAN VSAN Mapping");
        if (selectedSwitches != null) {
            this.remove(this.mainPanel);
            this.setBusy(true);
            this.mainPanel = this.createVEFCoEConfigurationPanel(activeVlanVsans, selectedVlanVsans, interfacesList, switchVFCAdminMode);
            this.updateSummaryInfo(selectedSwitches[0], selectedSwitches[1]);
            this.add((Component)this.mainPanel, "Center");
            this.setBusy(false);
            this.repaint();
        }
        return true;
    }

    private void updateSummaryInfo(AbstractSwitch sw1, AbstractSwitch sw2) {
        if (this._selSwitch1Lbl != null) {
            this._selSwitch1Lbl.setText(sw1.getName());
        }
        if (this._selSwitch2Lbl != null) {
            this._selSwitch2Lbl.setText(sw2.getName());
        }
    }

    @Override
    public void doFinish() {
        if (this.tablePanel.startConfiguration()) {
            super.doFinish();
            this.getWizard().getNavigator().setCancelButton("Close");
        }
    }

    public void updateStep() {
        if (FCoEConfigurationWizard.isISLLaunch) {
            this.setTitle("Step 2 of 2: Configure Ethernet Interfaces");
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (!this.getWizard().getNavigator().getNextBtn().isEnabled() && e != null && e.getColumn() == -1) {
            this.getWizard().getNavigator().getNextBtn().setEnabled(true);
        }
    }
}

