/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.gui;

import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.ControlPanel;
import com.cisco.dcbu.sm.client.gui.EditUserIf;
import com.cisco.dcbu.sm.client.gui.EditViewScopeIf;
import com.cisco.dcbu.sm.client.gui.EditVirtualCenterIf;
import com.cisco.dcbu.sm.client.gui.NewOpenDialogIf;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.GroupPK;
import com.cisco.dcbu.vi.model.VirtualCenterBase;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.InetAddress;
import java.rmi.RemoteException;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class ControlPanelDialog
extends JDialog
implements NewOpenDialogIf,
EditUserIf,
EditViewScopeIf,
EditVirtualCenterIf {
    private static ControlPanelDialog dialogInstance = null;
    private static ControlPanel controlPanelInstance = null;
    private WindowListener windowListener = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent e) {
            ControlPanelDialog.this.onCancel();
        }
    };

    public static ControlPanelDialog getExistingInstance() {
        return dialogInstance;
    }

    public static void handleFabricDeleted() {
        if (dialogInstance != null && controlPanelInstance != null) {
            controlPanelInstance.handleFabricOrLanDeleted();
        }
    }

    protected void onCancel() {
        if (controlPanelInstance == null) {
            return;
        }
        controlPanelInstance.onClose();
    }

    public static ControlPanelDialog getInstance(JFrame parent) {
        if (dialogInstance == null) {
            dialogInstance = new ControlPanelDialog(parent, "Control Panel - " + ClientController.getInstance().getFMUsername() + "@" + ClientController.getInstance().getServer() + " (session " + System.getProperty("fm.sessionid") + ") - " + "DCNM-SAN");
            controlPanelInstance = new ControlPanel(dialogInstance);
            dialogInstance.getContentPane().add(controlPanelInstance);
            dialogInstance.pack();
            dialogInstance.setDefaultCloseOperation(2);
            controlPanelInstance.handleNoFabrics();
        }
        return dialogInstance;
    }

    public static ControlPanelDialog getInstance(Frame parent) {
        if (dialogInstance == null) {
            dialogInstance = new ControlPanelDialog(parent, "Control Panel - " + ClientController.getInstance().getFMUsername() + "@" + ClientController.getInstance().getServer() + " (session " + System.getProperty("fm.sessionid") + ") - " + "DCNM-SAN");
            controlPanelInstance = new ControlPanel(dialogInstance);
            dialogInstance.getContentPane().add(controlPanelInstance);
            dialogInstance.pack();
            dialogInstance.setDefaultCloseOperation(2);
            controlPanelInstance.handleNoFabrics();
        }
        return dialogInstance;
    }

    private ControlPanelDialog(Frame parent, String title) {
        super(parent, title);
        this.addWindowListener(this.windowListener);
    }

    private ControlPanelDialog(JFrame parent, String title) {
        super((Frame)parent, title);
        this.addWindowListener(this.windowListener);
    }

    @Override
    public void setCursor(Cursor cursor) {
        boolean wantBusyCursor = cursor != null && cursor.getType() == 3;
        this.getGlassPane().setVisible(wantBusyCursor);
        this.getGlassPane().setCursor(wantBusyCursor ? Cursor.getPredefinedCursor(3) : null);
    }

    public void showTab(String tabName) {
        if (controlPanelInstance == null) {
            return;
        }
        controlPanelInstance.showTab(tabName);
    }

    @Override
    public boolean contains(FabricPK fabricPK) {
        if (controlPanelInstance == null) {
            return false;
        }
        return controlPanelInstance.contains(fabricPK);
    }

    @Override
    public void addFabricItem(FabricPK fabricPK, SnmpUserOpt snmpUserOpt, boolean licensed, boolean evalLicensed) {
        if (controlPanelInstance == null) {
            return;
        }
        controlPanelInstance.addFabricItem(fabricPK, snmpUserOpt, licensed, evalLicensed);
    }

    @Override
    public void editUser(String name, String role, char[] pass, boolean newUser) throws Exception {
        controlPanelInstance.editUser(name, role, pass, newUser);
    }

    public void updateTitle() {
        this.setTitle("Control Panel - " + ClientController.getInstance().getFMUsername() + "@" + ClientController.getInstance().getServer() + " (session " + System.getProperty("fm.sessionid") + ") - " + "DCNM-SAN" + " " + "6.3(2)");
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.updateTitle();
        }
    }

    @Override
    public void addGroup(String userName, GroupPK[] groups) throws Exception {
        controlPanelInstance.addGroup(userName, groups);
    }

    @Override
    public void updateGroup(String userName, GroupPK[] groups) throws Exception {
        controlPanelInstance.updateGroup(userName, groups);
    }

    @Override
    public VirtualCenterBase addVirtualCenter(InetAddress vcIP, String username, String passwd, boolean discovery, String targetServerIp) throws RemoteException, Exception {
        return controlPanelInstance.addVirtualCenter(vcIP, username, passwd, discovery, targetServerIp);
    }

    @Override
    public void updateVirtualCenter(InetAddress vcIP, String username, String passwd, boolean discovery, String targetServerIp) throws RemoteException, Exception {
        controlPanelInstance.updateVirtualCenter(vcIP, username, passwd, discovery, targetServerIp);
    }
}

