/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.gui;

import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.KTextField;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.sm.client.gui.EditUserIf;
import com.cisco.dcbu.sm.common.security.RoleType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class EditFMUserDialog
extends JDialog
implements ActionListener {
    private static final int USERNAME = 0;
    private static final int PASSWORD = 1;
    private static final int CONFIRM_PASSWORD = 2;
    private static final int ROLE = 3;
    private final boolean _new;
    private JComponent[] _inputs;
    private final String[] _buttonLabels = new String[]{"OK", "Cancel"};
    private String _username;
    private String _role;
    private EditUserIf _adminDialog;
    Dimension _preferredSize = new Dimension(280, 250);

    public EditFMUserDialog(JDialog parent) {
        this(parent, null, null);
    }

    public EditFMUserDialog(JFrame parent) {
        this(parent, null, null);
    }

    public EditFMUserDialog(JDialog parent, String username, String role) {
        super(parent, "DCNM-SAN User", true);
        if (parent instanceof EditUserIf) {
            this._adminDialog = (EditUserIf)((Object)parent);
        }
        this._new = username == null;
        this._username = username;
        this._role = role;
        this.buildGUI();
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    public EditFMUserDialog(JFrame parent, String username, String role) {
        super(parent, "DCNM-SAN User", true);
        if (parent instanceof EditUserIf) {
            this._adminDialog = (EditUserIf)((Object)parent);
        }
        if (username == null) {
            this._new = true;
            this.setTitle("Add Local DCNM User");
        } else {
            this._new = false;
            this.setTitle("Edit Local DCNM User");
        }
        this._username = username;
        this._role = role;
        this.buildGUI();
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private void buildGUI() {
        String[] inputLabels = this._new ? new String[]{"User Name:", "Password:", "Confirm Password:", "Role:"} : new String[]{"User Name:", "New Password:", "Confirm Password:", "Role:"};
        JComponent[] labels = DialogUtil.buildLabels(inputLabels);
        this._inputs = new JComponent[inputLabels.length];
        this._inputs[0] = new KTextField(this._username);
        if (!this._new) {
            ((KTextField)this._inputs[0]).setEditable(false);
        }
        this._inputs[1] = new JPasswordField("");
        this._inputs[2] = new JPasswordField("");
        if (this._new) {
            String[] roles = new String[]{RoleType.ROLE_ADMIN.value(), RoleType.ROLE_OPER.value(), RoleType.ROLE_SA_ADMIN.value()};
            JComboBox<String> combo = new JComboBox<String>(roles);
            combo.setEditable(false);
            this._inputs[3] = combo;
        } else {
            KTextField field = new KTextField(this._role);
            field.setEditable(false);
            this._inputs[3] = field;
        }
        JPanel main = new JPanel(new BorderLayout());
        main.setBorder(DialogUtil._Margin);
        JPanel inputPanel = DialogUtil.buildPanel(labels, this._inputs);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.insets = DialogUtil.getInsets();
        DialogUtil.extend(gbc, inputPanel, this._inputs[3]);
        JButton[] buttons = DialogUtil.buildButtons(this._buttonLabels, (ActionListener)this);
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 6, 3));
        for (int i = 0; i < buttons.length; ++i) {
            buttonPanel.add(buttons[i]);
        }
        main.add((Component)inputPanel, "Center");
        main.add((Component)buttonPanel, "South");
        this.getContentPane().add((Component)main, "Center");
        this.getRootPane().setDefaultButton(buttons[0]);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            String cmd = e.getActionCommand();
            char ch = cmd.charAt(0);
            if (ch == 'C') {
                this.onClose();
            } else if (ch == 'O') {
                this.onOK();
            }
        }
        catch (Exception ex) {
            Util.errorMessage((Component)this, ex);
        }
    }

    private void onOK() throws Exception {
        String username = this.getUsername();
        char[] password = this.getPassword();
        String role = this.getRole();
        try {
            this._adminDialog.editUser(username, role, password, this._new);
        }
        catch (Exception ex) {
            Util.errorMessage((Component)this, ex);
        }
        this.onClose();
    }

    private String getUsername() throws Exception {
        String username = ((JTextField)this._inputs[0]).getText().trim();
        if (username == null || username.length() == 0) {
            throw new Exception("Please enter user name");
        }
        if (username.contains("@")) {
            throw new Exception("Invalid entry for user name - @ is not allowed");
        }
        if (!GenUtil.validateUsername(username)) {
            throw new Exception("Invalid entry for user name. Only [A..Z, a..z, 0..9, '.', '-', '_'] are allowed.");
        }
        return username;
    }

    private String getRole() {
        if (this._new) {
            return (String)((JComboBox)this._inputs[3]).getSelectedItem();
        }
        return ((JTextField)this._inputs[3]).getText();
    }

    private char[] getPassword() throws Exception {
        char[] password = ((JPasswordField)this._inputs[1]).getPassword();
        char[] password1 = ((JPasswordField)this._inputs[2]).getPassword();
        if (password == null || password.length == 0) {
            throw new Exception("Please enter password");
        }
        if (!GenUtil.validatePassword(new String(password))) {
            throw new Exception("Please provide a password with a minimum of 8 chars long and at least one letter and number");
        }
        if (password1 == null || password1.length == 0) {
            throw new Exception("Please confirm password");
        }
        String str1 = String.valueOf(password).trim();
        String str2 = String.valueOf(password1).trim();
        if (str1.length() == 0 || str2.length() == 0) {
            throw new Exception("Password (or confirmed password) can not be blank");
        }
        if (!str1.equals(str2)) {
            throw new Exception("The passwords you typed do not match");
        }
        return str1.toCharArray();
    }

    private void onClose() {
        this._adminDialog = null;
        this.setVisible(false);
        super.dispose();
    }

    @Override
    public Dimension getPreferredSize() {
        return this._preferredSize;
    }
}

