/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.gui;

import com.cisco.dcbu.lib.mds.SharedUtil;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.KTextField;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.EditVirtualCenterIf;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class EditVirtualCenterServerDialog
extends JDialog
implements ActionListener {
    private static final int IP = 0;
    private static final int USERNAME = 1;
    private static final int PASSWORD = 2;
    private static final int DISCOVER = 3;
    public static final int SERVER = 4;
    private List<String> _serverIpList;
    private final boolean _new;
    private JComponent[] _inputs;
    private final String[] _buttonLabels = new String[]{"OK", "Cancel"};
    private String _ip;
    private String _username;
    private EditVirtualCenterIf _adminDialog;
    Dimension _preferredSize = new Dimension(300, 250);

    public EditVirtualCenterServerDialog(JDialog parent) {
        this(parent, null, null);
    }

    public EditVirtualCenterServerDialog(JFrame parent) {
        this(parent, null, null);
    }

    public EditVirtualCenterServerDialog(JDialog parent, String ip, String username) {
        super(parent, "Virtual Server Center - DCNM-SAN", true);
        if (parent instanceof EditVirtualCenterIf) {
            this._adminDialog = (EditVirtualCenterIf)((Object)parent);
        }
        this._new = username == null;
        this._ip = ip;
        this._username = username;
        this.buildGUI();
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    public EditVirtualCenterServerDialog(JFrame parent, String ip, String username) {
        super(parent, "Virtual Server Center - DCNM-SAN", true);
        if (parent instanceof EditVirtualCenterIf) {
            this._adminDialog = (EditVirtualCenterIf)((Object)parent);
        }
        if (username == null) {
            this._new = true;
            this.setTitle("Add VCenter Server");
        } else {
            this._new = false;
            this.setTitle("Edit VCenter Server");
        }
        this._ip = ip;
        this._username = username;
        this.buildGUI();
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private void buildGUI() {
        String[] inputLabels = this._new ? new String[]{"IP Address:", "User Name:", "Password:", "Manage Continuously:", "Server:"} : new String[]{"IP Address:", "New User Name:", "New Password:", "Manage Continuously:", "Server:"};
        JComponent[] labels = DialogUtil.buildLabels(inputLabels);
        this._inputs = new JComponent[inputLabels.length];
        this._inputs[0] = new KTextField(this._ip);
        this._inputs[1] = new KTextField(this._username);
        if (!this._new) {
            ((KTextField)this._inputs[0]).setEditable(false);
        }
        this._inputs[2] = new JPasswordField("");
        this._inputs[3] = new JCheckBox("");
        ((JCheckBox)this._inputs[3]).setSelected(this._new);
        this._serverIpList = ClientController.getInstance().getServerNodes();
        if (this._serverIpList == null) {
            this._serverIpList = new ArrayList<String>();
        }
        this._inputs[4] = new JComboBox<Object>(this._serverIpList.toArray());
        if (this._serverIpList == null || this._serverIpList.size() < 2) {
            labels[4].setVisible(false);
            this._inputs[4].setVisible(false);
        }
        JPanel main = new JPanel(new BorderLayout());
        main.setBorder(DialogUtil._Margin);
        JPanel inputPanel = DialogUtil.buildPanel(labels, this._inputs);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.insets = DialogUtil.getInsets();
        JButton[] buttons = DialogUtil.buildButtons(this._buttonLabels, (ActionListener)this);
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 6, 3));
        for (int i = 0; i < buttons.length; ++i) {
            buttonPanel.add(buttons[i]);
        }
        main.add((Component)inputPanel, "Center");
        main.add((Component)buttonPanel, "South");
        this.getContentPane().add((Component)main, "Center");
        this.getRootPane().setDefaultButton(buttons[0]);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            String cmd = e.getActionCommand();
            char ch = cmd.charAt(0);
            if (ch == 'C') {
                this.onClose();
            } else if (ch == 'O') {
                this.onOK();
            }
        }
        catch (Exception ex) {
            Util.errorMessage((Component)this, ex);
        }
    }

    private void onOK() throws Exception {
        String ipaddress = this.getIpAddress();
        String username = this.getUsername();
        char[] password = this.getPassword();
        boolean discover = this.getDiscover();
        try {
            if (this._new) {
                this._adminDialog.addVirtualCenter(InetAddress.getByName(ipaddress), username, new String(password), discover, this.getServerIp());
            } else {
                this._adminDialog.updateVirtualCenter(InetAddress.getByName(ipaddress), username, new String(password), discover, this.getServerIp());
            }
        }
        catch (Exception ex) {
            Util.errorMessage((Component)this, ex);
            return;
        }
        this.onClose();
    }

    private String getIpAddress() throws Exception {
        String ipAddress = ((JTextField)this._inputs[0]).getText().trim();
        if (ipAddress == null || ipAddress.length() == 0) {
            throw new Exception("Please enter IP Address");
        }
        if (ipAddress.contains("@")) {
            throw new Exception("Invalid entry for IP Address - @ is not allowed");
        }
        if (!SharedUtil.isIpAddress(ipAddress, false)) {
            throw new Exception("Invalid entry for IP Address.");
        }
        return ipAddress;
    }

    private String getUsername() throws Exception {
        String username = ((JTextField)this._inputs[1]).getText().trim();
        if (username == null || username.length() == 0) {
            throw new Exception("Please enter user name");
        }
        if (username.contains("@")) {
            throw new Exception("Invalid entry for user name - @ is not allowed");
        }
        if (!GenUtil.validateUsername(username)) {
            throw new Exception("Invalid entry for user name. Only [A..Z, a..z, 0..9, '.', '-', '_'] are allowed.");
        }
        return username;
    }

    private char[] getPassword() throws Exception {
        char[] password = ((JPasswordField)this._inputs[2]).getPassword();
        if (password == null || password.length == 0) {
            throw new Exception("Please enter password");
        }
        String str1 = String.valueOf(password).trim();
        return str1.toCharArray();
    }

    private boolean getDiscover() {
        return ((JCheckBox)this._inputs[3]).isSelected();
    }

    public String getServerIp() {
        JComboBox svrChoice = (JComboBox)this._inputs[4];
        if (!svrChoice.isVisible()) {
            return null;
        }
        return this._serverIpList.get(svrChoice.getSelectedIndex());
    }

    private void onClose() {
        this._adminDialog = null;
        this.setVisible(false);
        super.dispose();
    }

    @Override
    public Dimension getPreferredSize() {
        return this._preferredSize;
    }
}

