/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.gui;

import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.ManageFabricThreadListenerIf;
import com.cisco.dcbu.sm.common.rif.ModelFacadeRif;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.vi.model.VirtualCenterBase;
import java.awt.Component;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class ManageVirtualCenterThread
extends Thread {
    private List<PKIf> _virtualCenterList = new ArrayList<PKIf>();
    private boolean _keepWaiting = true;
    private boolean _doneAddingVirtualCenters = false;
    private Component _component = null;
    private ManageFabricThreadListenerIf _listener = null;
    private Logger _logger = Logger.getLogger(this.getClass());

    public void addVirtualCenter(PKIf pk) {
        this._logger.debug((Object)("ManageVirtualCenterThread addVirtualCenter() " + pk));
        this._virtualCenterList.add(pk);
    }

    public void removeVirtualCenter(PKIf pk) {
        this._logger.debug((Object)("ManageVirtualCenterThread removeVirtualCenter() " + pk));
        this._virtualCenterList.remove(pk);
    }

    public void removeAllVirtualCenters() {
        this._logger.debug((Object)"ManageVirtualCenterThread removeAllVirtualCenter() ");
        this._virtualCenterList.clear();
    }

    public void setComponent(Component component) {
        this._logger.debug((Object)"ManageVirtualCenterThread setComponent()");
        this._component = component;
    }

    public void setListener(ManageFabricThreadListenerIf listener) {
        this._listener = listener;
    }

    public void doneAddingVirtualCenters() {
        this._logger.debug((Object)"ManageVirtualCenterThread doneAddingVirtualCenters()");
        this._doneAddingVirtualCenters = true;
    }

    @Override
    public void run() {
        this._logger.debug((Object)"ManageVirtualCenterThread run()");
        this._keepWaiting = true;
        if (this._component != null) {
            this._logger.debug((Object)"ManageVirtualCenterThread run() setCursor WAIT_CURSOR");
            this._component.setCursor(Cursor.getPredefinedCursor(3));
        }
        long time = System.currentTimeMillis();
        int j = 0;
        while (this._keepWaiting || !this._doneAddingVirtualCenters) {
            int i;
            try {
                ManageVirtualCenterThread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            this._logger.debug((Object)("ManageVirtualCenterThread run() " + ++j));
            if (this._virtualCenterList.isEmpty()) {
                this._keepWaiting = false;
                continue;
            }
            HashMap<PKIf, VirtualCenterBase> vHashMap = new HashMap<PKIf, VirtualCenterBase>();
            ModelFacadeRif modelFacadeRif = null;
            VirtualCenterBase[] list = null;
            try {
                modelFacadeRif = ClientController.getInstance().assertModelFacade();
                list = modelFacadeRif.getVirtualCenters();
                if (list == null || list.length == 0) continue;
                for (i = 0; i < list.length; ++i) {
                    vHashMap.put(list[i].getPK(), list[i]);
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            for (i = this._virtualCenterList.size() - 1; i >= 0; --i) {
                PKIf pk = this._virtualCenterList.get(i);
                if (pk == null) continue;
                try {
                    VirtualCenterBase virtualCenterBase = (VirtualCenterBase)vHashMap.get(pk);
                    if (virtualCenterBase == null || !virtualCenterBase.getManageState()) continue;
                    this.removeVirtualCenter(pk);
                    if (this._listener == null) continue;
                    this._logger.debug((Object)"ManageVirtualCenterThread run() handleFinished");
                    this._listener.handleFinished(pk);
                    if (this._component == null) continue;
                    this._logger.debug((Object)"ManageVirtualCenterThread run() setCursor null");
                    this._component.setCursor(null);
                    continue;
                }
                catch (Exception e) {
                    this._logger.error((Object)e.getMessage(), (Throwable)e);
                    this.removeVirtualCenter(pk);
                    if (this._listener == null) continue;
                    this._logger.debug((Object)"ManageVirtualCenterThread run() handleFinished");
                    this._listener.handleFinished(pk);
                }
            }
            if (this._virtualCenterList.isEmpty()) {
                this._keepWaiting = false;
                continue;
            }
            if (System.currentTimeMillis() - time <= 60000L) continue;
            int retVal = JOptionPane.showConfirmDialog(this._component, "Virtual Center Server discovery has not finished. Keep waiting?", "Keep waiting?", 0);
            if (retVal == 0) {
                time = System.currentTimeMillis();
                continue;
            }
            this._keepWaiting = false;
        }
        if (this._component != null) {
            this._logger.debug((Object)"ManageVirtualCenterThread run() setCursor null");
            this._component.setCursor(null);
        }
    }
}

