/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.gui;

import com.cisco.dcbu.lib.jnm.LogWindow;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.SM;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.LogLevelDialog;
import com.cisco.dcbu.sm.client.model.DataCenter;
import com.cisco.dcbu.sm.client.model.Lan;
import com.cisco.dcbu.sm.common.rif.SessionRif;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class SmLogWindow
extends LogWindow {
    private static final long serialVersionUID = 1L;
    private static SmLogWindow _Instance = null;
    private Logger _logger = Logger.getLogger(this.getClass());
    LogLevelDialog logLevelDialog = null;
    static final String LOG_LEVEL = "Log Level...";
    static final String DUMP_FM = "Dump DCNM-SAN Server";
    static final String[] _dumpItems = new String[]{"DataCenter", "LAN", "", "Fabric", "VSANs", "Switches", "ISLs", "NxPorts", "NP Links", "Device Alias", "Enclosures", "Zones", "IVR", "FC Ports", "Hashes"};
    static final String DEFAULT_LEVEL = Level.WARN.toString();
    static String[] logNamesFrom_log4j_fm = new String[]{"snmp", "CLI", "EventHandler", "com.cisco.dcbu.lib", "com.cisco.dcbu.lib.ui", "com.cisco.dcbu.lib.map", "com.cisco.dcbu.sm.client", "com.cisco.dcbu.sm.client.map", "com.cisco.dcbu.sm.client.event", "com.cisco.dcbu.sm.client.ClientController", "com.cisco.dcbu.sm.client.ProxyInvocationHandler", "com.cisco.dcbu.sm.client.SM", "channel.eventchannel", "com.cisco.dcbu.sm.client.cat", "com.cisco.dcbu.sm.client.cfs", "com.cisco.dcbu.sm.client.datamig", "com.cisco.dcbu.sm.client.dialog", "com.cisco.dcbu.sm.client.fc", "com.cisco.dcbu.sm.client.fcip", "com.cisco.dcbu.sm.client.gui", "com.cisco.dcbu.sm.client.iscsi", "com.cisco.dcbu.sm.client.license", "com.cisco.dcbu.sm.client.logicaltree", "com.cisco.dcbu.sm.client.model", "com.cisco.dcbu.sm.client.npv", "com.cisco.dcbu.sm.client.portchnl", "com.cisco.dcbu.sm.client.pref", "com.cisco.dcbu.sm.client.qos", "com.cisco.dcbu.sm.client.sanexttuner", "com.cisco.dcbu.sm.client.upgrade", "com.cisco.dcbu.sm.client.zm", "IOA", "org.jboss", "org.hornetq.core.client"};
    static HashMap catagoryMap = new HashMap();
    static Properties logLevelProperties;

    public static SmLogWindow getInstance() {
        if (_Instance == null) {
            _Instance = new SmLogWindow();
        }
        return _Instance;
    }

    private SmLogWindow() {
    }

    @Override
    protected JPopupMenu buildMenu() {
        JPopupMenu menu = super.buildMenu();
        menu.remove(this._trapTrace);
        this._trapTrace = null;
        menu.addSeparator();
        JMenu dump = new JMenu("Dump Discovery");
        for (int i = 0; i < _dumpItems.length; ++i) {
            if (_dumpItems[i].equals("")) {
                dump.addSeparator();
                continue;
            }
            JMenuItem mi = new JMenuItem(_dumpItems[i]);
            mi.addActionListener(this);
            dump.add(mi);
        }
        menu.add(dump);
        Arrays.sort(_dumpItems);
        JMenuItem dumpServer = new JMenuItem(DUMP_FM);
        dumpServer.addActionListener(this);
        menu.add(dumpServer);
        JMenuItem logLevelDialogMenuItem = new JMenuItem(LOG_LEVEL);
        logLevelDialogMenuItem.addActionListener(this);
        menu.add(logLevelDialogMenuItem);
        return menu;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block17: {
            String command = e.getActionCommand();
            String techSupportResults = "";
            if (command.equals(DUMP_FM)) {
                SessionRif sess = ClientController.getInstance().getServerSession();
                try {
                    techSupportResults = sess.techSupport();
                    if (techSupportResults == null || techSupportResults.length() <= 0) break block17;
                    if (SM._FmStandalone) {
                        DefaultLogger._DumpLogger.info((Object)("Dump written to " + techSupportResults));
                        break block17;
                    }
                    DefaultLogger._DumpLogger.info((Object)("Dump written to " + techSupportResults + " on " + ClientController.getInstance().getServer()));
                }
                catch (RemoteException ex) {
                    if (ex.getCause() != null) {
                        this._logger.error((Object)ex.getMessage(), (Throwable)ex);
                        Util.errorMessage((Component)BrowserFrame.getInstance(), ex.getCause().getMessage());
                        break block17;
                    }
                    Util.errorMessage((Component)BrowserFrame.getInstance(), ex);
                }
            } else if (command.equals(LOG_LEVEL)) {
                if (this.logLevelDialog == null) {
                    this.logLevelDialog = new LogLevelDialog(BrowserFrame.getInstance(), "DCNM-SAN");
                }
                this.logLevelDialog.setVisible(true);
            } else if (Arrays.binarySearch(_dumpItems, command) >= 0) {
                if (command != null && command.equalsIgnoreCase("LAN")) {
                    Lan.getInstance().dump("LAN");
                    return;
                }
                if (command != null && command.equalsIgnoreCase("DataCenter")) {
                    DataCenter.getInstance().dump("DataCenter");
                    return;
                }
                if (ClientController.getInstance().getFabric() != null) {
                    ClientController.getInstance().getFabric().dump(command);
                    if (command.equals("Hashes")) {
                        this.dumpSnmpPeers();
                    }
                }
            } else if (command.equals("Trace SNMP")) {
                this.setSnmpTraceProperty();
                super.actionPerformed(e);
            } else {
                super.actionPerformed(e);
            }
        }
    }

    private void dumpSnmpPeers() {
        int num = 0;
        StringBuffer buf = new StringBuffer();
        SnmpPeer peer = null;
        Iterator<Map.Entry<InetAddress, SnmpPeer>> snmpPeersIterator = SnmpPeer.getPeersIterator();
        if (snmpPeersIterator != null) {
            while (snmpPeersIterator.hasNext()) {
                peer = snmpPeersIterator.next().getValue();
                if (peer == null) continue;
                ++num;
                buf.append("\taddress=" + peer.getAddress() + "\tsysName=" + peer.getSysName() + "\n");
            }
        }
        DefaultLogger._DumpLogger.info((Object)("\nSnmpPeers: " + num + "\n" + buf));
    }

    void setSnmpTraceProperty() {
        Level l = this.isSnmpTraceSelected() ? Level.ALL : Level.WARN;
        Properties logLevelProperties = ClientController.getInstance().loadPropertiesFromServer("smloglevel_3_2.properties", false);
        if (logLevelProperties == null) {
            logLevelProperties = new Properties();
        }
        String levelText = l.toString();
        logLevelProperties.put("snmp", levelText);
        ClientController.getInstance().storePropertiesToServer("smloglevel_3_2.properties", logLevelProperties, "(c) Cisco Systems\n#DCNM-SAN 6.3(2)\n", false);
    }

    static {
        catagoryMap.put("CLI", new String[]{"com.cisco.dcbu.lib.mds.SmlCommandsHandler", "com.cisco.dcbu.lib.jnm.Vsh"});
        logLevelProperties = new Properties();
        logLevelProperties = ClientController.getInstance().loadPropertiesFromServer("smloglevel_3_2.properties", false);
        if (logLevelProperties == null) {
            logLevelProperties = new Properties();
        }
        for (int i = 0; i < logNamesFrom_log4j_fm.length; ++i) {
            String levelText = (String)logLevelProperties.get(logNamesFrom_log4j_fm[i]);
            if (levelText == null || levelText.length() == 0) {
                levelText = DEFAULT_LEVEL;
                logLevelProperties.put(logNamesFrom_log4j_fm[i], levelText);
            }
            if (levelText == null || levelText.length() <= 0) continue;
            String[] catagories = (String[])catagoryMap.get(logNamesFrom_log4j_fm[i]);
            if (catagories != null) {
                LogWindow.setLogLevel(Level.toLevel((String)levelText), catagories);
                continue;
            }
            LogWindow.setLogLevel(Level.toLevel((String)levelText), new String[]{logNamesFrom_log4j_fm[i]});
        }
    }
}

