/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.gui;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.mds.PortEditorCardAttribute;
import com.cisco.dcbu.lib.mds.PortEditorFilter;
import com.cisco.dcbu.lib.mds.PortSetFieldPanel;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.model.NpvLink;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.common.model.Card;
import java.util.ArrayList;
import java.util.List;

public class SmPortSetFieldPanel
extends PortSetFieldPanel {
    boolean _includeISLPCLogicalIfs = false;
    boolean _includeFPCLogicalIfs = false;
    boolean _includeFEXPortIfs = false;
    private short _logical_show_bit_map = 1;
    public static short SHOW_LOGICAL_MGMT_BMP = 1;
    public static short SHOW_F_PC_BMP = (short)2;
    public static short SHOW_ISL_PC_BMP = (short)4;
    public static short SHOW_VFC_BMP = (short)8;
    public static short SHOW_ETH_PC_BMP = (short)16;
    public static short SHOW_FCIP_BMP = (short)32;

    public SmPortSetFieldPanel(boolean exclusive, int width, PortEditorFilter filter) {
        super(exclusive, width, filter);
    }

    public SmPortSetFieldPanel(boolean exclusive, int width, PortEditorFilter filter, short show_logical_map) {
        super(exclusive, width, filter);
        this._logical_show_bit_map = show_logical_map;
        if (show_logical_map != 0) {
            this.setAllowLogicalIf(true);
        }
    }

    public SmPortSetFieldPanel(boolean exclusive, boolean allowNoSelectionWhenExclusive, int width, PortEditorFilter filter) {
        super(exclusive, allowNoSelectionWhenExclusive, width, filter);
    }

    public SmPortSetFieldPanel(boolean exclusive, boolean allowNoSelectionWhenExclusive, int width, PortEditorFilter filter, short show_logical_map) {
        super(exclusive, allowNoSelectionWhenExclusive, width, filter);
        this._logical_show_bit_map = show_logical_map;
        if (show_logical_map != 0) {
            this.setAllowLogicalIf(true);
        }
    }

    public void setAllowFexPorts(boolean include) {
        this._includeFEXPortIfs = include;
    }

    @Override
    public void setNode(SnmpPeer node) {
        int portIndex;
        int index;
        int totalLogicalIfCount;
        this._node = node;
        Switch sw = ClientController.findFabricSwitchByIpAddress(this._node.getAddress());
        Card[] cards = sw.getCards();
        if (cards == null || sw.getSwitchBase().isBladeServer()) {
            this._button.setEnabled(false);
            return;
        }
        this._button.setEnabled(true);
        this._slotMembers = new PortEditorCardAttribute[cards.length];
        for (int i = 0; i < cards.length; ++i) {
            if (cards[i] == null || FRUConstants.isInternalModule(cards[i].getType()) || !this._includeFEXPortIfs && cards[i].isFex()) continue;
            int nOfPortonCard = cards[i].getNumPorts();
            int[] ifTypes = new int[nOfPortonCard];
            for (int j = 0; j < nOfPortonCard; ++j) {
                ifTypes[j] = cards[i].getIfType(j + 1);
            }
            String cardString = cards[i].isFex() ? Integer.toString(cards[i].getSlotId()) + "/1" : Integer.toString(cards[i].getSlotId());
            this._slotMembers[i] = new PortEditorCardAttribute(cards[i].getType(), nOfPortonCard, ifTypes, 0, cardString, cards[i].getSlotId());
        }
        List<Object> vfcs = new ArrayList();
        List<Object> ethPCs = new ArrayList();
        List<Object> fcips = new ArrayList();
        Array<Isl> portChannelIsls = null;
        Array<NpvLink> fPortChannelLinks = null;
        int numIslPortChannels = 0;
        int numFportChannels = 0;
        int numLogicalIf = 0;
        int numVFCs = 0;
        int numEthPCs = 0;
        int numFCIPs = 0;
        if ((this._logical_show_bit_map & SHOW_LOGICAL_MGMT_BMP) == SHOW_LOGICAL_MGMT_BMP) {
            numLogicalIf = 1;
        }
        if ((this._logical_show_bit_map & SHOW_VFC_BMP) == SHOW_VFC_BMP) {
            vfcs = sw.findPorts(30);
            numVFCs = vfcs.size();
        }
        if ((this._logical_show_bit_map & SHOW_ETH_PC_BMP) == SHOW_ETH_PC_BMP) {
            ethPCs = sw.findPorts(22);
            numEthPCs = ethPCs.size();
        }
        if ((this._logical_show_bit_map & SHOW_FCIP_BMP) == SHOW_FCIP_BMP) {
            fcips = sw.findPorts(10);
            numFCIPs = fcips.size();
        }
        if ((this._logical_show_bit_map & SHOW_ISL_PC_BMP) == SHOW_ISL_PC_BMP) {
            portChannelIsls = sw.getFabric().findPcIslsBySwitch(sw);
            Fabric.removeNonPresentModelObject(portChannelIsls);
            numIslPortChannels = portChannelIsls.size();
        }
        if ((this._logical_show_bit_map & SHOW_F_PC_BMP) == SHOW_F_PC_BMP) {
            fPortChannelLinks = sw.getFabric().findPcNpvLinks(sw);
            Fabric.removeNonPresentModelObject(fPortChannelLinks);
            numFportChannels = fPortChannelLinks.size();
        }
        if ((totalLogicalIfCount = numLogicalIf + numIslPortChannels + numFportChannels + numVFCs + numEthPCs + numFCIPs) <= 0) {
            this._logicalIfs = null;
            return;
        }
        this._logicalIfs = new int[totalLogicalIfCount];
        int logicalIndex = 0;
        if ((this._logical_show_bit_map & SHOW_LOGICAL_MGMT_BMP) == SHOW_LOGICAL_MGMT_BMP) {
            this._logicalIfs[logicalIndex++] = IfIndexUtil.name2IfIndex("mgmt0");
        }
        for (Integer n : vfcs) {
            this._logicalIfs[logicalIndex++] = n;
        }
        for (Integer n : ethPCs) {
            this._logicalIfs[logicalIndex++] = n;
        }
        for (Integer n : fcips) {
            this._logicalIfs[logicalIndex++] = n;
        }
        for (index = 0; index < numIslPortChannels; ++index) {
            Isl isl = portChannelIsls.elementAt(index);
            portIndex = isl.getIfIndex1();
            if (sw.equals(isl.getSwitch2())) {
                portIndex = isl.getIfIndex2();
            }
            this._logicalIfs[logicalIndex++] = portIndex;
        }
        for (index = 0; index < numFportChannels; ++index) {
            NpvLink npvLink = fPortChannelLinks.elementAt(index);
            portIndex = npvLink.getFPortIfIndex();
            if (sw.equals(npvLink.getEdgeSwitch())) {
                portIndex = npvLink.getNpPortIfIndex();
            }
            this._logicalIfs[logicalIndex++] = portIndex;
        }
    }
}

