/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.gui;

import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.IndexCellRenderer;
import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.jnm.SysUpTimeIf;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpAggregrate;
import com.cisco.dcbu.lib.snmp.SnmpAggregrateIf;
import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpNull;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.PerspectiveIf;
import com.cisco.dcbu.lib.ui.PerspectiveManager;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.IntHashMap;
import com.cisco.dcbu.lib.util.SyncedInt;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.DataView;
import com.cisco.dcbu.sm.client.gui.DataViewModelIf;
import com.cisco.dcbu.sm.client.gui.FilterInfo;
import com.cisco.dcbu.sm.client.gui.InsertDialog;
import com.cisco.dcbu.sm.client.gui.InsertForm;
import com.cisco.dcbu.sm.client.gui.RowInfo;
import com.cisco.dcbu.sm.client.gui.SmCfsUtil;
import com.cisco.dcbu.sm.client.gui.SmFeatureCtrlUtil;
import com.cisco.dcbu.sm.client.map.actions.SelectionAction;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.SmFilter;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellRenderer;

public class SmTableModel
extends SnmpTableModel
implements SnmpCallbackIf,
SnmpAggregrateIf,
DataViewModelIf {
    protected String[] _vars;
    protected Array _responseData = new Array();
    protected int[] _firstOid;
    protected int _state;
    protected int _index;
    protected int _stopIndex = -1;
    protected boolean _isScalar;
    protected int[] _rowStatus;
    protected int _insertValue;
    protected int _deleteValue;
    protected String[] _indexVars;
    protected String[] _insertFormVars = null;
    protected Class _insertFormClass;
    protected Array _timedoutPeers = new Array();
    protected Array _queriedPeers = new Array();
    protected Array _setErrMsg = new Array();
    protected SmTableModelCellChecker[] _cellCheckers;
    protected SnmpPeer[] _wrkingPeers = null;
    protected HashMap _peers2MultiIndexedFilters = null;
    protected boolean _tableFiltered = false;
    protected InsertDialog _myInsertDlg;
    protected boolean _validateVbl;
    protected boolean _validateGETEntireVbl = false;
    protected String _validateInsertRowVblSwVerGreaterThanEqual;
    protected String _swVersionSupportedGreaterThan;
    protected String _swVersionSupportedGreaterThanEqual;
    protected String _swVersionSupportedLessThan;
    protected String _swVersionSupportedLessThanEqual;
    protected int[] _unSupportedSwitchModelTypes;
    protected String _wizSignature;
    protected HashMap _peers2RowsGetCols = new HashMap();
    boolean _refreshChangedRow;
    protected boolean _fragPduOnByte;
    protected boolean _ignoreSegmentedVsan = false;
    protected String _cfsFeatureName = null;
    protected SnmpPeer _cfsMasterPeer = null;
    protected int[][] _featurectrlIndices = null;
    protected String _featureCtrlVersion = null;
    protected Vsan _cfsVsan = null;
    protected boolean _isStatsTable = false;
    protected String _editMethod;
    protected boolean _indexTranslationNeedSwitch = false;
    protected int _ifIndexOffset = 0;
    public static final byte GET_ROW_REQ = 1;
    public static final byte GETNEXT_REQ = 2;
    public static final byte GET_ROWS_REQ = 3;
    public static final byte GETBULK_REQ = 4;
    public static final byte SET_REQ = 5;
    public static final byte GET_COLS_REQ = 6;
    static final int UPDATETABLE_PER_NROW = 20;
    static final int MAX_ERR_MSG = 50;
    protected boolean _outScope = false;
    protected IntHashMap _switch2MibVars;
    protected IntHashMap _switch2MibNodes;
    protected boolean _needQuail = false;
    protected boolean _checkForEmptyColumns = false;
    protected RadioButtonPanel _cfsView = null;
    protected SmFilter[] _oldFilters = null;
    protected final SyncedInt _numOutstanding = new SyncedInt(0);
    protected int _leadIndex;
    private static final String[][] CFS_BUTTON = new String[][]{{null, "Commit CFS", "F"}};

    public SmTableModel() {
        DataView view = BrowserFrame.getDataView();
        if (view != null) {
            view.modelReset();
        }
    }

    public SmTableModel(String bitmap, String tooltip, int insertBefore, String action, ActionListener listener) {
        this();
        String[] wizardButtons = new String[]{bitmap, tooltip, action};
        DataView dataView = BrowserFrame.getDataView();
        dataView.insertButton(insertBefore, new String[][]{wizardButtons}, new ActionListener[]{listener});
    }

    @Override
    public final boolean[] getEditable() {
        return super.getEditable();
    }

    @Override
    public void setEditable(boolean[] editable) {
        PerspectiveIf view = PerspectiveManager.getInstance().getView();
        if (view == null || !view.isTableEditable(this.getClass().getName())) {
            if (editable != null) {
                boolean[] allFalse = new boolean[editable.length];
                for (int i = 0; i < allFalse.length; ++i) {
                    allFalse[i] = false;
                }
                super.setEditable(allFalse);
            }
        } else {
            super.setEditable(editable);
        }
    }

    public int[] getFirstOid() {
        return this._firstOid;
    }

    @Override
    public void setEditable(int index, boolean editable) {
        PerspectiveIf view = PerspectiveManager.getInstance().getView();
        if (view == null || !view.isTableEditable(this.getClass().getName())) {
            super.setEditable(index, false);
        } else {
            super.setEditable(index, editable);
        }
    }

    public void setAttr(String[] vars, String[] prefixes, int index, boolean isScalar) {
        this._isScalar = isScalar;
        this._index = index;
        this._vars = vars;
        this.build(vars, prefixes, this._isScalar ? 1 : 2);
        this.setHeader(0, this._cfsFeatureName != null && this._cfsMasterPeer != null ? "Master" : "Switch");
        if (!this._isScalar) {
            this.setHeader(1, "Id");
        }
    }

    public void setCellChecker(SmTableModelCellChecker[] checkers) {
        this._cellCheckers = checkers;
    }

    public void clear() {
        this.resetChanges(false);
        this.setData(null);
        this.setHeaders(null);
        this.setEditable(null);
        this._stopIndex = -1;
        this._vars = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Array getVars(SnmpPeer[] nodes) throws SnmpException {
        this._responseData = new Array();
        if (nodes == null || nodes.length == 0) {
            return this._responseData;
        }
        this._state = 1;
        this.setData(this._responseData);
        this._timedoutPeers.clear();
        this._queriedPeers = new Array();
        this._firstOid = this._mibNodes[this._offset].getOid();
        this._numOutstanding.set(0);
        Object object = this._numOutstanding.getLock();
        synchronized (object) {
            for (int i = 0; i < nodes.length; ++i) {
                SnmpPDU pdu = this.buildGetPdu(nodes[i], this.getIndex(nodes[i]));
                if (pdu.getVariables().size() == 0) continue;
                nodes[i].send(pdu, this);
                this._numOutstanding.increment();
                this._queriedPeers.addUniqueElement(pdu.getPeer());
            }
        }
        if (this._numOutstanding.get() > 0) {
            this.wait(this._numOutstanding);
        }
        return this._responseData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wait(Object o) {
        try {
            Object object = o;
            synchronized (object) {
                o.wait(this.getWaitTime());
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected int getWaitTime() {
        return SnmpPeer._Timeout * (SnmpPeer._Retries + 1) + 5000;
    }

    protected boolean validateInsertRowVbl(SnmpPeer peer, VarBindList vbl, int state) {
        if (this._validateInsertRowVblSwVerGreaterThanEqual == null) {
            return true;
        }
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        if (!sw.isVersionGreaterThanEqual(this._validateInsertRowVblSwVerGreaterThanEqual)) {
            return true;
        }
        return this.validateVbl(peer, vbl, state);
    }

    protected boolean validateVbl(SnmpPeer peer, VarBindList vbl, int state) {
        block14: {
            int i;
            SnmpVarBind firstVb;
            block13: {
                Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
                if (!sw.isMDS()) {
                    return true;
                }
                firstVb = vbl.getVb(0);
                if (state != 2) break block13;
                int[] firstOid = firstVb.getOid().getValue();
                int[] firstIndex = new int[firstOid.length - this._mibNodes[this._offset].getOid().length];
                System.arraycopy(firstOid, firstOid.length - firstIndex.length, firstIndex, 0, firstIndex.length);
                int mibNodeCol = this._offset + 1;
                for (int vbCol = 1; mibNodeCol < this._mibNodes.length && vbCol < vbl.size(); ++mibNodeCol, ++vbCol) {
                    boolean findMibVar = true;
                    if (this._mibNodes[mibNodeCol] == null) {
                        findMibVar = false;
                        for (int j = mibNodeCol + 1; j < this._mibNodes.length; ++j) {
                            if (this._mibNodes[j] == null) continue;
                            mibNodeCol = j;
                            findMibVar = true;
                            break;
                        }
                    }
                    if (!findMibVar) continue;
                    int[] mibOid = this._mibNodes[mibNodeCol].getOid();
                    SnmpVarBind vb = vbl.getVb(vbCol);
                    int[] curOid = vb.getOid().getValue();
                    if (curOid.length < mibOid.length) {
                        this.repairVb(mibOid, curOid, firstIndex, vb);
                        continue;
                    }
                    int[] curIndex = new int[curOid.length - mibOid.length];
                    System.arraycopy(curOid, curOid.length - curIndex.length, curIndex, 0, curIndex.length);
                    if (SnmpOID.startsWith(mibOid, curOid) && SnmpOID.startsWith(firstIndex, curIndex)) continue;
                    this.repairVb(mibOid, curOid, firstIndex, vb);
                }
                break block14;
            }
            int mibLen = 0;
            for (MibNode mibNode : this._mibNodes) {
                if (mibNode == null) continue;
                ++mibLen;
            }
            for (i = vbl.size() - mibLen; i >= 0; i -= mibLen) {
                if (vbl.get(i).getVar().getType() != 5) continue;
                vbl.removeRange(i, i + mibLen);
            }
            if (vbl.size() == 0) {
                return false;
            }
            if (state != 4) break block14;
            for (i = 0; i < vbl.size(); i += mibLen) {
                VarBindList rowVbl = new VarBindList(mibLen);
                rowVbl.copy(vbl, i, mibLen);
                firstVb = rowVbl.getVb(0);
                int[] firstOid = firstVb.getOid().getValue();
                int[] firstIndex = new int[firstOid.length - this._mibNodes[this._offset].getOid().length];
                System.arraycopy(firstOid, firstOid.length - firstIndex.length, firstIndex, 0, firstIndex.length);
                int mibNodeCol = this._offset + 1;
                for (int vbCol = 1; mibNodeCol < this._mibNodes.length && vbCol < rowVbl.size(); ++mibNodeCol, ++vbCol) {
                    boolean findMibVar = true;
                    if (this._mibNodes[mibNodeCol] == null) {
                        findMibVar = false;
                        for (int j = mibNodeCol + 1; j < this._mibNodes.length; ++j) {
                            if (this._mibNodes[j] == null) continue;
                            mibNodeCol = j;
                            findMibVar = true;
                            break;
                        }
                    }
                    if (!findMibVar) continue;
                    int[] mibOid = this._mibNodes[mibNodeCol].getOid();
                    SnmpVarBind vb = rowVbl.getVb(vbCol);
                    int[] curOid = vb.getOid().getValue();
                    if (curOid.length < mibOid.length) {
                        vb.setVar(new SnmpNull(20));
                        continue;
                    }
                    int[] curIndex = new int[curOid.length - mibOid.length];
                    System.arraycopy(curOid, curOid.length - curIndex.length, curIndex, 0, curIndex.length);
                    if (SnmpOID.startsWith(mibOid, curOid) && SnmpOID.startsWith(firstIndex, curIndex)) continue;
                    vb.setVar(new SnmpNull(20));
                }
            }
        }
        return true;
    }

    protected void repairVb(int[] mibOid, int[] curOid, int[] firstIndex, SnmpVarBind vb) {
        vb.setOid(new SnmpOID(mibOid, firstIndex));
        vb.setVar(new SnmpNull(20));
    }

    public SnmpPDU buildGetPdu(SnmpPeer node, int[] index) {
        VarBindList vbl = this.buildGetVbl(node, index);
        SnmpPDU getPdu = new SnmpPDU(-96, vbl);
        return getPdu;
    }

    public VarBindList buildGetVbl(SnmpPeer node, int[] index) {
        VarBindList vbl = new VarBindList();
        return this.buildGetVbl(vbl, node, index);
    }

    public VarBindList buildGetVbl(VarBindList vbl, SnmpPeer node, int[] index) {
        Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
        MibNode[] mibNodes = this.getMibNodes(sw);
        if (mibNodes != null) {
            for (int i = this._offset; i < mibNodes.length; ++i) {
                if (mibNodes[i] == null) continue;
                vbl.add(new SnmpVarBind(new SnmpOID(mibNodes[i].getOid(), this.buildGetVBLIndex(node, index, i))));
            }
        }
        return vbl;
    }

    protected int[] buildGetVBLIndex(SnmpPeer node, int[] index, int mibNodeIndex) {
        return this.buildGetVBLIndex(index, mibNodeIndex);
    }

    protected int[] buildGetVBLIndex(int[] index, int mibNodeIndex) {
        return index;
    }

    protected int[] getIndex(SnmpPeer node) {
        return this.getIndex();
    }

    protected int[] getIndex() {
        int[] index = new int[]{this._index};
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Array getTableVars(SnmpPeer[] nodes) throws SnmpException {
        this._responseData = new Array();
        if (nodes == null || nodes.length == 0) {
            return this._responseData;
        }
        this.setData(this._responseData);
        this._timedoutPeers.clear();
        this._queriedPeers = new Array();
        this._firstOid = this._mibNodes[this._offset].getOid();
        this._state = 2;
        this._numOutstanding.set(0);
        Object object = this._numOutstanding.getLock();
        synchronized (object) {
            for (int i = 0; i < nodes.length; ++i) {
                SnmpPDU pdu = this.buildGetTablePdu(nodes[i], this.getIndex(nodes[i]));
                if (pdu.getVariables().size() == 0) continue;
                nodes[i].send(pdu, this);
                this._numOutstanding.increment();
                this._queriedPeers.addUniqueElement(pdu.getPeer());
            }
        }
        if (this._numOutstanding.get() > 0) {
            this.wait(this._numOutstanding);
        }
        return this._responseData;
    }

    protected SnmpPDU buildGetTablePdu(SnmpPeer node, int[] index) {
        SnmpPDU pdu = new SnmpPDU(-95, new VarBindList(this._mibNodes.length));
        Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
        MibNode[] mibNodes = this.getMibNodes(sw);
        if (mibNodes != null) {
            for (int j = this._offset; j < mibNodes.length; ++j) {
                if (mibNodes[j] == null) continue;
                pdu.addNull(new SnmpOID(mibNodes[j].getOid(), this.getTableGetNextIndex(node, index, j)));
            }
        }
        return pdu;
    }

    public int[] getTableGetNextIndex(SnmpPeer node, int[] defaultIndex, int col) {
        return defaultIndex;
    }

    public Array getTableVars(MgmtDomainIf mgmtDomain, boolean isScalar) throws SnmpException {
        int view = SmCfsUtil.getInstance().getCfsView(this.getCfsFeatureName(), this.getCfsVsan());
        if (view != -1 && this._cfsView != null) {
            this._cfsView.getButton(view == 1 ? 0 : 1).setSelected(true);
        }
        this._responseData = new Array();
        if (mgmtDomain == null) {
            return this._responseData;
        }
        if (isScalar) {
            return this.getVars(mgmtDomain);
        }
        return this.getTableVars(mgmtDomain);
    }

    public Array getTableVars(MgmtDomainIf mgmtDomain) throws SnmpException {
        return this.getTableVars(this.getWrkingPeers(mgmtDomain));
    }

    public Array getVars(MgmtDomainIf mgmtDomain) throws SnmpException {
        return this.getVars(this.getWrkingPeers(mgmtDomain));
    }

    public Array getTableVars(SmFilter[] invoker) throws SnmpException {
        int view = SmCfsUtil.getInstance().getCfsView(this.getCfsFeatureName(), this.getCfsVsan());
        if (view != -1 && this._cfsView != null) {
            this._cfsView.getButton(view == 1 ? 0 : 1).setSelected(true);
        }
        invoker = this.setCfsInvoker(invoker);
        return this.getTableVars(invoker, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Array getTableVars(SmFilter[] invoker, boolean setViewFilter) throws SnmpException {
        this._responseData = new Array();
        if (invoker == null || invoker.length == 0) {
            return this._responseData;
        }
        if (setViewFilter) {
            this.setViewFilter(invoker);
        }
        this._state = 3;
        this.setData(this._responseData);
        this._timedoutPeers.clear();
        this._queriedPeers = new Array();
        this._firstOid = this._mibNodes[this._offset].getOid();
        ArrayList<SnmpPeer> peersGetNext = new ArrayList<SnmpPeer>();
        this._numOutstanding.set(0);
        Object object = this._numOutstanding.getLock();
        synchronized (object) {
            for (int i = 0; i < invoker.length; ++i) {
                SnmpPeer peer;
                if (invoker[i] == null || !this.isVersionSupported(peer = invoker[i].getSnmpPeer()) || !this.isModelTypeSupported(peer) || !this.validatePeerforFeature(peer)) continue;
                if (peer != null && invoker[i].getIndicesCount() == 0) {
                    peersGetNext.add(peer);
                    continue;
                }
                this._validateVbl = true;
                VarBindList vbl = this.buildGetTableVarsVbl(invoker[i]);
                if (vbl.size() == 0) continue;
                SnmpFetch f = new SnmpFetch();
                f.getWithFixedRoundTripDelay(peer, vbl, this, 10);
                this._numOutstanding.increment();
                this._queriedPeers.addUniqueElement(peer);
            }
        }
        if (this._numOutstanding.get() > 0) {
            this.wait(this._numOutstanding);
            this._tableFiltered = true;
        }
        if (peersGetNext.size() != 0) {
            Array data = this._responseData;
            SnmpPeer[] peers = peersGetNext.toArray(new SnmpPeer[0]);
            Array getEntireTableData = this.getTableVars(peers);
            data.append(getEntireTableData);
            this._responseData = data;
        }
        return this._responseData;
    }

    protected VarBindList buildGetTableVarsVbl(SmFilter invoker) {
        VarBindList vbl = new VarBindList();
        int[][] queryIndices = this.getTableVarsIndices(invoker);
        Switch sw = ClientController.findFabricSwitchByIpAddress(invoker.getSnmpPeer().getAddress());
        MibNode[] mibNodes = this.getMibNodes(sw);
        if (mibNodes != null) {
            for (int j = 0; j < queryIndices.length; ++j) {
                for (int k = this._offset; k < mibNodes.length; ++k) {
                    if (mibNodes[k] == null) continue;
                    int[] mibOid = mibNodes[k].getOid();
                    vbl.add(new SnmpVarBind(new SnmpOID(mibOid, this.getCellGetIndex(sw, k, queryIndices[j]))));
                }
            }
        }
        return vbl;
    }

    protected int[][] getTableVarsIndices(SmFilter invoker) {
        return invoker.getIndices();
    }

    protected int[] getCellGetIndex(Switch sw, int col, int[] defaultIndex) {
        return defaultIndex;
    }

    public Array getMultiIndexedTableVars(MgmtDomainIf mgmtDomain, short type) throws SnmpException {
        if (mgmtDomain.isSan() || mgmtDomain.isFabric()) {
            return null;
        }
        return this.getMultiIndexedTableVars(mgmtDomain.getFilters(type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Array getMultiIndexedTableVars(SmFilter[] invoker) throws SnmpException {
        this._state = 2;
        int view = SmCfsUtil.getInstance().getCfsView(this.getCfsFeatureName(), this.getCfsVsan());
        if (view != -1 && this._cfsView != null) {
            this._cfsView.getButton(view == 1 ? 0 : 1).setSelected(true);
        }
        this.setViewFilter(invoker);
        invoker = this.setCfsInvoker(invoker);
        this._responseData = new Array();
        this.setData(this._responseData);
        this._timedoutPeers.clear();
        this._queriedPeers = new Array();
        this._firstOid = this._mibNodes[this._offset].getOid();
        this._peers2MultiIndexedFilters = new HashMap();
        HashMap<SnmpPeer, Integer> peers2Send = new HashMap<SnmpPeer, Integer>();
        int count = 0;
        for (int i = 0; i < invoker.length; ++i) {
            int j;
            FilterInfo filterInfo;
            int j2;
            SnmpPeer peer;
            if (invoker[i] == null || !this.isVersionSupported(peer = invoker[i].getSnmpPeer()) || !this.isModelTypeSupported(peer) || !this.validatePeerforFeature(peer)) continue;
            count = invoker[i].getIndicesCount();
            int[] sortedIndices = new int[count];
            for (j2 = 0; j2 < count; ++j2) {
                sortedIndices[j2] = invoker[i].getIndex(j2, 0);
            }
            Arrays.sort(sortedIndices);
            for (j2 = 0; j2 < count; ++j2) {
                invoker[i].setIndex(j2, 0, sortedIndices[j2]);
            }
            int startIndex = invoker[i].getIndex(0, 0);
            Integer curPeerStartIndex = (Integer)peers2Send.get(peer);
            if (curPeerStartIndex == null) {
                peers2Send.put(peer, new Integer(startIndex));
                filterInfo = new FilterInfo();
                filterInfo._indices = invoker[i].getIndices();
                filterInfo._step = 0;
                this._peers2MultiIndexedFilters.put(peer, filterInfo);
                continue;
            }
            if (startIndex < curPeerStartIndex) {
                peers2Send.put(peer, new Integer(startIndex));
            }
            filterInfo = (FilterInfo)this._peers2MultiIndexedFilters.get(peer);
            int[] newIndices = new int[filterInfo._indices.length + invoker[i].getIndicesCount()];
            for (j = 0; j < filterInfo._indices.length; ++j) {
                newIndices[j] = filterInfo._indices[j][0];
            }
            for (j = 0; j < invoker[i].getIndicesCount(); ++j) {
                newIndices[j + filterInfo._indices.length] = invoker[i].getIndex(j, 0);
            }
            Arrays.sort(newIndices);
            filterInfo._indices = new int[newIndices.length][1];
            for (j = 0; j < newIndices.length; ++j) {
                filterInfo._indices[j][0] = newIndices[j];
            }
        }
        this._numOutstanding.set(0);
        Object object = this._numOutstanding.getLock();
        synchronized (object) {
            for (SnmpPeer peer : peers2Send.keySet()) {
                int startIndex;
                int[] index;
                SnmpPDU pdu = this.buildGetTablePdu(peer, index = new int[]{startIndex = ((Integer)peers2Send.get(peer)).intValue()});
                if (pdu.getVariables().size() == 0) continue;
                peer.send(pdu, this);
                this._numOutstanding.increment();
                this._queriedPeers.addUniqueElement(pdu.getPeer());
            }
        }
        if (this._numOutstanding.get() > 0) {
            this.wait(this._numOutstanding);
        }
        this._tableFiltered = true;
        return this._responseData;
    }

    public boolean isTableFiltered() {
        return this._tableFiltered;
    }

    public String getTimeouts() {
        return this.getTimeouts(this._timedoutPeers);
    }

    public SnmpPeer[] getLivePeers(SnmpPeer[] nodes) {
        SnmpPeer[] checkNodes;
        SnmpPeer[] snmpPeerArray = checkNodes = nodes == null ? this.getWrkingPeers() : nodes;
        if (checkNodes == null) {
            return null;
        }
        ArrayList<SnmpPeer> livePeers = new ArrayList<SnmpPeer>();
        for (int i = 0; i < checkNodes.length; ++i) {
            if (this._timedoutPeers.find(checkNodes[i]) != -1) continue;
            livePeers.add(checkNodes[i]);
        }
        return livePeers.toArray(new SnmpPeer[livePeers.size()]);
    }

    public String getQueriedPeers() {
        if (this._queriedPeers.size() != 0) {
            return " queried " + this._queriedPeers.size() + " switch" + (this._queriedPeers.size() == 1 ? "" : "es");
        }
        return null;
    }

    public String getTimeouts(Array timedoutPeers) {
        if (timedoutPeers.size() == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(timedoutPeers.size() + " switches timed out: ");
        for (int i = 0; i < timedoutPeers.size(); ++i) {
            sb.append(timedoutPeers.elementAt(i));
            sb.append(',');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public String getStatusUpdate() {
        return null;
    }

    public boolean isPeerTimedOut(SnmpPeer peer) {
        return this._timedoutPeers.find(peer) != -1;
    }

    public synchronized Object[] addElement(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        if (this._outScope) {
            return null;
        }
        Object[] row = this.createRow();
        this._responseData.addElement(row);
        row[0] = node;
        if (index != null) {
            row[1] = index;
        }
        Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
        MibNode[] mibNodes = this.getMibNodes(sw);
        String[] mibVars = this.getMibVars(sw);
        if (mibNodes != null && mibVars != null) {
            int mibCol = 0;
            for (int vblCol = 0; mibCol < mibVars.length && vblCol < vbl.size(); ++mibCol, ++vblCol) {
                boolean findMibVar = true;
                if (mibVars[mibCol] == null) {
                    findMibVar = false;
                    for (int j = mibCol + 1; j < mibVars.length; ++j) {
                        if (mibVars[j] == null) continue;
                        mibCol = j;
                        findMibVar = true;
                        break;
                    }
                }
                if (!findMibVar) continue;
                row[mibCol + this._offset] = this.getCellDisplayString(node, mibNodes[mibCol + this._offset], vbl, vbl.getVb(vblCol), mibVars[mibCol], this._responseData.size() - 1, mibCol + this._offset, index, 0);
            }
        }
        this.updateGetProgress();
        return row;
    }

    protected Object[] createRow() {
        return new Object[this.getHeaders().length + 1];
    }

    public synchronized void updateCols(VarBindList vbl, SnmpPeer node) {
        ArrayList rows = (ArrayList)this._peers2RowsGetCols.get(node);
        RowInfo[] entries = rows.toArray(new RowInfo[rows.size()]);
        Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
        MibNode[] mibNodes = this.getMibNodes(sw);
        if (mibNodes != null) {
            int i;
            int mibLen = 0;
            for (i = 0; i < mibNodes.length; ++i) {
                if (mibNodes[i] == null) continue;
                ++mibLen;
            }
            i = 0;
            int j = 0;
            while (i < vbl.size()) {
                RowInfo entry = entries[j];
                SnmpOID indexSOid = entry._indexSOid;
                Object[] row = entry._rowData;
                int rowIndex = this.getData().find(row);
                this.updateRow(row, node, vbl, i, mibLen, rowIndex, indexSOid);
                i += mibLen;
                ++j;
            }
        }
    }

    protected void updateRow(Object[] row, SnmpPeer node, VarBindList vbl, int indexOfVbl, int mibLen, int rowIndex, SnmpOID index) {
        Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
        MibNode[] mibNodes = this.getMibNodes(sw);
        String[] mibVars = this.getMibVars(sw);
        if (mibNodes != null && mibVars != null) {
            int mibCol = 0;
            for (int vblCol = 0; mibCol < mibVars.length && vblCol < mibLen; ++mibCol, ++vblCol) {
                boolean findMibVar = true;
                if (mibVars[mibCol] == null) {
                    findMibVar = false;
                    for (int j = mibCol + 1; j < mibVars.length; ++j) {
                        if (mibVars[j] == null) continue;
                        mibCol = j;
                        findMibVar = true;
                        break;
                    }
                }
                if (!findMibVar) continue;
                row[mibCol + this._offset] = this.getCellDisplayString(node, this._mibNodes[mibCol + this._offset], vbl, vbl.getVb(indexOfVbl + vblCol), mibVars[mibCol], rowIndex, mibCol + this._offset, index, indexOfVbl);
            }
        }
    }

    protected void updateGetProgress() {
        BrowserFrame.getInstance().setStatus(this.getProgressStatus());
    }

    public String getProgressStatus() {
        int rc = this.getRowCount();
        return rc + " row" + (rc == 1 ? "" : "s");
    }

    public synchronized Object[] addElements(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        int mibLen = 0;
        Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
        MibNode[] mibNodes = this.getMibNodes(sw);
        int[] firstOid = this.getFirstOid(sw);
        if (mibNodes != null) {
            int i;
            for (i = 0; i < mibNodes.length; ++i) {
                if (mibNodes[i] == null) continue;
                ++mibLen;
            }
            if (firstOid != null) {
                for (i = 0; i < vbl.size(); i += mibLen) {
                    SnmpVarBind vb = vbl.getVb(i);
                    int[] oid = vb.getOid().getValue();
                    index = new SnmpOID(oid, firstOid.length, oid.length - firstOid.length);
                    VarBindList rowVbl = new VarBindList(mibLen);
                    rowVbl.copy(vbl, i, mibLen);
                    if (!this.bAddElementRow(rowVbl, node, index, this._state)) continue;
                    this.addElement(rowVbl, node, index);
                }
            }
        }
        return null;
    }

    protected boolean bAddElementRow(VarBindList vbl, SnmpPeer node, SnmpOID index, int state) {
        return true;
    }

    public void addCallbackRow(SnmpPDU pdu, SnmpPeer node, SnmpOID index, int state) {
        if (!this._validateVbl || this._validateVbl && this.validateVbl(node, pdu.getVariables(), state)) {
            this.addElement(pdu.getVariables(), node, index);
        }
    }

    protected synchronized void processGetBulk(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        this.addElements(vbl, node, index);
    }

    public Object getCellDisplayString(SnmpPeer node, MibNode mibNode, VarBindList vbl, SnmpVarBind vb, String var, int row, int col, SnmpOID index, int indexOfVbl) {
        return super.toCell(mibNode, vb.getVar(), var, row);
    }

    public boolean checkSnmpCallbackErr(SnmpPeer node, SnmpPDU pdu, boolean timedOut) {
        if (node == null) {
            DefaultLogger._DefLogger.error((Object)(pdu.getHostAddress() + ": unexpected response"));
            return true;
        }
        if (timedOut || pdu.getError() != 0) {
            if (timedOut) {
                this._timedoutPeers.addElement(node);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        SnmpPeer node = SnmpPeer.findPeer(pdu.getAddress());
        if (!this.checkSnmpCallbackErr(node, pdu, timedOut) && pdu.getVariables().size() > 0 && !this._outScope) {
            if (this._peers2MultiIndexedFilters == null) {
                this.processCallback(node, session, reqid, pdu, timedOut);
            } else {
                this.processMultiIndexedTableCallback(node, session, reqid, pdu, timedOut);
            }
        }
        this._numOutstanding.decrement();
        if (this._numOutstanding.get() <= 0) {
            SyncedInt syncedInt = this._numOutstanding;
            synchronized (syncedInt) {
                this._numOutstanding.notifyAll();
            }
        }
        this.updateTableDisplay();
    }

    public void processCallback(SnmpPeer node, SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        SnmpVarBind vb = pdu.getVariables().getVb(0);
        int[] oid = vb.getOid().getValue();
        Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
        int[] firstOid = this.getFirstOid(sw);
        if (firstOid != null && oid.length >= firstOid.length) {
            SnmpOID index = new SnmpOID(oid, firstOid.length, oid.length - firstOid.length);
            if (this._state == 5) {
                this.processSetCallback(node, session, reqid, pdu, timedOut);
            } else if (this._state == 2) {
                if (!this.isEnd(node, firstOid, vb, index.getValue(), reqid)) {
                    if (!this.isSkip(node, firstOid, vb, index.getValue(), pdu.getVariables(), reqid) && (!this._validateVbl || this._validateVbl && this.validateVbl(node, pdu.getVariables(), this._state))) {
                        this.addElement(pdu.getVariables(), node, index);
                    }
                    if (!this._outScope && this.prepareGetNextPdu(node, pdu.getVariables())) {
                        try {
                            this.sendGetNextPdu(node, pdu);
                            this._numOutstanding.increment();
                        }
                        catch (SnmpException ex) {}
                    }
                }
            } else if (this._state == 1) {
                this.addCallbackRow(pdu, node, index, this._state);
            } else if (this._state == 6) {
                if (!this._validateVbl || this._validateVbl && this.validateVbl(node, pdu.getVariables(), this._state)) {
                    this.updateCols(pdu.getVariables(), node);
                }
            } else if (this._state == 3) {
                if (!this._validateVbl || this._validateVbl && (this._validateGETEntireVbl || this.validateVbl(node, pdu.getVariables(), this._state))) {
                    this.addElements(pdu.getVariables(), node, index);
                }
            } else if (!this.isEnd(node, firstOid, vb, index.getValue(), reqid) && (!this._validateVbl || this._validateVbl && this.validateVbl(node, pdu.getVariables(), this._state))) {
                this.processGetBulk(pdu.getVariables(), node, index);
            }
        }
    }

    protected boolean prepareGetNextPdu(SnmpPeer peer, VarBindList vbl) {
        for (int i = 0; i < vbl.size(); ++i) {
            SnmpVarBind vb = vbl.getVb(i);
            vb.setVar(null);
        }
        return true;
    }

    protected int sendGetNextPdu(SnmpPeer node, SnmpPDU pdu) throws SnmpException {
        pdu.setCommand((byte)-95);
        pdu.setReqid(0);
        return node.send(pdu, this);
    }

    public void processSetCallback(SnmpPeer node, SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
    }

    public void processMultiIndexedTableCallback(SnmpPeer node, SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        SnmpOID index;
        SnmpVarBind vb = pdu.getVariables().getVb(0);
        int[] oid = vb.getOid().getValue();
        Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
        int[] firstOid = this.getFirstOid(sw);
        if (firstOid != null && oid.length >= firstOid.length && !this.isEnd(node, firstOid, vb, (index = new SnmpOID(oid, firstOid.length, oid.length - firstOid.length)).getValue(), reqid)) {
            if (!this.isSkip(node, firstOid, vb, index.getValue(), pdu.getVariables(), reqid) && this.isIndexInRange(node, index)) {
                if (!this._validateVbl || this._validateVbl && this.validateVbl(node, pdu.getVariables(), this._state)) {
                    this.addElement(pdu.getVariables(), node, index);
                }
                for (int i = 0; i < pdu.getVariables().size(); ++i) {
                    vb = pdu.getVariables().getVb(i);
                    vb.setVar(null);
                }
            }
            try {
                if (this.goOnGetNextRow(node, pdu, index) && !this._outScope) {
                    this.sendGetNextPdu(node, pdu);
                    this._numOutstanding.increment();
                }
            }
            catch (SnmpException ex) {
                // empty catch block
            }
        }
    }

    protected boolean goOnGetNextRow(SnmpPeer node, SnmpPDU pdu, SnmpOID indexOid) throws SnmpException {
        int[] curIndex = indexOid.getValue();
        int curIfIndex = curIndex[0];
        FilterInfo filterInfo = (FilterInfo)this._peers2MultiIndexedFilters.get(node);
        if (filterInfo._step >= filterInfo._indices.length) {
            return false;
        }
        if (this.isSubIndexInRange(node, curIfIndex, filterInfo._indices[filterInfo._step][0])) {
            return true;
        }
        ++filterInfo._step;
        if (filterInfo._step < filterInfo._indices.length) {
            int newIfIndex = filterInfo._indices[filterInfo._step][0];
            int[] newIndex = new int[]{newIfIndex};
            pdu = this.buildGetTablePdu(node, newIndex);
            if (pdu.getVariables().size() != 0) {
                node.send(pdu, this);
                this._numOutstanding.increment();
            }
        }
        return false;
    }

    boolean isIndexInRange(SnmpPeer node, SnmpOID indexOid) {
        int[] index = indexOid.getValue();
        int curIndex = index[0];
        FilterInfo filterInfo = (FilterInfo)this._peers2MultiIndexedFilters.get(node);
        if (filterInfo == null) {
            return false;
        }
        return this.isSubIndexInRange(node, curIndex, filterInfo._indices[filterInfo._step][0]);
    }

    protected boolean isSubIndexInRange(SnmpPeer node, int currentTableIndex, int originalStartIndex) {
        return currentTableIndex == originalStartIndex;
    }

    @Override
    public void snmpAggregrate(SnmpPDU pdu, String err) {
        if (err != null && err.length() != 0) {
            this._setErrMsg.addElement(err);
        }
    }

    protected void updateTableDisplay() {
        if (this._responseData.size() == 20 || this._numOutstanding.get() == 0) {
            SwingUtilities.invokeLater(new UpdateTable());
        }
    }

    public void updateTableInfo() {
        this.fireTableDataChanged();
    }

    protected boolean isEnd(SnmpPeer peer, int[] req, SnmpVarBind vb, int[] index, int reqId) {
        if (vb.getError() == 21) {
            return true;
        }
        if (!SnmpOID.startsWith(req, vb.getOid().getValue())) {
            return true;
        }
        return this._stopIndex != -1 && index[0] >= this._stopIndex;
    }

    protected boolean isSkip(SnmpPeer peer, int[] req, SnmpVarBind firstVb, int[] index, VarBindList vbl, int reqId) {
        return false;
    }

    public int[] getCellSetIndex(Cell cell) {
        return this.getIndex(cell._row, cell._col);
    }

    @Override
    public int[] getIndex(int row, int col) {
        return this.getIndex(row);
    }

    @Override
    public int[] getIndex(int row) {
        if (this._isScalar) {
            int[] index = new int[]{this._index};
            return index;
        }
        return ((SnmpOID)this.getValueAt(row, 1)).getValue();
    }

    public int getTableIndex() {
        return this._index;
    }

    protected int[] getEditIndex(int row) {
        return this.getIndex(row);
    }

    public int getVarIndex(String var) {
        for (int i = 0; i < this._vars.length; ++i) {
            if (this._vars[i] == null || !this._vars[i].equals(var)) continue;
            return i + this._offset;
        }
        return -1;
    }

    public boolean applyChangesAction() throws Exception {
        this._setErrMsg.clear();
        boolean bchangesApplied = this.applyChanges();
        this.postErrorMsg();
        return bchangesApplied;
    }

    public boolean applyChanges() throws Exception {
        return this.applyChanges(this);
    }

    public boolean applyChanges(SnmpAggregrateIf applyChangesCallback) throws Exception {
        this._state = 5;
        HashMap pdus = this.buildSendPdus();
        if (pdus == null || pdus.size() == 0) {
            return false;
        }
        int successfulSets = this.applyChangesSet(pdus, applyChangesCallback);
        if (successfulSets == 0) {
            return false;
        }
        if (successfulSets < pdus.size()) {
            int failedSets = pdus.size() - successfulSets;
            this._setErrMsg.addElement("Failed on " + failedSets + " of " + pdus.size() + " device(s).");
            return false;
        }
        SmCfsUtil.getInstance().processCfs(this, this.getCfsFeatureName(), this.getCfsVsan(), 2);
        if (this._refreshChangedRow) {
            this.getTableCols();
        }
        return true;
    }

    public int applyChangesSet(HashMap pdus, SnmpAggregrateIf applyChangesCallback) throws Exception {
        SnmpAggregrate aggregrate = new SnmpAggregrate();
        int successfulSets = aggregrate.set(pdus.keySet().iterator(), pdus.values().iterator(), pdus.values().iterator(), applyChangesCallback, this._fragPduOnByte);
        return successfulSets;
    }

    protected HashMap buildSendPdus() throws Exception {
        this._fragPduOnByte = false;
        Array cells = this.getChangeCells();
        if (cells == null) {
            return null;
        }
        Array warningMsg = new Array();
        if (this._cellCheckers != null) {
            this.resetCheckerPostFlag();
        }
        HashMap pdus = new HashMap();
        this.addChangedCells2Pdu(pdus, cells, warningMsg);
        if (warningMsg.size() != 0) {
            for (int i = 0; i < warningMsg.size(); ++i) {
                if (!this.promptWarning((String)warningMsg.elementAt(i))) continue;
                return null;
            }
        }
        return pdus;
    }

    protected boolean promptWarning(String message) {
        return JOptionPane.showConfirmDialog(BrowserFrame.getDataView(), message, "Select an Option", 0) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getTableCols() throws SnmpException {
        VarBindList vbl;
        this._peers2RowsGetCols.clear();
        HashMap<SnmpPeer, VarBindList> peers2Vbl = new HashMap<SnmpPeer, VarBindList>();
        Array cells = this.getChangeCells();
        Array data = this.getData();
        for (int i = 0; i < cells.size(); ++i) {
            Cell cell = (Cell)cells.elementAt(i);
            SnmpPeer node = this.getRowPeer(cell._row);
            Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
            if (!sw.isMDS()) continue;
            Object[] rowData = (Object[])data.elementAt(cell._row);
            ArrayList<RowInfo> rows = (ArrayList<RowInfo>)this._peers2RowsGetCols.get(node);
            vbl = (VarBindList)peers2Vbl.get(node);
            if (rows == null) {
                rows = new ArrayList<RowInfo>();
                this._peers2RowsGetCols.put(node, rows);
                vbl = new VarBindList();
                peers2Vbl.put(node, vbl);
            }
            SnmpOID indexSOid = !this._isScalar ? (SnmpOID)this.getValueAt(cell._row, 1) : new SnmpOID(this.getIndex(cell._row));
            boolean addRow = true;
            if (rows.size() != 0) {
                for (int j = 0; j < rows.size(); ++j) {
                    RowInfo rowinfo = (RowInfo)rows.get(j);
                    if (!indexSOid.equals(rowinfo._indexSOid)) continue;
                    addRow = false;
                    break;
                }
            }
            if (!addRow) continue;
            rows.add(new RowInfo(indexSOid, rowData));
            int[] index = indexSOid.getValue();
            this.buildGetVbl(vbl, node, index);
        }
        this._state = 6;
        this._numOutstanding.set(0);
        Object object = this._numOutstanding.getLock();
        synchronized (object) {
            for (SnmpPeer peer : peers2Vbl.keySet()) {
                vbl = (VarBindList)peers2Vbl.get(peer);
                SnmpFetch f = new SnmpFetch();
                this.fetchTableCols(f, peer, vbl);
                this._numOutstanding.increment();
            }
        }
        if (this._numOutstanding.get() > 0) {
            this.wait(this._numOutstanding);
        }
    }

    @Override
    public boolean isPopulated() {
        return this._numOutstanding.get() == 0;
    }

    @Override
    protected SnmpPeer getRowPeer(int row) {
        return (SnmpPeer)this.getValueAt(row, 0);
    }

    protected void fetchTableCols(SnmpFetch f, SnmpPeer peer, VarBindList vbl) throws SnmpException {
        f.get(peer, vbl, this);
    }

    protected Array getChangeCells() {
        return super.getChanged();
    }

    protected void addChangedCells2Pdu(HashMap pdus, Array cells, Array warningMsg) throws Exception {
        for (int i = 0; i < cells.size(); ++i) {
            Cell cell = (Cell)cells.elementAt(i);
            this.addCell2Pdu(pdus, cells, cell, warningMsg);
        }
    }

    protected void addCell2Pdu(HashMap pdus, Array cells, Cell cell, Array warningMsg) throws Exception {
        String msg;
        SnmpPeer node = this.getRowPeer(cell._row);
        if (node == null) {
            return;
        }
        SnmpPDU pdu = (SnmpPDU)pdus.get(node);
        if (pdu == null) {
            pdu = new SnmpPDU(-93, new VarBindList());
            pdu.setAddress(node.getAddress());
            pdus.put(node, pdu);
        }
        int[] index = this.getCellSetIndex(cell);
        SnmpOID oid = this.getCellOid(cell, index, node);
        SnmpVar changedCellVar = this.processChangedCell(cell, pdu, oid, index);
        if (this._cellCheckers != null && changedCellVar != null && (msg = this.checkChangedCell(node, oid, changedCellVar)) != null) {
            warningMsg.addElement(msg);
        }
    }

    protected SnmpOID getCellOid(Cell cell, int[] index, SnmpPeer node) {
        Switch sw;
        MibNode[] mibNodes;
        if (node != null && (mibNodes = this.getMibNodes(sw = ClientController.findFabricSwitchByIpAddress(node.getAddress()))) != null) {
            return new SnmpOID(mibNodes[cell._col].getOid(), index);
        }
        return null;
    }

    protected SnmpVar processChangedCell(Cell cell, SnmpPDU pdu, SnmpOID changedCellOid, int[] index) throws Exception {
        SnmpVar changedCellVar = this.getChangedCellVar(cell._row, cell._col, changedCellOid, index);
        if (changedCellVar != null) {
            pdu.addVar(changedCellOid, changedCellVar);
        }
        return changedCellVar;
    }

    protected SnmpVar getChangedCellVar(int row, int col, SnmpOID changedCellOid, int[] index) throws Exception {
        SnmpPeer node = (SnmpPeer)this.getValueAt(row, 0);
        Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
        MibNode[] mibNodes = this.getMibNodes(sw);
        if (mibNodes != null) {
            return this.getChangedCell(row, col, mibNodes);
        }
        return null;
    }

    protected MibNode[] getMibNodes(Switch sw) {
        MibNode[] mibNodes = null;
        if (sw.isMDS()) {
            mibNodes = this._mibNodes;
        } else if (this._switch2MibNodes != null) {
            mibNodes = (MibNode[])this._switch2MibNodes.get(sw.getModelType());
        }
        return mibNodes;
    }

    protected String[] getMibVars(Switch sw) {
        String[] mibVars = null;
        MibNode[] mibNodes = this.getMibNodes(sw);
        if (this._mibNodes == mibNodes) {
            mibVars = this._mibVars;
        } else if (this._switch2MibVars != null) {
            mibVars = (String[])this._switch2MibVars.get(sw.getModelType());
        }
        return mibVars;
    }

    protected int[] getFirstOid(Switch sw) {
        int[] firstOid = null;
        MibNode[] mibNodes = this.getMibNodes(sw);
        if (this._mibNodes == mibNodes) {
            firstOid = this._firstOid;
        } else if (mibNodes != null) {
            int firstIndex;
            for (firstIndex = this._offset; mibNodes[firstIndex] == null && firstIndex < mibNodes.length; ++firstIndex) {
            }
            if (mibNodes[firstIndex] != null) {
                firstOid = mibNodes[firstIndex].getOid();
            }
        }
        return firstOid;
    }

    protected String checkChangedCell(SnmpPeer peer, SnmpOID changedCellOid, SnmpVar changedCellVar) {
        for (int i = 0; i < this._cellCheckers.length; ++i) {
            SmTableModelCellChecker checker = this._cellCheckers[i];
            if (changedCellOid == null || !changedCellOid.startsWith(checker._mibOid) || checker._bMsgPosted) continue;
            checker._bMsgPosted = true;
            if (!checker.doCheck(peer, changedCellOid, changedCellVar)) continue;
            if (checker._bWarnOnChange) {
                return checker._warningMsg;
            }
            for (int j = 0; j < checker._values.length; ++j) {
                int cellValue = ((SnmpInt)changedCellVar).getValue();
                if (cellValue != checker._values[j]) continue;
                if (checker._version != null) {
                    ClientController.getInstance();
                    Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
                    if (sw == null || !sw.isVersionGreaterThanEqual(checker._version)) continue;
                    return checker._warningMsg;
                }
                return checker._warningMsg;
            }
        }
        return null;
    }

    public void resetCheckerPostFlag() {
        for (int i = 0; i < this._cellCheckers.length; ++i) {
            SmTableModelCellChecker checker = this._cellCheckers[i];
            checker._bMsgPosted = false;
        }
    }

    public boolean deleteRowsAction(int[] rows) throws Exception {
        if (DataView._ConfirmRowDeletion && JOptionPane.showOptionDialog(BrowserFrame.getDataView(), "Please confirm deletion", "DCNM-SAN", 0, 2, null, new String[]{"Yes", "No"}, "No") != 0) {
            return false;
        }
        this._setErrMsg.clear();
        BrowserFrame.getDataView().setCursor(Cursor.getPredefinedCursor(3));
        this.deleteRows(rows);
        BrowserFrame.getDataView().setCursor(Cursor.getDefaultCursor());
        SmCfsUtil.getInstance().processCfs(this, this.getCfsFeatureName(), this.getCfsVsan(), 2);
        this.postErrorMsg();
        return true;
    }

    public void deleteRows(int[] rows) throws Exception {
        this.deleteRows(rows, this);
    }

    public void deleteRows(int[] rows, SnmpAggregrateIf deleteRowCallback) throws Exception {
        this._state = 5;
        HashMap<SnmpPeer, SnmpPDU> pdus = new HashMap<SnmpPeer, SnmpPDU>();
        for (int i = 0; i < rows.length; ++i) {
            SnmpPeer node = this.getRowPeer(rows[i]);
            SnmpPDU pdu = (SnmpPDU)pdus.get(node);
            if (pdu == null) {
                pdu = new SnmpPDU(-93, new VarBindList());
                pdu.setAddress(node.getAddress());
                pdus.put(node, pdu);
            }
            this.processDeleteRow(node, pdu, rows[i]);
        }
        SnmpAggregrate aggregrate = this.getDeleteSnmpAggregrate();
        int successfulSets = aggregrate.set(pdus.keySet().iterator(), pdus.values().iterator(), deleteRowCallback);
        if (successfulSets < pdus.size()) {
            int failedSets = pdus.size() - successfulSets;
            this._setErrMsg.addElement("Failed on " + failedSets + " of " + pdus.size() + " device(s).");
        }
    }

    protected SnmpAggregrate getDeleteSnmpAggregrate() {
        return new SnmpAggregrate();
    }

    protected SnmpPDU processDeleteRow(SnmpPeer node, SnmpPDU pdu, int rowN) {
        pdu.addVar(new SnmpOID(this._rowStatus, this.getIndex(rowN)), new SnmpInt(this._deleteValue));
        return pdu;
    }

    protected void postDeleteRowsAction() throws Exception {
    }

    public void postErrorMsg() throws Exception {
        if (this._setErrMsg.size() == 0) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this._setErrMsg.size(); ++i) {
            sb.append(this._setErrMsg.elementAt(i));
            sb.append('\n');
            if (i != 50) continue;
            sb.append("...see log for details.\n");
            throw new SnmpException(sb.toString());
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
            throw new Exception('\n' + sb.toString());
        }
    }

    protected void setRowStatus(int[] rowStatus, int insertValue, int deleteValue, String[] indexVars) {
        this._rowStatus = rowStatus;
        this._insertValue = insertValue;
        this._deleteValue = deleteValue;
        this._indexVars = indexVars;
        this._insertFormClass = InsertForm.class;
    }

    public void setInsertFormClass(Class c) {
        this._insertFormClass = c;
    }

    public void setInsertFormVars(String[] insertFormVars) {
        this._insertFormVars = insertFormVars;
    }

    public String[] getInsertVars() {
        if (this._insertFormVars != null) {
            return this._insertFormVars;
        }
        String[] insertVars = new String[this._indexVars.length + this._vars.length];
        System.arraycopy(this._indexVars, 0, insertVars, 0, this._indexVars.length);
        System.arraycopy(this._vars, 0, insertVars, this._indexVars.length, this._vars.length);
        int numRemoved = 0;
        for (int i = this._indexVars.length; i < insertVars.length; ++i) {
            if (this.isMIBVarCreatable(insertVars[i])) continue;
            insertVars[i] = null;
            ++numRemoved;
        }
        if (numRemoved > 0) {
            String[] iVars = new String[insertVars.length - numRemoved];
            int j = 0;
            for (int i = 0; i < insertVars.length; ++i) {
                if (insertVars[i] == null) continue;
                iVars[j++] = insertVars[i];
            }
            insertVars = iVars;
        }
        return insertVars;
    }

    protected boolean isMIBVarCreatable(String mibName) {
        return MibNode.get(mibName).isCreatable();
    }

    @Override
    protected IfIndexIf getIfIndexIf(int row) {
        SnmpPeer peer;
        Switch sw;
        Object[] rowData = (Object[])this.getData().elementAt(row);
        if (rowData[0] instanceof SnmpPeer && (sw = ClientController.findFabricSwitchByIpAddress((peer = (SnmpPeer)rowData[0]).getAddress())) != null) {
            return sw;
        }
        return _IfIndexIf;
    }

    @Override
    protected SysUpTimeIf getSysUpTimeIf(int row) {
        if (this._responseData != null && this._responseData.size() > 0 && row >= 0) {
            SnmpPeer peer = (SnmpPeer)((Object[])this._responseData.elementAt(row))[0];
            return ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        }
        return null;
    }

    void setVarEditable(String varName, boolean editable) {
        boolean[] isEditable = this.getEditable();
        for (int i = 0; i < this._vars.length; ++i) {
            if (this._vars[i] == null || !this._vars[i].equals(varName)) continue;
            isEditable[i + this._offset] = editable;
        }
        this.setEditable(isEditable);
    }

    protected void selectionAction(SnmpKTable table) {
        this.mapSelectDevice(table);
    }

    @Override
    public void initialize() {
    }

    @Override
    public void cleanup() {
        this._outScope = true;
        SelectionAction.getInstance().clearSelection();
        this.restoreFilter4CFS();
    }

    private void restoreFilter4CFS() {
        if (this._cfsFeatureName != null && this._cfsVsan != null && this._oldFilters != null) {
            this.setViewFilter(this._oldFilters);
        }
    }

    public void setInsertDlg(InsertDialog insertDlg) {
        this._myInsertDlg = insertDlg;
    }

    public InsertDialog getInsertDlg() {
        return this._myInsertDlg;
    }

    public boolean isMyInsertDlg() {
        InsertDialog insertDlg = BrowserFrame.getDataView().getInsertDlg();
        return insertDlg == this._myInsertDlg;
    }

    protected void setSpecialAttr() {
    }

    protected boolean ApplyBtnOn() {
        return false;
    }

    protected boolean RefreshBtnOn() {
        return true;
    }

    protected void refresh() {
    }

    protected String getInsertTitle(SnmpKTable table) {
        return null;
    }

    protected String getInsertTitleDetail(SnmpKTable table) {
        return null;
    }

    protected String getEditTitle(SnmpKTable table) {
        return "Details ";
    }

    protected boolean enableEdit(SnmpKTable table) {
        return false;
    }

    protected void tableSelectionChanged(boolean selected, SnmpKTable table) {
    }

    public void mapSelectLink(SnmpKTable table) {
        int[] sels = table.getSelectedRows();
        Array data = this.getData();
        ArrayList<Object> linkList = new ArrayList<Object>();
        for (int i = 0; i < sels.length; ++i) {
            int row = sels[i];
            Object[] rowData = (Object[])data.elementAt(row);
            Object target = rowData[rowData.length - 1];
            linkList.add(target);
        }
        SelectionAction.getInstance().setObjects(null, linkList);
        SelectionAction.getInstance().execute();
    }

    public void mapSelectDevice(SnmpKTable table) {
        this.mapSelectDevice(table, false);
    }

    public void mapSelectDevice(SnmpKTable table, boolean selectLink) {
        int[] sels = table.getSelectedRows();
        Array data = this.getData();
        ArrayList<Object> devList = new ArrayList<Object>();
        ArrayList linkList = selectLink ? new ArrayList() : null;
        for (int i = 0; i < sels.length; ++i) {
            int row = sels[i];
            Object[] rowData = (Object[])data.elementAt(row);
            Object target = this.getDevicebject(rowData);
            if (target == null) continue;
            if (target instanceof SnmpPeer) {
                Switch sw = ClientController.findFabricSwitchByIpAddress(((SnmpPeer)target).getAddress());
                if (sw != null) {
                    devList.add(sw);
                }
            } else {
                devList.add(target);
            }
            if (!selectLink) continue;
            this.addSelectedRowLink(rowData, linkList);
        }
        SelectionAction.getInstance().setObjects(devList, linkList);
        SelectionAction.getInstance().execute();
    }

    protected void setIfIndexOffset(int ifIndexOffset) {
        this._ifIndexOffset = ifIndexOffset;
    }

    protected void addSelectedRowLink(Object[] rowData, ArrayList linkList) {
        Switch sw;
        Object devObj = this.getDevicebject(rowData);
        if (devObj == null) {
            return;
        }
        int ifIndex = this.getSelectedRowLinkIfIndex(rowData);
        if (devObj instanceof SnmpPeer && (sw = ClientController.findFabricSwitchByIpAddress(((SnmpPeer)devObj).getAddress())) != null) {
            Isl isl = sw.getFabric().findIslBySwitchIfIndex(sw, ifIndex);
            if (isl != null) {
                linkList.add(isl);
            } else {
                ArrayList<EndPort> eps = sw.getFabric().findEndPortsBySwitchIfIndex(sw, ifIndex);
                if (eps != null) {
                    for (int i = 0; i < eps.size(); ++i) {
                        linkList.add(eps.get(i));
                    }
                }
            }
        }
    }

    protected int getSelectedRowLinkIfIndex(Object[] rowData) {
        int[] oid = ((SnmpOID)rowData[1]).getValue();
        return oid[this._ifIndexOffset];
    }

    protected Object getDevicebject(Object[] rowData) {
        return rowData[0];
    }

    public int[] getRowStatus() {
        return this._rowStatus;
    }

    public int getInsertValue() {
        return this._insertValue;
    }

    public int getDeleteValue() {
        return this._deleteValue;
    }

    protected SnmpPeer[] getWrkingPeers() {
        return this.getWrkingPeers(ClientController.getInstance().getSelectedDomain());
    }

    protected SnmpPeer[] getWrkingPeers(MgmtDomainIf mgmtDomain) {
        if (this._wrkingPeers != null) {
            return this._wrkingPeers;
        }
        if (mgmtDomain == null) {
            mgmtDomain = ClientController.getInstance().getSelectedDomain();
        }
        if (this._cfsFeatureName != null) {
            return this.getWrkingPeersCfs(mgmtDomain);
        }
        return this.getWrkingPeersGeneral(mgmtDomain);
    }

    protected SnmpPeer[] getWrkingPeersCfs(MgmtDomainIf mgmtDomain) {
        String lookupIndex = this._cfsFeatureName;
        if (this._cfsVsan != null) {
            lookupIndex = this._cfsFeatureName + Integer.toString(this._cfsVsan.getVsanId());
        }
        if (this._cfsMasterPeer == null) {
            this._cfsMasterPeer = SmCfsUtil.getInstance().getMaster(lookupIndex);
        }
        if (this._cfsMasterPeer != null) {
            this._wrkingPeers = new SnmpPeer[]{this._cfsMasterPeer};
            return this._wrkingPeers;
        }
        return this.getWrkingPeersGeneral(mgmtDomain);
    }

    public SnmpPeer getCfsMaster() {
        return this._cfsMasterPeer;
    }

    protected SnmpPeer[] getWrkingPeersGeneral(MgmtDomainIf mgmtDomain) {
        if (mgmtDomain == null) {
            return null;
        }
        SnmpPeer[] peers = null;
        if (mgmtDomain.isVsan() && this._ignoreSegmentedVsan) {
            short vsanId = ((Vsan)mgmtDomain).getId();
            Fabric f = mgmtDomain.getFabric();
            Vsan[] vsans = f.getVsansById(vsanId);
            ArrayList<SnmpPeer> peerList = new ArrayList<SnmpPeer>();
            for (int i = 0; i < vsans.length; ++i) {
                SnmpPeer[] peersInVsan = vsans[i].getSnmpPeers(this._needQuail);
                for (int j = 0; j < peersInVsan.length; ++j) {
                    peerList.add(peersInVsan[j]);
                }
            }
            peers = peerList.toArray(new SnmpPeer[peerList.size()]);
        } else {
            peers = mgmtDomain.getSnmpPeers(this._needQuail);
        }
        if (peers == null || peers.length == 0) {
            return null;
        }
        return this.getWrkingPeers(peers);
    }

    protected SnmpPeer[] getWrkingPeers(SnmpPeer[] peers) {
        ArrayList<SnmpPeer> peersValid = new ArrayList<SnmpPeer>(peers.length);
        for (int i = 0; i < peers.length; ++i) {
            if (!this.isModelTypeSupported(peers[i]) || !this.isVersionSupported(peers[i])) continue;
            peersValid.add(peers[i]);
        }
        this._wrkingPeers = peersValid.toArray(new SnmpPeer[peersValid.size()]);
        return this.getFeatureCtrlPeers(this._wrkingPeers);
    }

    protected SnmpPeer[] getFeatureCtrlPeers(SnmpPeer[] peers) {
        if (this._featurectrlIndices != null) {
            ArrayList<SnmpPeer> validFeaturePeers = new ArrayList<SnmpPeer>();
            for (int i = 0; i < peers.length; ++i) {
                if (!this.validatePeerforFeature(peers[i])) continue;
                validFeaturePeers.add(peers[i]);
            }
            this._wrkingPeers = validFeaturePeers.size() == 0 ? null : validFeaturePeers.toArray(new SnmpPeer[validFeaturePeers.size()]);
        }
        return this._wrkingPeers;
    }

    boolean validatePeerforFeature(SnmpPeer peer) {
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        if (this._featurectrlIndices != null && (this._featureCtrlVersion == null || this._featureCtrlVersion != null && sw.isVersionGreaterThanEqual(this._featureCtrlVersion))) {
            for (int j = 0; j < this._featurectrlIndices.length; ++j) {
                ArrayList featurePeerList = SmFeatureCtrlUtil.getInstance().getPeerList(this._featurectrlIndices[j][0]);
                if (featurePeerList != null && (featurePeerList == null || featurePeerList.contains(peer))) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean isModelTypeSupported(SnmpPeer peer) {
        boolean flag = true;
        if (this._unSupportedSwitchModelTypes != null) {
            Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
            for (int modelType : this._unSupportedSwitchModelTypes) {
                if (modelType != sw.getModelType()) continue;
                flag = false;
                break;
            }
        }
        return flag;
    }

    protected boolean isVersionSupported(SnmpPeer peer) {
        boolean bGreater = true;
        boolean bLess = true;
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        if (sw == null) {
            return false;
        }
        if (!sw.isMDS()) {
            return true;
        }
        if (this._swVersionSupportedGreaterThan != null || this._swVersionSupportedGreaterThanEqual != null) {
            boolean bl = bGreater = this._swVersionSupportedGreaterThan != null ? sw.isVersionGreaterThan(this._swVersionSupportedGreaterThan) : sw.isVersionGreaterThanEqual(this._swVersionSupportedGreaterThanEqual);
        }
        if (this._swVersionSupportedLessThan != null || this._swVersionSupportedLessThanEqual != null) {
            bLess = this._swVersionSupportedLessThan != null ? sw.isVersionLessThan(this._swVersionSupportedLessThan) : sw.isVersionLessThanEqual(this._swVersionSupportedLessThanEqual);
        }
        return bGreater && bLess;
    }

    public void setWrkingPeers(SnmpPeer[] peers) {
        this._wrkingPeers = peers;
    }

    protected void removePeerFromWrkingPeers(SnmpPeer peer) {
        ArrayList<SnmpPeer> newPeers = new ArrayList<SnmpPeer>();
        for (int i = 0; i < this._wrkingPeers.length; ++i) {
            if (this._wrkingPeers[i] == peer) continue;
            newPeers.add(this._wrkingPeers[i]);
        }
        this._wrkingPeers = newPeers.toArray(new SnmpPeer[newPeers.size()]);
    }

    public void setUnSupportedSwitchModelTypes(int[] modelTypes) {
        this._unSupportedSwitchModelTypes = modelTypes;
    }

    public void setSwVersionSupportedGreaterThan(String swVersionSupportedGreaterThan) {
        this._swVersionSupportedGreaterThan = swVersionSupportedGreaterThan;
    }

    public void setSwVersionSupportedGreaterThanEqual(String swVersionSupportedGreaterThanEqual) {
        this._swVersionSupportedGreaterThanEqual = swVersionSupportedGreaterThanEqual;
    }

    public void setSwVersionSupportedLessThan(String swVersionSupportedLessThan) {
        this._swVersionSupportedLessThan = swVersionSupportedLessThan;
    }

    public void setSwVersionSupportedLessThanEqual(String swVersionSupportedLessThanEqual) {
        this._swVersionSupportedLessThanEqual = swVersionSupportedLessThanEqual;
    }

    public void setRefreshChangedRow(boolean refreshChangedRow) {
        this._refreshChangedRow = refreshChangedRow;
    }

    public boolean getRefreshChangedRow() {
        return this._refreshChangedRow;
    }

    protected void setViewFilter(SmFilter[] filter) {
        DataView dv = BrowserFrame.getDataView();
        dv._filter = filter;
    }

    protected void setIgnoreSegmentedVsan(boolean ignoreSegmentedVsan) {
        this._ignoreSegmentedVsan = ignoreSegmentedVsan;
    }

    protected boolean getIgnoreSegmentedVsan() {
        return this._ignoreSegmentedVsan;
    }

    public void setIndexTranslationNeedSwitch(boolean indexTranslationNeedSwitch) {
        this._indexTranslationNeedSwitch = indexTranslationNeedSwitch;
    }

    protected boolean getIndexTranslationNeedSwitch() {
        return this._indexTranslationNeedSwitch;
    }

    protected void setCfsFeatureName(String cfsFeatureName) {
        this.setCfsFeatureName(cfsFeatureName, null);
    }

    protected void setCfsFeatureName(String cfsFeatureName, Vsan vsan) {
        this._cfsFeatureName = cfsFeatureName;
        this._cfsVsan = vsan;
        String lookupIndex = this._cfsFeatureName;
        if (this._cfsVsan != null) {
            lookupIndex = this._cfsFeatureName + Integer.toString(this._cfsVsan.getVsanId());
        }
        this._cfsMasterPeer = SmCfsUtil.getInstance().getMaster(lookupIndex);
        if (this._cfsMasterPeer != null) {
            this.addCfsDataViewPanel();
        }
    }

    public String getCfsFeatureName() {
        return this._cfsFeatureName;
    }

    protected void addCfsDataViewPanel() {
        DataView dataView = BrowserFrame.getDataView();
        JPanel actPanel = new JPanel(new FlowLayout(0, 2, 2));
        this._cfsView = new RadioButtonPanel(new String[]{"Running", "Pending"});
        cfsViewListenerSource sourceListener = new cfsViewListenerSource();
        for (int i = 0; i < this._cfsView.getComponentCount(); ++i) {
            this._cfsView.getButton(i).addActionListener(sourceListener);
        }
        actPanel.add(this._cfsView);
        JPanel newToolbar = new JPanel(new FlowLayout(2, 2, 2));
        newToolbar.add(dataView.getButtonPanel());
        newToolbar.add(actPanel);
        dataView.replaceButtonPanel(newToolbar);
    }

    public RadioButtonPanel getCfsPanel() {
        return this._cfsView;
    }

    protected Vsan getCfsVsan() {
        return this._cfsVsan;
    }

    protected void setFeatureCtrlIndices(int[][] featurectrlIndices, String featureCtrlVersion) {
        this._featurectrlIndices = featurectrlIndices;
        this._featureCtrlVersion = featureCtrlVersion;
    }

    protected int[][] getFeatureCtrlIndices() {
        return this._featurectrlIndices;
    }

    protected boolean enableApplyOnChange(boolean requestToEnable, TableModelEvent e) {
        return requestToEnable;
    }

    protected int calcColWidth(SnmpKTable table) {
        if (!this._isStatsTable) {
            return table.colWidthToWidest();
        }
        return this.calcStatsColWidth(table);
    }

    protected void setisStatsTable(boolean isStatsTable) {
        this._isStatsTable = isStatsTable;
    }

    protected boolean getisStatsTable() {
        return this._isStatsTable;
    }

    protected int calcStatsColWidth(SnmpKTable t) {
        FontMetrics fm = t.getFontMetrics(t.getFont());
        int maxCellWidth = fm.stringWidth("999.999M");
        int width = 0;
        for (int i = 0; i < t.getColumnCount(); ++i) {
            int w = t.getHeaderColumnWidth(fm, i);
            if (w < maxCellWidth) {
                w = maxCellWidth;
            }
            t.getColumnModel().getColumn(i).setPreferredWidth(w);
            width += w + 1;
        }
        return width;
    }

    protected void setEditMethod(String editMethod) {
        this._editMethod = editMethod;
    }

    protected boolean enableDetailButton(SnmpKTable table) {
        boolean selected = this.getRowCount() > 0 && table.getSelectedRowCount() > 0;
        return selected && this._editMethod != null;
    }

    protected boolean showDetailButton() {
        return this._editMethod != null;
    }

    protected boolean showCfsButton() {
        return this._cfsMasterPeer != null;
    }

    protected boolean enableDeleteButton(SnmpKTable table) {
        return this._rowStatus != null && this.getRowCount() > 0 && table.getSelectedRowCount() > 0;
    }

    protected boolean removeRow(int row) {
        return true;
    }

    public void addSwitchMibVars(int switchType, String[] mibVars) {
        if (this._switch2MibVars == null) {
            this._switch2MibVars = new IntHashMap();
        }
        this._switch2MibVars.put(switchType, mibVars);
        MibNode[] mibNodes = new MibNode[this._mibNodes.length];
        for (int i = this._offset; i < mibNodes.length; ++i) {
            if (mibVars[i - this._offset] == null) continue;
            mibNodes[i] = MibNode.get(mibVars[i - this._offset]);
        }
        if (this._switch2MibNodes == null) {
            this._switch2MibNodes = new IntHashMap();
        }
        this._switch2MibNodes.put(switchType, mibNodes);
        boolean[] editable = this.getEditable();
        if (editable != null) {
            for (int i = this._offset; i < mibNodes.length; ++i) {
                if (mibNodes[i] == null) continue;
                if (!editable[i]) {
                    editable[i] = mibNodes[i].isEditable();
                }
                if (!editable[i] || this._isEditable) continue;
                this._isEditable = true;
            }
        }
        this.setEditable(editable);
    }

    public void setCellEditor(SnmpKTable table) {
        if (this._mibNodes != null) {
            table.addEnumCellEditor(this._mibNodes);
            table.addCellEditor(this._mibNodes);
        }
        if (this._switch2MibNodes != null) {
            int[] keys = this._switch2MibNodes.keys();
            for (int i = 0; i < keys.length; ++i) {
                MibNode[] mibNodes3rdParty = (MibNode[])this._switch2MibNodes.get(keys[i]);
                table.addEnumCellEditor(mibNodes3rdParty);
                table.addCellEditor(mibNodes3rdParty);
            }
        }
    }

    public void setNeedQuailPeer(boolean needQuail) {
        this._needQuail = needQuail;
    }

    public void setCheckForEmptyColumns(boolean checkForEmptyColumns) {
        this._checkForEmptyColumns = checkForEmptyColumns;
    }

    public boolean getCheckForEmptyColumns() {
        return this._checkForEmptyColumns;
    }

    @Override
    protected Object getSortColumnObj(Object row) {
        TableCellRenderer r;
        SnmpKTable table = BrowserFrame.getDataView()._table;
        int viewCol = table.convertColumnIndexToView(this._sortColumn);
        if (viewCol <= 1 && (r = table.getColumnModel().getColumn(viewCol).getCellRenderer()) instanceof IndexCellRenderer) {
            IndexCellRenderer icr = (IndexCellRenderer)r;
            Object colObj = ((Object[])row)[this._sortColumn];
            Object peer = ((Object[])row)[0];
            int[] index = ((SnmpOID)colObj).getValue();
            if (this._indexTranslationNeedSwitch) {
                return icr.getLabel(index, peer);
            }
            return icr.getLabel(index);
        }
        return super.getSortColumnObj(row);
    }

    @Override
    public int compareTo(Object o1, Object o2) {
        TableCellRenderer r;
        SnmpKTable table = BrowserFrame.getDataView()._table;
        int viewCol = table.convertColumnIndexToView(this._sortColumn);
        if (viewCol <= 1 && (r = table.getColumnModel().getColumn(viewCol).getCellRenderer()) instanceof IndexCellRenderer) {
            int result;
            Object colObj1 = ((Object[])o1)[this._sortColumn];
            Object colObj2 = ((Object[])o2)[this._sortColumn];
            int[] index1 = ((SnmpOID)colObj1).getValue();
            int[] index2 = ((SnmpOID)colObj2).getValue();
            if (index1.length != 1 || index2.length != 1) {
                return super.compareTo(o1, o2);
            }
            Object first = this.getSortColumnObj(o1);
            Object second = this.getSortColumnObj(o2);
            String substr1 = first.toString();
            String substr2 = second.toString();
            if (substr1.length() > 2 && substr2.length() > 2) {
                substr1 = first.toString().substring(0, 2);
                substr2 = second.toString().substring(0, 2);
            }
            if ((result = substr1.compareToIgnoreCase(substr2)) == 0) {
                int resultIndex = index1[0] >= index2[0] ? 1 : -1;
                return this.isAscending() ? resultIndex : -resultIndex;
            }
        }
        return super.compareTo(o1, o2);
    }

    private SmFilter[] setCfsInvoker(SmFilter[] invoker) {
        if (this._cfsFeatureName != null) {
            String lookupIndex = this._cfsFeatureName;
            if (this._cfsVsan != null) {
                lookupIndex = this._cfsFeatureName + Integer.toString(this._cfsVsan.getVsanId());
                DataView dataView = BrowserFrame.getDataView();
                this._oldFilters = new SmFilter[dataView._filter.length];
                for (int i = 0; i < this._oldFilters.length; ++i) {
                    this._oldFilters[i] = new SmFilter(dataView._filter[i].getSnmpPeer(), dataView._filter[i].getIndices());
                }
            }
            if (this._cfsMasterPeer == null) {
                this._cfsMasterPeer = SmCfsUtil.getInstance().getMaster(lookupIndex);
            }
            if (this._cfsMasterPeer != null) {
                SmFilter masterFilter = new SmFilter(this._cfsMasterPeer, invoker[0].getIndices());
                return new SmFilter[]{masterFilter};
            }
        }
        return invoker;
    }

    protected void commitCfs() {
        block2: {
            try {
                SmCfsUtil.getInstance().setCfsAction(this, this._cfsFeatureName, this._cfsVsan, 4);
            }
            catch (Exception ex) {
                Util.errorMessage((Component)BrowserFrame.getDataView(), ex);
                if (!SnmpSession.isTrace()) break block2;
                DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public JMenuItem[] getMapMenuItems() {
        return null;
    }

    public void setLeadIndex(int leadIndex) {
        this._leadIndex = leadIndex;
    }

    int getLeadSelectionIndex(SnmpKTable table) {
        return table.getSelectionModel().getLeadSelectionIndex();
    }

    class cfsViewListenerSource
    implements ActionListener {
        cfsViewListenerSource() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object o = e.getSource();
            String cmd = ((JToggleButton)o).getActionCommand();
            if (SmTableModel.this._cfsFeatureName != null) {
                String lookupIndex = SmTableModel.this._cfsFeatureName;
                if (SmTableModel.this._cfsVsan != null) {
                    lookupIndex = SmTableModel.this._cfsFeatureName + Integer.toString(SmTableModel.this._cfsVsan.getVsanId());
                }
                if (SmTableModel.this._cfsMasterPeer == null) {
                    SmTableModel.this._cfsMasterPeer = SmCfsUtil.getInstance().getMaster(lookupIndex);
                }
                if (SmTableModel.this._cfsMasterPeer != null) {
                    try {
                        SmCfsUtil.getInstance().processCfs(null, SmTableModel.this.getCfsFeatureName(), SmTableModel.this.getCfsVsan(), cmd.startsWith("Running") ? 1 : 2);
                    }
                    catch (SnmpException ex) {
                        // empty catch block
                    }
                    DataView view = BrowserFrame.getDataView();
                    if (view != null) {
                        SmTableModel.this.restoreFilter4CFS();
                        view.refresh();
                    }
                }
            }
        }
    }

    public class SmTableModelCellChecker {
        int[] _values;
        String _warningMsg;
        String _version = null;
        int[] _mibOid;
        boolean _bWarnOnChange = false;
        boolean _bMsgPosted = false;

        public SmTableModelCellChecker(String mibName, int[] values, String warningMsg) {
            this._mibOid = MibNode.get(mibName).getOid();
            this._values = values;
            this._warningMsg = warningMsg;
        }

        public SmTableModelCellChecker(String mibName, int[] values, String warningMsg, String version) {
            this._mibOid = MibNode.get(mibName).getOid();
            this._values = values;
            this._warningMsg = warningMsg;
            this._version = version;
        }

        public SmTableModelCellChecker(String mibName, int[] values, String warningMsg, boolean bWarnOnChange) {
            this._mibOid = MibNode.get(mibName).getOid();
            this._values = values;
            this._warningMsg = warningMsg;
            this._bWarnOnChange = bWarnOnChange;
        }

        public boolean doCheck(SnmpPeer peer, SnmpOID changedCellOid, SnmpVar changedCellVar) {
            return true;
        }
    }

    class UpdateTable
    implements Runnable {
        UpdateTable() {
        }

        @Override
        public void run() {
            SmTableModel.this.updateTableInfo();
        }
    }
}

