/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.gui;

import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.MenuButton;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Switch;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class WwnMenuButton
extends MenuButton {
    private boolean _showPWwn = false;

    public WwnMenuButton(JMenu menu) {
        super(menu);
    }

    public WwnMenuButton(JMenu menu, boolean showPWwn) {
        super(menu);
        this._showPWwn = showPWwn;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JMenuItem) {
            String source = ((JMenuItem)e.getSource()).getText();
            int index = source.indexOf(",");
            if (index == -1) {
                index = source.indexOf(" ");
            }
            ((FieldPanel)this.getParent()).setText(index != -1 ? source.substring(index + 1) : source);
            return;
        }
        super.actionPerformed(e);
    }

    public JMenu buildMenu(Object[] sws, Object[] eps) {
        int i;
        if (sws == null && eps == null) {
            return null;
        }
        if (sws == null || eps == null) {
            return this.buildMenu(sws == null ? eps : sws);
        }
        JMenu menu = this._menu = new JMenu();
        if (sws != null && sws.length != 0) {
            JMenu swMenu = new JMenu("Switch");
            this._menu.add(swMenu);
            menu = swMenu;
            i = 0;
            while (i < sws.length) {
                int max = i + 25;
                while (i < sws.length && i < max) {
                    menu.add(this.buildMenuItem(sws[i]));
                    ++i;
                }
                if (i >= sws.length) continue;
                JMenu more = new JMenu("More");
                menu.add(more);
                menu = more;
            }
        }
        if (eps != null && eps.length != 0) {
            JMenu epMenu = new JMenu("End Device");
            this._menu.add(epMenu);
            menu = epMenu;
            i = 0;
            while (i < eps.length) {
                int max = i + 25;
                while (i < eps.length && i < max) {
                    menu.add(this.buildMenuItem(eps[i]));
                    ++i;
                }
                if (i >= eps.length) continue;
                JMenu more = new JMenu("More");
                menu.add(more);
                menu = more;
            }
        }
        return this._menu;
    }

    @Override
    public JMenu buildMenu(Object[] items) {
        Comparator cmp = new Comparator(){

            public int compare(Object o1, Object o2) {
                String s1 = o1 instanceof Switch ? ((Switch)o1).getName() : WwnMenuButton.this.getNameForEndPort((EndPort)o1);
                String s2 = o2 instanceof Switch ? ((Switch)o2).getName() : WwnMenuButton.this.getNameForEndPort((EndPort)o2);
                return s1.compareTo(s2);
            }
        };
        Arrays.sort(items, cmp);
        return super.buildMenu(items);
    }

    @Override
    protected JMenuItem buildMenuItem(Object item) {
        JMenuItem mi = null;
        if (item instanceof Switch) {
            Switch sw = (Switch)item;
            mi = new JMenuItem(sw + "," + SnmpString.toHexString(sw.getWwn().getValue()));
            mi.addActionListener(this);
        } else if (item instanceof EndPort) {
            EndPort ep = (EndPort)item;
            String strItem = this.getNameForEndPort(ep);
            mi = new JMenuItem(strItem);
            mi.addActionListener(this);
        }
        return mi;
    }

    String getNameForEndPort(EndPort ep) {
        byte[] b = this._showPWwn ? ep.getPortWwn().getValue() : ep.getNodeWwn().getValue();
        String prefix = WwnDictionary.getVendor(b);
        if (ep.isISCSI()) {
            prefix = ep.getSymNodeName();
        }
        if (prefix != null) {
            return prefix + " " + SnmpString.toHexString(b);
        }
        return SnmpString.toHexString(b);
    }
}

