/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.gui.tools;

import com.cisco.dcbu.lib.jnm.FlowCounterRenderer;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.SnmpFcAddressId;
import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.KTable;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.SmCommand;
import com.cisco.dcbu.sm.client.gui.tools.FlowEndPortCellRenderer;
import com.cisco.dcbu.sm.client.gui.tools.IntegerRangerVerifier;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.EnforcedZone;
import com.cisco.dcbu.sm.client.model.EnforcedZoneMember;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.NpvLink;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.common.dto.PossibleFCFlowTrafficDto;
import com.cisco.dcbu.sm.common.model.Card;
import com.cisco.dcbu.sm.common.model.EndPortBase;
import com.cisco.dcbu.sm.common.rif.FMServerRif;
import com.cisco.dcbu.sm.common.rif.ModelFacadeRif;
import com.cisco.dcbu.sm.common.type.FabricPK;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ProgressMonitor;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import org.apache.log4j.Logger;

public class FlowConfigWizard
extends JWizard {
    private static final int MAX_FLOWS = 10000;
    private static final int HOST2STORAGE = 1;
    private static final int STORAGE2STORAGE = 2;
    private static final int ALL = 3;
    static final String _SELECTED_TYPE = "SELECTED_TYPE";
    static final int _VSAN_TYPE = 1;
    static final int _TRAFFIC_TYPE = 2;
    private Review _review;
    private ReviewTraffic _reviewTraffic;
    private DefineVsan _defineVsan;
    private DefineTraffic _defineTraffic;
    private Option _option;
    private boolean _changed = false;
    private TitledBorder _vsanTitleBorder = null;
    private TitledBorder _trafficTitleBorder = null;
    public static Logger _Logger = Logger.getLogger((String)"com.cisco.dcbu.sm.client.fc");
    public static final String _Flow_Wiz_Sig = "FLOW";
    private Fabric _fabric = null;
    static final String[] VARS = new String[]{"1.3.6.1.4.1.9.9.284.1.2.1.1.2", "1.3.6.1.4.1.9.9.284.1.2.1.1.6", "1.3.6.1.4.1.9.9.284.1.2.1.1.3", "1.3.6.1.4.1.9.9.284.1.2.1.1.4", "1.3.6.1.4.1.9.9.284.1.2.1.1.5", "1.3.6.1.4.1.9.9.284.1.2.1.1.9"};

    public FlowConfigWizard(JFrame parent) {
        super(parent);
        this.setTitle("Flow Configuration Wizard" + ClientController.getInstance().getDialogFabricTitlePostfix());
        this.setSize(800, 520);
        this._option = new Option(this);
        this.addPanel("options", this._option);
        this._defineVsan = new DefineVsan(this);
        this.addPanel("define", this._defineVsan);
        this._review = new Review(this);
        this.addPanel("review", this._review);
        this.first();
        this._fabric = ClientController.getInstance().getFabric();
        this.setLocationRelativeTo(this.getParent());
    }

    private void updateSteps(int selectedType) {
        this.removeAllPanelAfterCurrent();
        switch (selectedType) {
            case 1: {
                if (this._defineVsan == null) {
                    this._defineVsan = new DefineVsan(this);
                }
                if (this._review == null) {
                    this._review = new Review(this);
                }
                this.addPanel("define", this._defineVsan);
                this.addPanel("review", this._review);
                break;
            }
            case 2: {
                if (this._defineTraffic == null) {
                    this._defineTraffic = new DefineTraffic(this);
                }
                if (this._reviewTraffic == null) {
                    this._reviewTraffic = new ReviewTraffic(this);
                }
                this.addPanel("define", this._defineTraffic);
                this.addPanel("review", this._reviewTraffic);
            }
        }
    }

    public Fabric getCurrenFabric() {
        return this._fabric;
    }

    private void updateReviewTable(HashMap<Switch, Array> flowsBySwitch, HashMap<Switch, Array> existingFlowsBySwitch, String message) {
        this._review.updateTable(flowsBySwitch, existingFlowsBySwitch, message);
    }

    private HashMap<Switch, HashMap> trafficFlowsDiff(HashMap<Switch, HashMap> all, HashMap<Switch, HashMap> sub) {
        return this._reviewTraffic.diff(all, sub);
    }

    private void updateReviewTrafficTable(HashMap<Switch, HashMap> allflowsBySwitch, HashMap<Switch, HashMap> justFlowsToAdd, HashMap<Switch, HashMap> existingFlowsBySwitch, String message) {
        this._reviewTraffic.updateTable(allflowsBySwitch, justFlowsToAdd, existingFlowsBySwitch, message);
    }

    private boolean isCreateOnAllCards() {
        return this._defineVsan._createOnAllCards.isSelected();
    }

    public static int getNextFlowIndex(Array flows, int module, int offset) {
        int nextFlowIndex = 1;
        for (int i = 0; i < flows.size(); ++i) {
            int[] flowData = (int[])flows.elementAt(i);
            if (flowData[0] != module) continue;
            if (flowData[1] - nextFlowIndex == 0) {
                ++nextFlowIndex;
                continue;
            }
            if (flowData[1] - nextFlowIndex - offset == 0) break;
            ++nextFlowIndex;
        }
        return nextFlowIndex + offset;
    }

    public static int[] getSrcModules(Switch sw, EndPort srcPort) throws SnmpException {
        Card phyCard;
        int[] retModules = null;
        int ifIndex = srcPort.getIfIndex();
        int ifType = IfIndexUtil.getType(ifIndex);
        int card = 1;
        if (ifType == 30) {
            int subType = IfIndexUtil.getSubType(ifIndex);
            if (subType == 0 || subType == 2 || subType == 4) {
                String bindInterface = srcPort.getVFCBindTo();
                int bindIfIndex = IfIndexUtil.name2IfIndex(bindInterface);
                if (IfIndexUtil.getType(bindIfIndex) == 22) {
                    throw new SnmpException(srcPort.getSwitch().ifIndexToName(ifIndex) + " is bound to " + bindInterface + ". Flow creation wizard cannot create flows for vFC bound to Eth port-channel interface.");
                }
                card = sw.ifIndex2Card(bindIfIndex) + 1;
            }
        } else {
            card = sw.ifIndex2Card(srcPort.getIfIndex()) + 1;
        }
        if (srcPort.getSwitch() != null && srcPort.getSwitch().isNpvEnabled()) {
            List<NpvLink> links = sw.getFabric().findNpvLinksByNpvSwitchPK(srcPort.getSwitch().getSwitchPK());
            NpvLink link = null;
            for (NpvLink ele : links) {
                if (!ele.getCoreSwitch().getSwitchPK().equals(sw.getSwitchPK())) continue;
                link = ele;
            }
            if (link == null) {
                ClientController._Logger.warn((Object)("Can not find NPVLink info for attached device:" + srcPort.getName()));
                return null;
            }
            card = sw.ifIndex2Card(link.getFPortIfIndex()) + 1;
        }
        if ((phyCard = sw.getCard(card)) == null || phyCard.getOperStatus() != 2) {
            try {
                ClientController._Logger.warn((Object)("Flow chose an invalid module:" + card + "," + String.valueOf(phyCard) + "," + srcPort + "," + srcPort.getIfIndexName() + sw.ifIndex2Card(srcPort.getIfIndex())));
            }
            catch (Exception e) {
                ClientController._Logger.warn((Object)e);
            }
            return null;
        }
        retModules = new int[]{card + sw.getModuleIndexOffset()};
        return retModules;
    }

    public static void createFlow(Switch sw, int vsanId, Array flows, EndPort srcPort, EndPort dstPort, Array flowsToCreate) throws SnmpException {
        int srcId = srcPort.getFcIdNum(vsanId);
        int dstId = dstPort.getFcIdNum(vsanId);
        if (srcId != 0 && dstId != 0) {
            int[] modules = FlowConfigWizard.getSrcModules(sw, srcPort);
            if (modules != null) {
                VarBindList vbl = new VarBindList();
                for (int m = 0; m < modules.length; ++m) {
                    if (FlowConfigWizard.doesFlowExist(flows, modules[m] - 21, srcId, dstId)) continue;
                    int[] fcRouteFlowRowStatus = MibNode.get("fcRouteFlowRowStatus").getOid();
                    int[] fcRouteFlowType = MibNode.get("fcRouteFlowType").getOid();
                    int[] fcRouteFlowVsanId = MibNode.get("fcRouteFlowVsanId").getOid();
                    int[] fcRouteFlowDestId = MibNode.get("fcRouteFlowDestId").getOid();
                    int[] fcRouteFlowSrcId = MibNode.get("fcRouteFlowSrcId").getOid();
                    int[] fcRouteFlowMask = MibNode.get("fcRouteFlowMask").getOid();
                    int[] index = new int[]{modules[m], FlowConfigWizard.getNextFlowIndex(flows, modules[m] - 21, m)};
                    SnmpString type = new SnmpString(new byte[]{-32});
                    SnmpString mask = new SnmpString(new byte[]{-1, -1, -1});
                    SnmpString fcIdSrc = new SnmpString(new byte[]{(byte)(srcId >> 16 & 0xFF), (byte)(srcId >> 8 & 0xFF), (byte)(srcId & 0xFF)});
                    SnmpString fcIdDst = new SnmpString(new byte[]{(byte)(dstId >> 16 & 0xFF), (byte)(dstId >> 8 & 0xFF), (byte)(dstId & 0xFF)});
                    vbl.add(fcRouteFlowRowStatus, index, (SnmpVar)new SnmpInt(4));
                    vbl.add(fcRouteFlowType, index, (SnmpVar)type);
                    vbl.add(fcRouteFlowVsanId, index, (SnmpVar)new SnmpInt(vsanId));
                    vbl.add(fcRouteFlowDestId, index, (SnmpVar)fcIdDst);
                    vbl.add(fcRouteFlowSrcId, index, (SnmpVar)fcIdSrc);
                    vbl.add(fcRouteFlowMask, index, (SnmpVar)mask);
                    flowsToCreate.addElement(new int[]{modules[m] - 21, index[1], dstId, srcId});
                }
                if (vbl.size() > 0) {
                    SnmpFetch.set(sw.getPeer(), vbl);
                } else {
                    _Logger.debug((Object)("A flow exists between " + srcPort + " and " + dstPort + " for vsan " + sw.getVsan((short)vsanId) + "\n"));
                }
            } else {
                _Logger.info((Object)("No module available for switch " + sw + "\n"));
            }
        } else {
            _Logger.debug((Object)("Zero fcid value srcId:" + srcPort + " and dstId:" + dstId + "\n"));
        }
    }

    public static void buildDeleteFlowVbl(VarBindList vbl, int flowIndex, int moduleId) {
        int[] fcRouteFlowRowStatus = MibNode.get("fcRouteFlowRowStatus").getOid();
        int[] index = new int[]{moduleId, flowIndex};
        vbl.add(fcRouteFlowRowStatus, index, (SnmpVar)new SnmpInt(6));
    }

    public static int getExitingFlowIndex(Array flows, int module, int srcId, int dstId) {
        for (int i = 0; i < flows.size(); ++i) {
            int[] flowData = (int[])flows.elementAt(i);
            if ((flowData[0] != module || flowData[2] != srcId || flowData[3] != dstId) && (flowData[3] != srcId || flowData[2] != dstId)) continue;
            return flowData[1];
        }
        return -1;
    }

    public static ArrayList getExitingFlowIndices(Array flows, int module, int srcId) {
        ArrayList<int[]> indices = new ArrayList<int[]>();
        for (int i = 0; i < flows.size(); ++i) {
            int[] flowData = (int[])flows.elementAt(i);
            if (flowData[0] != module || flowData[2] != srcId && flowData[3] != srcId) continue;
            indices.add(new int[]{flowData[1], flowData[2] == srcId ? flowData[3] : flowData[2]});
        }
        return indices;
    }

    public static ArrayList getExitingFlowIndices(Array flows, int srcId) {
        ArrayList<int[]> indices = new ArrayList<int[]>();
        for (int i = 0; i < flows.size(); ++i) {
            int[] flowData = (int[])flows.elementAt(i);
            if (flowData[2] != srcId && flowData[3] != srcId) continue;
            indices.add(new int[]{flowData[1], flowData[2] == srcId ? flowData[3] : flowData[2]});
        }
        return indices;
    }

    public static boolean doesFlowExist(Array flows, int module, int srcId, int dstId) {
        return FlowConfigWizard.getExitingFlowIndex(flows, module, srcId, dstId) != -1;
    }

    public static Switch getRealSwitch(EndPort ep, Vsan vsan) {
        Switch sw = ep.getSwitch();
        if (sw.isNpvEnabled()) {
            int vsanId = vsan.getVsanId();
            int fcid = ep.getFcIdNum(vsanId);
            Fabric f = ClientController.getInstance().getFabric();
            Switch coreSwitch = f.findSwitchByVsanDomainId(vsanId, fcid >> 16);
            if (coreSwitch == null) {
                DefaultLogger._DefLogger.warn((Object)"Can not locate core switch!");
            } else {
                sw = coreSwitch;
            }
        }
        return sw;
    }

    public static Array getExistingFlowsOnSwitch(Switch sw, int vsanId) throws SnmpException {
        Array<int[]> flows = new Array<int[]>();
        VarBindList vbl = new VarBindList();
        for (int k = 0; k < VARS.length; ++k) {
            vbl.add(new SnmpVarBind(new SnmpOID(VARS[k])));
        }
        SnmpPDU pdu = SnmpFetch.getBulk(sw.getPeer(), vbl);
        VarBindList resp = pdu.getVariables();
        for (int j = 0; j < resp.size(); j += VARS.length) {
            int vId;
            int[] oid = resp.getOid(j).getValue();
            int module = oid[oid.length - 2] - 21;
            int index = oid[oid.length - 1];
            byte[] mask = resp.byteValue(j + 1);
            if (mask.length != 3 || (mask[2] & 0xFF) != 255 || (vId = resp.intValue(j + 2)) != vsanId) continue;
            byte[] destId = resp.byteValue(j + 3);
            int did = ((destId[0] & 0xFF) << 16) + ((destId[1] & 0xFF) << 8) + (destId[2] & 0xFF);
            byte[] srcId = resp.byteValue(j + 4);
            int sid = ((srcId[0] & 0xFF) << 16) + ((srcId[1] & 0xFF) << 8) + (srcId[2] & 0xFF);
            flows.addElement(new int[]{module, index, did, sid});
        }
        return flows;
    }

    class ReviewTraffic
    extends WizardPanel
    implements ActionListener,
    ListSelectionListener {
        private final Font TableFont;
        KTable _table;
        KTableModel _tableModel;
        KTable _inTable;
        TableRowSorter _tableSorter;
        KTableModel _inTableModel;
        JButton _remove;
        JButton _add;
        JButton _removeAll;
        JButton _addAll;
        JTextField _filterText;
        int[] filterColumnIndices;
        private ProgressMonitor progressMonitor;
        private Task task;

        public ReviewTraffic(FlowConfigWizard wizard) {
            super("3 of 3: Review Traffic Flows", "Please use Add/Remove button to add/remove flow. New flows will be added to PM collection when Finish button is clicked. We will create these flows on " + (FlowConfigWizard.this.isCreateOnAllCards() ? "each " : "") + "FC/IPS modules" + (FlowConfigWizard.this.isCreateOnAllCards() ? "for flexibility." : ""), wizard, Util.loadIcon("icons/RouteFlow.gif"));
            this.TableFont = (Font)UIManager.getDefaults().get("Table.font");
            this.filterColumnIndices = new int[]{1, 2};
            JLabel filterLabel = new JLabel("Possible Flow Pairs   Filter Source or Destination Name by Pattern:");
            filterLabel.setHorizontalTextPosition(4);
            this._filterText = new JTextField(20);
            this._filterText.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    ReviewTraffic.this.newFilter();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    ReviewTraffic.this.newFilter();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    ReviewTraffic.this.newFilter();
                }
            });
            this._tableModel = new KTableModel();
            this._tableModel.setData(new Array());
            this._tableModel.setHeaders(new String[]{"Switch", "Source", "Destination", "VSAN", "Peak Rx", "Peak Tx", "Avg Rx", "Avg Tx"});
            this._table = new KTable(this._tableModel);
            this._tableSorter = new TableRowSorter<KTableModel>(this._tableModel);
            this._table.setRowSorter(this._tableSorter);
            TableColumn col = this._table.getColumnModel().getColumn(1);
            col.setCellRenderer(new FlowEndPortCellRenderer());
            col = this._table.getColumnModel().getColumn(2);
            col.setCellRenderer(new FlowEndPortCellRenderer());
            col = this._table.getColumnModel().getColumn(4);
            col.setCellRenderer(new FlowCounterRenderer());
            col = this._table.getColumnModel().getColumn(5);
            col.setCellRenderer(new FlowCounterRenderer());
            col = this._table.getColumnModel().getColumn(6);
            col.setCellRenderer(new FlowCounterRenderer());
            col = this._table.getColumnModel().getColumn(7);
            col.setCellRenderer(new FlowCounterRenderer());
            this.setColumnWidth(this._table, new int[]{35, 35, 35, 20, 15, 15, 15, 15});
            this._table.setSortable(true);
            this._table.getSelectionModel().addListSelectionListener(this);
            JScrollPane sp = new JScrollPane(this._table);
            FlowConfigWizard.this._trafficTitleBorder = BorderFactory.createTitledBorder("Possible Flow Pairs");
            sp.setBorder(BorderFactory.createTitledBorder(""));
            this._inTableModel = new KTableModel();
            this._inTableModel.setData(new Array());
            this._inTableModel.setHeaders(new String[]{"Switch", "Source", "Destination", "VSAN"});
            this._inTable = new KTable(this._inTableModel);
            col = this._inTable.getColumnModel().getColumn(1);
            col.setCellRenderer(new FlowEndPortCellRenderer());
            col = this._inTable.getColumnModel().getColumn(2);
            col.setCellRenderer(new FlowEndPortCellRenderer());
            this._inTable.setSortable(true);
            this._inTable.setRowSorter(new TableRowSorter<KTableModel>(this._inTableModel));
            this._inTable.getSelectionModel().addListSelectionListener(this);
            JScrollPane insp = new JScrollPane(this._inTable);
            FlowConfigWizard.this._vsanTitleBorder = BorderFactory.createTitledBorder("Existing Flow Pairs");
            insp.setBorder(BorderFactory.createTitledBorder("Existing Flow Pairs"));
            this._remove = new JButton("Remove");
            this._remove.addActionListener(this);
            this._remove.setEnabled(false);
            this._add = new JButton("Add");
            this._add.addActionListener(this);
            this._add.setEnabled(false);
            this._removeAll = new JButton("Remove All");
            this._removeAll.addActionListener(this);
            this._removeAll.setEnabled(false);
            this._addAll = new JButton("Add All");
            this._addAll.addActionListener(this);
            this._addAll.setEnabled(false);
            JPanel actionPanel = new JPanel();
            actionPanel.setLayout(new GridBagLayout());
            GridBagConstraints gb = new GridBagConstraints();
            gb.fill = 1;
            gb.gridwidth = 0;
            gb.weightx = 100.0;
            gb.weighty = 45.0;
            actionPanel.add((Component)sp, gb);
            JPanel buttonPanel = new JPanel();
            buttonPanel.add(this._add);
            buttonPanel.add(this._addAll);
            buttonPanel.add(this._remove);
            buttonPanel.add(this._removeAll);
            actionPanel.add(buttonPanel);
            gb.weightx = 100.0;
            gb.weighty = 45.0;
            gb.gridx = 0;
            gb.gridy = 2;
            gb.gridwidth = 0;
            gb.fill = 1;
            actionPanel.add((Component)insp, gb);
            JPanel filterPanel = new JPanel(new FlowLayout(0));
            filterPanel.add(filterLabel);
            filterPanel.add(this._filterText);
            this.add("North", filterPanel);
            this.add("Center", actionPanel);
        }

        private void newFilter() {
            RowFilter rf = null;
            try {
                rf = RowFilter.regexFilter(this._filterText.getText(), this.filterColumnIndices);
            }
            catch (PatternSyntaxException e) {
                return;
            }
            this._tableSorter.setRowFilter(rf);
        }

        public void setColumnWidth(KTable table, int[] columnNumChars) {
            int cols = table.getColumnCount();
            if (cols > columnNumChars.length) {
                throw new IllegalArgumentException("");
            }
            for (int i = 0; i < cols; ++i) {
                int width = this.calcColumnWidth(table, i, this.TableFont, columnNumChars[i]);
                this.setColumnWidth(table, i, width);
            }
        }

        public int calcColumnWidth(KTable table, int col, Font font, int charLen) {
            FontMetrics fm = this.getFontMetrics(font);
            int widest = table.getHeaderColumnWidth(fm, col);
            char[] chars = new char[charLen];
            for (int i = 0; i < charLen; ++i) {
                chars[i] = 77;
            }
            int cwidth = fm.charsWidth(chars, 0, charLen - 1);
            if (widest < cwidth) {
                widest = cwidth;
            }
            return widest + 4;
        }

        public void setColumnWidth(KTable table, int col, int width) {
            table.getColumnModel().getColumn(col).setPreferredWidth(width);
        }

        void updateTable(HashMap<Switch, HashMap> allflowsBySwitch, HashMap<Switch, HashMap> justFlowsToAdd, HashMap<Switch, HashMap> existingFlowsBySwitch, String message) {
            String description = "Please use Add/Remove button to add/remove flow. New flows will be added to PM collection when Finish button is clicked. We will create these flows on " + (FlowConfigWizard.this.isCreateOnAllCards() ? "each " : "") + "FC/IPS modules only.";
            this.setDescription(description);
            this.populateTable(justFlowsToAdd, this._tableModel, true);
            this.populateTable(existingFlowsBySwitch, this._inTableModel, false);
            this._inTable.invalidate();
            this._table.invalidate();
            this.refreshButtons();
        }

        @Override
        public void doPrevious() {
            super.doPrevious();
            FlowConfigWizard.this.getNavigator().getCancel().setVisible(true);
        }

        private HashMap<Switch, HashMap> diff(HashMap<Switch, HashMap> all, HashMap<Switch, HashMap> sub) {
            HashMap<Switch, HashMap> ret = new HashMap<Switch, HashMap>();
            for (Switch sw : all.keySet()) {
                HashMap existingVsanMap = sub.get(sw);
                if (existingVsanMap == null) {
                    ret.put(sw, all.get(sw));
                    continue;
                }
                HashMap allVsanMap = all.get(sw);
                for (Vsan vsan : allVsanMap.keySet()) {
                    Array existingarr = (Array)existingVsanMap.get(vsan);
                    if (existingarr == null) {
                        HashMap resultVsanMap = ret.get(sw);
                        if (resultVsanMap == null) {
                            resultVsanMap = new HashMap();
                            ret.put(sw, resultVsanMap);
                        }
                        resultVsanMap.put(vsan, allVsanMap.get(vsan));
                        continue;
                    }
                    Array<Object> newArr = new Array<Object>();
                    Array allarr = (Array)allVsanMap.get(vsan);
                    for (int i = 0; i < allarr.size(); i += 3) {
                        EndPort srcPort = (EndPort)allarr.elementAt(i);
                        Array dstList = (Array)allarr.elementAt(i + 1);
                        PossibleFCFlowTrafficDto dto = (PossibleFCFlowTrafficDto)allarr.elementAt(i + 2);
                        for (int j = 0; j < dstList.size(); ++j) {
                            if (this.checkExist(existingarr, srcPort, (EndPort)dstList.elementAt(j))) continue;
                            Array newdestArr = new Array();
                            newdestArr.addElement(dstList.elementAt(j));
                            newArr.addElement(srcPort);
                            newArr.addElement(newdestArr);
                            newArr.addElement(dto);
                        }
                    }
                    if (newArr.size() <= 0) continue;
                    HashMap resultVsanMap = ret.get(sw);
                    if (resultVsanMap == null) {
                        resultVsanMap = new HashMap();
                        ret.put(sw, resultVsanMap);
                    }
                    resultVsanMap.put(vsan, newArr);
                }
            }
            return ret;
        }

        private boolean checkExist(Array arr, EndPort src, EndPort dest) {
            boolean exist = false;
            for (int i = 0; i < arr.size(); i += 3) {
                EndPort compareSrc = (EndPort)arr.elementAt(i);
                if (!compareSrc.equals(src)) continue;
                Array compareArr = (Array)arr.elementAt(i + 1);
                for (int j = 0; j < compareArr.size(); ++j) {
                    if (!dest.equals(compareArr.elementAt(j))) continue;
                    return true;
                }
            }
            return exist;
        }

        private Array populateTable(HashMap<Switch, HashMap> flowsBySwitch, KTableModel tabModel, boolean showTraffic) {
            Array data = tabModel.getData();
            data.clear();
            for (Switch sw : flowsBySwitch.keySet()) {
                HashMap flowsByVsanMap = flowsBySwitch.get(sw);
                for (Vsan vsan : flowsByVsanMap.keySet()) {
                    Array flows = (Array)flowsByVsanMap.get(vsan);
                    for (int i = 0; i < flows.size(); i += 3) {
                        EndPort srcPort = (EndPort)flows.elementAt(i);
                        Array dstList = (Array)flows.elementAt(i + 1);
                        for (int j = 0; j < dstList.size(); ++j) {
                            EndPort dstPort = (EndPort)dstList.elementAt(j);
                            if (showTraffic) {
                                Object element3rd = flows.elementAt(i + 2);
                                if (element3rd instanceof PossibleFCFlowTrafficDto) {
                                    PossibleFCFlowTrafficDto dto = (PossibleFCFlowTrafficDto)flows.elementAt(i + 2);
                                    data.addElement(new Object[]{sw, srcPort, dstPort, vsan, dto.getPeakRx(), dto.getPeakTx(), dto.getAverRx(), dto.getAverTx()});
                                    continue;
                                }
                                data.addElement(new Object[]{sw, srcPort, dstPort, vsan, null, null, null, null});
                                continue;
                            }
                            data.addElement(new Object[]{sw, srcPort, dstPort, vsan});
                        }
                    }
                }
            }
            this._tableModel.fireTableDataChanged();
            return data;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.refreshButtons();
        }

        private void refreshButtons() {
            this._add.setEnabled(this._table.getSelectedRowCount() > 0);
            this._remove.setEnabled(this._inTable.getSelectedRowCount() > 0);
            this._addAll.setEnabled(this._table.getRowCount() > 0);
            this._removeAll.setEnabled(this._inTable.getRowCount() > 0);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i;
            int i2;
            int[] selection;
            if (e.getActionCommand().equals("Remove")) {
                selection = this._inTable.getSelectedRows();
                for (i2 = 0; i2 < selection.length; ++i2) {
                    selection[i2] = this._inTable.convertRowIndexToModel(selection[i2]);
                }
                this.handleRemove(selection);
            }
            if (e.getActionCommand().equals("Add")) {
                selection = this._table.getSelectedRows();
                for (i2 = 0; i2 < selection.length; ++i2) {
                    selection[i2] = this._table.convertRowIndexToModel(selection[i2]);
                }
                this.handleAdd(selection);
            }
            if (e.getActionCommand().equals("Remove All")) {
                int count = this._inTable.getRowCount();
                int[] rows = new int[count];
                for (i = 0; i < count; ++i) {
                    rows[i] = this._inTable.convertRowIndexToModel(i);
                }
                this.handleRemove(rows);
            }
            if (e.getActionCommand().equals("Add All")) {
                int count = this._table.getRowCount();
                int[] rows = new int[count];
                for (i = 0; i < count; ++i) {
                    rows[i] = this._table.convertRowIndexToModel(i);
                }
                this.handleAdd(rows);
            }
            this.refreshButtons();
        }

        private void handleRemove(int[] rows) {
            this.progressMonitor = new ProgressMonitor(this.getWizard(), "Remove flows", "", 0, rows.length);
            this.progressMonitor.setProgress(1);
            this.task = new Task(this, rows);
            this.task.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleAdd(int[] rows) {
            Object[] objs;
            int i;
            Array arr = this._tableModel.getData();
            Array inarr = this._inTableModel.getData();
            Array<Object[]> flowsArr = new Array<Object[]>();
            for (i = rows.length - 1; i >= 0; --i) {
                objs = (Object[])arr.elementAt(rows[i]);
                flowsArr.addElement(objs);
            }
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                FlowConfigWizard.this._changed = true;
                this.createFlows(flowsArr, false, false);
            }
            catch (Exception ex) {
                Util.errorMessage((Component)this, ex);
                return;
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
            for (i = rows.length - 1; i >= 0; --i) {
                objs = (Object[])arr.elementAt(rows[i]);
                this._tableModel.getData().removeElementAt(rows[i]);
                inarr.addElement(objs);
            }
            this._tableModel.fireTableDataChanged();
            this._inTableModel.fireTableDataChanged();
        }

        private void removeFlow(Vsan vsan, Switch sw, EndPort src, EndPort dest, Map<Switch, SnmpPDU> map) throws Exception {
            Fabric fb = sw.getFabric();
            VarBindList vbl = new VarBindList();
            for (int k = 0; k < VARS.length; ++k) {
                vbl.add(new SnmpVarBind(new SnmpOID(VARS[k])));
            }
            SnmpPDU pdu = map.get(sw);
            if (pdu == null) {
                pdu = SnmpFetch.getBulk(sw.getPeer(), vbl);
            }
            VarBindList resp = pdu.getVariables();
            for (int j = 0; j < resp.size(); j += VARS.length) {
                byte[] mask;
                if (resp.byteValue(j).length == 0 || resp.byteValue(j)[0] != -32 || (mask = resp.byteValue(j + 1)).length != 3 || (mask[2] & 0xFF) != 255) continue;
                int vId = resp.intValue(j + 2);
                if (vsan.getVsanId() != vId) continue;
                byte[] destId = resp.byteValue(j + 3);
                int did = ((destId[0] & 0xFF) << 16) + ((destId[1] & 0xFF) << 8) + (destId[2] & 0xFF);
                byte[] srcId = resp.byteValue(j + 4);
                int sid = ((srcId[0] & 0xFF) << 16) + ((srcId[1] & 0xFF) << 8) + (srcId[2] & 0xFF);
                EndPort sp = fb.findEndPortByVsanFcId(vId, srcId);
                EndPort dp = fb.findEndPortByVsanFcId(vId, destId);
                if (sp == null || dp == null || !(sp.equals(src) & dp.equals(dest))) continue;
                VarBindList removeVbl = new VarBindList();
                int[] rowStatus = MibNode.get("fcRouteFlowRowStatus").getOid();
                _Logger.debug((Object)("remvoe flow :" + sp + " => " + dp));
                SnmpVarBind removeVar = resp.get(j);
                removeVar.getOid().getValue()[13] = 12;
                removeVar.setVar(new SnmpInt(6));
                removeVbl.add(removeVar);
                SnmpFetch.set(sw.getPeer(), removeVbl);
            }
            map.put(sw, pdu);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doFinish() {
            FlowConfigWizard w = (FlowConfigWizard)this.getWizard();
            try {
                ModelFacadeRif rif = ClientController.getInstance().assertModelFacade();
                if (rif.isFabricInPmCollection((FabricPK)FlowConfigWizard.this._fabric.getPK()) && FlowConfigWizard.this._changed && JOptionPane.showConfirmDialog(w, "Do you want to restart PM collection to include newly created flows?", "Confirmation", 0) == 0) {
                    ClientController.getInstance().assertPM().restart();
                }
            }
            catch (Exception ex) {
                Util.errorMessage((Component)this, ex);
            }
            finally {
                w.dispose();
                BrowserFrame.getDataView()._filter = null;
                SmCommand.flows(BrowserFrame.getDataView(), "Flow Statistics", null, null, null, null);
            }
        }

        private void createFlows(Array flows, boolean isClearExistingFlows, boolean createAllCards) throws SnmpException {
            int[] fcRouteFlowRowStatus = MibNode.get("fcRouteFlowRowStatus").getOid();
            int[] fcRouteFlowType = MibNode.get("fcRouteFlowType").getOid();
            int[] fcRouteFlowVsanId = MibNode.get("fcRouteFlowVsanId").getOid();
            int[] fcRouteFlowDestId = MibNode.get("fcRouteFlowDestId").getOid();
            int[] fcRouteFlowSrcId = MibNode.get("fcRouteFlowSrcId").getOid();
            int[] fcRouteFlowMask = MibNode.get("fcRouteFlowMask").getOid();
            int[] index = new int[2];
            SnmpString type = new SnmpString(new byte[]{-32});
            SnmpString mask = new SnmpString(new byte[]{-1, -1, -1});
            Switch lastSw = null;
            int[] usedFlowIndeces = null;
            int usedFlowIndexNo = 1;
            int[] modules = null;
            VarBindList vbl = null;
            HashSet<Switch> unmanagedSwSet = new HashSet<Switch>();
            HashSet<Switch> managedSwSet = new HashSet<Switch>();
            for (int i = 0; i < flows.size(); ++i) {
                int ifType;
                boolean isFC;
                Object[] cols = (Object[])flows.elementAt(i);
                Switch sw = (Switch)cols[0];
                EndPort srcPort = (EndPort)cols[1];
                EndPort dstPort = (EndPort)cols[2];
                Vsan vsan = (Vsan)cols[3];
                SnmpInt vsanId = new SnmpInt(vsan.getId());
                if (sw == null || unmanagedSwSet.contains(sw)) continue;
                if (!managedSwSet.contains(sw)) {
                    String authMsg = null;
                    if (sw.isManageable()) {
                        try {
                            authMsg = sw.authenticate();
                        }
                        catch (Exception e) {
                            authMsg = e.getMessage();
                        }
                    }
                    if (authMsg != null || !sw.isManageable()) {
                        unmanagedSwSet.add(sw);
                        continue;
                    }
                    managedSwSet.add(sw);
                }
                if (sw != lastSw) {
                    if (lastSw != null) {
                        SnmpFetch.set(lastSw.getPeer(), vbl);
                    }
                    usedFlowIndeces = this.fetchUsedFlowIndeces(sw, vsan.getId(), fcRouteFlowType, fcRouteFlowVsanId, fcRouteFlowRowStatus, isClearExistingFlows);
                    usedFlowIndexNo = 1;
                    vbl = new VarBindList();
                    lastSw = sw;
                }
                boolean bl = isFC = (ifType = IfIndexUtil.getType(srcPort.getIfIndex())) == 1 || ifType == 30;
                if (createAllCards) {
                    modules = this.getModules(sw);
                } else {
                    int[] retModules = FlowConfigWizard.getSrcModules(sw, srcPort);
                    if (retModules == null) continue;
                    modules = retModules;
                }
                for (int k = 0; k < modules.length && modules[k] != 0; ++k) {
                    if (usedFlowIndexNo == 10000) {
                        throw new SnmpException("10000 flows on switch " + lastSw);
                    }
                    while (usedFlowIndeces[usedFlowIndexNo] == 1) {
                        if (++usedFlowIndexNo != 10000) continue;
                        throw new SnmpException("10000 flows on switch " + lastSw);
                    }
                    index[0] = modules[k];
                    index[1] = usedFlowIndexNo++;
                    vbl.add(fcRouteFlowRowStatus, index, (SnmpVar)new SnmpInt(4));
                    vbl.add(fcRouteFlowType, index, (SnmpVar)type);
                    vbl.add(fcRouteFlowVsanId, index, (SnmpVar)vsanId);
                    int t = srcPort.getFcIdNum(vsan.getId());
                    SnmpString srcFcId = new SnmpString(new byte[]{(byte)(t >> 16 & 0xFF), (byte)(t >> 8 & 0xFF), (byte)(t & 0xFF)});
                    vbl.add(fcRouteFlowSrcId, index, (SnmpVar)srcFcId);
                    int s = dstPort.getFcIdNum(vsan.getId());
                    SnmpString fcId = new SnmpString(new byte[]{(byte)(s >> 16 & 0xFF), (byte)(s >> 8 & 0xFF), (byte)(s & 0xFF)});
                    vbl.add(fcRouteFlowDestId, index, (SnmpVar)fcId);
                    vbl.add(fcRouteFlowMask, index, (SnmpVar)mask);
                    _Logger.debug((Object)("create flow: " + srcPort + " => " + dstPort));
                }
            }
            if (lastSw != null) {
                SnmpFetch.set(lastSw.getPeer(), vbl);
            }
            if (unmanagedSwSet.size() > 0) {
                StringBuffer sb = new StringBuffer();
                sb.append("The following switches are not manageable:\n");
                for (Switch sw : unmanagedSwSet) {
                    sb.append(sw).append(",");
                }
                sb.deleteCharAt(sb.length() - 1);
                sb.append("\n\nAssociated flows cannot be created.");
                Util.errorMessage((Component)this, sb.toString());
            }
        }

        private int[] getModules(Switch sw) {
            Card[] cards = sw.getCards();
            if (cards == null) {
                return new int[]{22};
            }
            int[] indeces = new int[cards.length];
            int no = 0;
            for (int i = 0; i < cards.length; ++i) {
                if (cards[i] == null || cards[i].getOperStatus() != 2 || cards[i].getNumPorts() <= 0) continue;
                indeces[no++] = cards[i].getSlotId() + sw.getModuleIndexOffset();
            }
            int[] slots = new int[no];
            System.arraycopy(indeces, 0, slots, 0, no);
            return slots;
        }

        private int[] fetchUsedFlowIndeces(Switch sw, int vsanId, int[] fcRouteFlowType, int[] fcRouteFlowVsan, int[] fcRouteFlowRowStatus, boolean isClearExistingFlows) throws SnmpException {
            VarBindList vbl = new VarBindList();
            vbl.add(new SnmpVarBind(new SnmpOID(fcRouteFlowType)));
            if (isClearExistingFlows) {
                vbl.add(new SnmpVarBind(new SnmpOID(fcRouteFlowVsan)));
            }
            SnmpPDU pdu = SnmpFetch.getBulk(sw.getPeer(), vbl);
            int[] usedIndeces = new int[10000];
            vbl = pdu.getVariables();
            if (isClearExistingFlows && vbl.size() > 0) {
                VarBindList clearVbl = new VarBindList();
                int[] index = new int[2];
                for (int i = 1; i < vbl.size(); i += 2) {
                    int flowVsan = vbl.intValue(i);
                    if (flowVsan == vsanId) {
                        int[] oid = vbl.getVb(i).getOid().getValue();
                        index[0] = oid[oid.length - 2];
                        index[1] = oid[oid.length - 1];
                        clearVbl.add(fcRouteFlowRowStatus, index, (SnmpVar)new SnmpInt(6));
                        continue;
                    }
                    int id = vbl.getVb(i).getIndex();
                    if (id <= 0 || id >= 10000) continue;
                    usedIndeces[id] = 1;
                }
                if (clearVbl.size() > 0) {
                    SnmpFetch.set(sw.getPeer(), clearVbl);
                }
                return usedIndeces;
            }
            for (int i = 0; i < vbl.size(); ++i) {
                int index = vbl.getVb(i).getIndex();
                if (index > 0 && index < 10000) {
                    usedIndeces[index] = 1;
                }
                if (!isClearExistingFlows) continue;
                ++i;
            }
            return usedIndeces;
        }

        class Task
        extends Thread {
            ReviewTraffic parent;
            int[] rows;

            public Task(ReviewTraffic _parent, int[] r) {
                this.parent = _parent;
                this.rows = r;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block12: {
                    Random random = new Random();
                    boolean progress = false;
                    Array arr = ReviewTraffic.this._tableModel.getData();
                    Array inarr = ReviewTraffic.this._inTableModel.getData();
                    HashMap map = new HashMap();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ReviewTraffic.this.progressMonitor.setProgress(1);
                        }
                    });
                    for (int i = this.rows.length - 1; i >= 0; --i) {
                        Object[] objs = (Object[])inarr.elementAt(this.rows[i]);
                        ReviewTraffic.this._inTableModel.getData().removeElementAt(this.rows[i]);
                        arr.addElement(objs);
                        try {
                            ReviewTraffic.this.setCursor(Cursor.getPredefinedCursor(3));
                            int j = this.rows.length - i;
                            final int steps = j == 0 ? 1 : j;
                            final String noteStr = "Remove " + j + " out of " + this.rows.length + " flows";
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ReviewTraffic.this.progressMonitor.setProgress(steps);
                                    ReviewTraffic.this.progressMonitor.setNote(noteStr);
                                }
                            });
                            ReviewTraffic.this.removeFlow((Vsan)objs[3], (Switch)objs[0], (EndPort)objs[1], (EndPort)objs[2], map);
                            if (!ReviewTraffic.this.progressMonitor.isCanceled()) continue;
                            break;
                        }
                        catch (Exception ex) {
                            Util.errorMessage((Component)this.parent, ex);
                            if (ReviewTraffic.this.progressMonitor != null) {
                                ReviewTraffic.this.progressMonitor.close();
                            }
                            map.clear();
                            ReviewTraffic.this.setCursor(Cursor.getDefaultCursor());
                            ReviewTraffic.this.refreshButtons();
                            return;
                        }
                        finally {
                            ReviewTraffic.this.setCursor(Cursor.getDefaultCursor());
                        }
                    }
                    ReviewTraffic.this._inTableModel.fireTableDataChanged();
                    break block12;
                    finally {
                        if (ReviewTraffic.this.progressMonitor != null) {
                            ReviewTraffic.this.progressMonitor.close();
                        }
                        map.clear();
                        ReviewTraffic.this.setCursor(Cursor.getDefaultCursor());
                        ReviewTraffic.this.refreshButtons();
                    }
                }
                ReviewTraffic.this._tableModel.fireTableDataChanged();
            }
        }
    }

    class Review
    extends WizardPanel
    implements ActionListener,
    ListSelectionListener {
        SnmpKTable _table;
        KTableModel _tableModel;
        SnmpKTable _inTable;
        KTableModel _inTableModel;
        JButton _remove;
        JButton _add;
        JButton _removeAll;
        JButton _addAll;
        JTextField _filterText;
        TableRowSorter _tableSorter;
        int[] filterColumnIndices;
        private ProgressMonitor progressMonitor;
        private Task task;

        public Review(FlowConfigWizard wizard) {
            super("3 of 3: Review Traffic Flows", "Please use Add/Remove button to add/remove flow. New flows will be added to PM collection when Finish button is clicked. We will create these flows on " + (FlowConfigWizard.this.isCreateOnAllCards() ? "each " : "") + "FC/IPS modules" + (FlowConfigWizard.this.isCreateOnAllCards() ? "for flexibility." : ""), wizard, Util.loadIcon("icons/RouteFlow.gif"));
            this.filterColumnIndices = new int[]{1, 2};
            JLabel filterLabel = new JLabel("Possible Flow Pairs   Filter Source or Destination Name by Pattern:");
            filterLabel.setHorizontalTextPosition(4);
            this._filterText = new JTextField(20);
            this._filterText.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    Review.this.newFilter();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    Review.this.newFilter();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    Review.this.newFilter();
                }
            });
            this._tableModel = new KTableModel();
            this._tableModel.setData(new Array());
            this._tableModel.setHeaders(new String[]{"Switch", "Source", "Destination"});
            this._table = new SnmpKTable(this._tableModel);
            this._tableSorter = new TableRowSorter<KTableModel>(this._tableModel);
            this._table.setRowSorter(this._tableSorter);
            TableColumn col = this._table.getColumnModel().getColumn(1);
            col.setCellRenderer(new FlowEndPortCellRenderer());
            col = this._table.getColumnModel().getColumn(2);
            col.setCellRenderer(new FlowEndPortCellRenderer());
            this._table.setSortable(true);
            this._table.getSelectionModel().addListSelectionListener(this);
            JScrollPane sp = new JScrollPane(this._table);
            sp.setBorder(BorderFactory.createTitledBorder(""));
            this._inTableModel = new KTableModel();
            this._inTableModel.setData(new Array());
            this._inTableModel.setHeaders(new String[]{"Switch", "Source", "Destination"});
            this._inTable = new SnmpKTable(this._inTableModel);
            this._inTable.setRowSorter(new TableRowSorter<KTableModel>(this._inTableModel));
            col = this._inTable.getColumnModel().getColumn(1);
            col.setCellRenderer(new FlowEndPortCellRenderer());
            col = this._inTable.getColumnModel().getColumn(2);
            col.setCellRenderer(new FlowEndPortCellRenderer());
            this._inTable.setSortable(true);
            this._inTable.getSelectionModel().addListSelectionListener(this);
            JScrollPane insp = new JScrollPane(this._inTable);
            FlowConfigWizard w = (FlowConfigWizard)this.getWizard();
            FlowConfigWizard.this._vsanTitleBorder = BorderFactory.createTitledBorder("Existing Flows for Vsan:" + (Vsan)((FlowConfigWizard)w)._defineVsan._vsan.getSelectedItem());
            insp.setBorder(FlowConfigWizard.this._vsanTitleBorder);
            this._remove = new JButton("Remove");
            this._remove.addActionListener(this);
            this._remove.setEnabled(false);
            this._add = new JButton("Add");
            this._add.addActionListener(this);
            this._add.setEnabled(false);
            this._removeAll = new JButton("Remove All");
            this._removeAll.addActionListener(this);
            this._removeAll.setEnabled(false);
            this._addAll = new JButton("Add All");
            this._addAll.addActionListener(this);
            this._addAll.setEnabled(false);
            JPanel actionPanel = new JPanel();
            actionPanel.setLayout(new GridBagLayout());
            GridBagConstraints gb = new GridBagConstraints();
            gb.fill = 1;
            gb.gridwidth = 0;
            gb.weightx = 100.0;
            gb.weighty = 45.0;
            actionPanel.add((Component)sp, gb);
            JPanel buttonPanel = new JPanel();
            buttonPanel.add(this._add);
            buttonPanel.add(this._addAll);
            buttonPanel.add(this._remove);
            buttonPanel.add(this._removeAll);
            actionPanel.add(buttonPanel);
            gb.weightx = 100.0;
            gb.weighty = 45.0;
            gb.gridx = 0;
            gb.gridy = 2;
            gb.gridwidth = 0;
            gb.fill = 1;
            actionPanel.add((Component)insp, gb);
            JPanel filterPanel = new JPanel(new FlowLayout(0));
            filterPanel.add(filterLabel);
            filterPanel.add(this._filterText);
            this.add("North", filterPanel);
            this.add("Center", actionPanel);
        }

        void updateTable(HashMap<Switch, Array> flowsBySwitch, HashMap<Switch, Array> existingFlowsBySwitch, String message) {
            String description = "Please use Add/Remove button to add/remove flow. New flows will be added to PM collection when Finish button is clicked. We will create these flows on " + (FlowConfigWizard.this.isCreateOnAllCards() ? "each " : "") + "FC/IPS modules only.";
            this.setDescription(description);
            this.populateTable(this.diff(flowsBySwitch, existingFlowsBySwitch), this._tableModel);
            this.populateTable(existingFlowsBySwitch, this._inTableModel);
            this._inTable.invalidate();
            this._table.invalidate();
            this.refreshButtons();
        }

        private void newFilter() {
            RowFilter rf = null;
            try {
                rf = RowFilter.regexFilter(this._filterText.getText(), this.filterColumnIndices);
            }
            catch (PatternSyntaxException e) {
                return;
            }
            this._tableSorter.setRowFilter(rf);
        }

        @Override
        public void doPrevious() {
            super.doPrevious();
            FlowConfigWizard.this.getNavigator().getCancel().setVisible(true);
        }

        private HashMap diff(HashMap<Switch, Array> all, HashMap<Switch, Array> sub) {
            HashMap ret = new HashMap();
            for (Switch sw : all.keySet()) {
                Array existingarr = sub.get(sw);
                if (existingarr == null) {
                    ret.put(sw, all.get(sw));
                    continue;
                }
                Array<Object> newArr = new Array<Object>();
                Array allarr = all.get(sw);
                for (int i = 0; i < allarr.size(); i += 2) {
                    EndPort srcPort = (EndPort)allarr.elementAt(i);
                    Array dstList = (Array)allarr.elementAt(i + 1);
                    for (int j = 0; j < dstList.size(); ++j) {
                        if (this.checkExist(existingarr, srcPort, (EndPort)dstList.elementAt(j))) continue;
                        Array newdestArr = new Array();
                        newdestArr.addElement(dstList.elementAt(j));
                        newArr.addElement(srcPort);
                        newArr.addElement(newdestArr);
                    }
                }
                if (newArr.size() <= 0) continue;
                ret.put(sw, newArr);
            }
            return ret;
        }

        private boolean checkExist(Array arr, EndPort src, EndPort dest) {
            boolean exist = false;
            for (int i = 0; i < arr.size(); i += 2) {
                EndPort compareSrc = (EndPort)arr.elementAt(i);
                if (!compareSrc.equals(src)) continue;
                Array compareArr = (Array)arr.elementAt(i + 1);
                for (int j = 0; j < compareArr.size(); ++j) {
                    if (!dest.equals(compareArr.elementAt(j))) continue;
                    return true;
                }
            }
            return exist;
        }

        private Array populateTable(HashMap<Switch, Array> flowsBySwitch, KTableModel tabModel) {
            Array data = tabModel.getData();
            data.clear();
            for (Switch sw : flowsBySwitch.keySet()) {
                Array flows = flowsBySwitch.get(sw);
                for (int i = 0; i < flows.size(); i += 2) {
                    EndPort srcPort = (EndPort)flows.elementAt(i);
                    Array dstList = (Array)flows.elementAt(i + 1);
                    for (int j = 0; j < dstList.size(); ++j) {
                        EndPort dstPort = (EndPort)dstList.elementAt(j);
                        data.addElement(new Object[]{sw, srcPort, dstPort});
                    }
                }
            }
            this._tableModel.fireTableDataChanged();
            return data;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.refreshButtons();
        }

        private void refreshButtons() {
            this._add.setEnabled(this._table.getSelectedRowCount() > 0);
            this._remove.setEnabled(this._inTable.getSelectedRowCount() > 0);
            this._addAll.setEnabled(this._table.getRowCount() > 0);
            this._removeAll.setEnabled(this._inTable.getRowCount() > 0);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i;
            int i2;
            int[] selection;
            if (e.getActionCommand().equals("Remove")) {
                selection = this._inTable.getSelectedRows();
                for (i2 = 0; i2 < selection.length; ++i2) {
                    selection[i2] = this._inTable.convertRowIndexToModel(selection[i2]);
                }
                this.handleRemove(selection);
            }
            if (e.getActionCommand().equals("Add")) {
                selection = this._table.getSelectedRows();
                for (i2 = 0; i2 < selection.length; ++i2) {
                    selection[i2] = this._table.convertRowIndexToModel(selection[i2]);
                }
                this.handleAdd(selection);
            }
            if (e.getActionCommand().equals("Remove All")) {
                int count = this._inTable.getRowCount();
                int[] rows = new int[count];
                for (i = 0; i < count; ++i) {
                    rows[i] = this._inTable.convertRowIndexToModel(i);
                }
                this.handleRemove(rows);
            }
            if (e.getActionCommand().equals("Add All")) {
                int count = this._table.getRowCount();
                int[] rows = new int[count];
                for (i = 0; i < count; ++i) {
                    rows[i] = this._table.convertRowIndexToModel(i);
                }
                this.handleAdd(rows);
            }
            this.refreshButtons();
        }

        private void handleRemove(int[] rows) {
            this.progressMonitor = new ProgressMonitor(this.getWizard(), "Remove flows", "", 0, rows.length);
            this.progressMonitor.setProgress(1);
            this.task = new Task(this, rows);
            this.task.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleAdd(int[] rows) {
            Object[] objs;
            Array arr = this._tableModel.getData();
            Array inarr = this._inTableModel.getData();
            Array<Object[]> flowsArr = new Array<Object[]>();
            for (int i = rows.length - 1; i >= 0; --i) {
                objs = (Object[])arr.elementAt(rows[i]);
                flowsArr.addElement(objs);
            }
            try {
                FlowConfigWizard w = (FlowConfigWizard)this.getWizard();
                this.setCursor(Cursor.getPredefinedCursor(3));
                FlowConfigWizard.this._changed = true;
                this.createFlows((Vsan)((FlowConfigWizard)w)._defineVsan._vsan.getSelectedItem(), flowsArr, false, w.isCreateOnAllCards());
            }
            catch (Exception ex) {
                Util.errorMessage((Component)this, ex);
                return;
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
            for (int i = rows.length - 1; i >= 0; --i) {
                objs = (Object[])arr.elementAt(rows[i]);
                this._tableModel.getData().removeElementAt(rows[i]);
                inarr.addElement(objs);
            }
            this._tableModel.fireTableDataChanged();
            this._inTableModel.fireTableDataChanged();
        }

        private void removeFlow(Vsan vsan, Switch sw, EndPort src, EndPort dest, Map<Switch, SnmpPDU> map) throws Exception {
            Fabric fb = sw.getFabric();
            VarBindList vbl = new VarBindList();
            for (int k = 0; k < VARS.length; ++k) {
                vbl.add(new SnmpVarBind(new SnmpOID(VARS[k])));
            }
            SnmpPDU pdu = map.get(sw);
            if (pdu == null) {
                pdu = SnmpFetch.getBulk(sw.getPeer(), vbl);
            }
            VarBindList resp = pdu.getVariables();
            for (int j = 0; j < resp.size(); j += VARS.length) {
                byte[] mask;
                if (resp.byteValue(j).length == 0 || resp.byteValue(j)[0] != -32 || (mask = resp.byteValue(j + 1)).length != 3 || (mask[2] & 0xFF) != 255) continue;
                int vId = resp.intValue(j + 2);
                if (vsan.getVsanId() != vId) continue;
                byte[] destId = resp.byteValue(j + 3);
                int did = ((destId[0] & 0xFF) << 16) + ((destId[1] & 0xFF) << 8) + (destId[2] & 0xFF);
                byte[] srcId = resp.byteValue(j + 4);
                int sid = ((srcId[0] & 0xFF) << 16) + ((srcId[1] & 0xFF) << 8) + (srcId[2] & 0xFF);
                EndPort sp = fb.findEndPortByVsanFcId(vId, srcId);
                EndPort dp = fb.findEndPortByVsanFcId(vId, destId);
                if (sp == null || dp == null || !(sp.equals(src) & dp.equals(dest))) continue;
                VarBindList removeVbl = new VarBindList();
                int[] rowStatus = MibNode.get("fcRouteFlowRowStatus").getOid();
                _Logger.debug((Object)("remvoe flow :" + sp + " => " + dp));
                SnmpVarBind removeVar = resp.get(j);
                removeVar.getOid().getValue()[13] = 12;
                removeVar.setVar(new SnmpInt(6));
                removeVbl.add(removeVar);
                SnmpFetch.set(sw.getPeer(), removeVbl);
            }
            map.put(sw, pdu);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doFinish() {
            FlowConfigWizard w = (FlowConfigWizard)this.getWizard();
            try {
                ModelFacadeRif rif = ClientController.getInstance().assertModelFacade();
                if (rif.isFabricInPmCollection((FabricPK)FlowConfigWizard.this._fabric.getPK()) && FlowConfigWizard.this._changed && JOptionPane.showConfirmDialog(w, "Do you want to restart PM collection to include newly created flows?", "Confirmation", 0) == 0) {
                    ClientController.getInstance().assertPM().restart();
                }
            }
            catch (Exception ex) {
                Util.errorMessage((Component)this, ex);
            }
            finally {
                w.dispose();
                BrowserFrame.getDataView()._filter = null;
                SmCommand.flows(BrowserFrame.getDataView(), "Flow Statistics", null, null, null, null);
            }
        }

        private void createFlows(Vsan v, Array flows, boolean isClearExistingFlows, boolean createAllCards) throws SnmpException {
            int[] fcRouteFlowRowStatus = MibNode.get("fcRouteFlowRowStatus").getOid();
            int[] fcRouteFlowType = MibNode.get("fcRouteFlowType").getOid();
            int[] fcRouteFlowVsanId = MibNode.get("fcRouteFlowVsanId").getOid();
            int[] fcRouteFlowDestId = MibNode.get("fcRouteFlowDestId").getOid();
            int[] fcRouteFlowSrcId = MibNode.get("fcRouteFlowSrcId").getOid();
            int[] fcRouteFlowMask = MibNode.get("fcRouteFlowMask").getOid();
            int[] index = new int[2];
            SnmpInt vsanId = new SnmpInt(v.getId());
            SnmpString type = new SnmpString(new byte[]{-32});
            SnmpString mask = new SnmpString(new byte[]{-1, -1, -1});
            Switch lastSw = null;
            int[] usedFlowIndeces = null;
            int usedFlowIndexNo = 1;
            int[] modules = null;
            VarBindList vbl = null;
            HashSet<Switch> unmanagedSwSet = new HashSet<Switch>();
            HashSet<Switch> managedSwSet = new HashSet<Switch>();
            for (int i = 0; i < flows.size(); ++i) {
                int ifType;
                boolean isFC;
                Object[] cols = (Object[])flows.elementAt(i);
                Switch sw = (Switch)cols[0];
                EndPort srcPort = (EndPort)cols[1];
                EndPort dstPort = (EndPort)cols[2];
                if (sw == null || unmanagedSwSet.contains(sw)) continue;
                if (!managedSwSet.contains(sw)) {
                    String authMsg = null;
                    if (sw.isManageable()) {
                        try {
                            authMsg = sw.authenticate();
                        }
                        catch (Exception e) {
                            authMsg = e.getMessage();
                        }
                    }
                    if (authMsg != null || !sw.isManageable()) {
                        unmanagedSwSet.add(sw);
                        continue;
                    }
                    managedSwSet.add(sw);
                }
                if (sw != lastSw) {
                    if (lastSw != null) {
                        SnmpFetch.set(lastSw.getPeer(), vbl);
                    }
                    usedFlowIndeces = this.fetchUsedFlowIndeces(sw, v.getId(), fcRouteFlowType, fcRouteFlowVsanId, fcRouteFlowRowStatus, isClearExistingFlows);
                    usedFlowIndexNo = 1;
                    vbl = new VarBindList();
                    lastSw = sw;
                }
                boolean bl = isFC = (ifType = IfIndexUtil.getType(srcPort.getIfIndex())) == 1 || ifType == 30;
                if (createAllCards) {
                    modules = this.getModules(sw);
                } else {
                    int[] retModules = FlowConfigWizard.getSrcModules(sw, srcPort);
                    if (retModules == null) continue;
                    modules = retModules;
                }
                for (int k = 0; k < modules.length && modules[k] != 0; ++k) {
                    if (usedFlowIndexNo == 10000) {
                        throw new SnmpException("10000 flows on switch " + lastSw);
                    }
                    while (usedFlowIndeces[usedFlowIndexNo] == 1) {
                        if (++usedFlowIndexNo != 10000) continue;
                        throw new SnmpException("10000 flows on switch " + lastSw);
                    }
                    index[0] = modules[k];
                    index[1] = usedFlowIndexNo++;
                    vbl.add(fcRouteFlowRowStatus, index, (SnmpVar)new SnmpInt(4));
                    vbl.add(fcRouteFlowType, index, (SnmpVar)type);
                    vbl.add(fcRouteFlowVsanId, index, (SnmpVar)vsanId);
                    int t = srcPort.getFcIdNum(v.getId());
                    SnmpString srcFcId = new SnmpString(new byte[]{(byte)(t >> 16 & 0xFF), (byte)(t >> 8 & 0xFF), (byte)(t & 0xFF)});
                    vbl.add(fcRouteFlowSrcId, index, (SnmpVar)srcFcId);
                    int s = dstPort.getFcIdNum(v.getId());
                    SnmpString fcId = new SnmpString(new byte[]{(byte)(s >> 16 & 0xFF), (byte)(s >> 8 & 0xFF), (byte)(s & 0xFF)});
                    vbl.add(fcRouteFlowDestId, index, (SnmpVar)fcId);
                    vbl.add(fcRouteFlowMask, index, (SnmpVar)mask);
                    _Logger.debug((Object)("create flow: " + srcPort + " => " + dstPort));
                }
            }
            if (lastSw != null) {
                SnmpFetch.set(lastSw.getPeer(), vbl);
            }
            if (unmanagedSwSet.size() > 0) {
                StringBuffer sb = new StringBuffer();
                sb.append("The following switches are not manageable:\n");
                for (Switch sw : unmanagedSwSet) {
                    sb.append(sw).append(",");
                }
                sb.deleteCharAt(sb.length() - 1);
                sb.append("\n\nAssociated flows cannot be created.");
                Util.errorMessage((Component)this, sb.toString());
            }
        }

        private int[] getModules(Switch sw) {
            Card[] cards = sw.getCards();
            if (cards == null) {
                return new int[]{22};
            }
            int[] indeces = new int[cards.length];
            int no = 0;
            for (int i = 0; i < cards.length; ++i) {
                if (cards[i] == null || cards[i].getOperStatus() != 2 || cards[i].getNumPorts() <= 0) continue;
                indeces[no++] = cards[i].getSlotId() + sw.getModuleIndexOffset();
            }
            int[] slots = new int[no];
            System.arraycopy(indeces, 0, slots, 0, no);
            return slots;
        }

        private int[] fetchUsedFlowIndeces(Switch sw, int vsanId, int[] fcRouteFlowType, int[] fcRouteFlowVsan, int[] fcRouteFlowRowStatus, boolean isClearExistingFlows) throws SnmpException {
            VarBindList vbl = new VarBindList();
            vbl.add(new SnmpVarBind(new SnmpOID(fcRouteFlowType)));
            if (isClearExistingFlows) {
                vbl.add(new SnmpVarBind(new SnmpOID(fcRouteFlowVsan)));
            }
            SnmpPDU pdu = SnmpFetch.getBulk(sw.getPeer(), vbl);
            int[] usedIndeces = new int[10000];
            vbl = pdu.getVariables();
            if (isClearExistingFlows && vbl.size() > 0) {
                VarBindList clearVbl = new VarBindList();
                int[] index = new int[2];
                for (int i = 1; i < vbl.size(); i += 2) {
                    int flowVsan = vbl.intValue(i);
                    if (flowVsan == vsanId) {
                        int[] oid = vbl.getVb(i).getOid().getValue();
                        index[0] = oid[oid.length - 2];
                        index[1] = oid[oid.length - 1];
                        clearVbl.add(fcRouteFlowRowStatus, index, (SnmpVar)new SnmpInt(6));
                        continue;
                    }
                    int id = vbl.getVb(i).getIndex();
                    if (id <= 0 || id >= 10000) continue;
                    usedIndeces[id] = 1;
                }
                if (clearVbl.size() > 0) {
                    SnmpFetch.set(sw.getPeer(), clearVbl);
                }
                return usedIndeces;
            }
            for (int i = 0; i < vbl.size(); ++i) {
                int index = vbl.getVb(i).getIndex();
                if (index > 0 && index < 10000) {
                    usedIndeces[index] = 1;
                }
                if (!isClearExistingFlows) continue;
                ++i;
            }
            return usedIndeces;
        }

        class Task
        extends Thread {
            Review parent;
            int[] rows;

            public Task(Review _parent, int[] r) {
                this.parent = _parent;
                this.rows = r;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block12: {
                    Random random = new Random();
                    boolean progress = false;
                    Array arr = Review.this._tableModel.getData();
                    Array inarr = Review.this._inTableModel.getData();
                    HashMap map = new HashMap();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Review.this.progressMonitor.setProgress(1);
                        }
                    });
                    for (int i = this.rows.length - 1; i >= 0; --i) {
                        Object[] objs = (Object[])inarr.elementAt(this.rows[i]);
                        Review.this._inTableModel.getData().removeElementAt(this.rows[i]);
                        arr.addElement(objs);
                        FlowConfigWizard w = (FlowConfigWizard)Review.this.getWizard();
                        try {
                            Review.this.setCursor(Cursor.getPredefinedCursor(3));
                            int j = this.rows.length - i;
                            final int steps = j == 0 ? 1 : j;
                            final String noteStr = "Remove " + j + " out of " + this.rows.length + " flows";
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    Review.this.progressMonitor.setProgress(steps);
                                    Review.this.progressMonitor.setNote(noteStr);
                                }
                            });
                            Review.this.removeFlow((Vsan)((FlowConfigWizard)w)._defineVsan._vsan.getSelectedItem(), (Switch)objs[0], (EndPort)objs[1], (EndPort)objs[2], map);
                            if (!Review.this.progressMonitor.isCanceled()) continue;
                            break;
                        }
                        catch (Exception ex) {
                            Util.errorMessage((Component)this.parent, ex);
                            if (Review.this.progressMonitor != null) {
                                Review.this.progressMonitor.close();
                            }
                            map.clear();
                            Review.this.setCursor(Cursor.getDefaultCursor());
                            Review.this.refreshButtons();
                            return;
                        }
                        finally {
                            Review.this.setCursor(Cursor.getDefaultCursor());
                        }
                    }
                    Review.this._inTableModel.fireTableDataChanged();
                    break block12;
                    finally {
                        if (Review.this.progressMonitor != null) {
                            Review.this.progressMonitor.close();
                        }
                        map.clear();
                        Review.this.setCursor(Cursor.getDefaultCursor());
                        Review.this.refreshButtons();
                    }
                }
                Review.this._tableModel.fireTableDataChanged();
            }
        }
    }

    class DefineVsan
    extends WizardPanel
    implements ItemListener {
        JComboBox _vsan;
        JComboBox _zone;
        RadioButtonPanel _type;
        Map<String, EnforcedZone> _zoneMap;
        JCheckBox _createOnAllCards;
        StringBuffer _numIgnored;

        public DefineVsan(FlowConfigWizard wizard) {
            super("2 of 3: Define Traffic Flows", "Define traffic counters between source and destination devices in a VSAN. The active zones are used to determine which groups can communicate. The source devices (Hosts and Storage) must be directly attached to a Cisco NXOS switch.\n\nYou can monitor this traffic in the web client Admin->Performance->Collections page.", wizard, Util.loadIcon("icons/RouteFlow.gif"));
            this._zoneMap = new HashMap<String, EnforcedZone>();
            this._numIgnored = new StringBuffer();
            if (FlowConfigWizard.this._fabric == null) {
                FlowConfigWizard.this._fabric = ClientController.getInstance().getFabric();
            }
            Object[] vsans = FlowConfigWizard.this._fabric.getVsans();
            Arrays.sort(vsans);
            this._zone = new JComboBox<String>(this.getAllZones((Vsan)vsans[0]));
            this._vsan = new JComboBox<Object>(vsans);
            this._vsan.addItemListener(this);
            this._type = new RadioButtonPanel(new String[]{"Host<->Storage", "Storage<->Storage", "Both"});
            this._createOnAllCards = new JCheckBox("Create flows on all cards", false);
            this._createOnAllCards.setVisible(false);
            JPanel center = DialogUtil.buildPanel(DialogUtil.buildLabels(new String[]{"VSAN:", "Zone:", "Type:", null}), new JComponent[]{this._vsan, this._zone, this._type, this._createOnAllCards});
            this.add("Center", center);
        }

        Vector<String> getAllZones(Vsan vsan) {
            this._zoneMap.clear();
            EnforcedZone[] zones = vsan.getEnforcedZones();
            Vector<String> zoneNames = new Vector<String>();
            for (int i = 0; i < zones.length; ++i) {
                this._zoneMap.put(zones[i].getName(), zones[i]);
                zoneNames.add(zones[i].getName());
            }
            Collections.sort(zoneNames);
            zoneNames.add(0, "AllZones");
            return zoneNames;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doNext() {
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                FlowConfigWizard w = (FlowConfigWizard)this.getWizard();
                this._numIgnored.setLength(0);
                HashMap<Switch, Array> flows = this.getFlows((Vsan)this._vsan.getSelectedItem(), this._type.getSelected() + 1, this._numIgnored);
                HashMap<Switch, Array> existingFlows = this.getExistingFlows((Vsan)this._vsan.getSelectedItem(), flows);
                w.updateReviewTable(flows, existingFlows, this._numIgnored.toString());
                FlowConfigWizard.this._vsanTitleBorder.setTitle("Existing Flows for Vsan:" + (Vsan)((FlowConfigWizard)w)._defineVsan._vsan.getSelectedItem());
                super.doNext();
                FlowConfigWizard.this.getNavigator().getCancel().setVisible(false);
            }
            catch (Exception ex) {
                Util.errorMessage((Component)this, ex);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Vsan vsan = (Vsan)e.getItem();
            this._zone.removeAllItems();
            Vector<String> zonenames = this.getAllZones(vsan);
            Iterator<String> iter = zonenames.iterator();
            while (iter.hasNext()) {
                this._zone.addItem(iter.next());
            }
        }

        private HashMap<Switch, Array> getExistingFlows(Vsan vsan, HashMap allFlows) throws Exception {
            HashMap<Switch, Array> ret = new HashMap<Switch, Array>();
            Iterator iter = allFlows.keySet().iterator();
            HashMap temp = new HashMap();
            EnforcedZone efZone = this._zoneMap.get(this._vsan.getSelectedItem());
            ArrayList<EndPort> zoneMemPorts = null;
            if (efZone != null) {
                zoneMemPorts = efZone.getEndPortsAsList();
            }
            while (iter.hasNext()) {
                Switch sw = (Switch)iter.next();
                if (sw.getVsan(vsan.getId()) == null) continue;
                Fabric fb = sw.getFabric();
                VarBindList vbl = new VarBindList();
                for (int k = 0; k < VARS.length; ++k) {
                    vbl.add(new SnmpVarBind(new SnmpOID(VARS[k])));
                }
                SnmpPDU pdu = SnmpFetch.getBulk(sw.getPeer(), vbl);
                VarBindList resp = pdu.getVariables();
                for (int j = 0; j < resp.size(); j += VARS.length) {
                    if (resp.byteValue(j)[0] != -32) continue;
                    int module = resp.getOid(j).getValue()[14] - 21;
                    byte[] mask = resp.byteValue(j + 1);
                    if (mask.length != 3 || (mask[2] & 0xFF) != 255) continue;
                    int vId = resp.intValue(j + 2);
                    if (vsan.getVsanId() != vId) continue;
                    byte[] destId = resp.byteValue(j + 3);
                    int did = ((destId[0] & 0xFF) << 16) + ((destId[1] & 0xFF) << 8) + (destId[2] & 0xFF);
                    byte[] srcId = resp.byteValue(j + 4);
                    int sid = ((srcId[0] & 0xFF) << 16) + ((srcId[1] & 0xFF) << 8) + (srcId[2] & 0xFF);
                    EndPort sp = fb.findEndPortByVsanFcId(vId, srcId);
                    EndPort dp = fb.findEndPortByVsanFcId(vId, destId);
                    if (sp == null || dp == null) {
                        _Logger.debug((Object)("Unknown flow fcid: Vsan " + vId + ", " + SnmpFcAddressId.toHexString(srcId) + " - " + SnmpFcAddressId.toHexString(destId)));
                        continue;
                    }
                    if (zoneMemPorts != null && (!zoneMemPorts.contains(sp) || !zoneMemPorts.contains(dp))) continue;
                    Array<Object> flows = ret.get(sw);
                    if (flows == null) {
                        flows = new Array<Object>();
                        ret.put(sw, flows);
                    }
                    if (this.exists(flows, sp, dp)) continue;
                    flows.addElement(sp);
                    Array<EndPort> arr = new Array<EndPort>();
                    arr.addElement(dp);
                    flows.addElement(arr);
                }
            }
            return ret;
        }

        private boolean exists(Array flows, EndPort sp, EndPort dp) {
            for (int i = 0; i < flows.size() - 1; i += 2) {
                Array arr;
                if (!((EndPort)flows.elementAt(i)).equals(sp) || (arr = (Array)flows.elementAt(i + 1)).find(dp) < 0) continue;
                return true;
            }
            return false;
        }

        private HashMap<Switch, Array> getFlows(Vsan vsan, int type, StringBuffer ignoredMsg) throws Exception {
            HashMap<Switch, Array> map = this.getFlowsNoModule(vsan, type, ignoredMsg);
            return map;
        }

        private HashMap<Switch, Array> getFlowsNoModule(Vsan vsan, int type, StringBuffer ignoredMsg) throws Exception {
            Array targetList;
            HashMap initListByTarget = new HashMap();
            HashMap targetListByTarget = new HashMap();
            HashMap targetListByInit = new HashMap();
            EnforcedZone[] ez = vsan.getEnforcedZones();
            if (this._zoneMap.get(this._zone.getSelectedItem()) != null) {
                ez = new EnforcedZone[]{this._zoneMap.get(this._zone.getSelectedItem())};
            }
            if (ez == null || ez.length == 0) {
                throw new Exception("No Active Zones in " + vsan);
            }
            int numIgnored = 0;
            for (int i = 0; i < ez.length; ++i) {
                ArrayList al;
                EnforcedZoneMember ezm;
                int j;
                Array members = ez[i].getMembers();
                Array<EndPort> zoneTargets = new Array<EndPort>();
                Array<EndPort> zoneInits = new Array<EndPort>();
                for (j = 0; j < members.size(); ++j) {
                    ezm = (EnforcedZoneMember)members.elementAt(j);
                    al = ezm.getEndPorts(vsan.getFabric());
                    if (al == null) {
                        ++numIgnored;
                        continue;
                    }
                    for (EndPort ep : al) {
                        if (!(ep != null && ep.getSwitch() != null && ep.getSwitch().isMDS() && ep.getSwitch().isManageable() && ep.getVsan() != null && ep.isMemberOfVsan(vsan))) {
                            ++numIgnored;
                            continue;
                        }
                        if (((EndPortBase)ep.getBaseModelObject()).isInternal()) continue;
                        if (ep.isTarget()) {
                            Array targetList2;
                            Array initList = (Array)initListByTarget.get(ep);
                            if (initList == null) {
                                initListByTarget.put(ep, new Array());
                            }
                            if ((targetList2 = (Array)targetListByTarget.get(ep)) == null) {
                                targetListByTarget.put(ep, new Array());
                            }
                            zoneTargets.addElement(ep);
                            continue;
                        }
                        Array targetList3 = (Array)targetListByInit.get(ep);
                        if (targetList3 == null) {
                            targetListByInit.put(ep, new Array());
                        }
                        zoneInits.addElement(ep);
                    }
                }
                if (zoneTargets.size() == 0 && zoneInits.size() == 0) continue;
                for (j = 0; j < members.size(); ++j) {
                    ezm = (EnforcedZoneMember)members.elementAt(j);
                    al = ezm.getEndPorts(vsan.getFabric());
                    if (al == null) {
                        ++numIgnored;
                        continue;
                    }
                    for (EndPort ep : al) {
                        EndPort targetPort;
                        int k;
                        if (!(ep != null && ep.getSwitch() != null && ep.getVsan() != null && ep.getSwitch().isMDS() && ep.getSwitch().isManageable() && ep.isMemberOfVsan(vsan))) {
                            ++numIgnored;
                            continue;
                        }
                        if (((EndPortBase)ep.getBaseModelObject()).isInternal()) continue;
                        if (ep.isTarget()) {
                            Array targetList4;
                            for (k = 0; k < zoneInits.size(); ++k) {
                                EndPort initPort = (EndPort)zoneInits.elementAt(k);
                                targetList4 = (Array)targetListByInit.get(initPort);
                                if (targetList4.find(ep) != -1) continue;
                                targetList4.addElement(ep);
                            }
                            for (k = 0; k < zoneTargets.size(); ++k) {
                                targetPort = (EndPort)zoneTargets.elementAt(k);
                                targetList4 = (Array)targetListByTarget.get(targetPort);
                                if (ep == targetPort || targetList4.find(ep) != -1) continue;
                                targetList4.addElement(ep);
                            }
                            continue;
                        }
                        for (k = 0; k < zoneTargets.size(); ++k) {
                            targetPort = (EndPort)zoneTargets.elementAt(k);
                            Array initList = (Array)initListByTarget.get(targetPort);
                            if (initList.find(ep) != -1) continue;
                            initList.addElement(ep);
                        }
                    }
                }
            }
            HashMap<Switch, Array> flowsBySwitch = new HashMap<Switch, Array>();
            if (type == 1 || type == 3) {
                for (EndPort targetPort : initListByTarget.keySet()) {
                    Array initList = (Array)initListByTarget.get(targetPort);
                    if (initList.size() == 0) continue;
                    Array flows = this.getFlowByPort(flowsBySwitch, targetPort, vsan);
                    this.add2switchFlowList(targetPort, initList, flows);
                }
            }
            if (type == 2 || type == 3) {
                for (EndPort targetPort : targetListByTarget.keySet()) {
                    targetList = (Array)targetListByTarget.get(targetPort);
                    if (targetList.size() == 0) continue;
                    Array flows = this.getFlowByPort(flowsBySwitch, targetPort, vsan);
                    this.add2switchFlowList(targetPort, targetList, flows);
                }
            }
            if (type == 1 || type == 3) {
                for (EndPort initPort : targetListByInit.keySet()) {
                    targetList = (Array)targetListByInit.get(initPort);
                    if (targetList.size() == 0) continue;
                    Array flows = this.getFlowByPort(flowsBySwitch, initPort, vsan);
                    this.add2switchFlowList(initPort, targetList, flows);
                }
            }
            if (numIgnored > 0) {
                ignoredMsg.append(", " + numIgnored + " devices ignored (not-managable, non-MDS, invalid zone member, etc)");
            }
            return flowsBySwitch;
        }

        private void add2switchFlowList(EndPort targetPort, Array initList, Array flows) {
            boolean added = false;
            for (int i = 0; i < flows.size(); i += 2) {
                if (!((EndPort)flows.elementAt(i)).equals(targetPort)) continue;
                Array list = (Array)flows.elementAt(i + 1);
                list.append(initList);
                for (int j = 0; j < initList.size(); ++j) {
                    list.addUniqueElement(initList.elementAt(j));
                }
                added = true;
                return;
            }
            if (!added) {
                flows.addElement(targetPort);
                flows.addElement(initList);
            }
        }

        private Array getFlowByPort(HashMap flowsBySwitch, EndPort targetPort, Vsan vsan) {
            Switch sw;
            Array flows = (Array)flowsBySwitch.get(targetPort.getSwitch());
            if (targetPort.getSwitch().isNpvEnabled()) {
                sw = FlowConfigWizard.getRealSwitch(targetPort, vsan);
                flows = (Array)flowsBySwitch.get(sw);
            }
            if (flows == null) {
                if (targetPort.getSwitch().isNpvEnabled()) {
                    sw = FlowConfigWizard.getRealSwitch(targetPort, vsan);
                    flows = new Array();
                    flowsBySwitch.put(sw, flows);
                } else {
                    flows = new Array();
                    flowsBySwitch.put(targetPort.getSwitch(), flows);
                }
            }
            return flows;
        }
    }

    class DefineTraffic
    extends WizardPanel {
        JTextField _percent;
        RadioButtonPanel _time;
        RadioButtonPanel _type;
        RadioButtonPanel _conversation_type;

        public DefineTraffic(FlowConfigWizard wizard) {
            super("2 of 3: Define Traffic Flows", "Define traffic counters between source and destination devices based upon traffic generated by the source port. The active zones are used to determine which source and target can communicate, only zone member types of wwn, device-alias(default region only) and domain,port will be searched.  Excluded are IVR zones and all other member types. The source devices must have either one day or one week of PM traffic collection to be considered.\n\nYou can monitor this traffic in the web client Admin->Performance->Collections page.", wizard, Util.loadIcon("icons/RouteFlow.gif"));
            JPanel row1 = new JPanel(new FlowLayout(0));
            JLabel postLabel = new JLabel(" (1..95%)");
            postLabel.setHorizontalTextPosition(2);
            this._percent = new JTextField(4);
            this._percent.setText("5");
            IntegerRangerVerifier inputVerifier = new IntegerRangerVerifier(this, 1, 95);
            this._percent.setInputVerifier(inputVerifier);
            row1.add(this._percent);
            row1.add(postLabel);
            this._time = new RadioButtonPanel(new String[]{"Day", "Week"});
            this._type = new RadioButtonPanel(new String[]{"Peak", "Average values"});
            this._type.setSelected(1);
            this._conversation_type = new RadioButtonPanel(new String[]{"Host<->Storage", "Storage<->Storage", "Both"});
            JPanel mainPAnel = DialogUtil.buildPanel(DialogUtil.buildLabels(new String[]{"Show device ports with traffic >", "During last: ", "Using: ", "Type: "}), new JComponent[]{row1, this._time, this._type, this._conversation_type});
            this.add("Center", mainPAnel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doNext() {
            try {
                String percentStr;
                this.setCursor(Cursor.getPredefinedCursor(3));
                FlowConfigWizard w = (FlowConfigWizard)this.getWizard();
                if (FlowConfigWizard.this._fabric == null) {
                    FlowConfigWizard.this._fabric = ClientController.getInstance().getFabric();
                }
                if ((percentStr = this._percent.getText()) == null || percentStr.trim().equals("")) {
                    JOptionPane.showMessageDialog(w, "Please enter a value for the traffic %.", "Empty Field.", 1);
                    return;
                }
                int percentInt = Integer.parseInt(this._percent.getText());
                int collectionPeriod = this._time.getSelectedValue().equals("Day") ? 1 : 2;
                int collectionDataType = this._type.getSelectedValue().equals("Peak") ? 1 : 2;
                int conversation_type = this._conversation_type.getSelected() + 1;
                ClientController clientController = ClientController.getInstance();
                FMServerRif server = clientController.assertFMSConnection();
                List<PossibleFCFlowTrafficDto> possibleFlows = server.getPossibleFlowPairsPerTraffic((FabricPK)FlowConfigWizard.this._fabric.getPK(), collectionPeriod, collectionDataType, percentInt, conversation_type, clientController.assertSession().getSSOToken());
                HashMap<Switch, HashMap> flows = new HashMap<Switch, HashMap>();
                for (PossibleFCFlowTrafficDto nextDto : possibleFlows) {
                    EndPort dp;
                    EndPort sp;
                    Vsan vsan;
                    Array<Object> srcDestflows;
                    Switch sw = FlowConfigWizard.this._fabric.findSwitchByPK(nextDto.getSw().getPK());
                    HashMap vsanMap = flows.get(sw);
                    if (vsanMap == null) {
                        vsanMap = new HashMap();
                        flows.put(sw, vsanMap);
                    }
                    if ((srcDestflows = (Array<Object>)vsanMap.get(vsan = sw.getVsan(nextDto.getVsan().getId()))) == null) {
                        srcDestflows = new Array<Object>();
                        vsanMap.put(vsan, srcDestflows);
                    }
                    if (this.exists(srcDestflows, sp = FlowConfigWizard.this._fabric.findEndPortByPK(nextDto.getSrc().getPK()), dp = FlowConfigWizard.this._fabric.findEndPortByPK(nextDto.getDest().getPK()))) continue;
                    srcDestflows.addElement(sp);
                    Array<EndPort> arr = new Array<EndPort>();
                    arr.addElement(dp);
                    srcDestflows.addElement(arr);
                    srcDestflows.addElement(nextDto);
                }
                HashMap<Switch, HashMap> existingFlows = this.getExistingFlows(flows);
                if (flows.isEmpty()) {
                    JOptionPane.showMessageDialog(w, "No new flow pairs were found to add.  \nEither no devices had traffic above the threshold provided or the devices found didn't have any zoned storage.", "No new flow pairs found to add.", 1);
                    return;
                }
                HashMap justFlowsToAdd = w.trafficFlowsDiff(flows, existingFlows);
                if (justFlowsToAdd.isEmpty()) {
                    JOptionPane.showMessageDialog(w, "No new flow pairs were found to add as all of the suggested pairs are already added.", "No new flow pairs found to add.", 1);
                    return;
                }
                FlowConfigWizard.this._trafficTitleBorder.setTitle("Possible Flow Pairs based on " + this._type.getSelectedValue() + " traffic collected over the last " + this._time.getSelectedValue() + " > " + percentInt + "%");
                w.updateReviewTrafficTable(flows, justFlowsToAdd, existingFlows, "");
                super.doNext();
                FlowConfigWizard.this.getNavigator().getCancel().setVisible(false);
            }
            catch (Exception ex) {
                Util.errorMessage((Component)this, ex);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }

        private HashMap<Switch, HashMap> getExistingFlows(HashMap<Switch, HashMap> allFlows) throws Exception {
            HashMap<Switch, HashMap> ret = new HashMap<Switch, HashMap>();
            Iterator<Switch> iter = allFlows.keySet().iterator();
            HashMap temp = new HashMap();
            while (iter.hasNext()) {
                Switch sw = iter.next();
                Fabric fb = sw.getFabric();
                VarBindList vbl = new VarBindList();
                for (int k = 0; k < VARS.length; ++k) {
                    vbl.add(new SnmpVarBind(new SnmpOID(VARS[k])));
                }
                SnmpPDU pdu = SnmpFetch.getBulk(sw.getPeer(), vbl);
                VarBindList resp = pdu.getVariables();
                for (int j = 0; j < resp.size(); j += VARS.length) {
                    Array<Object> flows;
                    int vId;
                    Vsan vsan;
                    if (resp.byteValue(j)[0] != -32) continue;
                    int module = resp.getOid(j).getValue()[14] - 21;
                    byte[] mask = resp.byteValue(j + 1);
                    if (mask.length != 3 || (mask[2] & 0xFF) != 255 || (vsan = sw.getVsan(new Integer(vId = resp.intValue(j + 2)).shortValue())) == null) continue;
                    byte[] destId = resp.byteValue(j + 3);
                    int did = ((destId[0] & 0xFF) << 16) + ((destId[1] & 0xFF) << 8) + (destId[2] & 0xFF);
                    byte[] srcId = resp.byteValue(j + 4);
                    int sid = ((srcId[0] & 0xFF) << 16) + ((srcId[1] & 0xFF) << 8) + (srcId[2] & 0xFF);
                    EndPort sp = fb.findEndPortByVsanFcId(vId, srcId);
                    EndPort dp = fb.findEndPortByVsanFcId(vId, destId);
                    if (sp == null || dp == null) {
                        _Logger.debug((Object)("Unknown flow fcid: Vsan " + vId + ", " + SnmpFcAddressId.toHexString(srcId) + " - " + SnmpFcAddressId.toHexString(destId)));
                        continue;
                    }
                    HashMap resultVsanMap = ret.get(sw);
                    if (resultVsanMap == null) {
                        resultVsanMap = new HashMap();
                        ret.put(sw, resultVsanMap);
                    }
                    if ((flows = (Array<Object>)resultVsanMap.get(vsan)) == null) {
                        flows = new Array<Object>();
                        resultVsanMap.put(vsan, flows);
                    }
                    if (this.exists(flows, sp, dp)) continue;
                    flows.addElement(sp);
                    Array<EndPort> arr = new Array<EndPort>();
                    arr.addElement(dp);
                    flows.addElement(arr);
                    flows.addElement("");
                }
            }
            return ret;
        }

        private boolean exists(Array flows, EndPort sp, EndPort dp) {
            for (int i = 0; i < flows.size() - 1; i += 3) {
                Array arr;
                if (!((EndPort)flows.elementAt(i)).equals(sp) || (arr = (Array)flows.elementAt(i + 1)).find(dp) < 0) continue;
                return true;
            }
            return false;
        }
    }

    class Option
    extends WizardPanel {
        ButtonGroup _bg;
        JRadioButton _vsanB;
        JRadioButton _trafficB;

        public Option(FlowConfigWizard wizard) {
            super("1 of 3: Select flows define type", "Select how new flows will be determined. \n\nNote: The source devices (Hosts and Storage) must be directly attached to an MDS switch, flows won't be created for devices attached to third party switches.", wizard, Util.loadIcon("icons/RouteFlow.gif"));
            JLabel defineLabel = new JLabel("Define flows by:");
            JPanel type = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridy = 0;
            gbc.gridx = 0;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this._bg = new ButtonGroup();
            this._vsanB = new JRadioButton("<html>VSAN <br> Define traffic counters between source and destination devices in a VSAN.  The active zones are used to determine which groups can communicate.<br></html>");
            this._trafficB = new JRadioButton("<html>Device Traffic <br>Define traffic counters between source and destination devices based on high traffic devices.  The active zones are used to determine which groups can communicate.  Device traffic is determined by current Performance Monitor(PM) collections, consequently PM collections must already be turned on in order to use this option.<br></html>");
            this._vsanB.setVerticalTextPosition(1);
            this._trafficB.setVerticalTextPosition(1);
            this._bg.add(this._vsanB);
            this._bg.add(this._trafficB);
            this._vsanB.setSelected(true);
            gbc.weighty = 2.0;
            ++gbc.gridy;
            ++gbc.gridy;
            type.add((Component)this._vsanB, gbc);
            ++gbc.gridy;
            ++gbc.gridy;
            type.add((Component)this._trafficB, gbc);
            this.add("Center", type);
        }

        public Integer getSelectedValue() {
            if (this._vsanB.isSelected()) {
                return 1;
            }
            return 2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doNext() {
            try {
                ModelFacadeRif rif;
                this.setCursor(Cursor.getPredefinedCursor(3));
                Integer selValue = (Integer)this.getModelValue(FlowConfigWizard._SELECTED_TYPE);
                Integer selectedType = this.getSelectedValue();
                if (selectedType == 2 && !(rif = ClientController.getInstance().assertModelFacade()).isFabricInPmCollection((FabricPK)FlowConfigWizard.this._fabric.getPK())) {
                    FlowConfigWizard w = (FlowConfigWizard)this.getWizard();
                    JOptionPane.showMessageDialog(w, "Performance Monitoring collections is not turned on for this Fabric.  To use this option PM must already be turned on and have collected data for this fabric.", "Performance Monitoring not turned on", 0);
                    return;
                }
                if (selValue == null || selValue.intValue() != selectedType.intValue()) {
                    this.setModelValue(FlowConfigWizard._SELECTED_TYPE, selectedType);
                    this.setDataValidForAllPanels(false);
                    this.setDataValid(true);
                    FlowConfigWizard.this.updateSteps(selectedType);
                }
                super.doNext();
                FlowConfigWizard.this.getNavigator().getCancel().setVisible(false);
            }
            catch (Exception ex) {
                Util.errorMessage((Component)this, ex);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }

        protected void setDataValidForAllPanels(boolean flag) {
            int panelIndex = this.getWizard().getCurrentCardIndex();
            WizardPanel pnl = null;
            do {
                if (null != (pnl = this.getWizard().get(panelIndex))) {
                    pnl.setDataValid(flag);
                }
                ++panelIndex;
            } while (pnl != null);
        }
    }
}

